#include "mx_rr.h"

namespace ADNS {

	MX_RR::MX_RR()
	{
		rr_type = RR_TYPE::MX;
		Exchange = gcnew DOMAIN_NAME();
		UpdateRdata();
	}

	Void MX_RR::SetExchange(DOMAIN_NAME^ dn)
	{
		Exchange = gcnew DOMAIN_NAME(dn->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ MX_RR::GetExchange()
	{
		return Exchange->Clone();
	}

	UInt16 MX_RR::GetPreference()
	{
		return preference;
	}

	Void MX_RR::SetPreference(UInt16 p)
	{
		preference = p;
		UpdateRdata();
		return;
	}

	String^ MX_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += Convert::ToString(preference);
		output += " ";
		output += Exchange->Print();

		return output;
	}

	Void MX_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(Exchange->GetName()->Length + 2);
		else
			rdata->Resize(rdata,Exchange->GetName()->Length + 2);

		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int)preference))->CopyTo(rdata,0);
		Exchange->GetName()->CopyTo(rdata,2);

		return;
	}

	Void MX_RR::ToCanonical()
	{
		Exchange->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}
	
	MX_RR^ MX_RR::Clone()
	{
		MX_RR^ newrr = gcnew MX_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->Exchange = Exchange->Clone();
		newrr->preference = preference;
		newrr->UpdateRdata();
		return newrr;
	}
	
	ResourceRecord^ MX_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		MX_RR^ mxout;
		array<Byte>^ tmparray;
		int pos;
		int reallen;

		mxout = gcnew MX_RR();
		mxout->owner = gcnew DOMAIN_NAME(domainname);
		mxout->rr_class = (RR_CLASS) rr_class;
		mxout->ttl = ttl;
		//Get Preference
		mxout->SetPreference(IPAddress::NetworkToHostOrder((short int) BitConverter::ToUInt16(packet,rdata_start)));
		//Get Exchange domain name
		pos = rdata_start + 2;
		tmparray = ReadDomainFromPacket(packet, pos, reallen);
		mxout->SetExchange(gcnew DOMAIN_NAME(tmparray));
		return mxout;
	}

	String^ MX_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<MX_RR^>(rec)->Print();
	}

	ResourceRecord^ MX_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<MX_RR^>(rec)->Clone();
	}

}