#!/usr/bin/env bash

set -e
set -u

#
# Usage: publish-minimum-versions.sh
#
# Parses minimum-versions.inc.sh to update template file /docs/minimum-versions.md.in.
# If /docs/minimum-versions.md is changed, commit and push changes
#

## START STANDARD BUILD SCRIPT INCLUDE
# adjust relative paths as necessary
THIS_SCRIPT="$(readlink -f "${BASH_SOURCE[0]}")"
. "${THIS_SCRIPT%/*}/build-utils.sh"
## END STANDARD BUILD SCRIPT INCLUDE

. "${KEYMAN_ROOT}/resources/build/minimum-versions.inc.sh"

function generate_table {
  echo ""
  echo "## minimum-versions.inc.sh Variables"
  echo ""
  echo "|          KEYMAN Variable          |     Value    |"
  echo "|-----------------------------------|--------------|"

  # Get all the shell variables named KEYMAN*VERSION
  strarr=( $(compgen -v KEYMAN | grep VERSION) )
  # echo "${strarr[@]}"

  for n in ${!strarr[@]}; do
    echo "| ${strarr[n]} | ${!strarr[n]} |"
  done

  echo ""
  echo "> ### This file is auto-generated by publish-minimum-versions.sh. Do not modify"
}

cp "$KEYMAN_ROOT/docs/minimum-versions.md.in" "$KEYMAN_ROOT/docs/minimum-versions.md"
generate_table >> "$KEYMAN_ROOT/docs/minimum-versions.md"
