/*
  Copyright:    © 2018 SIL International.
  Description:  API declarations for modifier keys, handy access masks and
                Keyman VKEY names.  These follow the same keytop->code
                associations as the Windows API. This is a separate header to
                maintain readability of the primary API header.
  Create Date:  17 Oct 2018
  Authors:      Tim Eves (TSE)
  History:      17 Oct 2018 - TSE - Moved & refactored km_core_modifier_state
                                    from keyman_core_api.h.
                                  - Added VKey and mask definitions.
                 6 Oct 2018 - TSE - Move into keyman folder.

*/

#pragma once

enum km_core_modifier_state {
  KM_CORE_MODIFIER_NONE        = 0,
  KM_CORE_MODIFIER_LCTRL       = 1 << 0,
  KM_CORE_MODIFIER_RCTRL       = 1 << 1,
  KM_CORE_MODIFIER_LALT        = 1 << 2,
  KM_CORE_MODIFIER_RALT        = 1 << 3,
  KM_CORE_MODIFIER_SHIFT       = 1 << 4,
  KM_CORE_MODIFIER_CTRL        = 1 << 5,
  KM_CORE_MODIFIER_ALT         = 1 << 6,
  /*
    KM_CORE_MODIFIER_META        = 1 << 7,    // Either Meta-key flag (tentative).  Not usable by keyboards currently
                                             // Used internally (currently, only by KMW) to ensure Meta-key
                                             // shortcuts safely bypass rules
                                             // Meta key = Command key on macOS, Windows key on Windows
  */
  KM_CORE_MODIFIER_CAPS        = 1 << 8,
  KM_CORE_MODIFIER_NOCAPS      = 1 << 9,
  /*
    KM_CORE_MODIFIER_NUMLOCK     = 1 << 10,
    KM_CORE_MODIFIER_NONUMLOCK   = 1 << 11,
    KM_CORE_MODIFIER_SCROLLOCK   = 1 << 12,
    KM_CORE_MODIFIER_NOSCROLLOCK = 1 << 13,
    KM_CORE_MODIFIER_VIRTUALKEY  = 1 << 14,
  */
};

enum km_core_modifier_mask {
  KM_CORE_MODIFIER_MASK_ALL         = 0x7f,
  KM_CORE_MODIFIER_MASK_ALT_GR_SIM  = KM_CORE_MODIFIER_LCTRL|KM_CORE_MODIFIER_LALT,
  KM_CORE_MODIFIER_MASK_CHIRAL      = 0x1f,
  KM_CORE_MODIFIER_MASK_IS_CHIRAL   = 0x0f,
  KM_CORE_MODIFIER_MASK_NON_CHIRAL  = 0x7f,
  KM_CORE_MODIFIER_MASK_CAPS        = 0x0300,
/*KM_CORE_MODIFIER_MASK_NUMLOCK     = 0x0C00,
  KM_CORE_MODIFIER_MASK_SCROLLLOCK  = 0x3000,*/
};

// These are Windows API VKEYs, using Keyman VKEY names.
enum km_kpb_virtual_key {
  KM_CORE_VKEY__00,
  KM_CORE_VKEY_LBUTTON,
  KM_CORE_VKEY_RBUTTON,
  KM_CORE_VKEY_CANCEL,
  KM_CORE_VKEY_MBUTTON,
  KM_CORE_VKEY__05,
  KM_CORE_VKEY__06,
  KM_CORE_VKEY__07,
  KM_CORE_VKEY_BKSP,
  KM_CORE_VKEY_TAB,
  KM_CORE_VKEY__0A,
  KM_CORE_VKEY__0B,
  KM_CORE_VKEY_KP5,
  KM_CORE_VKEY_ENTER,
  KM_CORE_VKEY__0E,
  KM_CORE_VKEY__0F,
  KM_CORE_VKEY_SHIFT,
  KM_CORE_VKEY_CONTROL,
  KM_CORE_VKEY_ALT,
  KM_CORE_VKEY_PAUSE,
  KM_CORE_VKEY_CAPS,
  KM_CORE_VKEY__15,
  KM_CORE_VKEY__16,
  KM_CORE_VKEY__17,
  KM_CORE_VKEY__18,
  KM_CORE_VKEY__19,
  KM_CORE_VKEY__1A,
  KM_CORE_VKEY_ESC,
  KM_CORE_VKEY__1C,
  KM_CORE_VKEY__1D,
  KM_CORE_VKEY__1E,
  KM_CORE_VKEY__1F,
  KM_CORE_VKEY_SPACE,
  KM_CORE_VKEY_PGUP,
  KM_CORE_VKEY_PGDN,
  KM_CORE_VKEY_END,
  KM_CORE_VKEY_HOME,
  KM_CORE_VKEY_LEFT,
  KM_CORE_VKEY_UP,
  KM_CORE_VKEY_RIGHT,
  KM_CORE_VKEY_DOWN,
  KM_CORE_VKEY_SEL,
  KM_CORE_VKEY_PRINT,
  KM_CORE_VKEY_EXEC,
  KM_CORE_VKEY_PRTSCN,
  KM_CORE_VKEY_INS,
  KM_CORE_VKEY_DEL,
  KM_CORE_VKEY_HELP,
  KM_CORE_VKEY_0,
  KM_CORE_VKEY_1,
  KM_CORE_VKEY_2,
  KM_CORE_VKEY_3,
  KM_CORE_VKEY_4,
  KM_CORE_VKEY_5,
  KM_CORE_VKEY_6,
  KM_CORE_VKEY_7,
  KM_CORE_VKEY_8,
  KM_CORE_VKEY_9,
  KM_CORE_VKEY__3A,
  KM_CORE_VKEY__3B,
  KM_CORE_VKEY__3C,
  KM_CORE_VKEY__3D,
  KM_CORE_VKEY__3E,
  KM_CORE_VKEY__3F,
  KM_CORE_VKEY__40,
  KM_CORE_VKEY_A,
  KM_CORE_VKEY_B,
  KM_CORE_VKEY_C,
  KM_CORE_VKEY_D,
  KM_CORE_VKEY_E,
  KM_CORE_VKEY_F,
  KM_CORE_VKEY_G,
  KM_CORE_VKEY_H,
  KM_CORE_VKEY_I,
  KM_CORE_VKEY_J,
  KM_CORE_VKEY_K,
  KM_CORE_VKEY_L,
  KM_CORE_VKEY_M,
  KM_CORE_VKEY_N,
  KM_CORE_VKEY_O,
  KM_CORE_VKEY_P,
  KM_CORE_VKEY_Q,
  KM_CORE_VKEY_R,
  KM_CORE_VKEY_S,
  KM_CORE_VKEY_T,
  KM_CORE_VKEY_U,
  KM_CORE_VKEY_V,
  KM_CORE_VKEY_W,
  KM_CORE_VKEY_X,
  KM_CORE_VKEY_Y,
  KM_CORE_VKEY_Z,
  KM_CORE_VKEY__5B,
  KM_CORE_VKEY__5C,
  KM_CORE_VKEY__5D,
  KM_CORE_VKEY__5E,
  KM_CORE_VKEY__5F,
  KM_CORE_VKEY_NP0,
  KM_CORE_VKEY_NP1,
  KM_CORE_VKEY_NP2,
  KM_CORE_VKEY_NP3,
  KM_CORE_VKEY_NP4,
  KM_CORE_VKEY_NP5,
  KM_CORE_VKEY_NP6,
  KM_CORE_VKEY_NP7,
  KM_CORE_VKEY_NP8,
  KM_CORE_VKEY_NP9,
  KM_CORE_VKEY_NPSTAR,
  KM_CORE_VKEY_NPPLUS,
  KM_CORE_VKEY_SEPARATOR,
  KM_CORE_VKEY_NPMINUS,
  KM_CORE_VKEY_NPDOT,
  KM_CORE_VKEY_NPSLASH,
  KM_CORE_VKEY_F1,
  KM_CORE_VKEY_F2,
  KM_CORE_VKEY_F3,
  KM_CORE_VKEY_F4,
  KM_CORE_VKEY_F5,
  KM_CORE_VKEY_F6,
  KM_CORE_VKEY_F7,
  KM_CORE_VKEY_F8,
  KM_CORE_VKEY_F9,
  KM_CORE_VKEY_F10,
  KM_CORE_VKEY_F11,
  KM_CORE_VKEY_F12,
  KM_CORE_VKEY_F13,
  KM_CORE_VKEY_F14,
  KM_CORE_VKEY_F15,
  KM_CORE_VKEY_F16,
  KM_CORE_VKEY_F17,
  KM_CORE_VKEY_F18,
  KM_CORE_VKEY_F19,
  KM_CORE_VKEY_F20,
  KM_CORE_VKEY_F21,
  KM_CORE_VKEY_F22,
  KM_CORE_VKEY_F23,
  KM_CORE_VKEY_F24,
  KM_CORE_VKEY__88,
  KM_CORE_VKEY__89,
  KM_CORE_VKEY__8A,
  KM_CORE_VKEY__8B,
  KM_CORE_VKEY__8C,
  KM_CORE_VKEY__8D,
  KM_CORE_VKEY__8E,
  KM_CORE_VKEY__8F,
  KM_CORE_VKEY_NUMLOCK,
  KM_CORE_VKEY_SCROLL,
  KM_CORE_VKEY__92,
  KM_CORE_VKEY__93,
  KM_CORE_VKEY__94,
  KM_CORE_VKEY__95,
  KM_CORE_VKEY__96,
  KM_CORE_VKEY__97,
  KM_CORE_VKEY__98,
  KM_CORE_VKEY__99,
  KM_CORE_VKEY__9A,
  KM_CORE_VKEY__9B,
  KM_CORE_VKEY__9C,
  KM_CORE_VKEY__9D,
  KM_CORE_VKEY__9E,
  KM_CORE_VKEY__9F,
  KM_CORE_VKEY__A0,
  KM_CORE_VKEY__A1,
  KM_CORE_VKEY__A2,
  KM_CORE_VKEY__A3,
  KM_CORE_VKEY__A4,
  KM_CORE_VKEY__A5,
  KM_CORE_VKEY__A6,
  KM_CORE_VKEY__A7,
  KM_CORE_VKEY__A8,
  KM_CORE_VKEY__A9,
  KM_CORE_VKEY__AA,
  KM_CORE_VKEY__AB,
  KM_CORE_VKEY__AC,
  KM_CORE_VKEY__AD,
  KM_CORE_VKEY__AE,
  KM_CORE_VKEY__AF,
  KM_CORE_VKEY__B0,
  KM_CORE_VKEY__B1,
  KM_CORE_VKEY__B2,
  KM_CORE_VKEY__B3,
  KM_CORE_VKEY__B4,
  KM_CORE_VKEY__B5,
  KM_CORE_VKEY__B6,
  KM_CORE_VKEY__B7,
  KM_CORE_VKEY__B8,
  KM_CORE_VKEY__B9,
  KM_CORE_VKEY_COLON,
  KM_CORE_VKEY_EQUAL,
  KM_CORE_VKEY_COMMA,
  KM_CORE_VKEY_HYPHEN,
  KM_CORE_VKEY_PERIOD,
  KM_CORE_VKEY_SLASH,
  KM_CORE_VKEY_BKQUOTE,
  KM_CORE_VKEY__C1,
  KM_CORE_VKEY__C2,
  KM_CORE_VKEY__C3,
  KM_CORE_VKEY__C4,
  KM_CORE_VKEY__C5,
  KM_CORE_VKEY__C6,
  KM_CORE_VKEY__C7,
  KM_CORE_VKEY__C8,
  KM_CORE_VKEY__C9,
  KM_CORE_VKEY__CA,
  KM_CORE_VKEY__CB,
  KM_CORE_VKEY__CC,
  KM_CORE_VKEY__CD,
  KM_CORE_VKEY__CE,
  KM_CORE_VKEY__CF,
  KM_CORE_VKEY__D0,
  KM_CORE_VKEY__D1,
  KM_CORE_VKEY__D2,
  KM_CORE_VKEY__D3,
  KM_CORE_VKEY__D4,
  KM_CORE_VKEY__D5,
  KM_CORE_VKEY__D6,
  KM_CORE_VKEY__D7,
  KM_CORE_VKEY__D8,
  KM_CORE_VKEY__D9,
  KM_CORE_VKEY__DA,
  KM_CORE_VKEY_LBRKT,
  KM_CORE_VKEY_BKSLASH,
  KM_CORE_VKEY_RBRKT,
  KM_CORE_VKEY_QUOTE,
  KM_CORE_VKEY_oDF,
  KM_CORE_VKEY_oE0,
  KM_CORE_VKEY_oE1,
  KM_CORE_VKEY_oE2,  // 102nd key on European layouts
  KM_CORE_VKEY_oE3,
  KM_CORE_VKEY_oE4,
  KM_CORE_VKEY__E5,
  KM_CORE_VKEY_oE6,
  KM_CORE_VKEY__E7,
  KM_CORE_VKEY__E8,
  KM_CORE_VKEY_oE9,
  KM_CORE_VKEY_oEA,
  KM_CORE_VKEY_oEB,
  KM_CORE_VKEY_oEC,
  KM_CORE_VKEY_oED,
  KM_CORE_VKEY_oEE,
  KM_CORE_VKEY_oEF,
  KM_CORE_VKEY_oF0,
  KM_CORE_VKEY_oF1,
  KM_CORE_VKEY_oF2,
  KM_CORE_VKEY_oF3,
  KM_CORE_VKEY_oF4,
  KM_CORE_VKEY_oF5,
  KM_CORE_VKEY__F6,
  KM_CORE_VKEY__F7,
  KM_CORE_VKEY__F8,
  KM_CORE_VKEY__F9,
  KM_CORE_VKEY__FA,
  KM_CORE_VKEY__FB,
  KM_CORE_VKEY__FC,
  KM_CORE_VKEY__FD,
  KM_CORE_VKEY__FE,
  KM_CORE_VKEY__FF,
};
