/*
Jaxe - Editeur XML en Java

Copyright (C) 2010 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package jaxe.wxs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;


/**
 * Reprsente un lment des schmas XML qui peut contenir des sous-lments ou pointer vers des sous-lments (lments XML autoriss sous un lment).
 */
public interface AvecSousElements {
    
    /**
     * Resoudre les rfrences vers d'autres lments du schma de tous les descendants de cet lment du schma.
     */
    public void resoudreReferences(final WXSSchema schema, final WXSThing redefine);
    
    /**
     * Renvoie la liste des lments dfinis sous ce modle (parmi tous les descendants de l'lment des schmas, mais sans les rfrences d'lments).
     */
    public Set<WXSElement> listeTousElements();
    
    /**
     * Renvoie la liste des tous les lments que l'on peut trouver directement sous ce modle (y compris avec des rfrences).
     */
    public ArrayList<ToutElement> listeSousElements();
    
    /**
     * Renvoie une expression rgulire correspondant  ce modle, destine  tre lue par un utilisateur (mais pas utilisable pour autre chose).
     */
    public String expressionReguliere();
    
    /**
     * Renvoie Boolean.TRUE si l'lment est un enfant obligatoire dans ce modle.
     * Renvoie null si l'enfant n'en est pas un.
     */
    public Boolean enfantObligatoire(final WXSElement enfant);
    
    /**
     * Renvoie Boolean.TRUE si l'lment pass en paramtre peut se retrouver plusieurs fois de suite dans ce modle  cause d'un maxOccurs > 1.
     * Renvoie null si l'enfant n'en est pas un.
     */
    public Boolean enfantsMultiples(final WXSElement enfant);
    
    /**
     * renvoie la position dans la liste jusqu'o la validation est possible (0 si aucune validation possible, sousElements().size() si tout est valid)
     */
    public int valider(final List<WXSElement> sousElements, final int start, final boolean insertion);
    
    /**
     * Renvoie true si l'ensemble des lments correspondant est optionnel, par exemple pour une squence avec uniquement des lments optionnels.
     */
    public boolean estOptionnel();
    
}
