/*
* Copyright (c) 2017, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
#pragma once
#pragma pack(1)

#include <cstdint>
#include <cstddef>

class CmHwVeboxCmdG10
{
public:
    // Internal Macros
    #define __CODEGEN_MAX(_a, _b) (((_a) > (_b)) ? (_a) : (_b))
    #define __CODEGEN_BITFIELD(l, h) (h) - (l) + 1
    #define __CODEGEN_OP_LENGTH_BIAS 2
    #define __CODEGEN_OP_LENGTH( x ) (uint32_t)((__CODEGEN_MAX(x, __CODEGEN_OP_LENGTH_BIAS)) - __CODEGEN_OP_LENGTH_BIAS)
    //!
    //! \brief VEBOX_ACE_LACE_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for ACE
    //!     state.
    //!
    struct VEBOX_ACE_LACE_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 AceEnable                                        : __CODEGEN_BITFIELD( 0,  0)    ; ///< U1
                uint32_t                 Reserved1                                        : __CODEGEN_BITFIELD( 1,  1)    ; ///< U1
                uint32_t                 SkinThreshold                                    : __CODEGEN_BITFIELD( 2,  6)    ; ///< U5
                uint32_t                 Reserved7                                        : __CODEGEN_BITFIELD( 7, 11)    ; ///< U5
                uint32_t                 LaceHistogramEnable                              : __CODEGEN_BITFIELD(12, 12)    ; ///< U1
                uint32_t                 LaceHistogramSize                                : __CODEGEN_BITFIELD(13, 13)    ; ///< U1
                uint32_t                 LaceSingleHistogramSet                           : __CODEGEN_BITFIELD(14, 15)    ; ///< U2
                uint32_t                 MinAceLuma                                       : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 Ymin                                             : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 Y1                                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 Y2                                               : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 Y3                                               : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 Y4                                               : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 Y5                                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 Y6                                               : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 Y7                                               : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 Y8                                               : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 Y9                                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 Y10                                              : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 Ymax                                             : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 B1                                               : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 B2                                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 B3                                               : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 B4                                               : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 B5                                               : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 B6                                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 B7                                               : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 B8                                               : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 B9                                               : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 B10                                              : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 Reserved208                                      : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 S0                                               : __CODEGEN_BITFIELD( 0, 10)    ; ///< U110
                uint32_t                 Reserved235                                      : __CODEGEN_BITFIELD(11, 15)    ; ///< U5
                uint32_t                 S1                                               : __CODEGEN_BITFIELD(16, 26)    ; ///< U110
                uint32_t                 Reserved251                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 S2                                               : __CODEGEN_BITFIELD( 0, 10)    ; ///< U110
                uint32_t                 Reserved267                                      : __CODEGEN_BITFIELD(11, 15)    ; ///< U5
                uint32_t                 S3                                               : __CODEGEN_BITFIELD(16, 26)    ; ///< U110
                uint32_t                 Reserved283                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 S4                                               : __CODEGEN_BITFIELD( 0, 10)    ; ///< U110
                uint32_t                 Reserved299                                      : __CODEGEN_BITFIELD(11, 15)    ; ///< U5
                uint32_t                 S5                                               : __CODEGEN_BITFIELD(16, 26)    ; ///< U110
                uint32_t                 Reserved315                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 S6                                               : __CODEGEN_BITFIELD( 0, 10)    ; ///< U110
                uint32_t                 Reserved331                                      : __CODEGEN_BITFIELD(11, 15)    ; ///< U5
                uint32_t                 S7                                               : __CODEGEN_BITFIELD(16, 26)    ; ///< U110
                uint32_t                 Reserved347                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 S8                                               : __CODEGEN_BITFIELD( 0, 10)    ; ///< U110
                uint32_t                 Reserved363                                      : __CODEGEN_BITFIELD(11, 15)    ; ///< U5
                uint32_t                 S9                                               : __CODEGEN_BITFIELD(16, 26)    ; ///< U110
                uint32_t                 Reserved379                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 S10                                              : __CODEGEN_BITFIELD( 0, 10)    ; ///< U110
                uint32_t                 Reserved395                                      : __CODEGEN_BITFIELD(11, 15)    ; ///< U5
                uint32_t                 MaxAceLuma                                       : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW12;

        //! \name Local enumerations

        enum SKIN_THRESHOLD
        {
            SKIN_THRESHOLD_UNNAMED26                                         = 26, ///<
        };
        enum LACE_HISTOGRAM_ENABLE
        {
            LACE_HISTOGRAM_ENABLE_UNNAMED0                                   = 0, ///<
        };
        enum LACE_HISTOGRAM_SIZE
        {
            LACE_HISTOGRAM_SIZE_128_BINHISTOGRAM                             = 0, ///<
            LACE_HISTOGRAM_SIZE_256_BINHISTOGRAM                             = 1, ///<
        };
        enum LACE_SINGLE_HISTOGRAM_SET
        {
            LACE_SINGLE_HISTOGRAM_SET_CURRENT                                = 0, ///< The histogram includes only the current frame.
            LACE_SINGLE_HISTOGRAM_SET_PREVIOUS                               = 1, ///< The histogram includes only the previous frame.
            LACE_SINGLE_HISTOGRAM_SET_CURRENTPREVIOUS                        = 2, ///< The histogram includes pixels from both the current and previous frame.
            LACE_SINGLE_HISTOGRAM_SET_PREVIOUSCURRENT                        = 3, ///< The histogram includes the previous frame followed by the current frame.
        };
        enum YMIN
        {
            YMIN_UNNAMED16                                                   = 16, ///<
        };
        enum Y1
        {
            Y1_UNNAMED36                                                     = 36, ///<
        };
        enum Y2
        {
            Y2_UNNAMED56                                                     = 56, ///<
        };
        enum Y3
        {
            Y3_UNNAMED76                                                     = 76, ///<
        };
        enum Y4
        {
            Y4_UNNAMED96                                                     = 96, ///<
        };
        enum Y5
        {
            Y5_UNNAMED116                                                    = 116, ///<
        };
        enum Y6
        {
            Y6_UNNAMED136                                                    = 136, ///<
        };
        enum Y7
        {
            Y7_UNNAMED156                                                    = 156, ///<
        };
        enum Y8
        {
            Y8_UNNAMED176                                                    = 176, ///<
        };
        enum Y9
        {
            Y9_UNNAMED196                                                    = 196, ///<
        };
        enum Y10
        {
            Y10_UNNAMED216                                                   = 216, ///<
        };
        enum YMAX
        {
            YMAX_UNNAMED235                                                  = 235, ///<
        };
        enum B1
        {
            B1_UNNAMED36                                                     = 36, ///<
        };
        enum B2
        {
            B2_UNNAMED56                                                     = 56, ///<
        };
        enum B3
        {
            B3_UNNAMED76                                                     = 76, ///<
        };
        enum B4
        {
            B4_UNNAMED96                                                     = 96, ///<
        };
        enum B5
        {
            B5_UNNAMED116                                                    = 116, ///<
        };
        enum B6
        {
            B6_UNNAMED136                                                    = 136, ///<
        };
        enum B7
        {
            B7_UNNAMED156                                                    = 156, ///<
        };
        enum B8
        {
            B8_UNNAMED176                                                    = 176, ///<
        };
        enum B9
        {
            B9_UNNAMED196                                                    = 196, ///<
        };
        enum B10
        {
            B10_UNNAMED216                                                   = 216, ///<
        };
        enum S0
        {
            S0_UNNAMED1024                                                   = 1024, ///<
        };
        enum S1
        {
            S1_UNNAMED1024                                                   = 1024, ///<
        };
        enum S2
        {
            S2_UNNAMED1024                                                   = 1024, ///<
        };
        enum S3
        {
            S3_UNNAMED1024                                                   = 1024, ///<
        };
        enum S4
        {
            S4_UNNAMED1024                                                   = 1024, ///<
        };
        enum S5
        {
            S5_UNNAMED1024                                                   = 1024, ///<
        };
        enum S6
        {
            S6_UNNAMED1024                                                   = 1024, ///<
        };
        enum S7
        {
            S7_UNNAMED1024                                                   = 1024, ///<
        };
        enum S8
        {
            S8_UNNAMED1024                                                   = 1024, ///<
        };
        enum S9
        {
            S9_UNNAMED1024                                                   = 1024, ///<
        };
        enum S10
        {
            S10_UNNAMED1024                                                  = 1024, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API  VEBOX_ACE_LACE_STATE_CMD() {
            DW0.Value = 0;
            DW0.SkinThreshold = SKIN_THRESHOLD_UNNAMED26;
            DW0.LaceHistogramEnable = LACE_HISTOGRAM_ENABLE_UNNAMED0;
            DW0.LaceHistogramSize = LACE_HISTOGRAM_SIZE_128_BINHISTOGRAM;
            DW0.LaceSingleHistogramSet = LACE_SINGLE_HISTOGRAM_SET_CURRENT;

            DW1.Value = 0;
            DW1.Ymin = YMIN_UNNAMED16;
            DW1.Y1 = Y1_UNNAMED36;
            DW1.Y2 = Y2_UNNAMED56;
            DW1.Y3 = Y3_UNNAMED76;

            DW2.Value = 0;
            DW2.Y4 = Y4_UNNAMED96;
            DW2.Y5 = Y5_UNNAMED116;
            DW2.Y6 = Y6_UNNAMED136;
            DW2.Y7 = Y7_UNNAMED156;

            DW3.Value = 0;
            DW3.Y8 = Y8_UNNAMED176;
            DW3.Y9 = Y9_UNNAMED196;
            DW3.Y10 = Y10_UNNAMED216;
            DW3.Ymax = YMAX_UNNAMED235;

            DW4.Value = 0;
            DW4.B1 = B1_UNNAMED36;
            DW4.B2 = B2_UNNAMED56;
            DW4.B3 = B3_UNNAMED76;
            DW4.B4 = B4_UNNAMED96;

            DW5.Value = 0;
            DW5.B5 = B5_UNNAMED116;
            DW5.B6 = B6_UNNAMED136;
            DW5.B7 = B7_UNNAMED156;
            DW5.B8 = B8_UNNAMED176;

            DW6.Value = 0;
            DW6.B9 = B9_UNNAMED196;
            DW6.B10 = B10_UNNAMED216;

            DW7.Value = 0;
            DW7.S0 = S0_UNNAMED1024;
            DW7.S1 = S1_UNNAMED1024;

            DW8.Value = 0;
            DW8.S2 = S2_UNNAMED1024;
            DW8.S3 = S3_UNNAMED1024;

            DW9.Value = 0;
            DW9.S4 = S4_UNNAMED1024;
            DW9.S5 = S5_UNNAMED1024;

            DW10.Value = 0;
            DW10.S6 = S6_UNNAMED1024;
            DW10.S7 = S7_UNNAMED1024;

            DW11.Value = 0;
            DW11.S8 = S8_UNNAMED1024;
            DW11.S9 = S9_UNNAMED1024;

            DW12.Value = 0;
            DW12.S10 = S10_UNNAMED1024;

        };

        static const size_t DW_SIZE = 13;
        static const size_t BYTE_SIZE = 52;
    };

    //!
    //! \brief VEBOX_ALPHA_AOI_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for Fixed
    //!     Alpha State and Area of Interest State.
    //!
    struct VEBOX_ALPHA_AOI_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 ColorPipeAlpha                                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 AlphaFromStateSelect                             : __CODEGEN_BITFIELD(16, 16)    ; ///< U1
                uint32_t                 FullImageHistogram                               : __CODEGEN_BITFIELD(17, 17)    ; ///< U1
                uint32_t                 Reserved18                                       : __CODEGEN_BITFIELD(18, 31)    ; ///< U14
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 AoiMinX                                          : __CODEGEN_BITFIELD( 0, 13)    ; ///< U14
                uint32_t                 Reserved46                                       : __CODEGEN_BITFIELD(14, 15)    ; ///< U2
                uint32_t                 AoiMaxX                                          : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 Reserved62                                       : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 AoiMinY                                          : __CODEGEN_BITFIELD( 0, 13)    ; ///< U14
                uint32_t                 Reserved78                                       : __CODEGEN_BITFIELD(14, 15)    ; ///< U2
                uint32_t                 AoiMaxY                                          : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 Reserved94                                       : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW2;

        //! \name Local enumerations

        enum ALPHA_FROM_STATE_SELECT
        {
            ALPHA_FROM_STATE_SELECT_ALPHAISTAKENFROMMESSAGE                  = 0, ///<
            ALPHA_FROM_STATE_SELECT_ALPHAISTAKENFROMSTATE                    = 1, ///<
        };
        enum AOI_MIN_X
        {
            AOI_MIN_X_UNNAMED0                                               = 0, ///<
        };
        enum AOI_MAX_X
        {
            AOI_MAX_X_UNNAMED3                                               = 3, ///<
        };
        enum AOI_MIN_Y
        {
            AOI_MIN_Y_UNNAMED0                                               = 0, ///<
        };
        enum AOI_MAX_Y
        {
            AOI_MAX_Y_UNNAMED3                                               = 3, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API  VEBOX_ALPHA_AOI_STATE_CMD() {
            DW0.Value = 0;
            DW0.AlphaFromStateSelect = ALPHA_FROM_STATE_SELECT_ALPHAISTAKENFROMMESSAGE;

            DW1.Value = 0;
            DW1.AoiMinX = AOI_MIN_X_UNNAMED0;
            DW1.AoiMaxX = AOI_MAX_X_UNNAMED3;

            DW2.Value = 0;
            DW2.AoiMinY = AOI_MIN_Y_UNNAMED0;
            DW2.AoiMaxY = AOI_MAX_Y_UNNAMED3;
        };

        static const size_t DW_SIZE = 3;
        static const size_t BYTE_SIZE = 12;
    };

    //!
    //! \brief VEBOX_CAPTURE_PIPE_STATE
    //! \details
    //!     This command  contains variables for controlling Demosaic and the White
    //!     Balance Statistics.
    //!
    struct VEBOX_CAPTURE_PIPE_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 GoodPixelNeighborThreshold                       : __CODEGEN_BITFIELD( 0,  5)    ; ///< U6
                uint32_t                 Reserved6                                        : __CODEGEN_BITFIELD( 6,  7)    ; ///< U2
                uint32_t                 AverageColorThreshold                            : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 GreenImbalanceThreshold                          : __CODEGEN_BITFIELD(16, 19)    ; ///< U4
                uint32_t                 ShiftMinCost                                     : __CODEGEN_BITFIELD(20, 22)    ; ///< U3
                uint32_t                 Reserved23                                       : __CODEGEN_BITFIELD(23, 23)    ; ///< U1
                uint32_t                 GoodPixelThreshold                               : __CODEGEN_BITFIELD(24, 29)    ; ///< U6
                uint32_t                 DirmapScale                                      : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 BadColorThreshold3                               : __CODEGEN_BITFIELD( 0,  3)    ; ///< U4
                uint32_t                 NumberBigPixelThreshold                          : __CODEGEN_BITFIELD( 4,  7)    ; ///< U4
                uint32_t                 BadColorThreshold2                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 BadColorThreshold1                               : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 GoodIntesityThreshold                            : __CODEGEN_BITFIELD(24, 27)    ; ///< U4
                uint32_t                 ScaleForMinCost                                  : __CODEGEN_BITFIELD(28, 31)    ; ///< U4
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 WhiteBalanceCorrectionEnable                     : __CODEGEN_BITFIELD( 0,  0)    ; ///< U1
                uint32_t                 BlackPointCorrectionEnable                       : __CODEGEN_BITFIELD( 1,  1)    ; ///< U1
                uint32_t                 VignetteCorrectionFormat                         : __CODEGEN_BITFIELD( 2,  2)    ; ///< U1
                uint32_t                 RgbHistogramEnable                               : __CODEGEN_BITFIELD( 3,  3)    ; ///< U1
                uint32_t                 BlackPointOffsetGreenBottomMsb                   : __CODEGEN_BITFIELD( 4,  4)    ; ///< U1
                uint32_t                 BlackPointOffsetBlueMsb                          : __CODEGEN_BITFIELD( 5,  5)    ; ///< U1
                uint32_t                 BlackPointOffsetGreenTopMsb                      : __CODEGEN_BITFIELD( 6,  6)    ; ///< U1
                uint32_t                 BlackPointOffsetRedMsb                           : __CODEGEN_BITFIELD( 7,  7)    ; ///< U1
                uint32_t                 UvThresholdValue                                 : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 YOutlierValue                                    : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 YBrightValue                                     : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 BlackPointOffsetGreenTop                         : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 BlackPointOffsetRed                              : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 BlackPointOffsetGreenBottom                      : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 BlackPointOffsetBlue                             : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 WhiteBalanceGreenTopCorrection                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U4.12
                uint32_t                 WhiteBalanceRedCorrection                        : __CODEGEN_BITFIELD(16, 31)    ; ///< U4.12
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 WhiteBalanceGreenBottomCorrection                : __CODEGEN_BITFIELD( 0, 15)    ; ///< U4.12
                uint32_t                 WhiteBalanceBlueCorrection                       : __CODEGEN_BITFIELD(16, 31)    ; ///< U4.12
            };
            uint32_t                     Value;
        } DW6;

        //! \name Local enumerations

        enum GOOD_PIXEL_NEIGHBOR_THRESHOLD
        {
            GOOD_PIXEL_NEIGHBOR_THRESHOLD_UNNAMED35                          = 35, ///<
        };
        enum AVERAGE_COLOR_THRESHOLD
        {
            AVERAGE_COLOR_THRESHOLD_UNNAMED255                               = 255, ///<
        };
        enum GREEN_IMBALANCE_THRESHOLD
        {
            GREEN_IMBALANCE_THRESHOLD_UNNAMED1                               = 1, ///<
        };
        enum SHIFT_MIN_COST
        {
            SHIFT_MIN_COST_UNNAMED1                                          = 1, ///<
        };
        enum GOOD_PIXEL_THRESHOLD
        {
            GOOD_PIXEL_THRESHOLD_UNNAMED5                                    = 5, ///<
        };
        enum DIRMAP_SCALE
        {
            DIRMAP_SCALE_UNNAMED2                                            = 2, ///<
        };
        enum BAD_COLOR_THRESHOLD_3
        {
            BAD_COLOR_THRESHOLD_3_UNNAMED10                                  = 10, ///<
        };
        enum NUMBER_BIG_PIXEL_THRESHOLD
        {
            NUMBER_BIG_PIXEL_THRESHOLD_UNNAMED10                             = 10, ///<
        };
        enum BAD_COLOR_THRESHOLD_2
        {
            BAD_COLOR_THRESHOLD_2_UNNAMED175                                 = 175, ///<
        };
        enum BAD_COLOR_THRESHOLD_1
        {
            BAD_COLOR_THRESHOLD_1_UNNAMED100                                 = 100, ///<
        };
        enum GOOD_INTESITY_THRESHOLD
        {
            GOOD_INTESITY_THRESHOLD_UNNAMED10                                = 10, ///<
        };
        enum SCALE_FOR_MIN_COST
        {
            SCALE_FOR_MIN_COST_UNNAMED10                                     = 10, ///<
        };
        enum VIGNETTE_CORRECTION_FORMAT
        {
            VIGNETTE_CORRECTION_FORMAT_U88                                   = 0, ///<
            VIGNETTE_CORRECTION_FORMAT_U412                                  = 1, ///<
        };
        enum UV_THRESHOLD_VALUE
        {
            UV_THRESHOLD_VALUE_UNNAMED64                                     = 64, ///< 0.25 * 255 = 64
        };
        enum Y_OUTLIER_VALUE
        {
            Y_OUTLIER_VALUE_UNNAMED253                                       = 253, ///<
        };
        enum Y_BRIGHT_VALUE
        {
            Y_BRIGHT_VALUE_UNNAMED230                                        = 230, ///<
        };
        enum BLACK_POINT_OFFSET_GREEN_TOP
        {
            BLACK_POINT_OFFSET_GREEN_TOP_UNNAMED0                            = 0, ///<
        };
        enum BLACK_POINT_OFFSET_RED
        {
            BLACK_POINT_OFFSET_RED_UNNAMED0                                  = 0, ///<
        };
        enum BLACK_POINT_OFFSET_GREEN_BOTTOM
        {
            BLACK_POINT_OFFSET_GREEN_BOTTOM_UNNAMED0                         = 0, ///<
        };
        enum BLACK_POINT_OFFSET_BLUE
        {
            BLACK_POINT_OFFSET_BLUE_UNNAMED0                                 = 0, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_CAPTURE_PIPE_STATE_CMD() {
            DW0.Value = 0;
            DW0.GoodPixelNeighborThreshold = GOOD_PIXEL_NEIGHBOR_THRESHOLD_UNNAMED35;
            DW0.AverageColorThreshold = AVERAGE_COLOR_THRESHOLD_UNNAMED255;
            DW0.GreenImbalanceThreshold = GREEN_IMBALANCE_THRESHOLD_UNNAMED1;
            DW0.ShiftMinCost = SHIFT_MIN_COST_UNNAMED1;
            DW0.GoodPixelThreshold = GOOD_PIXEL_THRESHOLD_UNNAMED5;
            DW0.DirmapScale = DIRMAP_SCALE_UNNAMED2;

            DW1.Value = 0;
            DW1.BadColorThreshold3 = BAD_COLOR_THRESHOLD_3_UNNAMED10;
            DW1.NumberBigPixelThreshold = NUMBER_BIG_PIXEL_THRESHOLD_UNNAMED10;
            DW1.BadColorThreshold2 = BAD_COLOR_THRESHOLD_2_UNNAMED175;
            DW1.BadColorThreshold1 = BAD_COLOR_THRESHOLD_1_UNNAMED100;
            DW1.GoodIntesityThreshold = GOOD_INTESITY_THRESHOLD_UNNAMED10;
            DW1.ScaleForMinCost = SCALE_FOR_MIN_COST_UNNAMED10;

            DW2.Value = 0;
            DW2.VignetteCorrectionFormat = VIGNETTE_CORRECTION_FORMAT_U88;
            DW2.UvThresholdValue = UV_THRESHOLD_VALUE_UNNAMED64;
            DW2.YOutlierValue = Y_OUTLIER_VALUE_UNNAMED253;
            DW2.YBrightValue = Y_BRIGHT_VALUE_UNNAMED230;

            DW3.Value = 0;
            DW3.BlackPointOffsetGreenTop = BLACK_POINT_OFFSET_GREEN_TOP_UNNAMED0;
            DW3.BlackPointOffsetRed = BLACK_POINT_OFFSET_RED_UNNAMED0;

            DW4.Value = 0;
            DW4.BlackPointOffsetGreenBottom = BLACK_POINT_OFFSET_GREEN_BOTTOM_UNNAMED0;
            DW4.BlackPointOffsetBlue = BLACK_POINT_OFFSET_BLUE_UNNAMED0;

            DW5.Value = 0;

            DW6.Value = 0;
        };

        static const size_t DW_SIZE = 7;
        static const size_t BYTE_SIZE = 28;
    };

    //!
    //! \brief VEBOX_CCM_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for the
    //!     Color Correction Matrix State.
    //!
    struct VEBOX_CCM_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 C1                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved21                                       : __CODEGEN_BITFIELD(21, 30)    ; ///< U10
                uint32_t                 ColorCorrectionMatrixEnable                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 C0                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved53                                       : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 C3                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved85                                       : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 C2                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved117                                      : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 C5                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved149                                      : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 C4                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved181                                      : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 C7                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved213                                      : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 C6                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved245                                      : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 C8                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved277                                      : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 OffsetInR                                        : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved305                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 OffsetInG                                        : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved337                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 OffsetInB                                        : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved369                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 OffsetOutR                                       : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved401                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                /// uint32_t 13
                uint32_t                 OffsetOutG                                       : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved433                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                /// uint32_t 14
                uint32_t                 OffsetOutB                                       : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved465                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW14;

        //! \name Local enumerations

        enum C1
        {
            C1_1825665536                                                    = 18256, ///<
        };
        enum C0
        {
            C0_4467265536                                                    = 44672, ///<
        };
        enum C3
        {
            C3_113665536                                                     = 1136, ///<
        };
        enum C2
        {
            C2_54465536                                                      = 544, ///<
        };
        enum C5
        {
            C5_83265536                                                      = 33553600, ///<
        };
        enum C4
        {
            C4_5380865536                                                    = 53808, ///<
        };
        enum C7
        {
            C7_268865536                                                     = 2688, ///<
        };
        enum C6
        {
            C6_19265536                                                      = 33554240, ///<
        };
        enum C8
        {
            C8_5494465536                                                    = 54944, ///<
        };
        enum OFFSET_IN_R
        {
            OFFSET_IN_R_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_IN_G
        {
            OFFSET_IN_G_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_IN_B
        {
            OFFSET_IN_B_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_OUT_R
        {
            OFFSET_OUT_R_UNNAMED0                                            = 0, ///<
        };
        enum OFFSET_OUT_G
        {
            OFFSET_OUT_G_UNNAMED0                                            = 0, ///<
        };
        enum OFFSET_OUT_B
        {
            OFFSET_OUT_B_UNNAMED0                                            = 0, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_CCM_STATE_CMD() {
            DW0.Value = 0;
            DW0.C1 = C1_1825665536;

            DW1.Value = 0;
            DW1.C0 = C0_4467265536;

            DW2.Value = 0;
            DW2.C3 = C3_113665536;

            DW3.Value = 0;
            DW3.C2 = C2_54465536;

            DW4.Value = 0;
            DW4.C5 = C5_83265536;

            DW5.Value = 0;
            DW5.C4 = C4_5380865536;

            DW6.Value = 0;
            DW6.C7 = C7_268865536;

            DW7.Value = 0;
            DW7.C6 = C6_19265536;

            DW8.Value = 0;
            DW8.C8 = C8_5494465536;

            DW9.Value = 0;
            DW9.OffsetInR = OFFSET_IN_R_UNNAMED0;

            DW10.Value = 0;
            DW10.OffsetInG = OFFSET_IN_G_UNNAMED0;

            DW11.Value = 0;
            DW11.OffsetInB = OFFSET_IN_B_UNNAMED0;

            DW12.Value = 0;
            DW12.OffsetOutR = OFFSET_OUT_R_UNNAMED0;

            DW13.Value = 0;
            DW13.OffsetOutG = OFFSET_OUT_G_UNNAMED0;

            DW14.Value = 0;
            DW14.OffsetOutB = OFFSET_OUT_B_UNNAMED0;
        };

        static const size_t DW_SIZE = 15;
        static const size_t BYTE_SIZE = 60;
    };

    //!
    //! \brief VEBOX_CSC_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for CSC
    //!     state.
    //!
    struct VEBOX_CSC_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 C0                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved19                                       : __CODEGEN_BITFIELD(19, 30)    ; ///< U11
                uint32_t                 TransformEnable                                  : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 C1                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved51                                       : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 C2                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved83                                       : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 C3                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved115                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 C4                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved147                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 C5                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved179                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 C6                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved211                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 C7                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved243                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 C8                                               : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved275                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 OffsetIn1                                        : __CODEGEN_BITFIELD( 0, 15)    ; ///< S16
                uint32_t                 OffsetOut1                                       : __CODEGEN_BITFIELD(16, 31)    ; ///< S16
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 OffsetIn2                                        : __CODEGEN_BITFIELD( 0, 15)    ; ///< S16
                uint32_t                 OffsetOut2                                       : __CODEGEN_BITFIELD(16, 31)    ; ///< S16
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 OffsetIn3                                        : __CODEGEN_BITFIELD( 0, 15)    ; ///< S16
                uint32_t                 OffsetOut3                                       : __CODEGEN_BITFIELD(16, 31)    ; ///< S16
            };
            uint32_t                     Value;
        } DW11;

        //! \name Local enumerations

        enum C0
        {
            C0_OR10                                                          = 65536, ///<
        };
        enum C1
        {
            C1_UNNAMED0                                                      = 0, ///<
        };
        enum C2
        {
            C2_UNNAMED0                                                      = 0, ///<
        };
        enum C3
        {
            C3_UNNAMED0                                                      = 0, ///<
        };
        enum C4
        {
            C4_OR10                                                          = 65536, ///<
        };
        enum C5
        {
            C5_UNNAMED0                                                      = 0, ///<
        };
        enum C6
        {
            C6_UNNAMED0                                                      = 0, ///<
        };
        enum C7
        {
            C7_UNNAMED0                                                      = 0, ///<
        };
        enum C8
        {
            C8_OR10                                                          = 65536, ///<
        };
        enum OFFSET_IN_1
        {
            OFFSET_IN_1_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_OUT_1
        {
            OFFSET_OUT_1_UNNAMED0                                            = 0, ///<
        };
        enum OFFSET_IN_2
        {
            OFFSET_IN_2_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_OUT_2
        {
            OFFSET_OUT_2_UNNAMED0                                            = 0, ///<
        };
        enum OFFSET_IN_3
        {
            OFFSET_IN_3_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_OUT_3
        {
            OFFSET_OUT_3_UNNAMED0                                            = 0, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_CSC_STATE_CMD() {
            DW0.Value = 0;
            DW0.C0 = C0_OR10;

            DW1.Value = 0;
            DW1.C1 = C1_UNNAMED0;

            DW2.Value = 0;
            DW2.C2 = C2_UNNAMED0;

            DW3.Value = 0;
            DW3.C3 = C3_UNNAMED0;

            DW4.Value = 0;
            DW4.C4 = C4_OR10;

            DW5.Value = 0;
            DW5.C5 = C5_UNNAMED0;

            DW6.Value = 0;
            DW6.C6 = C6_UNNAMED0;

            DW7.Value = 0;
            DW7.C7 = C7_UNNAMED0;

            DW8.Value = 0;
            DW8.C8 = C8_OR10;

            DW9.Value = 0;
            DW9.OffsetIn1 = OFFSET_IN_1_UNNAMED0;
            DW9.OffsetOut1 = OFFSET_OUT_1_UNNAMED0;

            DW10.Value = 0;
            DW10.OffsetIn2 = OFFSET_IN_2_UNNAMED0;
            DW10.OffsetOut2 = OFFSET_OUT_2_UNNAMED0;

            DW11.Value = 0;
            DW11.OffsetIn3 = OFFSET_IN_3_UNNAMED0;
            DW11.OffsetOut3 = OFFSET_OUT_3_UNNAMED0;
        };

        static const size_t DW_SIZE = 12;
        static const size_t BYTE_SIZE = 48;
    };

    //!
    //! \brief VEBOX_DNDI_STATE
    //! \details
    //!     This state table is used by the Denoise and Deinterlacer functions. 
    //!     DW0 to 2 are for Temporal Denoise
    //!      DW3 is for global noise estimate and hot pixel detection
    //!      DW4 is for Chroma Denoise
    //!      DW5 to 11 are for 5x5 spatial denoise
    //!      DW12 to 17 are for Deinterlacer
    //!      DW18 to 24 [CNL+] Added controls for Deinterlace. Added Deflicker
    //!     filter at output of DI.
    //! 
    //!
    struct VEBOX_DNDI_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 DenoiseMovingPixelThreshold                      : __CODEGEN_BITFIELD( 0,  4)    ; ///< U5
                uint32_t                 Reserved5                                        : __CODEGEN_BITFIELD( 5,  7)    ; ///< U3
                uint32_t                 DenoiseHistoryIncrease                           : __CODEGEN_BITFIELD( 8, 11)    ; ///< U4
                uint32_t                 DenoiseMaximumHistory                            : __CODEGEN_BITFIELD(12, 19)    ; ///< U8
                uint32_t                 DenoiseStadThreshold                             : __CODEGEN_BITFIELD(20, 31)    ; ///< U12
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 LowTemporalDifferenceThreshold                   : __CODEGEN_BITFIELD( 0,  9)    ; ///< U10
                uint32_t                 TemporalDifferenceThreshold                      : __CODEGEN_BITFIELD(10, 19)    ; ///< U10
                uint32_t                 DenoiseAsdThreshold                              : __CODEGEN_BITFIELD(20, 31)    ; ///< U12
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 Reserved64                                       : __CODEGEN_BITFIELD( 0,  9)    ; ///< U10
                uint32_t                 InitialDenoiseHistory                            : __CODEGEN_BITFIELD(10, 15)    ; ///< U6
                uint32_t                 DenoiseThresholdForSumOfComplexityMeasure        : __CODEGEN_BITFIELD(16, 27)    ; ///< U12
                uint32_t                 ProgressiveDn                                    : __CODEGEN_BITFIELD(28, 28)    ; ///< U1
                uint32_t                 Reserved93                                       : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 BlockNoiseEstimateNoiseThreshold                 : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 BlockNoiseEstimateEdgeThreshold                  : __CODEGEN_BITFIELD(12, 19)    ; ///< U8
                uint32_t                 HotPixelThreshold                                : __CODEGEN_BITFIELD(20, 27)    ; ///< U8
                uint32_t                 HotPixelCount                                    : __CODEGEN_BITFIELD(28, 31)    ; ///< U4
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 ChromaLowTemporalDifferenceThreshold             : __CODEGEN_BITFIELD( 0,  5)    ; ///< U6
                uint32_t                 ChromaTemporalDifferenceThreshold                : __CODEGEN_BITFIELD( 6, 11)    ; ///< U6
                uint32_t                 ChromaDenoiseEnable                              : __CODEGEN_BITFIELD(12, 12)    ; ///< U1
                uint32_t                 Reserved141                                      : __CODEGEN_BITFIELD(13, 15)    ; ///< U3
                uint32_t                 ChromaDenoiseStadThreshold                       : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 Reserved152                                      : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 DnWr0                                            : __CODEGEN_BITFIELD( 0,  4)    ; ///< U5
                uint32_t                 DnWr1                                            : __CODEGEN_BITFIELD( 5,  9)    ; ///< U5
                uint32_t                 DnWr2                                            : __CODEGEN_BITFIELD(10, 14)    ; ///< U5
                uint32_t                 DnWr3                                            : __CODEGEN_BITFIELD(15, 19)    ; ///< U5
                uint32_t                 DnWr4                                            : __CODEGEN_BITFIELD(20, 24)    ; ///< U5
                uint32_t                 DnWr5                                            : __CODEGEN_BITFIELD(25, 29)    ; ///< U5
                uint32_t                 Reserved190                                      : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 DnThmin                                          : __CODEGEN_BITFIELD( 0, 12)    ; ///< U13
                uint32_t                 Reserved205                                      : __CODEGEN_BITFIELD(13, 15)    ; ///< U3
                uint32_t                 DnThmax                                          : __CODEGEN_BITFIELD(16, 28)    ; ///< U13
                uint32_t                 Reserved221                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 DnDynThmin                                       : __CODEGEN_BITFIELD( 0, 12)    ; ///< U13
                uint32_t                 Reserved237                                      : __CODEGEN_BITFIELD(13, 15)    ; ///< U3
                uint32_t                 DnPrt5                                           : __CODEGEN_BITFIELD(16, 28)    ; ///< U13
                uint32_t                 Reserved253                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 DnPrt3                                           : __CODEGEN_BITFIELD( 0, 12)    ; ///< U13
                uint32_t                 Reserved269                                      : __CODEGEN_BITFIELD(13, 15)    ; ///< U3
                uint32_t                 DnPrt4                                           : __CODEGEN_BITFIELD(16, 28)    ; ///< U13
                uint32_t                 Reserved285                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 DnPrt1                                           : __CODEGEN_BITFIELD( 0, 12)    ; ///< U13
                uint32_t                 Reserved301                                      : __CODEGEN_BITFIELD(13, 15)    ; ///< U3
                uint32_t                 DnPrt2                                           : __CODEGEN_BITFIELD(16, 28)    ; ///< U13
                uint32_t                 Reserved317                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 DnWd20                                           : __CODEGEN_BITFIELD( 0,  4)    ; ///< U5
                uint32_t                 DnWd21                                           : __CODEGEN_BITFIELD( 5,  9)    ; ///< U5
                uint32_t                 DnWd22                                           : __CODEGEN_BITFIELD(10, 14)    ; ///< U5
                uint32_t                 Reserved335                                      : __CODEGEN_BITFIELD(15, 15)    ; ///< U1
                uint32_t                 DnPrt0                                           : __CODEGEN_BITFIELD(16, 28)    ; ///< U13
                uint32_t                 Reserved349                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 DnWd00                                           : __CODEGEN_BITFIELD( 0,  4)    ; ///< U5
                uint32_t                 DnWd01                                           : __CODEGEN_BITFIELD( 5,  9)    ; ///< U5
                uint32_t                 DnWd02                                           : __CODEGEN_BITFIELD(10, 14)    ; ///< U5
                uint32_t                 DnWd10                                           : __CODEGEN_BITFIELD(15, 19)    ; ///< U5
                uint32_t                 DnWd11                                           : __CODEGEN_BITFIELD(20, 24)    ; ///< U5
                uint32_t                 DnWd12                                           : __CODEGEN_BITFIELD(25, 29)    ; ///< U5
                uint32_t                 Reserved382                                      : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 SmoothMvThreshold                                : __CODEGEN_BITFIELD( 0,  1)    ; ///< U2
                uint32_t                 SadTightThreshold                                : __CODEGEN_BITFIELD( 2,  5)    ; ///< U4
                uint32_t                 ContentAdaptiveThresholdSlope                    : __CODEGEN_BITFIELD( 6,  9)    ; ///< U4
                uint32_t                 StmmC2                                           : __CODEGEN_BITFIELD(10, 12)    ; ///< U3
                uint32_t                 Reserved397                                      : __CODEGEN_BITFIELD(13, 31)    ; ///< U19
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                /// uint32_t 13
                uint32_t                 MaximumStmm                                      : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 MultiplierForVecm                                : __CODEGEN_BITFIELD( 8, 13)    ; ///< U6
                uint32_t                 Reserved430                                      : __CODEGEN_BITFIELD(14, 15)    ; ///< U2
                uint32_t                 BlendingConstantAcrossTimeForSmallValuesOfStmm   : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 BlendingConstantAcrossTimeForLargeValuesOfStmm   : __CODEGEN_BITFIELD(24, 30)    ; ///< U7
                uint32_t                 StmmBlendingConstantSelect                       : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                /// uint32_t 14
                uint32_t                 FmdTemporalDifferenceThreshold                   : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 LumatdmWt                                        : __CODEGEN_BITFIELD( 8, 11)    ; ///< U22
                uint32_t                 ChromatdmWt                                      : __CODEGEN_BITFIELD(12, 15)    ; ///< U22
                uint32_t                 StmmOutputShift                                  : __CODEGEN_BITFIELD(16, 19)    ; ///< U4
                uint32_t                 StmmShiftUp                                      : __CODEGEN_BITFIELD(20, 21)    ; ///< U2
                uint32_t                 StmmShiftDown                                    : __CODEGEN_BITFIELD(22, 23)    ; ///< U2
                uint32_t                 MinimumStmm                                      : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                /// uint32_t 15
                uint32_t                 CoringThresholdForSvcm                           : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 DeltabitValueForSvcm                             : __CODEGEN_BITFIELD( 8, 11)    ; ///< U4
                uint32_t                 Reserved492                                      : __CODEGEN_BITFIELD(12, 15)    ; ///< U4
                uint32_t                 CoringThresholdForShcm                           : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 DeltabitValueForShcm                             : __CODEGEN_BITFIELD(24, 27)    ; ///< U4
                uint32_t                 Reserved508                                      : __CODEGEN_BITFIELD(28, 31)    ; ///< U4
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                /// uint32_t 16
                uint32_t                 Reserved512                                      : __CODEGEN_BITFIELD( 0,  2)    ; ///< U3
                uint32_t                 DnDiTopFirst                                     : __CODEGEN_BITFIELD( 3,  3)    ; ///< U1
                uint32_t                 Reserved516                                      : __CODEGEN_BITFIELD( 4,  6)    ; ///< U3
                uint32_t                 McdiEnable                                       : __CODEGEN_BITFIELD( 7,  7)    ; ///< U1
                uint32_t                 FmdTearThreshold                                 : __CODEGEN_BITFIELD( 8, 13)    ; ///< U6
                uint32_t                 CatThreshold                                     : __CODEGEN_BITFIELD(14, 15)    ; ///< U2
                uint32_t                 Fmd2VerticalDifferenceThreshold                  : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 Fmd1VerticalDifferenceThreshold                  : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                /// uint32_t 17
                uint32_t                 SadTha                                           : __CODEGEN_BITFIELD( 0,  3)    ; ///< U4
                uint32_t                 SadThb                                           : __CODEGEN_BITFIELD( 4,  7)    ; ///< U4
                uint32_t                 ProgressiveCadenceReconstructionFor1StFieldOfCurrentFrame : __CODEGEN_BITFIELD( 8,  9)    ; ///< U2
                uint32_t                 McPixelConsistencyThreshold                      : __CODEGEN_BITFIELD(10, 15)    ; ///< U6
                uint32_t                 ProgressiveCadenceReconstructionFor2NdFieldOfPreviousFrame : __CODEGEN_BITFIELD(16, 17)    ; ///< U2
                uint32_t                 Reserved562                                      : __CODEGEN_BITFIELD(18, 18)    ; ///< U1
                uint32_t                 NeighborPixelThreshold                           : __CODEGEN_BITFIELD(19, 22)    ; ///< U4
                uint32_t                 ChromaSmallerWindowForTdm                        : __CODEGEN_BITFIELD(23, 23)    ; ///< U1
                uint32_t                 LumaSmallerWindowForTdm                          : __CODEGEN_BITFIELD(24, 24)    ; ///< U1
                uint32_t                 Fastercovergence                                 : __CODEGEN_BITFIELD(25, 25)    ; ///< U1
                uint32_t                 Reserved570                                      : __CODEGEN_BITFIELD(26, 31)    ; ///< U6
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                /// uint32_t 18
                uint32_t                 SadWt0                                           : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 SadWt1                                           : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 SadWt2                                           : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 SadWt3                                           : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                /// uint32_t 19
                uint32_t                 SadWt4                                           : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 SadWt6                                           : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 CoringThresholdForLumaSadCalculation             : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 CoringThresholdForChromaSadCalculation           : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                /// uint32_t 20
                uint32_t                 ParDiffcheckslackthreshold                       : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 ParTearinghighthreshold                          : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 ParTearinglowthreshold                           : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 ParDirectioncheckth                              : __CODEGEN_BITFIELD(24, 26)    ; ///< U3
                uint32_t                 ParSyntheticcontentcheck                         : __CODEGEN_BITFIELD(27, 27)    ; ///< U1
                uint32_t                 ParLocalcheck                                    : __CODEGEN_BITFIELD(28, 28)    ; ///< U1
                uint32_t                 ParUsesyntheticcontentmedian                     : __CODEGEN_BITFIELD(29, 29)    ; ///< U1
                uint32_t                 BypassDeflicker                                  : __CODEGEN_BITFIELD(30, 30)    ; ///< U1
                uint32_t                 Reserved671                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                /// uint32_t 21
                uint32_t                 Lpfwtlut0                                        : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 Lpfwtlut1                                        : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 Lpfwtlut2                                        : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 Lpfwtlut3                                        : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                /// uint32_t 22
                uint32_t                 Lpfwtlut4                                        : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 Lpfwtlut5                                        : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 Lpfwtlut6                                        : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 Lpfwtlut7                                        : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW22;

        //! \name Local enumerations

        enum DENOISE_HISTORY_INCREASE
        {
            DENOISE_HISTORY_INCREASE_UNNAMED8                                = 8, ///<
            DENOISE_HISTORY_INCREASE_UNNAMED15                               = 15, ///< Maximum Allowed
        };
        enum INITIAL_DENOISE_HISTORY
        {
            INITIAL_DENOISE_HISTORY_UNNAMED32                                = 32, ///<
        };
        enum BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD
        {
            BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD_UNNAMED16                    = 16, ///<
            BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD_UNNAMED255                   = 255, ///< Maximium Value
        };
        enum CHROMA_DENOISE_ENABLE
        {
            CHROMA_DENOISE_ENABLE_UNNAMED0                                   = 0, ///< The U and V channels will be passed to the next stage after DN unchanged.
            CHROMA_DENOISE_ENABLE_UNNAMED1                                   = 1, ///< The U and V chroma channels will be denoise filtered.
        };
        enum SAD_TIGHT_THRESHOLD
        {
            SAD_TIGHT_THRESHOLD_UNNAMED5                                     = 5, ///<
        };
        enum CONTENT_ADAPTIVE_THRESHOLD_SLOPE
        {
            CONTENT_ADAPTIVE_THRESHOLD_SLOPE_UNNAMED9                        = 9, ///< CAT_slope value = 10
        };
        enum STMM_BLENDING_CONSTANT_SELECT
        {
            STMM_BLENDING_CONSTANT_SELECT_UNNAMED0                           = 0, ///< Use the blending constant for small values of STMM for stmm_md_th
            STMM_BLENDING_CONSTANT_SELECT_UNNAMED1                           = 1, ///< Use the blending constant for large values of STMM for stmm_md_th
        };
        enum LUMATDM_WT
        {
            LUMATDM_WT_UNNAMED4                                              = 4, ///<
        };
        enum CHROMATDM_WT
        {
            CHROMATDM_WT_UNNAMED0                                            = 0, ///<
        };
        enum STMM_SHIFT_UP
        {
            STMM_SHIFT_UP_SHIFTBY6                                           = 0, ///<
            STMM_SHIFT_UP_SHIFTBY7                                           = 1, ///<
            STMM_SHIFT_UP_SHIFTBY8                                           = 2, ///<
        };
        enum STMM_SHIFT_DOWN
        {
            STMM_SHIFT_DOWN_SHIFTBY4                                         = 0, ///<
            STMM_SHIFT_DOWN_SHIFTBY5                                         = 1, ///<
            STMM_SHIFT_DOWN_SHIFTBY6                                         = 2, ///<
        };
        enum CORING_THRESHOLD_FOR_SVCM
        {
            CORING_THRESHOLD_FOR_SVCM_UNNAMED255                             = 255, ///<
        };
        enum DELTABIT_VALUE_FOR_SVCM
        {
            DELTABIT_VALUE_FOR_SVCM_UNNAMED5                                 = 5, ///<
        };
        enum CORING_THRESHOLD_FOR_SHCM
        {
            CORING_THRESHOLD_FOR_SHCM_UNNAMED255                             = 255, ///<
        };
        enum DELTABIT_VALUE_FOR_SHCM
        {
            DELTABIT_VALUE_FOR_SHCM_UNNAMED5                                 = 5, ///<
        };
        enum CAT_THRESHOLD
        {
            CAT_THRESHOLD_UNNAMED0                                           = 0, ///<
        };
        enum SAD_THA
        {
            SAD_THA_UNNAMED5                                                 = 5, ///<
        };
        enum SAD_THB
        {
            SAD_THB_UNNAMED10                                                = 10, ///<
        };
        enum PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME
        {
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME_DEINTERLACE = 0, ///<
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME_PUTTOGETHERWITHPREVIOUSFIELDINSEQUENCE = 1, ///< 2^nd field of previous frame
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME_PUTTOGETHERWITHNEXTFIELDINSEQUENCE = 2, ///< 2^nd field of current frame
        };
        enum MC_PIXEL_CONSISTENCY_THRESHOLD
        {
            MC_PIXEL_CONSISTENCY_THRESHOLD_UNNAMED25                         = 25, ///<
        };
        enum PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME
        {
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME_DEINTERLACE = 0, ///<
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME_PUTTOGETHERWITHPREVIOUSFIELDINSEQUENCE = 1, ///< 1^st field of previous frame
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME_PUTTOGETHERWITHNEXTFIELDINSEQUENCE = 2, ///< 1^st field of current frame
        };
        enum NEIGHBOR_PIXEL_THRESHOLD
        {
            NEIGHBOR_PIXEL_THRESHOLD_UNNAMED10                               = 10, ///<
        };
        enum FASTERCOVERGENCE
        {
            FASTERCOVERGENCE_UNNAMED0                                        = 0, ///<
        };
        enum SAD_WT0
        {
            SAD_WT0_DEFAULTFORNATURALANDSYNTHETIC                            = 0, ///<
        };
        enum SAD_WT1
        {
            SAD_WT1_DEFAULTFORSYNTHETICANDDIENABLED                          = 12, ///<
            SAD_WT1_DEFAULTFORSYNTHETICANDAVSENABLED                         = 38, ///<
            SAD_WT1_DEFAULTFORNATURALANDDIENABLED                            = 63, ///<
            SAD_WT1_DEFAULTFORNATURALANDAVSENABLED                           = 166, ///<
        };
        enum SAD_WT2
        {
            SAD_WT2_DEFAULTFORSYNTHETICANDDIENABLED                          = 25, ///<
            SAD_WT2_DEFAULTFORSYNTHETICANDAVSENABLED                         = 51, ///<
            SAD_WT2_DEFAULTFORNATURALANDDIENABLED                            = 76, ///<
            SAD_WT2_DEFAULTFORNATURALANDAVSENABLED                           = 179, ///<
        };
        enum SAD_WT3
        {
            SAD_WT3_DEFAULTFORSYNTHETICANDDIENABLED                          = 38, ///<
            SAD_WT3_DEFAULTFORSYNTHETICANDAVSENABLED                         = 64, ///<
            SAD_WT3_DEFAULTFORNATURALANDDIENABLED                            = 89, ///<
            SAD_WT3_DEFAULTFORNATURALANDAVSENABLED                           = 192, ///<
        };
        enum SAD_WT4
        {
            SAD_WT4_DEFAULTFORSYNTHETICANDDIENABLED                          = 63, ///<
            SAD_WT4_DEFAULTFORSYNTHETICANDAVSENABLED                         = 90, ///<
            SAD_WT4_DEFAULTFORNATURALANDDIENABLED                            = 114, ///<
            SAD_WT4_DEFAULTFORNATURALANDAVSENABLED                           = 218, ///<
        };
        enum SAD_WT6
        {
            SAD_WT6_DEFAULTFORSYNTHETIC                                      = 64, ///<
            SAD_WT6_DEFAULTFORNATURAL                                        = 217, ///<
        };
        enum CORING_THRESHOLD_FOR_LUMA_SAD_CALCULATION
        {
            CORING_THRESHOLD_FOR_LUMA_SAD_CALCULATION_UNNAMED0               = 0, ///<
        };
        enum CORING_THRESHOLD_FOR_CHROMA_SAD_CALCULATION
        {
            CORING_THRESHOLD_FOR_CHROMA_SAD_CALCULATION_UNNAMED0             = 0, ///<
        };
        enum PAR_DIFFCHECKSLACKTHRESHOLD
        {
            PAR_DIFFCHECKSLACKTHRESHOLD_UNNAMED15                            = 15, ///<
        };
        enum PAR_TEARINGHIGHTHRESHOLD
        {
            PAR_TEARINGHIGHTHRESHOLD_UNNAMED100                              = 100, ///<
        };
        enum PAR_TEARINGLOWTHRESHOLD
        {
            PAR_TEARINGLOWTHRESHOLD_UNNAMED20                                = 20, ///<
        };
        enum PAR_DIRECTIONCHECKTH
        {
            PAR_DIRECTIONCHECKTH_UNNAMED3                                    = 3, ///<
        };
        enum PAR_SYNTHETICCONTENTCHECK
        {
            PAR_SYNTHETICCONTENTCHECK_UNNAMED0                               = 0, ///<
        };
        enum PAR_LOCALCHECK
        {
            PAR_LOCALCHECK_UNNAMED1                                          = 1, ///<
        };
        enum PAR_USESYNTHETICCONTENTMEDIAN
        {
            PAR_USESYNTHETICCONTENTMEDIAN_UNNAMED0                           = 0, ///<
        };
        enum LPFWTLUT0
        {
            LPFWTLUT0_UNNAMED0                                               = 0, ///<
        };
        enum LPFWTLUT1
        {
            LPFWTLUT1_UNNAMED0                                               = 0, ///<
        };
        enum LPFWTLUT2
        {
            LPFWTLUT2_UNNAMED0                                               = 0, ///<
        };
        enum LPFWTLUT3
        {
            LPFWTLUT3_UNNAMED0                                               = 0, ///<
        };
        enum LPFWTLUT4
        {
            LPFWTLUT4_UNNAMED32                                              = 32, ///<
        };
        enum LPFWTLUT5
        {
            LPFWTLUT5_UNNAMED64                                              = 64, ///<
        };
        enum LPFWTLUT6
        {
            LPFWTLUT6_UNNAMED128                                             = 128, ///<
        };
        enum LPFWTLUT7
        {
            LPFWTLUT7_UNNAMED255                                             = 255, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API  VEBOX_DNDI_STATE_CMD() {

            DW0.Value = 0;
            DW0.DenoiseHistoryIncrease = DENOISE_HISTORY_INCREASE_UNNAMED8;

            DW1.Value = 0;

            DW2.Value = 0;
            DW2.InitialDenoiseHistory = INITIAL_DENOISE_HISTORY_UNNAMED32;

            DW3.Value = 0;
            DW3.BlockNoiseEstimateEdgeThreshold = BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD_UNNAMED16;

            DW4.Value = 0;
            DW4.ChromaDenoiseEnable = CHROMA_DENOISE_ENABLE_UNNAMED1;

            DW5.Value = 0;

            DW6.Value = 0;

            DW7.Value = 0;

            DW8.Value = 0;

            DW9.Value = 0;

            DW10.Value = 0;

            DW11.Value = 0;

            DW12.Value = 0;
            DW12.SadTightThreshold = SAD_TIGHT_THRESHOLD_UNNAMED5;
            DW12.ContentAdaptiveThresholdSlope = CONTENT_ADAPTIVE_THRESHOLD_SLOPE_UNNAMED9;

            DW13.Value = 0;
            DW13.StmmBlendingConstantSelect = STMM_BLENDING_CONSTANT_SELECT_UNNAMED0;

            DW14.Value = 0;
            DW14.LumatdmWt = LUMATDM_WT_UNNAMED4;
            DW14.ChromatdmWt = CHROMATDM_WT_UNNAMED0;
            DW14.StmmShiftUp = STMM_SHIFT_UP_SHIFTBY6;
            DW14.StmmShiftDown = STMM_SHIFT_DOWN_SHIFTBY4;

            DW15.Value = 0;
            DW15.CoringThresholdForSvcm = CORING_THRESHOLD_FOR_SVCM_UNNAMED255;
            DW15.DeltabitValueForSvcm = DELTABIT_VALUE_FOR_SVCM_UNNAMED5;
            DW15.CoringThresholdForShcm = CORING_THRESHOLD_FOR_SHCM_UNNAMED255;
            DW15.DeltabitValueForShcm = DELTABIT_VALUE_FOR_SHCM_UNNAMED5;

            DW16.Value = 0;
            DW16.CatThreshold = CAT_THRESHOLD_UNNAMED0;

            DW17.Value = 0;
            DW17.SadTha = SAD_THA_UNNAMED5;
            DW17.SadThb = SAD_THB_UNNAMED10;
            DW17.ProgressiveCadenceReconstructionFor1StFieldOfCurrentFrame = PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME_DEINTERLACE;
            DW17.McPixelConsistencyThreshold = MC_PIXEL_CONSISTENCY_THRESHOLD_UNNAMED25;
            DW17.ProgressiveCadenceReconstructionFor2NdFieldOfPreviousFrame = PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME_DEINTERLACE;
            DW17.NeighborPixelThreshold = NEIGHBOR_PIXEL_THRESHOLD_UNNAMED10;
            DW17.Fastercovergence = FASTERCOVERGENCE_UNNAMED0;

            DW18.Value = 0;
            DW18.SadWt0 = SAD_WT0_DEFAULTFORNATURALANDSYNTHETIC;
            DW18.SadWt1 = SAD_WT1_DEFAULTFORNATURALANDAVSENABLED;
            DW18.SadWt2 = SAD_WT2_DEFAULTFORNATURALANDAVSENABLED;
            DW18.SadWt3 = SAD_WT3_DEFAULTFORNATURALANDAVSENABLED;

            DW19.Value = 0;
            DW19.SadWt4 = SAD_WT4_DEFAULTFORNATURALANDAVSENABLED;
            DW19.SadWt6 = SAD_WT6_DEFAULTFORNATURAL;
            DW19.CoringThresholdForLumaSadCalculation = CORING_THRESHOLD_FOR_LUMA_SAD_CALCULATION_UNNAMED0;
            DW19.CoringThresholdForChromaSadCalculation = CORING_THRESHOLD_FOR_CHROMA_SAD_CALCULATION_UNNAMED0;

            DW20.Value = 0;
            DW20.ParDiffcheckslackthreshold = PAR_DIFFCHECKSLACKTHRESHOLD_UNNAMED15;
            DW20.ParTearinghighthreshold = PAR_TEARINGHIGHTHRESHOLD_UNNAMED100;
            DW20.ParTearinglowthreshold = PAR_TEARINGLOWTHRESHOLD_UNNAMED20;
            DW20.ParDirectioncheckth = PAR_DIRECTIONCHECKTH_UNNAMED3;
            DW20.ParSyntheticcontentcheck = PAR_SYNTHETICCONTENTCHECK_UNNAMED0;
            DW20.ParLocalcheck = PAR_LOCALCHECK_UNNAMED1;
            DW20.ParUsesyntheticcontentmedian = PAR_USESYNTHETICCONTENTMEDIAN_UNNAMED0;

            DW21.Value = 0;
            DW21.Lpfwtlut0 = LPFWTLUT0_UNNAMED0;
            DW21.Lpfwtlut1 = LPFWTLUT1_UNNAMED0;
            DW21.Lpfwtlut2 = LPFWTLUT2_UNNAMED0;
            DW21.Lpfwtlut3 = LPFWTLUT3_UNNAMED0;

            DW22.Value = 0;
            DW22.Lpfwtlut4 = LPFWTLUT4_UNNAMED32;
            DW22.Lpfwtlut5 = LPFWTLUT5_UNNAMED64;
            DW22.Lpfwtlut6 = LPFWTLUT6_UNNAMED128;
            DW22.Lpfwtlut7 = LPFWTLUT7_UNNAMED255;
        }

        static const size_t DW_SIZE = 23;
        static const size_t BYTE_SIZE = 92;
    };

    //!
    //! \brief VEBOX_FRONT_END_CSC_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for
    //!     Front-end CSC state.
    //!
    struct VEBOX_FRONT_END_CSC_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 FecscC0TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved19                                       : __CODEGEN_BITFIELD(19, 30)    ; ///< U12
                uint32_t                 FrontEndCscTransformEnable                       : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 FecscC1TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved51                                       : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 FecscC2TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved83                                       : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 FecscC3TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved115                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 FecscC4TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved147                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 FecscC5TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved179                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 FecscC6TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved211                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 FecscC7TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved243                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 FecscC8TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; ///< S316
                uint32_t                 Reserved275                                      : __CODEGEN_BITFIELD(19, 31)    ; ///< U13
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 FecScOffsetIn1OffsetInForYR                      : __CODEGEN_BITFIELD( 0, 15)    ; ///< S16
                uint32_t                 FecScOffsetOut1OffsetOutForYR                    : __CODEGEN_BITFIELD(16, 31)    ; ///< S16
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 FecScOffsetIn2OffsetOutForUG                     : __CODEGEN_BITFIELD( 0, 15)    ; ///< S16
                uint32_t                 FecScOffsetOut2OffsetOutForUG                    : __CODEGEN_BITFIELD(16, 31)    ; ///< S16
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 FecScOffsetIn3OffsetOutForVB                     : __CODEGEN_BITFIELD( 0, 15)    ; ///< S16
                uint32_t                 FecScOffsetOut3OffsetOutForVB                    : __CODEGEN_BITFIELD(16, 31)    ; ///< S16
            };
            uint32_t                     Value;
        } DW11;

        //! \name Local enumerations

        enum FECSC_C0_TRANSFORM_COEFFICIENT
        {
            FECSC_C0_TRANSFORM_COEFFICIENT_OR10                              = 65536, ///<
        };
        enum FECSC_C1_TRANSFORM_COEFFICIENT
        {
            FECSC_C1_TRANSFORM_COEFFICIENT_OR00                              = 0, ///<
        };
        enum FECSC_C2_TRANSFORM_COEFFICIENT
        {
            FECSC_C2_TRANSFORM_COEFFICIENT_OR00                              = 0, ///<
        };
        enum FECSC_C3_TRANSFORM_COEFFICIENT
        {
            FECSC_C3_TRANSFORM_COEFFICIENT_OR00                              = 0, ///<
        };
        enum FECSC_C4_TRANSFORM_COEFFICIENT
        {
            FECSC_C4_TRANSFORM_COEFFICIENT_OR10                              = 65536, ///<
        };
        enum FECSC_C5_TRANSFORM_COEFFICIENT
        {
            FECSC_C5_TRANSFORM_COEFFICIENT_OR00                              = 0, ///<
        };
        enum FECSC_C6_TRANSFORM_COEFFICIENT
        {
            FECSC_C6_TRANSFORM_COEFFICIENT_OR00                              = 0, ///<
        };
        enum FECSC_C7_TRANSFORM_COEFFICIENT
        {
            FECSC_C7_TRANSFORM_COEFFICIENT_OR00                              = 0, ///<
        };
        enum FECSC_C8_TRANSFORM_COEFFICIENT
        {
            FECSC_C8_TRANSFORM_COEFFICIENT_OR10                              = 65536, ///<
        };
        enum FEC_SC_OFFSET_IN_1_OFFSET_IN_FOR_YR
        {
            FEC_SC_OFFSET_IN_1_OFFSET_IN_FOR_YR_UNNAMED0                     = 0, ///<
        };
        enum FEC_SC_OFFSET_OUT_1_OFFSET_OUT_FOR_YR
        {
            FEC_SC_OFFSET_OUT_1_OFFSET_OUT_FOR_YR_UNNAMED0                   = 0, ///<
        };
        enum FEC_SC_OFFSET_IN_2_OFFSET_OUT_FOR_UG
        {
            FEC_SC_OFFSET_IN_2_OFFSET_OUT_FOR_UG_UNNAMED0                    = 0, ///<
        };
        enum FEC_SC_OFFSET_OUT_2_OFFSET_OUT_FOR_UG
        {
            FEC_SC_OFFSET_OUT_2_OFFSET_OUT_FOR_UG_UNNAMED0                   = 0, ///<
        };
        enum FEC_SC_OFFSET_IN_3_OFFSET_OUT_FOR_VB
        {
            FEC_SC_OFFSET_IN_3_OFFSET_OUT_FOR_VB_UNNAMED0                    = 0, ///<
        };
        enum FEC_SC_OFFSET_OUT_3_OFFSET_OUT_FOR_VB
        {
            FEC_SC_OFFSET_OUT_3_OFFSET_OUT_FOR_VB_UNNAMED0                   = 0, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_FRONT_END_CSC_STATE_CMD() {
            DW0.Value = 0;
            DW0.FecscC0TransformCoefficient = FECSC_C0_TRANSFORM_COEFFICIENT_OR10;

            DW1.Value = 0;
            DW1.FecscC1TransformCoefficient = FECSC_C1_TRANSFORM_COEFFICIENT_OR00;

            DW2.Value = 0;
            DW2.FecscC2TransformCoefficient = FECSC_C2_TRANSFORM_COEFFICIENT_OR00;

            DW3.Value = 0;
            DW3.FecscC3TransformCoefficient = FECSC_C3_TRANSFORM_COEFFICIENT_OR00;

            DW4.Value = 0;
            DW4.FecscC4TransformCoefficient = FECSC_C4_TRANSFORM_COEFFICIENT_OR10;

            DW5.Value = 0;
            DW5.FecscC5TransformCoefficient = FECSC_C5_TRANSFORM_COEFFICIENT_OR00;

            DW6.Value = 0;
            DW6.FecscC6TransformCoefficient = FECSC_C6_TRANSFORM_COEFFICIENT_OR00;

            DW7.Value = 0;
            DW7.FecscC7TransformCoefficient = FECSC_C7_TRANSFORM_COEFFICIENT_OR00;

            DW8.Value = 0;
            DW8.FecscC8TransformCoefficient = FECSC_C8_TRANSFORM_COEFFICIENT_OR10;

            DW9.Value = 0;
            DW9.FecScOffsetIn1OffsetInForYR = FEC_SC_OFFSET_IN_1_OFFSET_IN_FOR_YR_UNNAMED0;
            DW9.FecScOffsetOut1OffsetOutForYR = FEC_SC_OFFSET_OUT_1_OFFSET_OUT_FOR_YR_UNNAMED0;

            DW10.Value = 0;
            DW10.FecScOffsetIn2OffsetOutForUG = FEC_SC_OFFSET_IN_2_OFFSET_OUT_FOR_UG_UNNAMED0;
            DW10.FecScOffsetOut2OffsetOutForUG = FEC_SC_OFFSET_OUT_2_OFFSET_OUT_FOR_UG_UNNAMED0;

            DW11.Value = 0;
            DW11.FecScOffsetIn3OffsetOutForVB = FEC_SC_OFFSET_IN_3_OFFSET_OUT_FOR_VB_UNNAMED0;
            DW11.FecScOffsetOut3OffsetOutForVB = FEC_SC_OFFSET_OUT_3_OFFSET_OUT_FOR_VB_UNNAMED0;
        };

        static const size_t DW_SIZE = 12;
        static const size_t BYTE_SIZE = 48;
    };

    //!
    //! \brief VEBOX_GAMUT_CONTROL_STATE
    //! \details
    //! 
    //!
    struct VEBOX_GAMUT_CONTROL_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 C1                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved21                                       : __CODEGEN_BITFIELD(21, 21)    ; ///< U1
                uint32_t                 GlobalModeEnable                                 : __CODEGEN_BITFIELD(22, 22)    ; ///< U1
                uint32_t                 AR                                               : __CODEGEN_BITFIELD(23, 31)    ; ///< U9
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 C0                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved53                                       : __CODEGEN_BITFIELD(21, 21)    ; ///< U1
                uint32_t                 CmW                                              : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 C3                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved85                                       : __CODEGEN_BITFIELD(21, 21)    ; ///< U1
                uint32_t                 CmS                                              : __CODEGEN_BITFIELD(22, 31)    ; ///< U2.8
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 C2                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved117                                      : __CODEGEN_BITFIELD(21, 24)    ; ///< U4
                uint32_t                 AG                                               : __CODEGEN_BITFIELD(25, 31)    ; ///< U7
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 C5                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved149                                      : __CODEGEN_BITFIELD(21, 24)    ; ///< U4
                uint32_t                 AB                                               : __CODEGEN_BITFIELD(25, 31)    ; ///< U7
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 C4                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved181                                      : __CODEGEN_BITFIELD(21, 21)    ; ///< U1
                uint32_t                 RS                                               : __CODEGEN_BITFIELD(22, 31)    ; ///< U2.8
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 C7                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved213                                      : __CODEGEN_BITFIELD(21, 23)    ; ///< U3
                uint32_t                 CmI                                              : __CODEGEN_BITFIELD(24, 31)    ; ///< U0.8
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 C6                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved245                                      : __CODEGEN_BITFIELD(21, 23)    ; ///< U3
                uint32_t                 RI                                               : __CODEGEN_BITFIELD(24, 31)    ; ///< U0.8
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 C8                                               : __CODEGEN_BITFIELD( 0, 20)    ; ///< S516
                uint32_t                 Reserved277                                      : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 OffsetInR                                        : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved305                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 OffsetInG                                        : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved337                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 OffsetInB                                        : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved369                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 OffsetOutR                                       : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved401                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                /// uint32_t 13
                uint32_t                 OffsetOutG                                       : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved433                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                /// uint32_t 14
                uint32_t                 OffsetOutB                                       : __CODEGEN_BITFIELD( 0, 16)    ; ///< S17
                uint32_t                 Reserved465                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                /// uint32_t 15
                uint32_t                 D1Out                                            : __CODEGEN_BITFIELD( 0,  9)    ; ///< U10
                uint32_t                 DOutDefault                                      : __CODEGEN_BITFIELD(10, 19)    ; ///< U10
                uint32_t                 DInDefault                                       : __CODEGEN_BITFIELD(20, 29)    ; ///< U10
                uint32_t                 Fullrangemappingenable                           : __CODEGEN_BITFIELD(30, 30)    ; ///< U1
                uint32_t                 Reserved511                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                /// uint32_t 16
                uint32_t                 D1In                                             : __CODEGEN_BITFIELD( 0,  9)    ; ///< U10
                uint32_t                 Reserved522                                      : __CODEGEN_BITFIELD(10, 27)    ; ///< U18
                uint32_t                 Compressionlineshift                             : __CODEGEN_BITFIELD(28, 30)    ; ///< U3
                uint32_t                 Xvyccdecencenable                                : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                /// uint32_t 17
                uint32_t                 CpiOverride                                      : __CODEGEN_BITFIELD( 0,  0)    ; ///< U1
                uint32_t                 Reserved545                                      : __CODEGEN_BITFIELD( 1, 10)    ; ///< U10
                uint32_t                 Basicmodescalingfactor                           : __CODEGEN_BITFIELD(11, 24)    ; ///< U2.12
                uint32_t                 Reserved569                                      : __CODEGEN_BITFIELD(25, 28)    ; ///< U4
                uint32_t                 Lumachormaonlycorrection                         : __CODEGEN_BITFIELD(29, 29)    ; ///< U1
                uint32_t                 GccBasicmodeselection                            : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW17;

        //! \name Local enumerations

        enum C1
        {
            C1_1825665536                                                    = 18256, ///<
        };
        enum GLOBAL_MODE_ENABLE
        {
            GLOBAL_MODE_ENABLE_ADVANCEMODE                                   = 0, ///<
            GLOBAL_MODE_ENABLE_BASICMODE                                     = 1, ///<
        };
        enum AR
        {
            AR_UNNAMED436                                                    = 436, ///<
        };
        enum C0
        {
            C0_4467265536                                                    = 44672, ///<
        };
        enum C3
        {
            C3_113665536                                                     = 1136, ///<
        };
        enum C2
        {
            C2_54465536                                                      = 544, ///<
        };
        enum C5
        {
            C5_83265536                                                      = 33553600, ///<
        };
        enum C4
        {
            C4_5380865536                                                    = 53808, ///<
        };
        enum C7
        {
            C7_268865536                                                     = 2688, ///<
        };
        enum C6
        {
            C6_19265536                                                      = 33554240, ///<
        };
        enum C8
        {
            C8_5494465536                                                    = 54944, ///<
        };
        enum OFFSET_IN_R
        {
            OFFSET_IN_R_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_IN_G
        {
            OFFSET_IN_G_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_IN_B
        {
            OFFSET_IN_B_UNNAMED0                                             = 0, ///<
        };
        enum OFFSET_OUT_R
        {
            OFFSET_OUT_R_UNNAMED0                                            = 0, ///<
        };
        enum OFFSET_OUT_G
        {
            OFFSET_OUT_G_UNNAMED0                                            = 0, ///<
        };
        enum OFFSET_OUT_B
        {
            OFFSET_OUT_B_UNNAMED0                                            = 0, ///<
        };
        enum D1OUT
        {
            D1OUT_UNNAMED287                                                 = 287, ///<
        };
        enum DOUT_DEFAULT
        {
            DOUT_DEFAULT_UNNAMED164                                          = 164, ///<
        };
        enum DINDEFAULT
        {
            DINDEFAULT_UNNAMED205                                            = 205, ///<
        };
        enum FULLRANGEMAPPINGENABLE
        {
            FULLRANGEMAPPINGENABLE_BASICMODE                                 = 0, ///<
            FULLRANGEMAPPINGENABLE_ADVANCEMODE                               = 1, ///<
        };
        enum D1IN
        {
            D1IN_UNNAMED820                                                  = 820, ///<
        };
        enum COMPRESSIONLINESHIFT
        {
            COMPRESSIONLINESHIFT_UNNAMED0                                    = 0, ///<
            COMPRESSIONLINESHIFT_UNNAMED3                                    = 3, ///<
            COMPRESSIONLINESHIFT_UNNAMED4                                    = 4, ///<
        };
        enum XVYCCDECENCENABLE
        {
            XVYCCDECENCENABLE_TODISABLEBOTHXVYCCDECODEANDXVYCCENCODE         = 0, ///<
            XVYCCDECENCENABLE_BOTHXVYCCDECODEANDXVYCCENCODEAREENABLED        = 1, ///<
        };
        enum CPI_OVERRIDE
        {
            CPI_OVERRIDE_UNNAMED0                                            = 0, ///<
            CPI_OVERRIDE_OVERRIDECPICALCULATION                              = 1, ///<
        };
        enum LUMACHORMAONLYCORRECTION
        {
            LUMACHORMAONLYCORRECTION_LUMAONLYCORRECTION                      = 0, ///<
            LUMACHORMAONLYCORRECTION_CHORMAONLYCORRECTION                    = 1, ///<
        };
        enum GCC_BASICMODESELECTION
        {
            GCC_BASICMODESELECTION_DEFAULT                                   = 0, ///<
            GCC_BASICMODESELECTION_SCALINGFACTOR                             = 1, ///< Used along with Dword66 Bits 28:11
            GCC_BASICMODESELECTION_SINGLEAXISGAMMACORRECTION                 = 2, ///< Used along with Dword67 Bit 29
            GCC_BASICMODESELECTION_SCALINGFACTORWITHFIXEDLUMA                = 3, ///< Used along with Dword37 Bits 28:11
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_GAMUT_CONTROL_STATE_CMD() {
            DW0.Value = 0;
            DW0.C1 = C1_1825665536;
            DW0.GlobalModeEnable = GLOBAL_MODE_ENABLE_ADVANCEMODE;
            DW0.AR = AR_UNNAMED436;

            DW1.Value = 0;
            DW1.C0 = C0_4467265536;

            DW2.Value = 0;
            DW2.C3 = C3_113665536;

            DW3.Value = 0;
            DW3.C2 = C2_54465536;

            DW4.Value = 0;
            DW4.C5 = C5_83265536;

            DW5.Value = 0;
            DW5.C4 = C4_5380865536;

            DW6.Value = 0;
            DW6.C7 = C7_268865536;

            DW7.Value = 0;
            DW7.C6 = C6_19265536;

            DW8.Value = 0;
            DW8.C8 = C8_5494465536;

            DW9.Value = 0;
            DW9.OffsetInR = OFFSET_IN_R_UNNAMED0;

            DW10.Value = 0;
            DW10.OffsetInG = OFFSET_IN_G_UNNAMED0;

            DW11.Value = 0;
            DW11.OffsetInB = OFFSET_IN_B_UNNAMED0;

            DW12.Value = 0;
            DW12.OffsetOutR = OFFSET_OUT_R_UNNAMED0;

            DW13.Value = 0;
            DW13.OffsetOutG = OFFSET_OUT_G_UNNAMED0;

            DW14.Value = 0;
            DW14.OffsetOutB = OFFSET_OUT_B_UNNAMED0;

            DW15.Value = 0;
            DW15.D1Out = D1OUT_UNNAMED287;
            DW15.DOutDefault = DOUT_DEFAULT_UNNAMED164;
            DW15.DInDefault = DINDEFAULT_UNNAMED205;
            DW15.Fullrangemappingenable = FULLRANGEMAPPINGENABLE_BASICMODE;

            DW16.Value = 0;
            DW16.D1In = D1IN_UNNAMED820;
            DW16.Compressionlineshift = COMPRESSIONLINESHIFT_UNNAMED3;
            DW16.Xvyccdecencenable = XVYCCDECENCENABLE_BOTHXVYCCDECODEANDXVYCCENCODEAREENABLED;

            DW17.Value = 0;
            DW17.CpiOverride = CPI_OVERRIDE_UNNAMED0;
            DW17.Lumachormaonlycorrection = LUMACHORMAONLYCORRECTION_LUMAONLYCORRECTION;
            DW17.GccBasicmodeselection = GCC_BASICMODESELECTION_DEFAULT;
        };

        static const size_t DW_SIZE = 18;
        static const size_t BYTE_SIZE = 72;
    };

    //!
    //! \brief VEBOX_STD_STE_STATE
    //! \details
    //!     This state structure contains the state used by the STD/STE function.
    //!
    struct VEBOX_STD_STE_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 StdEnable                                        : __CODEGEN_BITFIELD( 0,  0)    ; ///< U1
                uint32_t                 SteEnable                                        : __CODEGEN_BITFIELD( 1,  1)    ; ///< U1
                uint32_t                 OutputControl                                    : __CODEGEN_BITFIELD( 2,  2)    ; ///< U1
                uint32_t                 Reserved3                                        : __CODEGEN_BITFIELD( 3,  3)    ; ///< U1
                uint32_t                 SatMax                                           : __CODEGEN_BITFIELD( 4,  9)    ; ///< U6
                uint32_t                 HueMax                                           : __CODEGEN_BITFIELD(10, 15)    ; ///< U6
                uint32_t                 UMid                                             : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 VMid                                             : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 Sin                                              : __CODEGEN_BITFIELD( 0,  7)    ; ///< S17
                uint32_t                 Reserved40                                       : __CODEGEN_BITFIELD( 8,  9)    ; ///< U2
                uint32_t                 Cos                                              : __CODEGEN_BITFIELD(10, 17)    ; ///< S17
                uint32_t                 HsMargin                                         : __CODEGEN_BITFIELD(18, 20)    ; ///< U3
                uint32_t                 DiamondDu                                        : __CODEGEN_BITFIELD(21, 27)    ; ///< S7
                uint32_t                 DiamondMargin                                    : __CODEGEN_BITFIELD(28, 30)    ; ///< U3
                uint32_t                 StdScoreOutput                                   : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 DiamondDv                                        : __CODEGEN_BITFIELD( 0,  6)    ; ///< S7
                uint32_t                 DiamondTh                                        : __CODEGEN_BITFIELD( 7, 12)    ; ///< U6
                uint32_t                 DiamondAlpha                                     : __CODEGEN_BITFIELD(13, 20)    ; ///< U26
                uint32_t                 Reserved85                                       : __CODEGEN_BITFIELD(21, 31)    ; ///< U11
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 Reserved96                                       : __CODEGEN_BITFIELD( 0,  6)    ; ///< U7
                uint32_t                 VyStdEnable                                      : __CODEGEN_BITFIELD( 7,  7)    ; ///< U1
                uint32_t                 YPoint1                                          : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 YPoint2                                          : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 YPoint3                                          : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 YPoint4                                          : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 YSlope1                                          : __CODEGEN_BITFIELD( 8, 12)    ; ///< U23
                uint32_t                 YSlope2                                          : __CODEGEN_BITFIELD(13, 17)    ; ///< U23
                uint32_t                 Reserved146                                      : __CODEGEN_BITFIELD(18, 31)    ; ///< U14
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 InvMarginVyl                                     : __CODEGEN_BITFIELD( 0, 15)    ; ///< U0.16
                uint32_t                 InvSkinTypesMargin                               : __CODEGEN_BITFIELD(16, 31)    ; ///< U016
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 InvMarginVyu                                     : __CODEGEN_BITFIELD( 0, 15)    ; ///< U016
                uint32_t                 P0L                                              : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 P1L                                              : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 P2L                                              : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 P3L                                              : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 B0L                                              : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 B1L                                              : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 B2L                                              : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 B3L                                              : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 S0L                                              : __CODEGEN_BITFIELD(16, 26)    ; ///< S38
                uint32_t                 Reserved283                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 S1L                                              : __CODEGEN_BITFIELD( 0, 10)    ; ///< S38
                uint32_t                 S2L                                              : __CODEGEN_BITFIELD(11, 21)    ; ///< S38
                uint32_t                 Reserved310                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 S3L                                              : __CODEGEN_BITFIELD( 0, 10)    ; ///< S38
                uint32_t                 P0U                                              : __CODEGEN_BITFIELD(11, 18)    ; ///< U8
                uint32_t                 P1U                                              : __CODEGEN_BITFIELD(19, 26)    ; ///< U8
                uint32_t                 Reserved347                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 P2U                                              : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 P3U                                              : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 B0U                                              : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 B1U                                              : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 B2U                                              : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 B3U                                              : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 S0U                                              : __CODEGEN_BITFIELD(16, 26)    ; ///< S38
                uint32_t                 Reserved411                                      : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                /// uint32_t 13
                uint32_t                 S1U                                              : __CODEGEN_BITFIELD( 0, 10)    ; ///< S38
                uint32_t                 S2U                                              : __CODEGEN_BITFIELD(11, 21)    ; ///< S38
                uint32_t                 Reserved438                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                /// uint32_t 14
                uint32_t                 S3U                                              : __CODEGEN_BITFIELD( 0, 10)    ; ///< S38
                uint32_t                 SkinTypesEnable                                  : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 SkinTypesThresh                                  : __CODEGEN_BITFIELD(12, 19)    ; ///< U8
                uint32_t                 SkinTypesMargin                                  : __CODEGEN_BITFIELD(20, 27)    ; ///< U8
                uint32_t                 Reserved476                                      : __CODEGEN_BITFIELD(28, 31)    ; ///< U4
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                /// uint32_t 15
                uint32_t                 Satp1                                            : __CODEGEN_BITFIELD( 0,  6)    ; ///< S7
                uint32_t                 Satp2                                            : __CODEGEN_BITFIELD( 7, 13)    ; ///< S7
                uint32_t                 Satp3                                            : __CODEGEN_BITFIELD(14, 20)    ; ///< S7
                uint32_t                 Satb1                                            : __CODEGEN_BITFIELD(21, 30)    ; ///< S82
                uint32_t                 Reserved511                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                /// uint32_t 16
                uint32_t                 Satb2                                            : __CODEGEN_BITFIELD( 0,  9)    ; ///< S82
                uint32_t                 Satb3                                            : __CODEGEN_BITFIELD(10, 19)    ; ///< S82
                uint32_t                 Sats0                                            : __CODEGEN_BITFIELD(20, 30)    ; ///< U38
                uint32_t                 Reserved543                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                /// uint32_t 17
                uint32_t                 Sats1                                            : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Sats2                                            : __CODEGEN_BITFIELD(11, 21)    ; ///< U38
                uint32_t                 Reserved566                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                /// uint32_t 18
                uint32_t                 Sats3                                            : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Huep1                                            : __CODEGEN_BITFIELD(11, 17)    ; ///< S7
                uint32_t                 Huep2                                            : __CODEGEN_BITFIELD(18, 24)    ; ///< S7
                uint32_t                 Huep3                                            : __CODEGEN_BITFIELD(25, 31)    ; ///< S7
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                /// uint32_t 19
                uint32_t                 Hueb1                                            : __CODEGEN_BITFIELD( 0,  9)    ; ///< S82
                uint32_t                 Hueb2                                            : __CODEGEN_BITFIELD(10, 19)    ; ///< S82
                uint32_t                 Hueb3                                            : __CODEGEN_BITFIELD(20, 29)    ; ///< S82
                uint32_t                 Reserved638                                      : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                /// uint32_t 20
                uint32_t                 Hues0                                            : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Hues1                                            : __CODEGEN_BITFIELD(11, 21)    ; ///< U38
                uint32_t                 Reserved662                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                /// uint32_t 21
                uint32_t                 Hues2                                            : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Hues3                                            : __CODEGEN_BITFIELD(11, 21)    ; ///< U38
                uint32_t                 Reserved694                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                /// uint32_t 22
                uint32_t                 Satp1Dark                                        : __CODEGEN_BITFIELD( 0,  6)    ; ///< S7
                uint32_t                 Satp2Dark                                        : __CODEGEN_BITFIELD( 7, 13)    ; ///< S7
                uint32_t                 Satp3Dark                                        : __CODEGEN_BITFIELD(14, 20)    ; ///< S7
                uint32_t                 Satb1Dark                                        : __CODEGEN_BITFIELD(21, 30)    ; ///< S82
                uint32_t                 Reserved735                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                /// uint32_t 23
                uint32_t                 Satb2Dark                                        : __CODEGEN_BITFIELD( 0,  9)    ; ///< S82
                uint32_t                 Satb3Dark                                        : __CODEGEN_BITFIELD(10, 19)    ; ///< S82
                uint32_t                 Sats0Dark                                        : __CODEGEN_BITFIELD(20, 30)    ; ///< U38
                uint32_t                 Reserved767                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW23;
        union
        {
            struct
            {
                /// uint32_t 24
                uint32_t                 Sats1Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Sats2Dark                                        : __CODEGEN_BITFIELD(11, 21)    ; ///< U38
                uint32_t                 Reserved790                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                /// uint32_t 25
                uint32_t                 Sats3Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Huep1Dark                                        : __CODEGEN_BITFIELD(11, 17)    ; ///< S7
                uint32_t                 Huep2Dark                                        : __CODEGEN_BITFIELD(18, 24)    ; ///< S7
                uint32_t                 Huep3Dark                                        : __CODEGEN_BITFIELD(25, 31)    ; ///< S7
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                /// uint32_t 26
                uint32_t                 Hueb1Dark                                        : __CODEGEN_BITFIELD( 0,  9)    ; ///< S82
                uint32_t                 Hueb2Dark                                        : __CODEGEN_BITFIELD(10, 19)    ; ///< S82
                uint32_t                 Hueb3Dark                                        : __CODEGEN_BITFIELD(20, 29)    ; ///< S82
                uint32_t                 Reserved862                                      : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW26;
        union
        {
            struct
            {
                /// uint32_t 27
                uint32_t                 Hues0Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Hues1Dark                                        : __CODEGEN_BITFIELD(11, 21)    ; ///< U38
                uint32_t                 Reserved886                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW27;
        union
        {
            struct
            {
                /// uint32_t 28
                uint32_t                 Hues2Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; ///< U38
                uint32_t                 Hues3Dark                                        : __CODEGEN_BITFIELD(11, 21)    ; ///< U38
                uint32_t                 Reserved918                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW28;

        //! \name Local enumerations

        enum OUTPUT_CONTROL
        {
            OUTPUT_CONTROL_OUTPUTPIXELS                                      = 0, ///<
            OUTPUT_CONTROL_OUTPUTSTDDECISIONS                                = 1, ///<
        };
        enum SAT_MAX
        {
            SAT_MAX_UNNAMED31                                                = 31, ///<
        };
        enum HUE_MAX
        {
            HUE_MAX_UNNAMED14                                                = 14, ///<
        };
        enum U_MID
        {
            U_MID_UNNAMED110                                                 = 110, ///<
        };
        enum V_MID
        {
            V_MID_UNNAMED154                                                 = 154, ///<
        };
        enum SIN
        {
            SIN_UNNAMED101                                                  = 101, ///<
        };
        enum COS
        {
            COS_UNNAMED79                                                   = 79, ///<
        };
        enum HS_MARGIN
        {
            HS_MARGIN_UNNAMED3                                               = 3, ///<
        };
        enum DIAMOND_DU
        {
            DIAMOND_DU_UNNAMED0                                              = 0, ///<
        };
        enum DIAMOND_MARGIN
        {
            DIAMOND_MARGIN_UNNAMED4                                          = 4, ///<
        };
        enum DIAMOND_DV
        {
            DIAMOND_DV_UNNAMED0                                              = 0, ///<
        };
        enum DIAMOND_TH
        {
            DIAMOND_TH_UNNAMED35                                             = 35, ///<
        };
        enum DIAMOND_ALPHA
        {
            DIAMOND_ALPHA_UNNAMED100                                         = 100, ///<
        };
        enum Y_POINT_1
        {
            Y_POINT_1_UNNAMED46                                              = 46, ///<
        };
        enum Y_POINT_2
        {
            Y_POINT_2_UNNAMED47                                              = 47, ///<
        };
        enum Y_POINT_3
        {
            Y_POINT_3_UNNAMED254                                             = 254, ///<
        };
        enum Y_POINT_4
        {
            Y_POINT_4_UNNAMED255                                             = 255, ///<
        };
        enum Y_SLOPE_1
        {
            Y_SLOPE_1_UNNAMED31                                              = 31, ///<
        };
        enum Y_SLOPE_2
        {
            Y_SLOPE_2_UNNAMED31                                              = 31, ///<
        };
        enum INV_SKIN_TYPES_MARGIN
        {
            INV_SKIN_TYPES_MARGIN_SKINTYPEMARGIN                             = 20, ///<
        };
        enum INV_MARGIN_VYU
        {
            INV_MARGIN_VYU_UNNAMED1600                                       = 1600, ///<
        };
        enum P0L
        {
            P0L_UNNAMED46                                                    = 46, ///<
        };
        enum P1L
        {
            P1L_UNNAMED216                                                   = 216, ///<
        };
        enum P2L
        {
            P2L_UNNAMED236                                                   = 236, ///<
        };
        enum P3L
        {
            P3L_UNNAMED236                                                   = 236, ///<
        };
        enum B0L
        {
            B0L_UNNAMED133                                                   = 133, ///<
        };
        enum B1L
        {
            B1L_UNNAMED130                                                   = 130, ///<
        };
        enum B2L
        {
            B2L_UNNAMED130                                                   = 130, ///<
        };
        enum B3L
        {
            B3L_UNNAMED130                                                   = 130, ///<
        };
        enum S0L
        {
            S0L_UNNAMED4091                                                  = 4091, ///<
        };
        enum S1L
        {
            S1L_UNNAMED0                                                     = 0, ///<
        };
        enum S2L
        {
            S2L_UNNAMED0                                                     = 0, ///<
        };
        enum S3L
        {
            S3L_UNNAMED0                                                     = 0, ///<
        };
        enum P0U
        {
            P0U_UNNAMED46                                                    = 46, ///<
        };
        enum P1U
        {
            P1U_UNNAMED66                                                    = 66, ///<
        };
        enum P2U
        {
            P2U_UNNAMED150                                                   = 150, ///<
        };
        enum P3U
        {
            P3U_UNNAMED236                                                   = 236, ///<
        };
        enum B0U
        {
            B0U_UNNAMED143                                                   = 143, ///<
        };
        enum B1U
        {
            B1U_UNNAMED163                                                   = 163, ///<
        };
        enum B2U
        {
            B2U_UNNAMED200                                                   = 200, ///<
        };
        enum B3U
        {
            B3U_UNNAMED200                                                   = 200, ///<
        };
        enum S0U
        {
            S0U_UNNAMED256                                                   = 256, ///<
        };
        enum S1U
        {
            S1U_UNNAMED113                                                   = 113, ///<
        };
        enum S2U
        {
            S2U_UNNAMED3917                                                  = 3917, ///<
        };
        enum S3U
        {
            S3U_UNNAMED0                                                     = 0, ///<
        };
        enum SKIN_TYPES_THRESH
        {
            SKIN_TYPES_THRESH_UNNAMED120                                     = 120, ///<
        };
        enum SKIN_TYPES_MARGIN
        {
            SKIN_TYPES_MARGIN_UNNAMED20                                      = 20, ///<
        };
        enum SATP1
        {
            SATP1_UNNAMED6                                                   = 6, ///<
        };
        enum SATP2
        {
            SATP2_UNNAMED6                                                   = 6, ///<
        };
        enum SATP3
        {
            SATP3_UNNAMED31                                                  = 31, ///<
        };
        enum SATB1
        {
            SATB1_UNNAMED8                                                   = 8, ///<
        };
        enum SATB2
        {
            SATB2_UNNAMED8                                                   = 8, ///<
        };
        enum SATB3
        {
            SATB3_UNNAMED124                                                 = 124, ///<
        };
        enum SATS0
        {
            SATS0_UNNAMED297                                                 = 297, ///<
        };
        enum SATS1
        {
            SATS1_UNNAMED85                                                  = 85, ///<
        };
        enum SATS2
        {
            SATS2_UNNAMED297                                                 = 297, ///<
        };
        enum SATS3
        {
            SATS3_UNNAMED256                                                 = 256, ///<
        };
        enum HUEP1
        {
            HUEP1_6                                                          = 122, ///<
        };
        enum HUEP2
        {
            HUEP2_UNNAMED6                                                   = 6, ///<
        };
        enum HUEP3
        {
            HUEP3_UNNAMED14                                                  = 14, ///<
        };
        enum HUEB1
        {
            HUEB1_UNNAMED8                                                   = 8, ///<
        };
        enum HUEB2
        {
            HUEB2_UNNAMED8                                                   = 8, ///<
        };
        enum HUEB3
        {
            HUEB3_UNNAMED56                                                  = 56, ///<
        };
        enum HUES0
        {
            HUES0_UNNAMED384                                                 = 384, ///<
        };
        enum HUES1
        {
            HUES1_UNNAMED85                                                  = 85, ///<
        };
        enum HUES2
        {
            HUES2_UNNAMED384                                                 = 384, ///<
        };
        enum HUES3
        {
            HUES3_UNNAMED256                                                 = 256, ///<
        };
        enum SATP1_DARK
        {
            SATP1_DARK_UNNAMED4085                                           = 4085, ///<
        };
        enum SATP2_DARK
        {
            SATP2_DARK_UNNAMED31                                             = 31, ///<
        };
        enum SATP3_DARK
        {
            SATP3_DARK_UNNAMED31                                             = 31, ///<
        };
        enum SATB1_DARK
        {
            SATB1_DARK_UNNAMED0                                              = 0, ///<
        };
        enum SATB2_DARK
        {
            SATB2_DARK_UNNAMED124                                            = 124, ///<
        };
        enum SATB3_DARK
        {
            SATB3_DARK_UNNAMED124                                            = 124, ///<
        };
        enum SATS0_DARK
        {
            SATS0_DARK_UNNAMED397                                            = 397, ///<
        };
        enum SATS1_DARK
        {
            SATS1_DARK_UNNAMED189                                            = 189, ///<
        };
        enum SATS2_DARK
        {
            SATS2_DARK_UNNAMED256                                            = 256, ///<
        };
        enum SATS3_DARK
        {
            SATS3_DARK_UNNAMED256                                            = 256, ///<
        };
        enum HUEP1_DARK
        {
            HUEP1_DARK_UNNAMED0                                              = 0, ///<
        };
        enum HUEP2_DARK
        {
            HUEP2_DARK_UNNAMED2                                              = 2, ///<
        };
        enum HUEP3_DARK
        {
            HUEP3_DARK_UNNAMED14                                             = 14, ///<
        };
        enum HUEB1_DARK
        {
            HUEB1_DARK_UNNAMED0                                              = 0, ///<
        };
        enum HUEB2_DARK
        {
            HUEB2_DARK_UNNAMED0                                              = 0, ///<
        };
        enum HUEB3_DARK
        {
            HUEB3_DARK_UNNAMED56                                             = 56, ///<
        };
        enum HUES0_DARK
        {
            HUES0_DARK_UNNAMED299                                            = 299, ///<
        };
        enum HUES1_DARK
        {
            HUES1_DARK_UNNAMED256                                            = 256, ///<
        };
        enum HUES2_DARK
        {
            HUES2_DARK_UNNAMED299                                            = 299, ///<
        };
        enum HUES3_DARK
        {
            HUES3_DARK_UNNAMED256                                            = 256, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_STD_STE_STATE_CMD() {
            DW0.Value = 0;
            DW0.OutputControl = OUTPUT_CONTROL_OUTPUTPIXELS;
            DW0.SatMax = SAT_MAX_UNNAMED31;
            DW0.HueMax = HUE_MAX_UNNAMED14;
            DW0.UMid = U_MID_UNNAMED110;
            DW0.VMid = V_MID_UNNAMED154;

            DW1.Value = 0;
            DW1.Sin = SIN_UNNAMED101;
            DW1.Cos = COS_UNNAMED79;
            DW1.HsMargin = HS_MARGIN_UNNAMED3;
            DW1.DiamondDu = DIAMOND_DU_UNNAMED0;
            DW1.DiamondMargin = DIAMOND_MARGIN_UNNAMED4;

            DW2.Value = 0;
            DW2.DiamondDv = DIAMOND_DV_UNNAMED0;
            DW2.DiamondTh = DIAMOND_TH_UNNAMED35;
            DW2.DiamondAlpha = DIAMOND_ALPHA_UNNAMED100;

            DW3.Value = 0;
            DW3.YPoint1 = Y_POINT_1_UNNAMED46;
            DW3.YPoint2 = Y_POINT_2_UNNAMED47;
            DW3.YPoint3 = Y_POINT_3_UNNAMED254;

            DW4.Value = 0;
            DW4.YPoint4 = Y_POINT_4_UNNAMED255;
            DW4.YSlope1 = Y_SLOPE_1_UNNAMED31;
            DW4.YSlope2 = Y_SLOPE_2_UNNAMED31;

            DW5.Value = 0;
            DW5.InvSkinTypesMargin = INV_SKIN_TYPES_MARGIN_SKINTYPEMARGIN;

            DW6.Value = 0;
            DW6.InvMarginVyu = INV_MARGIN_VYU_UNNAMED1600;
            DW6.P0L = P0L_UNNAMED46;
            DW6.P1L = P1L_UNNAMED216;

            DW7.Value = 0;
            DW7.P2L = P2L_UNNAMED236;
            DW7.P3L = P3L_UNNAMED236;
            DW7.B0L = B0L_UNNAMED133;
            DW7.B1L = B1L_UNNAMED130;

            DW8.Value = 0;
            DW8.B2L = B2L_UNNAMED130;
            DW8.B3L = B3L_UNNAMED130;
            DW8.S0L = S0L_UNNAMED4091;

            DW9.Value = 0;
            DW9.S1L = S1L_UNNAMED0;
            DW9.S2L = S2L_UNNAMED0;

            DW10.Value = 0;
            DW10.S3L = S3L_UNNAMED0;
            DW10.P0U = P0U_UNNAMED46;
            DW10.P1U = P1U_UNNAMED66;

            DW11.Value = 0;
            DW11.P2U = P2U_UNNAMED150;
            DW11.P3U = P3U_UNNAMED236;
            DW11.B0U = B0U_UNNAMED143;
            DW11.B1U = B1U_UNNAMED163;

            DW12.Value = 0;
            DW12.B2U = B2U_UNNAMED200;
            DW12.B3U = B3U_UNNAMED200;
            DW12.S0U = S0U_UNNAMED256;

            DW13.Value = 0;
            DW13.S1U = S1U_UNNAMED113;
            DW13.S2U = S2U_UNNAMED3917;

            DW14.Value = 0;
            DW14.S3U = S3U_UNNAMED0;
            DW14.SkinTypesThresh = SKIN_TYPES_THRESH_UNNAMED120;
            DW14.SkinTypesMargin = SKIN_TYPES_MARGIN_UNNAMED20;

            DW15.Value = 0;
            DW15.Satp1 = SATP1_UNNAMED6;
            DW15.Satp2 = SATP2_UNNAMED6;
            DW15.Satp3 = SATP3_UNNAMED31;
            DW15.Satb1 = SATB1_UNNAMED8;

            DW16.Value = 0;
            DW16.Satb2 = SATB2_UNNAMED8;
            DW16.Satb3 = SATB3_UNNAMED124;
            DW16.Sats0 = SATS0_UNNAMED297;

            DW17.Value = 0;
            DW17.Sats1 = SATS1_UNNAMED85;
            DW17.Sats2 = SATS2_UNNAMED297;

            DW18.Value = 0;
            DW18.Sats3 = SATS3_UNNAMED256;
            DW18.Huep1 = HUEP1_6;
            DW18.Huep2 = HUEP2_UNNAMED6;
            DW18.Huep3 = HUEP3_UNNAMED14;

            DW19.Value = 0;
            DW19.Hueb1 = HUEB1_UNNAMED8;
            DW19.Hueb2 = HUEB2_UNNAMED8;
            DW19.Hueb3 = HUEB3_UNNAMED56;

            DW20.Value = 0;
            DW20.Hues0 = HUES0_UNNAMED384;
            DW20.Hues1 = HUES1_UNNAMED85;

            DW21.Value = 0;
            DW21.Hues2 = HUES2_UNNAMED384;
            DW21.Hues3 = HUES3_UNNAMED256;

            DW22.Value = 0;
            DW22.Satp1Dark = SATP1_DARK_UNNAMED4085;
            DW22.Satp2Dark = SATP2_DARK_UNNAMED31;
            DW22.Satp3Dark = SATP3_DARK_UNNAMED31;
            DW22.Satb1Dark = SATB1_DARK_UNNAMED0;

            DW23.Value = 0;
            DW23.Satb2Dark = SATB2_DARK_UNNAMED124;
            DW23.Satb3Dark = SATB3_DARK_UNNAMED124;
            DW23.Sats0Dark = SATS0_DARK_UNNAMED397;

            DW24.Value = 0;
            DW24.Sats1Dark = SATS1_DARK_UNNAMED189;
            DW24.Sats2Dark = SATS2_DARK_UNNAMED256;

            DW25.Value = 0;
            DW25.Sats3Dark = SATS3_DARK_UNNAMED256;
            DW25.Huep1Dark = HUEP1_DARK_UNNAMED0;
            DW25.Huep2Dark = HUEP2_DARK_UNNAMED2;
            DW25.Huep3Dark = HUEP3_DARK_UNNAMED14;

            DW26.Value = 0;
            DW26.Hueb1Dark = HUEB1_DARK_UNNAMED0;
            DW26.Hueb2Dark = HUEB2_DARK_UNNAMED0;
            DW26.Hueb3Dark = HUEB3_DARK_UNNAMED56;

            DW27.Value = 0;
            DW27.Hues0Dark = HUES0_DARK_UNNAMED299;
            DW27.Hues1Dark = HUES1_DARK_UNNAMED256;

            DW28.Value = 0;
            DW28.Hues2Dark = HUES2_DARK_UNNAMED299;
            DW28.Hues3Dark = HUES3_DARK_UNNAMED256;

        };

        static const size_t DW_SIZE = 29;
        static const size_t BYTE_SIZE = 116;
    };

    //!
    //! \brief VEBOX_TCC_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for TCC
    //!     state.
    //!
    struct VEBOX_TCC_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 Reserved0                                        : __CODEGEN_BITFIELD( 0,  6)    ; ///< U7
                uint32_t                 TccEnable                                        : __CODEGEN_BITFIELD( 7,  7)    ; ///< U1
                uint32_t                 Satfactor1                                       : __CODEGEN_BITFIELD( 8, 15)    ; ///< U17
                uint32_t                 Satfactor2                                       : __CODEGEN_BITFIELD(16, 23)    ; ///< U17
                uint32_t                 Satfactor3                                       : __CODEGEN_BITFIELD(24, 31)    ; ///< U17
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 Reserved32                                       : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 Satfactor4                                       : __CODEGEN_BITFIELD( 8, 15)    ; ///< U17
                uint32_t                 Satfactor5                                       : __CODEGEN_BITFIELD(16, 23)    ; ///< U17
                uint32_t                 Satfactor6                                       : __CODEGEN_BITFIELD(24, 31)    ; ///< U17
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 Basecolor1                                       : __CODEGEN_BITFIELD( 0,  9)    ; ///< U10
                uint32_t                 Basecolor2                                       : __CODEGEN_BITFIELD(10, 19)    ; ///< U10
                uint32_t                 Basecolor3                                       : __CODEGEN_BITFIELD(20, 29)    ; ///< U10
                uint32_t                 Reserved94                                       : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 Basecolo4                                        : __CODEGEN_BITFIELD( 0,  9)    ; ///< U10
                uint32_t                 Basecolor5                                       : __CODEGEN_BITFIELD(10, 19)    ; ///< U10
                uint32_t                 Basecolor6                                       : __CODEGEN_BITFIELD(20, 29)    ; ///< U10
                uint32_t                 Reserved126                                      : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 Colortransitslope2                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U016
                uint32_t                 Colortransitslope23                              : __CODEGEN_BITFIELD(16, 31)    ; ///< U016
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 Colortransitslope34                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U016
                uint32_t                 Colortransitslope45                              : __CODEGEN_BITFIELD(16, 31)    ; ///< U016
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 Colortransitslope56                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U016
                uint32_t                 Colortransitslope61                              : __CODEGEN_BITFIELD(16, 31)    ; ///< U016
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 Reserved224                                      : __CODEGEN_BITFIELD( 0,  1)    ; ///< U2
                uint32_t                 Colorbias1                                       : __CODEGEN_BITFIELD( 2, 11)    ; ///< U28
                uint32_t                 Colorbias2                                       : __CODEGEN_BITFIELD(12, 21)    ; ///< U28
                uint32_t                 Colorbias3                                       : __CODEGEN_BITFIELD(22, 31)    ; ///< U28
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 Reserved256                                      : __CODEGEN_BITFIELD( 0,  1)    ; ///< U2
                uint32_t                 Colorbias4                                       : __CODEGEN_BITFIELD( 2, 11)    ; ///< U28
                uint32_t                 Colorbias5                                       : __CODEGEN_BITFIELD(12, 21)    ; ///< U28
                uint32_t                 Colorbias6                                       : __CODEGEN_BITFIELD(22, 31)    ; ///< U28
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 SteSlopeBits                                     : __CODEGEN_BITFIELD( 0,  2)    ; ///< U3
                uint32_t                 Reserved291                                      : __CODEGEN_BITFIELD( 3,  7)    ; ///< U5
                uint32_t                 SteThreshold                                     : __CODEGEN_BITFIELD( 8, 12)    ; ///< U5
                uint32_t                 Reserved301                                      : __CODEGEN_BITFIELD(13, 15)    ; ///< U3
                uint32_t                 UvThresholdBits                                  : __CODEGEN_BITFIELD(16, 18)    ; ///< U3
                uint32_t                 Reserved307                                      : __CODEGEN_BITFIELD(19, 23)    ; ///< U5
                uint32_t                 UvThreshold                                      : __CODEGEN_BITFIELD(24, 30)    ; ///< U7
                uint32_t                 Reserved319                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 Uvmaxcolor                                       : __CODEGEN_BITFIELD( 0,  8)    ; ///< U9
                uint32_t                 Reserved329                                      : __CODEGEN_BITFIELD( 9, 15)    ; ///< U7
                uint32_t                 InvUvmaxcolor                                    : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW10;

        //! \name Local enumerations

        enum SATFACTOR1
        {
            SATFACTOR1_UNNAMED220                                            = 220, ///<
        };
        enum SATFACTOR2
        {
            SATFACTOR2_UNNAMED220                                            = 220, ///<
        };
        enum SATFACTOR3
        {
            SATFACTOR3_UNNAMED220                                            = 220, ///<
        };
        enum SATFACTOR4
        {
            SATFACTOR4_UNNAMED220                                            = 220, ///<
        };
        enum SATFACTOR5
        {
            SATFACTOR5_UNNAMED220                                            = 220, ///<
        };
        enum SATFACTOR6
        {
            SATFACTOR6_UNNAMED220                                            = 220, ///<
        };
        enum BASECOLOR1
        {
            BASECOLOR1_UNNAMED145                                            = 145, ///<
        };
        enum BASECOLOR2
        {
            BASECOLOR2_UNNAMED307                                            = 307, ///<
        };
        enum BASECOLOR3
        {
            BASECOLOR3_UNNAMED483                                            = 483, ///<
        };
        enum BASECOLO4
        {
            BASECOLO4_UNNAMED657                                             = 657, ///<
        };
        enum BASECOLOR5
        {
            BASECOLOR5_UNNAMED819                                            = 819, ///<
        };
        enum BASECOLOR6
        {
            BASECOLOR6_UNNAMED995                                            = 995, ///<
        };
        enum COLORTRANSITSLOPE2
        {
            COLORTRANSITSLOPE2_UNNAMED405                                    = 405, ///<
        };
        enum COLORTRANSITSLOPE23
        {
            COLORTRANSITSLOPE23_UNNAMED744                                   = 744, ///<
        };
        enum COLORTRANSITSLOPE34
        {
            COLORTRANSITSLOPE34_UNNAMED1131                                  = 1131, ///<
        };
        enum COLORTRANSITSLOPE45
        {
            COLORTRANSITSLOPE45_UNNAMED407                                   = 407, ///<
        };
        enum COLORTRANSITSLOPE56
        {
            COLORTRANSITSLOPE56_UNNAMED372                                   = 372, ///<
        };
        enum COLORTRANSITSLOPE61
        {
            COLORTRANSITSLOPE61_UNNAMED377                                   = 377, ///<
        };
        enum COLORBIAS1
        {
            COLORBIAS1_UNNAMED0                                              = 0, ///<
        };
        enum COLORBIAS2
        {
            COLORBIAS2_UNNAMED150                                            = 150, ///<
        };
        enum COLORBIAS3
        {
            COLORBIAS3_UNNAMED0                                              = 0, ///<
        };
        enum COLORBIAS4
        {
            COLORBIAS4_UNNAMED0                                              = 0, ///<
        };
        enum COLORBIAS5
        {
            COLORBIAS5_UNNAMED0                                              = 0, ///<
        };
        enum COLORBIAS6
        {
            COLORBIAS6_UNNAMED0                                              = 0, ///<
        };
        enum STE_SLOPE_BITS
        {
            STE_SLOPE_BITS_UNNAMED0                                          = 0, ///<
        };
        enum STE_THRESHOLD
        {
            STE_THRESHOLD_UNNAMED0                                           = 0, ///<
        };
        enum UV_THRESHOLD_BITS
        {
            UV_THRESHOLD_BITS_UNNAMED3                                       = 3, ///<
        };
        enum UV_THRESHOLD
        {
            UV_THRESHOLD_UNNAMED3                                            = 3, ///<
        };
        enum UVMAXCOLOR
        {
            UVMAXCOLOR_UNNAMED448                                            = 448, ///<
        };
        enum INV_UVMAXCOLOR
        {
            INV_UVMAXCOLOR_UNNAMED146                                        = 146, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_TCC_STATE_CMD() {
            DW0.Value = 0;
            DW0.Satfactor1 = SATFACTOR1_UNNAMED220;
            DW0.Satfactor2 = SATFACTOR2_UNNAMED220;
            DW0.Satfactor3 = SATFACTOR3_UNNAMED220;

            DW1.Value = 0;
            DW1.Satfactor4 = SATFACTOR4_UNNAMED220;
            DW1.Satfactor5 = SATFACTOR5_UNNAMED220;
            DW1.Satfactor6 = SATFACTOR6_UNNAMED220;

            DW2.Value = 0;
            DW2.Basecolor1 = BASECOLOR1_UNNAMED145;
            DW2.Basecolor2 = BASECOLOR2_UNNAMED307;
            DW2.Basecolor3 = BASECOLOR3_UNNAMED483;

            DW3.Value = 0;
            DW3.Basecolo4 = BASECOLO4_UNNAMED657;
            DW3.Basecolor5 = BASECOLOR5_UNNAMED819;
            DW3.Basecolor6 = BASECOLOR6_UNNAMED995;

            DW4.Value = 0;
            DW4.Colortransitslope2 = COLORTRANSITSLOPE2_UNNAMED405;
            DW4.Colortransitslope23 = COLORTRANSITSLOPE23_UNNAMED744;

            DW5.Value = 0;
            DW5.Colortransitslope34 = COLORTRANSITSLOPE34_UNNAMED1131;
            DW5.Colortransitslope45 = COLORTRANSITSLOPE45_UNNAMED407;

            DW6.Value = 0;
            DW6.Colortransitslope56 = COLORTRANSITSLOPE56_UNNAMED372;
            DW6.Colortransitslope61 = COLORTRANSITSLOPE61_UNNAMED377;

            DW7.Value = 0;
            DW7.Colorbias1 = COLORBIAS1_UNNAMED0;
            DW7.Colorbias2 = COLORBIAS2_UNNAMED150;
            DW7.Colorbias3 = COLORBIAS3_UNNAMED0;

            DW8.Value = 0;
            DW8.Colorbias4 = COLORBIAS4_UNNAMED0;
            DW8.Colorbias5 = COLORBIAS5_UNNAMED0;
            DW8.Colorbias6 = COLORBIAS6_UNNAMED0;

            DW9.Value = 0;
            DW9.SteSlopeBits = STE_SLOPE_BITS_UNNAMED0;
            DW9.SteThreshold = STE_THRESHOLD_UNNAMED0;
            DW9.UvThresholdBits = UV_THRESHOLD_BITS_UNNAMED3;
            DW9.UvThreshold = UV_THRESHOLD_UNNAMED3;

            DW10.Value = 0;
            DW10.Uvmaxcolor = UVMAXCOLOR_UNNAMED448;
            DW10.InvUvmaxcolor = INV_UVMAXCOLOR_UNNAMED146;
        };

        static const size_t DW_SIZE = 11;
        static const size_t BYTE_SIZE = 44;
    };

    //!
    //! \brief VEBOX_PROCAMP_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for ProcAmp
    //!     state.
    //!
    struct VEBOX_PROCAMP_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 ProcampEnable                                    : __CODEGEN_BITFIELD( 0,  0)    ; ///< U1
                uint32_t                 Brightness                                       : __CODEGEN_BITFIELD( 1, 12)    ; ///< S84
                uint32_t                 Reserved13                                       : __CODEGEN_BITFIELD(13, 16)    ; ///< U4
                uint32_t                 Contrast                                         : __CODEGEN_BITFIELD(17, 27)    ; ///< U47
                uint32_t                 Reserved28                                       : __CODEGEN_BITFIELD(28, 31)    ; ///< U4
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 SinCS                                            : __CODEGEN_BITFIELD( 0, 15)    ; ///< S88
                uint32_t                 CosCS                                            : __CODEGEN_BITFIELD(16, 31)    ; ///< S88
            };
            uint32_t                     Value;
        } DW1;

        //! \name Local enumerations

        enum BRIGHTNESS
        {
            BRIGHTNESS_OR00                                                  = 0, ///<
        };
        enum CONTRAST
        {
            CONTRAST_10INFIXEDPOINTU47                                       = 128, ///<
        };
        enum SIN_C_S
        {
            SIN_C_S_UNNAMED0                                                 = 0, ///<
        };
        enum COS_C_S
        {
            COS_C_S_UNNAMED256                                               = 256, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_PROCAMP_STATE_CMD() {
            DW0.Value = 0;
            DW0.Brightness = BRIGHTNESS_OR00;
            DW0.Contrast = CONTRAST_10INFIXEDPOINTU47;

            DW1.Value = 0;
            DW1.SinCS = SIN_C_S_UNNAMED0;
            DW1.CosCS = COS_C_S_UNNAMED256;
        };

        static const size_t DW_SIZE = 2;
        static const size_t BYTE_SIZE = 8;
    };

    //!
    //! \brief VEBOX_IECP_STATE
    //! \details
    //! 
    //!
    struct VEBOX_IECP_STATE_CMD
    {
        VEBOX_STD_STE_STATE_CMD       StdSteState                                                                      ; ///< VEBOX_STD_STE_STATE
        VEBOX_ACE_LACE_STATE_CMD      AceState                                                                         ; ///< VEBOX_ACE_LACE_STATE
        VEBOX_TCC_STATE_CMD           TccState                                                                         ; ///< VEBOX_TCC_STATE
        VEBOX_PROCAMP_STATE_CMD       ProcampState                                                                     ; ///< VEBOX_PROCAMP_STATE
        VEBOX_CSC_STATE_CMD           CscState                                                                         ; ///< VEBOX_CSC_STATE
        VEBOX_ALPHA_AOI_STATE_CMD     AlphaAoiState                                                                    ; ///< VEBOX_ALPHA_AOI_STATE
        VEBOX_CCM_STATE_CMD           CcmState                                                                         ; ///< VEBOX_CCM_STATE
        VEBOX_FRONT_END_CSC_STATE_CMD FrontEndCsc                                                                      ; ///< VEBOX_FRONT_END_CSC_STATE
        VEBOX_GAMUT_CONTROL_STATE_CMD GamutState                                                                       ; ///< VEBOX_GAMUT_CONTROL_STATE

        //! \name Local enumerations

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_IECP_STATE_CMD() {
        };

        static const size_t DW_SIZE = 115;
        static const size_t BYTE_SIZE = 460;
    };

    //!
    //! \brief VEBOX_CH_DIR_FILTER_COEFFICIENT
    //! \details
    //! 
    //!
    struct VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 FilterCoefficient0                               : __CODEGEN_BITFIELD( 0,  7)    ; ///< S2.6
                uint32_t                 FilterCoefficient1                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< S2.6
                uint32_t                 FilterCoefficient2                               : __CODEGEN_BITFIELD(16, 23)    ; ///< S2.6
                uint32_t                 FilterCoefficient3                               : __CODEGEN_BITFIELD(24, 31)    ; ///< S2.6
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 FilterCoefficient4                               : __CODEGEN_BITFIELD( 0,  7)    ; ///< S2.6
                uint32_t                 FilterCoefficient5                               : __CODEGEN_BITFIELD( 8, 15)    ; ///< S2.6
                uint32_t                 FilterCoefficient6                               : __CODEGEN_BITFIELD(16, 23)    ; ///< S2.6
                uint32_t                 FilterCoefficient7                               : __CODEGEN_BITFIELD(24, 31)    ; ///< S2.6
            };
            uint32_t                     Value;
        } DW1;

        //! \name Local enumerations

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD() {
            DW0.Value = 0;

            DW1.Value = 0;
        };

        static const size_t DW_SIZE = 2;
        static const size_t BYTE_SIZE = 8;
    };

    //!
    //! \brief VEBOX_Scalar_State
    //! \details
    //! 
    //!
    struct VEBOX_Scalar_State_CMD
    {
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableYChXDirFilterCoefficient070                                                 ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableYChYDirFilterCoefficient070                                                 ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableYChXDirFilterCoefficient170                                                 ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableYChYDirFilterCoefficient170                                                 ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChXDirFilterCoefficient070                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChYDirFilterCoefficient070                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChXDirFilterCoefficient170                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChYDirFilterCoefficient170                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChXDirFilterCoefficient270                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChYDirFilterCoefficient270                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChXDirFilterCoefficient370                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        VEBOX_CH_DIR_FILTER_COEFFICIENT_CMD TableUvChYDirFilterCoefficient370                                                ; ///< VEBOX_Ch_Dir_Filter_Coefficient
        union
        {
            struct
            {
                /// uint32_t 24
                uint32_t                 TransitionAreaWith8Pixels                        : __CODEGEN_BITFIELD( 0,  2)    ; ///< U3
                uint32_t                 Reserved771                                      : __CODEGEN_BITFIELD( 3,  3)    ; ///< U1
                uint32_t                 TransitionAreaWith4Pixels                        : __CODEGEN_BITFIELD( 4,  6)    ; ///< U3
                uint32_t                 DisableAdaptiveFilter                            : __CODEGEN_BITFIELD( 7,  7)    ; ///< U1
                uint32_t                 MaxDerivative8Pixels                             : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 MaxDerivative4Pixels                             : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 DefaultSharpnessLevel                            : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                /// uint32_t 25
                uint32_t                 EdgeTh                                           : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 Reserved808                                      : __CODEGEN_BITFIELD( 8, 31)    ; ///< U24
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                /// uint32_t 26
                uint32_t                 NumTransTh                                       : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 ChromaCoSitedVerticalPosition                    : __CODEGEN_BITFIELD( 8,  9)    ; ///< U2
                uint32_t                 ChromaCoSitedHorizontalPosition                  : __CODEGEN_BITFIELD(10, 11)    ; ///< U2
                uint32_t                 DisableChromaChannelDiagonalInterpolation        : __CODEGEN_BITFIELD(12, 12)    ; ///< U1
                uint32_t                 Mode                                             : __CODEGEN_BITFIELD(13, 13)    ; ///< U1
                uint32_t                 Dir2Threshold                                    : __CODEGEN_BITFIELD(14, 17)    ; ///< U4
                uint32_t                 DirdiagThreshold                                 : __CODEGEN_BITFIELD(18, 21)    ; ///< U4
                uint32_t                 Reserved854                                      : __CODEGEN_BITFIELD(22, 31)    ; ///< U10
            };
            uint32_t                     Value;
        } DW26;
        union
        {
            struct
            {
                /// uint32_t 27
                uint32_t                 TearingTh                                        : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 Reserved876                                      : __CODEGEN_BITFIELD(12, 31)    ; ///< U20
            };
            uint32_t                     Value;
        } DW27;
        union
        {
            struct
            {
                /// uint32_t 28
                uint32_t                 SadWt0                                           : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 SadWt1                                           : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 SadWt2                                           : __CODEGEN_BITFIELD(16, 23)    ; ///< U8
                uint32_t                 SadWt3                                           : __CODEGEN_BITFIELD(24, 31)    ; ///< U8
            };
            uint32_t                     Value;
        } DW28;
        union
        {
            struct
            {
                /// uint32_t 29
                uint32_t                 SadWt4                                           : __CODEGEN_BITFIELD( 0,  7)    ; ///< U8
                uint32_t                 SadWt5                                           : __CODEGEN_BITFIELD( 8, 15)    ; ///< U8
                uint32_t                 Reserved944                                      : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW29;

        //! \name Local enumerations

        enum DEFAULT_SHARPNESS_LEVEL
        {
            DEFAULT_SHARPNESS_LEVEL_SMOOTH                                   = 0, ///< Contribute 1 from the smooth scalar
            DEFAULT_SHARPNESS_LEVEL_SHARP                                    = 255, ///< Contribute 1 from the sharp scalar
        };
        enum EDGE_TH
        {
            EDGE_TH_UNNAMED32                                                = 32, ///<
        };
        enum NUM_TRANS_TH
        {
            NUM_TRANS_TH_UNNAMED3                                            = 3, ///<
        };
        enum CHROMA_CO_SITED_VERTICAL_POSITION
        {
            CHROMA_CO_SITED_VERTICAL_POSITION_UNNAMED0                       = 0, ///<
        };
        enum CHROMA_CO_SITED_HORIZONTAL_POSITION
        {
            CHROMA_CO_SITED_HORIZONTAL_POSITION_UNNAMED0                     = 0, ///<
        };
        enum DISABLE_CHROMA_CHANNEL_DIAGONAL_INTERPOLATION
        {
            DISABLE_CHROMA_CHANNEL_DIAGONAL_INTERPOLATION_UNNAMED0           = 0, ///<
        };
        enum MODE
        {
            MODE_UNNAMED1                                                    = 1, ///<
        };
        enum DIR2_THRESHOLD
        {
            DIR2_THRESHOLD_DEFAULT                                           = 2, ///<
        };
        enum DIRDIAG_THRESHOLD
        {
            DIRDIAG_THRESHOLD_DEFAULT                                        = 2, ///<
        };
        enum TEARING_TH
        {
            TEARING_TH_UNNAMED1800                                           = 1800, ///<
        };
        enum SAD_WT0
        {
            SAD_WT0_UNNAMED0                                                 = 0, ///<
        };
        enum SAD_WT1
        {
            SAD_WT1_UNNAMED12                                                = 12, ///<
        };
        enum SAD_WT2
        {
            SAD_WT2_UNNAMED25                                                = 25, ///<
        };
        enum SAD_WT3
        {
            SAD_WT3_UNNAMED38                                                = 38, ///<
        };
        enum SAD_WT4
        {
            SAD_WT4_UNNAMED51                                                = 51, ///<
        };
        enum SAD_WT5
        {
            SAD_WT5_UNNAMED64                                                = 64, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_Scalar_State_CMD() {
            DW24.Value = 0;
            DW24.DefaultSharpnessLevel = DEFAULT_SHARPNESS_LEVEL_SMOOTH;

            DW25.Value = 0;
            DW25.EdgeTh = EDGE_TH_UNNAMED32;

            DW26.Value = 0;
            DW26.NumTransTh = NUM_TRANS_TH_UNNAMED3;
            DW26.ChromaCoSitedVerticalPosition = CHROMA_CO_SITED_VERTICAL_POSITION_UNNAMED0;
            DW26.ChromaCoSitedHorizontalPosition = CHROMA_CO_SITED_HORIZONTAL_POSITION_UNNAMED0;
            DW26.DisableChromaChannelDiagonalInterpolation = DISABLE_CHROMA_CHANNEL_DIAGONAL_INTERPOLATION_UNNAMED0;
            DW26.Mode = MODE_UNNAMED1;
            DW26.Dir2Threshold = DIR2_THRESHOLD_DEFAULT;
            DW26.DirdiagThreshold = DIRDIAG_THRESHOLD_DEFAULT;

            DW27.Value = 0;
            DW27.TearingTh = TEARING_TH_UNNAMED1800;

            DW28.Value = 0;
            DW28.SadWt0 = SAD_WT0_UNNAMED0;
            DW28.SadWt1 = SAD_WT1_UNNAMED12;
            DW28.SadWt2 = SAD_WT2_UNNAMED25;
            DW28.SadWt3 = SAD_WT3_UNNAMED38;

            DW29.Value = 0;
            DW29.SadWt4 = SAD_WT4_UNNAMED51;
            DW29.SadWt5 = SAD_WT5_UNNAMED64;
        };

        static const size_t DW_SIZE = 30;
        static const size_t BYTE_SIZE = 120;
    };

    //!
    //! \brief VEBOX_STATE
    //! \details
    //!     This command controls the internal functions of the VEBOX. This command
    //!     has a set of indirect state buffers:  DN/DI state
    //!      IECP general state
    //!      IECP Gamut Expansion/Compression state
    //!      IECP Gamut Vertex Table state
    //!      Capture Pipe state
    //! 
    //! 
    //!     [DevSKL+]: Adds the LACE LUT Table as an indirect state buffer.
    //!
    struct VEBOX_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< =N
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; ///< U4
                uint32_t                 SubopcodeB                                       : __CODEGEN_BITFIELD(16, 20)    ; ///< U5
                uint32_t                 SubopcodeA                                       : __CODEGEN_BITFIELD(21, 23)    ; ///< U3
                uint32_t                 CommandOpcode                                    : __CODEGEN_BITFIELD(24, 26)    ; ///< U3
                uint32_t                 Pipeline                                         : __CODEGEN_BITFIELD(27, 28)    ; ///< U2
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 ColorGamutExpansionEnable                        : __CODEGEN_BITFIELD( 0,  0)    ; ///< U1
                uint32_t                 ColorGamutCompressionEnable                      : __CODEGEN_BITFIELD( 1,  1)    ; ///< U1
                uint32_t                 GlobalIecpEnable                                 : __CODEGEN_BITFIELD( 2,  2)    ; ///< U1
                uint32_t                 DnEnable                                         : __CODEGEN_BITFIELD( 3,  3)    ; ///< U1
                uint32_t                 DiEnable                                         : __CODEGEN_BITFIELD( 4,  4)    ; ///< U1
                uint32_t                 DnDiFirstFrame                                   : __CODEGEN_BITFIELD( 5,  5)    ; ///< U1
                uint32_t                 Reserved38                                       : __CODEGEN_BITFIELD( 6,  7)    ; ///< U2
                uint32_t                 DiOutputFrames                                   : __CODEGEN_BITFIELD( 8,  9)    ; ///< U2
                uint32_t                 DemosaicEnable                                   : __CODEGEN_BITFIELD(10, 10)    ; ///< U1
                uint32_t                 VignetteEnable                                   : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 AlphaPlaneEnable                                 : __CODEGEN_BITFIELD(12, 12)    ; ///< U1
                uint32_t                 HotPixelFilteringEnable                          : __CODEGEN_BITFIELD(13, 13)    ; ///< U1
                uint32_t                 SingleSliceVeboxEnable                           : __CODEGEN_BITFIELD(14, 15)    ; ///< U2
                uint32_t                 LaceCorrectionEnable                             : __CODEGEN_BITFIELD(16, 16)    ; ///< U1
                uint32_t                 DisableEncoderStatistics                         : __CODEGEN_BITFIELD(17, 17)    ; ///< U1
                uint32_t                 DisableTemporalDenoiseFilter                     : __CODEGEN_BITFIELD(18, 18)    ; ///< U1
                uint32_t                 SinglePipeEnable                                 : __CODEGEN_BITFIELD(19, 19)    ; ///< U1
                uint32_t                 ScalarMode                                       : __CODEGEN_BITFIELD(20, 20)    ; ///< U1
                uint32_t                 ForwardGammaCorrectionEnable                     : __CODEGEN_BITFIELD(21, 21)    ; ///< U1
                uint32_t                 GamutExpansionPosition                           : __CODEGEN_BITFIELD(22, 22)    ; ///< U1
                uint32_t                 Reserved55                                       : __CODEGEN_BITFIELD(23, 24)    ; ///< U2
                uint32_t                 StateSurfaceControlBits                          : __CODEGEN_BITFIELD(25, 31)    ; ///< U7
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 Reserved64                                       : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 DnDiStatePointerLow                              : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicAddress[31:12]
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 DnDiStatePointerHigh                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicAddress[47:32]
                uint32_t                 Reserved112                                      : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 Reserved128                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 IecpStatePointerLow                              : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicAddress[31:12]
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 IecpStatePointerHigh                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicAddress[47:32]
                uint32_t                 Reserved176                                      : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 Reserved192                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 GamutStatePointerLow                             : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicAddress[31:12]
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 GamutStatePointerHigh                            : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicAddress[47:32]
                uint32_t                 Reserved240                                      : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 Reserved256                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 VertexTableStatePointerLow                       : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicAddress[31:12]
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 VertexTableStatePointerHigh                      : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicAddress[47:32]
                uint32_t                 Reserved304                                      : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 Reserved320                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 CapturePipeStatePointerLow                       : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicAddress[31:12]
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 CapturePipeStatePointerHigh                      : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicAddress[47:32]
                uint32_t                 Reserved368                                      : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 Reserved384                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 LaceLutTableStatePointerLow                      : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicAddress[31:12]
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                /// uint32_t 13
                uint32_t                 LaceLutTableStatePointerHigh                     : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicAddress[47:32]
                uint32_t                 Reserved432                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 ArbitrationPriorityControlForLaceLut             : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                /// uint32_t 14..15
                uint64_t                 Reserved448                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint64_t                 GammaCorrectionValuesAddressGraphicsaddress4712  : __CODEGEN_BITFIELD(12, 47)    ; ///< Sub-structure
                uint64_t                 GammaCorrectionValuesAddressReserved             : __CODEGEN_BITFIELD(48, 63)    ; ///< Sub-structure
            };
            uint32_t                     Value[2];
        } DW14_15;
        union
        {
            struct
            {
                /// uint32_t 16
                uint32_t                 Reserved512                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< U12
                uint32_t                 Lut3DStatePointerLow                             : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicAddress[31:12]
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                /// uint32_t 17
                uint32_t                 Lut3DStatePointerHigh                            : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicAddress[47:32]
                uint32_t                 Reserved560                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 ArbitrationPriorityControlForLut3D               : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                /// uint32_t 18
                uint32_t                 ChromaUpsamplingCoSitedHorizontalOffset          : __CODEGEN_BITFIELD( 0,  1)    ; ///< U2
                uint32_t                 ChromaUpsamplingCoSitedVerticalOffset            : __CODEGEN_BITFIELD( 2,  4)    ; ///< U3
                uint32_t                 ChromaDownsamplingCoSitedHorizontalOffset        : __CODEGEN_BITFIELD( 5,  6)    ; ///< U2
                uint32_t                 ChromaDownsamplingCoSitedVerticalOffset          : __CODEGEN_BITFIELD( 7,  9)    ; ///< U3
                uint32_t                 BypassChromaUpsampling                           : __CODEGEN_BITFIELD(10, 10)    ; ///< U1
                uint32_t                 BypassChromaDownsampling                         : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 Reserved588                                      : __CODEGEN_BITFIELD(12, 28)    ; ///< U2
                uint32_t                 Lut3DSize                                        : __CODEGEN_BITFIELD(29, 30)    ; ///< U2
                uint32_t                 Lut3DEnable                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW18;

        //! \name Local enumerations

        enum SUBOPCODE_B
        {
            SUBOPCODE_B_UNNAMED2                                             = 2, ///<
        };
        enum SUBOPCODE_A
        {
            SUBOPCODE_A_UNNAMED0                                             = 0, ///<
        };
        enum COMMAND_OPCODE
        {
            COMMAND_OPCODE_VEBOX                                             = 4, ///<
        };
        enum PIPELINE
        {
            PIPELINE_MEDIA                                                   = 2, ///<
        };
        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, ///<
        };
        enum DI_OUTPUT_FRAMES
        {
            DI_OUTPUT_FRAMES_OUTPUTBOTHFRAMES                                = 0, ///<
            DI_OUTPUT_FRAMES_OUTPUTPREVIOUSFRAMEONLY                         = 1, ///<
            DI_OUTPUT_FRAMES_OUTPUTCURRENTFRAMEONLY                          = 2, ///<
        };
        enum SINGLE_SLICE_VEBOX_ENABLE
        {
            SINGLE_SLICE_VEBOX_ENABLE_BOTHSLICESENABLED                      = 0, ///<
            SINGLE_SLICE_VEBOX_ENABLE_SLICE0ENABLED                          = 1, ///<
            SINGLE_SLICE_VEBOX_ENABLE_SLICE1ENABLES                          = 2, ///<
        };
        enum SINGLE_PIPE_ENABLE
        {
            SINGLE_PIPE_ENABLE_DEFAULT                                       = 0, ///<
            SINGLE_PIPE_ENABLE_ENABLE                                        = 1, ///<
        };
        enum GAMUT_EXPANSION_POSITION
        {
            GAMUT_EXPANSION_POSITION_GAMUTEXPANSIONATTHEBACKENDOFIECPPIPE    = 0, ///<
            GAMUT_EXPANSION_POSITION_GAMUTEXPANSIONATTHEFRONTOFIECPPIPE      = 1, ///<
        };
        enum ARBITRATION_PRIORITY_CONTROL__FOR_LACE_LUT
        {
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_HIGHESTPRIORITY        = 0, ///<
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_SECONDHIGHESTPRIORITY  = 1, ///<
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_THIRDHIGHESTPRIORITY   = 2, ///<
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_LOWESTPRIORITY         = 3, ///<
        };
        enum ARBITRATION_PRIORITY_CONTROL__FOR_3D_LUT
        {
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_HIGHESTPRIORITY          = 0, ///<
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_SECONDHIGHESTPRIORITY    = 1, ///<
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_THIRDHIGHESTPRIORITY     = 2, ///<
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_LOWESTPRIORITY           = 3, ///<
        };
        enum CHROMA_UPSAMPLING_CO_SITED_HORIZONTAL_OFFSET
        {
            CHROMA_UPSAMPLING_CO_SITED_HORIZONTAL_OFFSET_UNNAMED0            = 0, ///<
        };
        enum CHROMA_UPSAMPLING_CO_SITED_VERTICAL_OFFSET
        {
            CHROMA_UPSAMPLING_CO_SITED_VERTICAL_OFFSET_UNNAMED0              = 0, ///<
        };
        enum CHROMA_DOWNSAMPLING_CO_SITED_HORIZONTAL_OFFSET
        {
            CHROMA_DOWNSAMPLING_CO_SITED_HORIZONTAL_OFFSET_UNNAMED0          = 0, ///<
        };
        enum CHROMA_DOWNSAMPLING_CO_SITED_VERTICAL_OFFSET
        {
            CHROMA_DOWNSAMPLING_CO_SITED_VERTICAL_OFFSET_UNNAMED0            = 0, ///<
        };
        enum BYPASS_CHROMA_UPSAMPLING
        {
            BYPASS_CHROMA_UPSAMPLING_UNNAMED1                                = 1, ///<
        };
        enum BYPASS_CHROMA_DOWNSAMPLING
        {
            BYPASS_CHROMA_DOWNSAMPLING_UNNAMED1                              = 1, ///<
        };
        enum _3D_LUT_SIZE
        {
            _3D_LUT_SIZE_33X33X33                                            = 0, ///<
            _3D_LUT_SIZE_17X17X17                                            = 1, ///<
            _3D_LUT_SIZE_65X65X65                                            = 2, ///<
        };
        enum PATCH_CONSTANTS
        {
            DNDISTATEPOINTERLOW_BYTEOFFSET                                   = 8, ///<
            DNDISTATEPOINTERLOW_INDEX                                        = 2, ///<
            DNDISTATEPOINTERHIGH_BYTEOFFSET                                  = 12, ///<
            DNDISTATEPOINTERHIGH_INDEX                                       = 3, ///<
            IECPSTATEPOINTERLOW_BYTEOFFSET                                   = 16, ///<
            IECPSTATEPOINTERLOW_INDEX                                        = 4, ///<
            IECPSTATEPOINTERHIGH_BYTEOFFSET                                  = 20, ///<
            IECPSTATEPOINTERHIGH_INDEX                                       = 5, ///<
            GAMUTSTATEPOINTERLOW_BYTEOFFSET                                  = 24, ///<
            GAMUTSTATEPOINTERLOW_INDEX                                       = 6, ///<
            GAMUTSTATEPOINTERHIGH_BYTEOFFSET                                 = 28, ///<
            GAMUTSTATEPOINTERHIGH_INDEX                                      = 7, ///<
            VERTEXTABLESTATEPOINTERLOW_BYTEOFFSET                            = 32, ///<
            VERTEXTABLESTATEPOINTERLOW_INDEX                                 = 8, ///<
            VERTEXTABLESTATEPOINTERHIGH_BYTEOFFSET                           = 36, ///<
            VERTEXTABLESTATEPOINTERHIGH_INDEX                                = 9, ///<
            CAPTUREPIPESTATEPOINTERLOW_BYTEOFFSET                            = 40, ///<
            CAPTUREPIPESTATEPOINTERLOW_INDEX                                 = 10, ///<
            CAPTUREPIPESTATEPOINTERHIGH_BYTEOFFSET                           = 44, ///<
            CAPTUREPIPESTATEPOINTERHIGH_INDEX                                = 11, ///<
            LACELUTTABLESTATEPOINTERLOW_BYTEOFFSET                           = 48, ///<
            LACELUTTABLESTATEPOINTERLOW_INDEX                                = 12, ///<
            LACELUTTABLESTATEPOINTERHIGH_BYTEOFFSET                          = 52, ///<
            LACELUTTABLESTATEPOINTERHIGH_INDEX                               = 13, ///<
            LUT3DSTATEPOINTERLOW_BYTEOFFSET = 64, ///<
            LUT3DSTATEPOINTERLOW_INDEX = 16, ///<
            LUT3DSTATEPOINTERHIGH_BYTEOFFSET = 68, ///<
            LUT3DSTATEPOINTERHIGH_INDEX = 17, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_STATE_CMD() {
            DW0.Value = 0;
            DW0.DwordLength = __CODEGEN_OP_LENGTH(DW_SIZE);
            DW0.SubopcodeB = SUBOPCODE_B_UNNAMED2;
            DW0.SubopcodeA = SUBOPCODE_A_UNNAMED0;
            DW0.CommandOpcode = COMMAND_OPCODE_VEBOX;
            DW0.Pipeline = PIPELINE_MEDIA;
            DW0.CommandType = COMMAND_TYPE_PARALLELVIDEOPIPE;

            DW1.Value = 0;
            DW1.DiOutputFrames = DI_OUTPUT_FRAMES_OUTPUTBOTHFRAMES;
            DW1.SingleSliceVeboxEnable = SINGLE_SLICE_VEBOX_ENABLE_BOTHSLICESENABLED;
            DW1.SinglePipeEnable = SINGLE_PIPE_ENABLE_DEFAULT;
            DW1.GamutExpansionPosition = GAMUT_EXPANSION_POSITION_GAMUTEXPANSIONATTHEBACKENDOFIECPPIPE;

            DW2.Value = 0;

            DW3.Value = 0;

            DW4.Value = 0;

            DW5.Value = 0;

            DW6.Value = 0;

            DW7.Value = 0;

            DW8.Value = 0;

            DW9.Value = 0;

            DW10.Value = 0;

            DW11.Value = 0;

            DW12.Value = 0;

            DW13.Value = 0;
            DW13.ArbitrationPriorityControlForLaceLut = ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_HIGHESTPRIORITY;

            DW14_15.Value[0] = DW14_15.Value[1] = 0;

            DW16.Value = 0;

            DW17.Value = 0;
            DW17.ArbitrationPriorityControlForLut3D = ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_HIGHESTPRIORITY;

            DW18.Value = 0;
            DW18.ChromaUpsamplingCoSitedHorizontalOffset = CHROMA_UPSAMPLING_CO_SITED_HORIZONTAL_OFFSET_UNNAMED0;
            DW18.ChromaUpsamplingCoSitedVerticalOffset = CHROMA_UPSAMPLING_CO_SITED_VERTICAL_OFFSET_UNNAMED0;
            DW18.ChromaDownsamplingCoSitedHorizontalOffset = CHROMA_DOWNSAMPLING_CO_SITED_HORIZONTAL_OFFSET_UNNAMED0;
            DW18.ChromaDownsamplingCoSitedVerticalOffset = CHROMA_DOWNSAMPLING_CO_SITED_VERTICAL_OFFSET_UNNAMED0;
            DW18.BypassChromaUpsampling = BYPASS_CHROMA_UPSAMPLING_UNNAMED1;
            DW18.BypassChromaDownsampling = BYPASS_CHROMA_DOWNSAMPLING_UNNAMED1;
            DW18.Lut3DSize = _3D_LUT_SIZE_33X33X33;
        };

        static const size_t DW_SIZE = 19;
        static const size_t BYTE_SIZE = 76;
    };

    //!
    //! \brief VEBOX_SURFACE_STATE
    //! \details
    //!     The input and output data containers accessed are called "surfaces".
    //!     Surface state is sent to VEBOX via an inline state command rather than
    //!     using binding tables. SURFACE_STATE contains the parameters defining
    //!     each surface to be accessed, including its size, format, and offsets to
    //!     its subsurfaces. The surface's base address is in the execution command.
    //!     Despite having multiple input and output surfaces, we limit the number
    //!     of surface states to one for input surfaces and one for output surfaces.
    //!     The other surfaces are derived from the input/output surface states.
    //! 
    //!     The Current Frame Input surface uses the Input SURFACE_STATE
    //! 
    //!     The Previous Denoised Input surface uses the Input SURFACE_STATE. (For
    //!     16-bit Bayer pattern inputs this will be 16-bit.)
    //! 
    //!     The Current Denoised Output surface uses the Input SURFACE_STATE. (For
    //!     16-bit Bayer pattern inputs this will be 16-bit.)
    //! 
    //!     The STMM/Noise History Input surface uses the Input SURFACE_STATE with
    //!     Tile-Y and Width/Height a multiple of 4.
    //! 
    //!     The STMM/Noise History Output surface uses the Input SURFACE_STATE with
    //!     Tile-Y and Width/Height a multiple of 4.
    //! 
    //!     The Current Deinterlaced/IECP Frame Output surface uses the Output
    //!     SURFACE_STATE.
    //! 
    //!     The Previous Deinterlaced/IECP Frame Output surface uses the Output
    //!     SURFACE_STATE.
    //! 
    //!     The FMD per block output / per Frame Output surface uses the Linear
    //!     SURFACE_STATE (see note below).
    //! 
    //!     The Alpha surface uses the Linear A8 SURFACE_STATE with Width/Height
    //!     equal to Input Surface. Pitch is width rounded to next 64.
    //! 
    //!     The Skin Score surface uses the Output SURFACE_STATE.
    //! 
    //!     The STMM height is the same as the Input Surface height except when the
    //!     input Surface Format is Bayer Pattern and the Bayer Pattern Offset is 10
    //!     or 11, in  which case the height is the input height + 4. For Bayer
    //!     pattern inputs when the Bayer Pattern Offset is 10 or 11, the Current
    //!     Denoised Output/Previous Denoised Input will also have a height which is
    //!     the input height + 4. For Bayer pattern inputs only the Current Denoised
    //!     Output/Previous Denoised Input are in Tile-Y.
    //! 
    //!     The linear surface for FMD statistics is linear (not tiled). The height
    //!     of the per block statistics is (Input Height +3)/4 - the Input Surface
    //!     height in pixels is rounded up to the next even 4 and divided by 4. The
    //!     width of the per block section in bytes is equal to the width of the
    //!     Input Surface in pixels rounded up to the next 16 bytes. The pitch of
    //!     the per block section in bytes is equal to the width of the Input
    //!     Surface in pixels rounded up to the next 64 bytes.
    //! 
    //!     The STMM surfaces must be identical to the Input surface except for the
    //!     tiling mode must be Tile-Y and the pitch is specified in DW7. The pitch
    //!     for the Current Denoised Output/Previous Denoised Input is specified in
    //!     DW7. The width and height must be a multiple of 4 rounded up from the
    //!     input height.
    //! 
    //!     The Vignette Correction surface uses the Linear 16-bit SURFACE_STATE
    //!     with :
    //!     Width=(Ceil(Image Width / 4) +1) * 4
    //!     Height= Ceil(Image Height / 4) +1
    //!     Pitch in bytes is (vignette width *2) rounded to the next 64
    //! 
    //!     VEBOX may write to memory between the surface width and the surface
    //!     pitch for output surfaces.
    //! 
    //!     VEBOX can support a frame level X/Y offset which allows processing of 2
    //!     side-by-side frames for certain 3D video formats.
    //! 
    //!     The X/Y Offset for Frame state applies only to the Current Frame Input
    //!     and the Current Deinterlaced/IECP Frame Output and Previous
    //!     Deinterlaced/IECP Frame Output. The statistics surfaces, the denoise
    //!     feedback surfaces and the alpha/vignette surfaces have no X/Y offsets.
    //! 
    //!     For 8bit Alpha input, when converted to 16bit output, the 8 bit alpha
    //!     value is replicated to both the upper and lower 8 bits to form the 16
    //!     bit alpha value.
    //! 
    //!     Skin Score Output Surface uses the same tiling format as the Output
    //!     surface.
    //! 
    //!     The input and Output surface for scalar is defined by this command.
    //!     Derived pitch is not used with the scalar command.
    //!
    struct VEBOX_SURFACE_STATE_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< =N
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; ///< U4
                uint32_t                 SubopcodeB                                       : __CODEGEN_BITFIELD(16, 20)    ; ///< U5
                uint32_t                 SubopcodeA                                       : __CODEGEN_BITFIELD(21, 23)    ; ///< U3
                uint32_t                 MediaCommandOpcode                               : __CODEGEN_BITFIELD(24, 26)    ; ///< U3
                uint32_t                 MediaCommandPipeline                             : __CODEGEN_BITFIELD(27, 28)    ; ///< U2
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 SurfaceIdentification                            : __CODEGEN_BITFIELD( 0,  0)    ; ///< U1
                uint32_t                 Reserved33                                       : __CODEGEN_BITFIELD( 1, 31)    ; ///< U31
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 Reserved64                                       : __CODEGEN_BITFIELD( 0,  3)    ; ///< U4
                uint32_t                 Width                                            : __CODEGEN_BITFIELD( 4, 17)    ; ///< U14
                uint32_t                 Height                                           : __CODEGEN_BITFIELD(18, 31)    ; ///< U14
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 TileWalk                                         : __CODEGEN_BITFIELD( 0,  0)    ; ///< _3D_TILEWALK
                uint32_t                 TiledSurface                                     : __CODEGEN_BITFIELD( 1,  1)    ; ///< U1
                uint32_t                 HalfPitchForChroma                               : __CODEGEN_BITFIELD( 2,  2)    ; ///< U1
                uint32_t                 SurfacePitch                                     : __CODEGEN_BITFIELD( 3, 19)    ; ///< U17
                uint32_t                 InterleaveChroma                                 : __CODEGEN_BITFIELD(20, 20)    ; ///< U1
                uint32_t                 Reserved117                                      : __CODEGEN_BITFIELD(21, 23)    ; ///< U3
                uint32_t                 BayerPatternFormat                               : __CODEGEN_BITFIELD(24, 24)    ; ///< U1
                uint32_t                 BayerPatternOffset                               : __CODEGEN_BITFIELD(25, 26)    ; ///< U2
                uint32_t                 SurfaceFormat                                    : __CODEGEN_BITFIELD(27, 31)    ; ///< U5
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 YOffsetForU                                      : __CODEGEN_BITFIELD( 0, 14)    ; ///< U15
                uint32_t                 Reserved143                                      : __CODEGEN_BITFIELD(15, 15)    ; ///< U1
                uint32_t                 XOffsetForU                                      : __CODEGEN_BITFIELD(16, 28)    ; ///< U13
                uint32_t                 Reserved157                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 YOffsetForV                                      : __CODEGEN_BITFIELD( 0, 14)    ; ///< U15
                uint32_t                 Reserved175                                      : __CODEGEN_BITFIELD(15, 15)    ; ///< U1
                uint32_t                 XOffsetForV                                      : __CODEGEN_BITFIELD(16, 28)    ; ///< U13
                uint32_t                 Reserved189                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 YOffsetForFrame                                  : __CODEGEN_BITFIELD( 0, 14)    ; ///< U15
                uint32_t                 Reserved207                                      : __CODEGEN_BITFIELD(15, 15)    ; ///< U1
                uint32_t                 XOffsetForFrame                                  : __CODEGEN_BITFIELD(16, 30)    ; ///< U15
                uint32_t                 Reserved223                                      : __CODEGEN_BITFIELD(31, 31)    ; ///< U1
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 DerivedSurfacePitch                              : __CODEGEN_BITFIELD( 0, 16)    ; ///< U17
                uint32_t                 Reserved241                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 SurfacePitchForSkinScoreOutputSurfaces           : __CODEGEN_BITFIELD( 0, 16)    ; ///< U17
                uint32_t                 Reserved273                                      : __CODEGEN_BITFIELD(17, 31)    ; ///< U15
            };
            uint32_t                     Value;
        } DW8;

        //! \name Local enumerations

        enum SUBOPCODE_B
        {
            SUBOPCODE_B_VEBOX                                                = 0, ///<
        };
        enum SUBOPCODE_A
        {
            SUBOPCODE_A_VEBOX                                                = 0, ///<
        };
        enum MEDIA_COMMAND_OPCODE
        {
            MEDIA_COMMAND_OPCODE_VEBOX                                       = 4, ///<
        };
        enum MEDIA_COMMAND_PIPELINE
        {
            MEDIA_COMMAND_PIPELINE_MEDIA                                     = 2, ///<
        };
        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, ///<
        };
        enum SURFACE_IDENTIFICATION
        {
            SURFACE_IDENTIFICATION_INPUTSURFACEANDDENOISEDCURRENTOUTPUTSURFACE = 0, ///<
            SURFACE_IDENTIFICATION_OUTPUTSURFACEALLEXCEPTTHEDENOISEDCURRENTOUTPUTSURFACE = 1, ///<
        };
        //! \brief 3D_TileWalk
        enum TILE_WALK
        {
            TILE_WALK_TILEWALKXMAJOR                                         = 0, ///<
            TILE_WALK_TILEWALKYMAJOR                                         = 1, ///<
        };
        enum BAYER_PATTERN_FORMAT
        {
            BAYER_PATTERN_FORMAT_8_BITINPUTATA8_BITSTRIDE                    = 0, ///<
            BAYER_PATTERN_FORMAT_16_BITINPUTATA16_BITSTRIDE                  = 1, ///<
        };
        enum BAYER_PATTERN_OFFSET
        {
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISBLUE                          = 0, ///<
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISRED                           = 1, ///<
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISGREEN_PIXELATX1_Y0ISRED       = 2, ///<
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISGREEN_PIXELATX1_Y0ISBLUE      = 3, ///<
        };
        enum SURFACE_FORMAT
        {
            SURFACE_FORMAT_YCRCBNORMAL                                       = 0, ///<
            SURFACE_FORMAT_YCRCBSWAPUVY                                      = 1, ///<
            SURFACE_FORMAT_YCRCBSWAPUV                                       = 2, ///<
            SURFACE_FORMAT_YCRCBSWAPY                                        = 3, ///<
            SURFACE_FORMAT_PLANAR4208                                        = 4, ///< NV12 with Interleave Chroma set
            SURFACE_FORMAT_PACKED444A8                                       = 5, ///<
            SURFACE_FORMAT_PACKED42216                                       = 6, ///<
            SURFACE_FORMAT_R10G10B10A2UNORMR10G10B10A2UNORMSRGB              = 7, ///<
            SURFACE_FORMAT_R8G8B8A8UNORMR8G8B8A8UNORMSRGB                    = 8, ///<
            SURFACE_FORMAT_PACKED44416                                       = 9, ///<
            SURFACE_FORMAT_PLANAR42216                                       = 10, ///<
            SURFACE_FORMAT_Y8UNORM                                           = 11, ///<
            SURFACE_FORMAT_PLANAR42016                                       = 12, ///<
            SURFACE_FORMAT_R16G16B16A16                                      = 13, ///<
            SURFACE_FORMAT_BAYERPATTERN                                      = 14, ///<
            SURFACE_FORMAT_Y16UNORM                                          = 15, ///<
            SURFACE_FORMAT_PACKED44410                                       = 16, ///<
            SURFACE_FORMAT_B8G8R8A8UNORM                                     = 17, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_SURFACE_STATE_CMD() {
            DW0.Value = 0;
            DW0.DwordLength = __CODEGEN_OP_LENGTH(DW_SIZE);
            DW0.SubopcodeB = SUBOPCODE_B_VEBOX;
            DW0.SubopcodeA = SUBOPCODE_A_VEBOX;
            DW0.MediaCommandOpcode = MEDIA_COMMAND_OPCODE_VEBOX;
            DW0.MediaCommandPipeline = MEDIA_COMMAND_PIPELINE_MEDIA;
            DW0.CommandType = COMMAND_TYPE_PARALLELVIDEOPIPE;

            DW1.Value = 0;
            DW1.SurfaceIdentification = SURFACE_IDENTIFICATION_INPUTSURFACEANDDENOISEDCURRENTOUTPUTSURFACE;

            DW2.Value = 0;

            DW3.Value = 0;
            DW3.TileWalk = TILE_WALK_TILEWALKXMAJOR;
            DW3.BayerPatternFormat = BAYER_PATTERN_FORMAT_8_BITINPUTATA8_BITSTRIDE;
            DW3.BayerPatternOffset = BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISBLUE;
            DW3.SurfaceFormat = SURFACE_FORMAT_YCRCBNORMAL;

            DW4.Value = 0;

            DW5.Value = 0;

            DW6.Value = 0;

            DW7.Value = 0;

            DW8.Value = 0;
        };

        static const size_t DW_SIZE = 9;
        static const size_t BYTE_SIZE = 36;
    };

    //!
    //! \brief VEBOX_TILING_CONVERT
    //! \details
    //!     This command takes the input surface and writes directly to the output
    //!     surface at high speed.  The surface format and width/height of the input
    //!     and output must be the same, only the tiling mode and pitch can change.
    //!
    struct VEBOX_TILING_CONVERT_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< =N
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; ///< U4
                uint32_t                 SubopcodeB                                       : __CODEGEN_BITFIELD(16, 20)    ; ///< U5
                uint32_t                 SubopcodeA                                       : __CODEGEN_BITFIELD(21, 23)    ; ///< U3
                uint32_t                 CommandOpcode                                    : __CODEGEN_BITFIELD(24, 26)    ; ///< U3
                uint32_t                 Pipeline                                         : __CODEGEN_BITFIELD(27, 28)    ; ///< U2
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1..2
                uint64_t                 InputSurfaceControlBits                          : __CODEGEN_BITFIELD( 0, 10)    ; ///< VEB_DI_IECP_COMMAND_SURFACE_CONTROL_BITS_SKL+
                uint64_t                 Reserved43                                       : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint64_t                 InputAddressGraphicsaddress4712                  : __CODEGEN_BITFIELD(12, 47)    ; ///< Sub-structure
                uint64_t                 InputAddressReserved                             : __CODEGEN_BITFIELD(48, 63)    ; ///< Sub-structure
            };
            uint32_t                     Value[2];
        } DW1_2;
        union
        {
            struct
            {
                /// uint32_t 3..4
                uint64_t                 OutputSurfaceControlBits                         : __CODEGEN_BITFIELD( 0, 10)    ; ///< VEB_DI_IECP_COMMAND_SURFACE_CONTROL_BITS_SKL+
                uint64_t                 Reserved107                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint64_t                 OutputAddressGraphicsaddress4712                 : __CODEGEN_BITFIELD(12, 47)    ; ///< Sub-structure
                uint64_t                 OutputAddressReserved                            : __CODEGEN_BITFIELD(48, 63)    ; ///< Sub-structure
            };
            uint32_t                     Value[2];
        } DW3_4;

        //! \name Local enumerations

        enum SUBOPCODE_B
        {
            SUBOPCODE_B_UNNAMED1                                             = 1, ///<
        };
        enum SUBOPCODE_A
        {
            SUBOPCODE_A_UNNAMED0                                             = 0, ///<
        };
        enum COMMAND_OPCODE
        {
            COMMAND_OPCODE_VEBOX                                             = 4, ///<
        };
        enum PIPELINE
        {
            PIPELINE_MEDIA                                                   = 2, ///<
        };
        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API VEBOX_TILING_CONVERT_CMD() {
            DW0.Value = 0;
            DW0.DwordLength = __CODEGEN_OP_LENGTH(DW_SIZE);
            DW0.SubopcodeB = SUBOPCODE_B_UNNAMED1;
            DW0.SubopcodeA = SUBOPCODE_A_UNNAMED0;
            DW0.CommandOpcode = COMMAND_OPCODE_VEBOX;
            DW0.Pipeline = PIPELINE_MEDIA;
            DW0.CommandType = COMMAND_TYPE_PARALLELVIDEOPIPE;

            DW1_2.Value[0] = DW1_2.Value[1] = 0;

            DW3_4.Value[0] = DW3_4.Value[1] = 0;
        };

        static const size_t DW_SIZE = 5;
        static const size_t BYTE_SIZE = 20;
    };

    //!
    //! \brief VEB_DI_IECP
    //! \details
    //!     The VEB_DI_IECP command causes the VEBOX to start processing the frames
    //!     specified by VEB_SURFACE_STATE using the parameters specified by
    //!     VEB_DI_STATE and VEB_IECP_STATE.  The processing can start and end at
    //!     any 64 pixel column in the frame. If Starting X and Ending X are used to
    //!     split the frame into sections, it should not be split into more than 4
    //!     sections.
    //!     Each VEB_DI_IECP command should be preceded by a VEB_STATE command and
    //!     the input/output VEB_SURFACE_STATE commands.
    //! 
    //!     When DI is enabled, only the Current Frame skin scores are outputted to
    //!     the Skin Score Output surface.
    //! 
    //!     When Scalar is enabled only Current frame input and output surface
    //!     pointers are valid in this command. LACE/ACE histogram pointers are also
    //!     used if LACE/ACE is enabled. StartX and EndX is not supported with
    //!     Scalar.
    //!
    struct VEB_DI_IECP_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; ///< =N
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; ///< U4
                uint32_t                 Subopb                                           : __CODEGEN_BITFIELD(16, 20)    ; ///< U5
                uint32_t                 Subopa                                           : __CODEGEN_BITFIELD(21, 23)    ; ///< U3
                uint32_t                 Opcode                                           : __CODEGEN_BITFIELD(24, 26)    ; ///< U3
                uint32_t                 Pipeline                                         : __CODEGEN_BITFIELD(27, 28)    ; ///< U2
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; ///< U3
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 EndingX                                          : __CODEGEN_BITFIELD( 0, 13)    ; ///< U14
                uint32_t                 Reserved46                                       : __CODEGEN_BITFIELD(14, 15)    ; ///< U2
                uint32_t                 StartingX                                        : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 Reserved62                                       : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 CurrentFrameSurfaceControlBitsReserved0          : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 CurrentFrameSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 CurrentFrameSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 CurrentFrameSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 CurrentFrameSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved75                                       : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 CurrentFrameInputAddress                         : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 CurrentFrameInputAddressHigh                     : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved112                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 CurrentFrameInputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 PreviousFrameSurfaceControlBitsReserved0         : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 PreviousFrameSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 PreviousFrameSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 PreviousFrameSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 PreviousFrameSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved139                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 PreviousFrameInputAddress                        : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 PreviousFrameInputAddressHigh                    : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved176                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 PreviousFrameInputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 StmmInputSurfaceControlBitsReserved0             : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 StmmInputSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 StmmInputSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 StmmInputSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 StmmInputSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved203                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 StmmInputAddress                                 : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 StmmInputAddressHigh                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved240                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 StmmInputSurfaceArbitrationPriorityControl       : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 StmmOutputSurfaceControlBitsReserved0            : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 StmmOutputSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 StmmOutputSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 StmmOutputSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 StmmOutputSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved267                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 StmmOutputAddress                                : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 StmmOutputAddressHigh                            : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved304                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 StmmOutputSurfaceArbitrationPriorityControl      : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 DenoisedCurrentOutputSurfaceControlBitsReserved0 : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 DenoisedCurrentOutputSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 DenoisedCurrentOutputSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 DenoisedCurrentOutputSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 DenoisedCurrentOutputSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved331                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 DenoisedCurrentFrameOutputAddress                : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 DenoisedCurrentFrameOutputAddressHigh            : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved368                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 DenoisedCurrentOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 CurrentFrameOutputSurfaceControlBitsReserved0    : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 CurrentFrameOutputSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 CurrentFrameOutputSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 CurrentFrameOutputSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 CurrentFrameOutputSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved395                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 CurrentFrameOutputAddress                        : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                /// uint32_t 13
                uint32_t                 CurrentFrameOutputAddressHigh                    : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved432                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 CurrentFrameOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                /// uint32_t 14
                uint32_t                 PreviousFrameOutputSurfaceControlBitsReserved0   : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 PreviousFrameOutputSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 PreviousFrameOutputSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 PreviousFrameOutputSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 PreviousFrameOutputSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved459                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 PreviousFrameOutputAddress                       : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                /// uint32_t 15
                uint32_t                 PreviousFrameOutputAddressHigh                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved496                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 PreviousFrameOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                /// uint32_t 16
                uint32_t                 StatisticsOutputSurfaceControlBitsReserved0      : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 StatisticsOutputSurfaceControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 StatisticsOutputSurfaceControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 StatisticsOutputSurfaceControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 StatisticsOutputSurfaceControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved523                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 StatisticsOutputAddress                          : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                /// uint32_t 17
                uint32_t                 StatisticsOutputAddressHigh                      : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved560                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 StatisticsOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                /// uint32_t 18
                uint32_t                 AlphaVignetteControlBitsReserved0                : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 AlphaVignetteControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 AlphaVignetteControlBitsMemoryCompressionEnable  : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 AlphaVignetteControlBitsMemoryCompressionMode    : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 AlphaVignetteControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved587                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 AlphaVignetteCorrectionAddress                   : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                /// uint32_t 19
                uint32_t                 AlphaVignetteCorrectionAddressHigh               : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved624                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 AlphaVignetteCorrectionSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                /// uint32_t 20
                uint32_t                 LaceAceRgbHistogramControlBitsReserved0          : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 LaceAceRgbHistogramControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 LaceAceRgbHistogramControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 LaceAceRgbHistogramControlBitsMemoryCompressionMode : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 LaceAceRgbHistogramControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved651                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 LaceAceRgbHistogramOutputAddress                 : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                /// uint32_t 21
                uint32_t                 LaceAceRgbHistogramOutputAddressHigh             : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved688                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 LaceAceRgbHistogramSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                /// uint32_t 22
                uint32_t                 SkinScoreOutputControlBitsReserved0              : __CODEGEN_BITFIELD( 0,  0)    ; ///< Sub-structure
                uint32_t                 SkinScoreOutputControlBitsIndexToMemoryObjectControlStateMocsTables : __CODEGEN_BITFIELD( 1,  6)    ; ///< Sub-structure
                uint32_t                 SkinScoreOutputControlBitsMemoryCompressionEnable : __CODEGEN_BITFIELD( 7,  7)    ; ///< Sub-structure
                uint32_t                 SkinScoreOutputControlBitsMemoryCompressionMode  : __CODEGEN_BITFIELD( 8,  8)    ; ///< Sub-structure
                uint32_t                 SkinScoreOutputControlBitsTiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; ///< Sub-structure
                uint32_t                 Reserved715                                      : __CODEGEN_BITFIELD(11, 11)    ; ///< U1
                uint32_t                 SkinScoreOutputAddress                           : __CODEGEN_BITFIELD(12, 31)    ; ///< GraphicsAddress
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                /// uint32_t 23
                uint32_t                 SkinScoreOutputAddressHigh                       : __CODEGEN_BITFIELD( 0, 15)    ; ///< GraphicsAddress
                uint32_t                 Reserved752                                      : __CODEGEN_BITFIELD(16, 29)    ; ///< U14
                uint32_t                 SkinScoreOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; ///< U2
            };
            uint32_t                     Value;
        } DW23;

        //! \name Local enumerations

        enum SUBOPB
        {
            SUBOPB_VEBDIIECP                                                 = 3, ///<
        };
        enum SUBOPA
        {
            SUBOPA_VEBDIIECP                                                 = 0, ///<
        };
        enum OPCODE
        {
            OPCODE_VEBOX                                                     = 4, ///<
        };
        enum PIPELINE
        {
            PIPELINE_MEDIA                                                   = 2, ///<
        };
        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, ///<
        };
        enum CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY  = 0, ///<
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY   = 3, ///<
        };
        enum STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY  = 3, ///<
        };
        enum DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, ///<
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, ///<
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, ///<
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, ///<
        };
        enum PATCH_CONSTANTS
        {
            CURRENTFRAMEINPUTADDRESS_BYTEOFFSET                              = 8, ///<
            CURRENTFRAMEINPUTADDRESS_INDEX                                   = 2, ///<
            CURRENTFRAMEINPUTADDRESSHIGH_BYTEOFFSET                          = 12, ///<
            CURRENTFRAMEINPUTADDRESSHIGH_INDEX                               = 3, ///<
            PREVIOUSFRAMEINPUTADDRESS_BYTEOFFSET                             = 16, ///<
            PREVIOUSFRAMEINPUTADDRESS_INDEX                                  = 4, ///<
            PREVIOUSFRAMEINPUTADDRESSHIGH_BYTEOFFSET                         = 20, ///<
            PREVIOUSFRAMEINPUTADDRESSHIGH_INDEX                              = 5, ///<
            STMMINPUTADDRESS_BYTEOFFSET                                      = 24, ///<
            STMMINPUTADDRESS_INDEX                                           = 6, ///<
            STMMINPUTADDRESSHIGH_BYTEOFFSET                                  = 28, ///<
            STMMINPUTADDRESSHIGH_INDEX                                       = 7, ///<
            STMMOUTPUTADDRESS_BYTEOFFSET                                     = 32, ///<
            STMMOUTPUTADDRESS_INDEX                                          = 8, ///<
            STMMOUTPUTADDRESSHIGH_BYTEOFFSET                                 = 36, ///<
            STMMOUTPUTADDRESSHIGH_INDEX                                      = 9, ///<
            DENOISEDCURRENTFRAMEOUTPUTADDRESS_BYTEOFFSET                     = 40, ///<
            DENOISEDCURRENTFRAMEOUTPUTADDRESS_INDEX                          = 10, ///<
            DENOISEDCURRENTFRAMEOUTPUTADDRESSHIGH_BYTEOFFSET                 = 44, ///<
            DENOISEDCURRENTFRAMEOUTPUTADDRESSHIGH_INDEX                      = 11, ///<
            CURRENTFRAMEOUTPUTADDRESS_BYTEOFFSET                             = 48, ///<
            CURRENTFRAMEOUTPUTADDRESS_INDEX                                  = 12, ///<
            CURRENTFRAMEOUTPUTADDRESSHIGH_BYTEOFFSET                         = 52, ///<
            CURRENTFRAMEOUTPUTADDRESSHIGH_INDEX                              = 13, ///<
            PREVIOUSFRAMEOUTPUTADDRESS_BYTEOFFSET                            = 56, ///<
            PREVIOUSFRAMEOUTPUTADDRESS_INDEX                                 = 14, ///<
            PREVIOUSFRAMEOUTPUTADDRESSHIGH_BYTEOFFSET                        = 60, ///<
            PREVIOUSFRAMEOUTPUTADDRESSHIGH_INDEX                             = 15, ///<
            STATISTICSOUTPUTADDRESS_BYTEOFFSET                               = 64, ///<
            STATISTICSOUTPUTADDRESS_INDEX                                    = 16, ///<
            STATISTICSOUTPUTADDRESSHIGH_BYTEOFFSET                           = 68, ///<
            STATISTICSOUTPUTADDRESSHIGH_INDEX                                = 17, ///<
            ALPHAVIGNETTECORRECTIONADDRESS_BYTEOFFSET                        = 72, ///<
            ALPHAVIGNETTECORRECTIONADDRESS_INDEX                             = 18, ///<
            ALPHAVIGNETTECORRECTIONADDRESSHIGH_BYTEOFFSET                    = 76, ///<
            ALPHAVIGNETTECORRECTIONADDRESSHIGH_INDEX                         = 19, ///<
            LACEACERGBHISTOGRAMOUTPUTADDRESS_BYTEOFFSET                      = 80, ///<
            LACEACERGBHISTOGRAMOUTPUTADDRESS_INDEX                           = 20, ///<
            LACEACERGBHISTOGRAMOUTPUTADDRESSHIGH_BYTEOFFSET                  = 84, ///<
            LACEACERGBHISTOGRAMOUTPUTADDRESSHIGH_INDEX                       = 21, ///<
            SKINSCOREOUTPUTADDRESS_BYTEOFFSET                                = 88, ///<
            SKINSCOREOUTPUTADDRESS_INDEX                                     = 22, ///<
            SKINSCOREOUTPUTADDRESSHIGH_BYTEOFFSET                            = 92, ///<
            SKINSCOREOUTPUTADDRESSHIGH_INDEX                                 = 23, ///<
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        CM_RT_API  VEB_DI_IECP_CMD() {
            DW0.Value = 0;
            DW0.DwordLength = __CODEGEN_OP_LENGTH(DW_SIZE);
            DW0.Subopb = SUBOPB_VEBDIIECP;
            DW0.Subopa = SUBOPA_VEBDIIECP;
            DW0.Opcode = OPCODE_VEBOX;
            DW0.Pipeline = PIPELINE_MEDIA;
            DW0.CommandType = COMMAND_TYPE_PARALLELVIDEOPIPE;

            DW1.Value = 0;

            DW2.Value = 0;

            DW3.Value = 0;
            DW3.CurrentFrameInputSurfaceArbitrationPriorityControl = CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW4.Value = 0;

            DW5.Value = 0;
            DW5.PreviousFrameInputSurfaceArbitrationPriorityControl = PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW6.Value = 0;

            DW7.Value = 0;
            DW7.StmmInputSurfaceArbitrationPriorityControl = STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW8.Value = 0;

            DW9.Value = 0;
            DW9.StmmOutputSurfaceArbitrationPriorityControl = STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW10.Value = 0;

            DW11.Value = 0;
            DW11.DenoisedCurrentOutputSurfaceArbitrationPriorityControl = DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW12.Value = 0;

            DW13.Value = 0;
            DW13.CurrentFrameOutputSurfaceArbitrationPriorityControl = CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW14.Value = 0;

            DW15.Value = 0;
            DW15.PreviousFrameOutputSurfaceArbitrationPriorityControl = PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW16.Value = 0;

            DW17.Value = 0;
            DW17.StatisticsOutputSurfaceArbitrationPriorityControl = STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW18.Value = 0;

            DW19.Value = 0;
            DW19.AlphaVignetteCorrectionSurfaceArbitrationPriorityControl = ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW20.Value = 0;

            DW21.Value = 0;
            DW21.LaceAceRgbHistogramSurfaceArbitrationPriorityControl = LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;

            DW22.Value = 0;

            DW23.Value = 0;
            DW23.SkinScoreOutputSurfaceArbitrationPriorityControl = SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY;
        };

        static const size_t DW_SIZE = 24;
        static const size_t BYTE_SIZE = 96;
    };

    //!
    //! \brief Gamut_Expansion_Gamma_Correction
    //! \details
    //!     The default values follow the pattern suggested by incomplete table
    //!     below. 
    //!
    struct Gamut_Expansion_Gamma_Correction_CMD
    {
        union
        {
            struct
            {
                /// uint32_t 0
                uint32_t                 InverseGChGammaCorrectedValue0                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                /// uint32_t 1
                uint32_t                 InversePixelValue0                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                /// uint32_t 2
                uint32_t                 ForwardGChGammaCorrectedValue0                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                /// uint32_t 3
                uint32_t                 ForwardPixelValue0                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                /// uint32_t 4
                uint32_t                 InverseGChGammaCorrectedValue1                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                /// uint32_t 5
                uint32_t                 InversePixelValue1                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                /// uint32_t 6
                uint32_t                 ForwardGChGammaCorrectedValue1                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                /// uint32_t 7
                uint32_t                 ForwardPixelValue1                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                /// uint32_t 8
                uint32_t                 InverseGChGammaCorrectedValue2                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                /// uint32_t 9
                uint32_t                 InversePixelValue2                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                /// uint32_t 10
                uint32_t                 ForwardGChGammaCorrectedValue2                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                /// uint32_t 11
                uint32_t                 ForwardPixelValue2                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                /// uint32_t 12
                uint32_t                 InverseGChGammaCorrectedValue3                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                /// uint32_t 13
                uint32_t                 InversePixelValue3                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                /// uint32_t 14
                uint32_t                 ForwardGChGammaCorrectedValue3                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                /// uint32_t 15
                uint32_t                 ForwardPixelValue3                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                /// uint32_t 16
                uint32_t                 InverseGChGammaCorrectedValue4                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                /// uint32_t 17
                uint32_t                 InversePixelValue4                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                /// uint32_t 18
                uint32_t                 ForwardGChGammaCorrectedValue4                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                /// uint32_t 19
                uint32_t                 ForwardPixelValue4                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                /// uint32_t 20
                uint32_t                 InverseGChGammaCorrectedValue5                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                /// uint32_t 21
                uint32_t                 InversePixelValue5                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                /// uint32_t 22
                uint32_t                 ForwardGChGammaCorrectedValue5                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                /// uint32_t 23
                uint32_t                 ForwardPixelValue5                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW23;
        union
        {
            struct
            {
                /// uint32_t 24
                uint32_t                 InverseGChGammaCorrectedValue6                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                /// uint32_t 25
                uint32_t                 InversePixelValue6                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                /// uint32_t 26
                uint32_t                 ForwardGChGammaCorrectedValue6                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW26;
        union
        {
            struct
            {
                /// uint32_t 27
                uint32_t                 ForwardPixelValue6                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW27;
        union
        {
            struct
            {
                /// uint32_t 28
                uint32_t                 InverseGChGammaCorrectedValue7                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW28;
        union
        {
            struct
            {
                /// uint32_t 29
                uint32_t                 InversePixelValue7                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW29;
        union
        {
            struct
            {
                /// uint32_t 30
                uint32_t                 ForwardGChGammaCorrectedValue7                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW30;
        union
        {
            struct
            {
                /// uint32_t 31
                uint32_t                 ForwardPixelValue7                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW31;
        union
        {
            struct
            {
                /// uint32_t 32
                uint32_t                 InverseGChGammaCorrectedValue8                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW32;
        union
        {
            struct
            {
                /// uint32_t 33
                uint32_t                 InversePixelValue8                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW33;
        union
        {
            struct
            {
                /// uint32_t 34
                uint32_t                 ForwardGChGammaCorrectedValue8                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW34;
        union
        {
            struct
            {
                /// uint32_t 35
                uint32_t                 ForwardPixelValue8                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW35;
        union
        {
            struct
            {
                /// uint32_t 36
                uint32_t                 InverseGChGammaCorrectedValue9                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW36;
        union
        {
            struct
            {
                /// uint32_t 37
                uint32_t                 InversePixelValue9                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW37;
        union
        {
            struct
            {
                /// uint32_t 38
                uint32_t                 ForwardGChGammaCorrectedValue9                   : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW38;
        union
        {
            struct
            {
                /// uint32_t 39
                uint32_t                 ForwardPixelValue9                               : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW39;
        union
        {
            struct
            {
                /// uint32_t 40
                uint32_t                 InverseGChGammaCorrectedValue10                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW40;
        union
        {
            struct
            {
                /// uint32_t 41
                uint32_t                 InversePixelValue10                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW41;
        union
        {
            struct
            {
                /// uint32_t 42
                uint32_t                 ForwardGChGammaCorrectedValue10                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW42;
        union
        {
            struct
            {
                /// uint32_t 43
                uint32_t                 ForwardPixelValue10                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW43;
        union
        {
            struct
            {
                /// uint32_t 44
                uint32_t                 InverseGChGammaCorrectedValue11                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW44;
        union
        {
            struct
            {
                /// uint32_t 45
                uint32_t                 InversePixelValue11                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW45;
        union
        {
            struct
            {
                /// uint32_t 46
                uint32_t                 ForwardGChGammaCorrectedValue11                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW46;
        union
        {
            struct
            {
                /// uint32_t 47
                uint32_t                 ForwardPixelValue11                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW47;
        union
        {
            struct
            {
                /// uint32_t 48
                uint32_t                 InverseGChGammaCorrectedValue12                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW48;
        union
        {
            struct
            {
                /// uint32_t 49
                uint32_t                 InversePixelValue12                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW49;
        union
        {
            struct
            {
                /// uint32_t 50
                uint32_t                 ForwardGChGammaCorrectedValue12                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW50;
        union
        {
            struct
            {
                /// uint32_t 51
                uint32_t                 ForwardPixelValue12                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW51;
        union
        {
            struct
            {
                /// uint32_t 52
                uint32_t                 InverseGChGammaCorrectedValue13                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW52;
        union
        {
            struct
            {
                /// uint32_t 53
                uint32_t                 InversePixelValue13                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW53;
        union
        {
            struct
            {
                /// uint32_t 54
                uint32_t                 ForwardGChGammaCorrectedValue13                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW54;
        union
        {
            struct
            {
                /// uint32_t 55
                uint32_t                 ForwardPixelValue13                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW55;
        union
        {
            struct
            {
                /// uint32_t 56
                uint32_t                 InverseGChGammaCorrectedValue14                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW56;
        union
        {
            struct
            {
                /// uint32_t 57
                uint32_t                 InversePixelValue14                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW57;
        union
        {
            struct
            {
                /// uint32_t 58
                uint32_t                 ForwardGChGammaCorrectedValue14                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW58;
        union
        {
            struct
            {
                /// uint32_t 59
                uint32_t                 ForwardPixelValue14                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW59;
        union
        {
            struct
            {
                /// uint32_t 60
                uint32_t                 InverseGChGammaCorrectedValue15                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW60;
        union
        {
            struct
            {
                /// uint32_t 61
                uint32_t                 InversePixelValue15                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW61;
        union
        {
            struct
            {
                /// uint32_t 62
                uint32_t                 ForwardGChGammaCorrectedValue15                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW62;
        union
        {
            struct
            {
                /// uint32_t 63
                uint32_t                 ForwardPixelValue15                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW63;
        union
        {
            struct
            {
                /// uint32_t 64
                uint32_t                 InverseGChGammaCorrectedValue16                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW64;
        union
        {
            struct
            {
                /// uint32_t 65
                uint32_t                 InversePixelValue16                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW65;
        union
        {
            struct
            {
                /// uint32_t 66
                uint32_t                 ForwardGChGammaCorrectedValue16                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW66;
        union
        {
            struct
            {
                /// uint32_t 67
                uint32_t                 ForwardPixelValue16                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW67;
        union
        {
            struct
            {
                /// uint32_t 68
                uint32_t                 InverseGChGammaCorrectedValue17                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW68;
        union
        {
            struct
            {
                /// uint32_t 69
                uint32_t                 InversePixelValue17                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW69;
        union
        {
            struct
            {
                /// uint32_t 70
                uint32_t                 ForwardGChGammaCorrectedValue17                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW70;
        union
        {
            struct
            {
                /// uint32_t 71
                uint32_t                 ForwardPixelValue17                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW71;
        union
        {
            struct
            {
                /// uint32_t 72
                uint32_t                 InverseGChGammaCorrectedValue18                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW72;
        union
        {
            struct
            {
                /// uint32_t 73
                uint32_t                 InversePixelValue18                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW73;
        union
        {
            struct
            {
                /// uint32_t 74
                uint32_t                 ForwardGChGammaCorrectedValue18                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW74;
        union
        {
            struct
            {
                /// uint32_t 75
                uint32_t                 ForwardPixelValue18                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW75;
        union
        {
            struct
            {
                /// uint32_t 76
                uint32_t                 InverseGChGammaCorrectedValue19                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW76;
        union
        {
            struct
            {
                /// uint32_t 77
                uint32_t                 InversePixelValue19                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW77;
        union
        {
            struct
            {
                /// uint32_t 78
                uint32_t                 ForwardGChGammaCorrectedValue19                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW78;
        union
        {
            struct
            {
                /// uint32_t 79
                uint32_t                 ForwardPixelValue19                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW79;
        union
        {
            struct
            {
                /// uint32_t 80
                uint32_t                 InverseGChGammaCorrectedValue20                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW80;
        union
        {
            struct
            {
                /// uint32_t 81
                uint32_t                 InversePixelValue20                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW81;
        union
        {
            struct
            {
                /// uint32_t 82
                uint32_t                 ForwardGChGammaCorrectedValue20                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW82;
        union
        {
            struct
            {
                /// uint32_t 83
                uint32_t                 ForwardPixelValue20                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW83;
        union
        {
            struct
            {
                /// uint32_t 84
                uint32_t                 InverseGChGammaCorrectedValue21                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW84;
        union
        {
            struct
            {
                /// uint32_t 85
                uint32_t                 InversePixelValue21                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW85;
        union
        {
            struct
            {
                /// uint32_t 86
                uint32_t                 ForwardGChGammaCorrectedValue21                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW86;
        union
        {
            struct
            {
                /// uint32_t 87
                uint32_t                 ForwardPixelValue21                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW87;
        union
        {
            struct
            {
                /// uint32_t 88
                uint32_t                 InverseGChGammaCorrectedValue22                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW88;
        union
        {
            struct
            {
                /// uint32_t 89
                uint32_t                 InversePixelValue22                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW89;
        union
        {
            struct
            {
                /// uint32_t 90
                uint32_t                 ForwardGChGammaCorrectedValue22                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW90;
        union
        {
            struct
            {
                /// uint32_t 91
                uint32_t                 ForwardPixelValue22                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW91;
        union
        {
            struct
            {
                /// uint32_t 92
                uint32_t                 InverseGChGammaCorrectedValue23                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW92;
        union
        {
            struct
            {
                /// uint32_t 93
                uint32_t                 InversePixelValue23                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW93;
        union
        {
            struct
            {
                /// uint32_t 94
                uint32_t                 ForwardGChGammaCorrectedValue23                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW94;
        union
        {
            struct
            {
                /// uint32_t 95
                uint32_t                 ForwardPixelValue23                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW95;
        union
        {
            struct
            {
                /// uint32_t 96
                uint32_t                 InverseGChGammaCorrectedValue24                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW96;
        union
        {
            struct
            {
                /// uint32_t 97
                uint32_t                 InversePixelValue24                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW97;
        union
        {
            struct
            {
                /// uint32_t 98
                uint32_t                 ForwardGChGammaCorrectedValue24                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW98;
        union
        {
            struct
            {
                /// uint32_t 99
                uint32_t                 ForwardPixelValue24                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW99;
        union
        {
            struct
            {
                /// uint32_t 100
                uint32_t                 InverseGChGammaCorrectedValue25                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW100;
        union
        {
            struct
            {
                /// uint32_t 101
                uint32_t                 InversePixelValue25                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW101;
        union
        {
            struct
            {
                /// uint32_t 102
                uint32_t                 ForwardGChGammaCorrectedValue25                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW102;
        union
        {
            struct
            {
                /// uint32_t 103
                uint32_t                 ForwardPixelValue25                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW103;
        union
        {
            struct
            {
                /// uint32_t 104
                uint32_t                 InverseGChGammaCorrectedValue26                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW104;
        union
        {
            struct
            {
                /// uint32_t 105
                uint32_t                 InversePixelValue26                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW105;
        union
        {
            struct
            {
                /// uint32_t 106
                uint32_t                 ForwardGChGammaCorrectedValue26                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW106;
        union
        {
            struct
            {
                /// uint32_t 107
                uint32_t                 ForwardPixelValue26                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW107;
        union
        {
            struct
            {
                /// uint32_t 108
                uint32_t                 InverseGChGammaCorrectedValue27                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW108;
        union
        {
            struct
            {
                /// uint32_t 109
                uint32_t                 InversePixelValue27                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW109;
        union
        {
            struct
            {
                /// uint32_t 110
                uint32_t                 ForwardGChGammaCorrectedValue27                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW110;
        union
        {
            struct
            {
                /// uint32_t 111
                uint32_t                 ForwardPixelValue27                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW111;
        union
        {
            struct
            {
                /// uint32_t 112
                uint32_t                 InverseGChGammaCorrectedValue28                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW112;
        union
        {
            struct
            {
                /// uint32_t 113
                uint32_t                 InversePixelValue28                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW113;
        union
        {
            struct
            {
                /// uint32_t 114
                uint32_t                 ForwardGChGammaCorrectedValue28                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW114;
        union
        {
            struct
            {
                /// uint32_t 115
                uint32_t                 ForwardPixelValue28                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW115;
        union
        {
            struct
            {
                /// uint32_t 116
                uint32_t                 InverseGChGammaCorrectedValue29                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW116;
        union
        {
            struct
            {
                /// uint32_t 117
                uint32_t                 InversePixelValue29                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW117;
        union
        {
            struct
            {
                /// uint32_t 118
                uint32_t                 ForwardGChGammaCorrectedValue29                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW118;
        union
        {
            struct
            {
                /// uint32_t 119
                uint32_t                 ForwardPixelValue29                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW119;
        union
        {
            struct
            {
                /// uint32_t 120
                uint32_t                 InverseGChGammaCorrectedValue30                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW120;
        union
        {
            struct
            {
                /// uint32_t 121
                uint32_t                 InversePixelValue30                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW121;
        union
        {
            struct
            {
                /// uint32_t 122
                uint32_t                 ForwardGChGammaCorrectedValue30                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW122;
        union
        {
            struct
            {
                /// uint32_t 123
                uint32_t                 ForwardPixelValue30                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW123;
        union
        {
            struct
            {
                /// uint32_t 124
                uint32_t                 InverseGChGammaCorrectedValue31                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW124;
        union
        {
            struct
            {
                /// uint32_t 125
                uint32_t                 InversePixelValue31                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW125;
        union
        {
            struct
            {
                /// uint32_t 126
                uint32_t                 ForwardGChGammaCorrectedValue31                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW126;
        union
        {
            struct
            {
                /// uint32_t 127
                uint32_t                 ForwardPixelValue31                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW127;
        union
        {
            struct
            {
                /// uint32_t 128
                uint32_t                 InverseGChGammaCorrectedValue32                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW128;
        union
        {
            struct
            {
                /// uint32_t 129
                uint32_t                 InversePixelValue32                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW129;
        union
        {
            struct
            {
                /// uint32_t 130
                uint32_t                 ForwardGChGammaCorrectedValue32                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW130;
        union
        {
            struct
            {
                /// uint32_t 131
                uint32_t                 ForwardPixelValue32                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW131;
        union
        {
            struct
            {
                /// uint32_t 132
                uint32_t                 InverseGChGammaCorrectedValue33                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW132;
        union
        {
            struct
            {
                /// uint32_t 133
                uint32_t                 InversePixelValue33                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW133;
        union
        {
            struct
            {
                /// uint32_t 134
                uint32_t                 ForwardGChGammaCorrectedValue33                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW134;
        union
        {
            struct
            {
                /// uint32_t 135
                uint32_t                 ForwardPixelValue33                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW135;
        union
        {
            struct
            {
                /// uint32_t 136
                uint32_t                 InverseGChGammaCorrectedValue34                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW136;
        union
        {
            struct
            {
                /// uint32_t 137
                uint32_t                 InversePixelValue34                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW137;
        union
        {
            struct
            {
                /// uint32_t 138
                uint32_t                 ForwardGChGammaCorrectedValue34                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW138;
        union
        {
            struct
            {
                /// uint32_t 139
                uint32_t                 ForwardPixelValue34                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW139;
        union
        {
            struct
            {
                /// uint32_t 140
                uint32_t                 InverseGChGammaCorrectedValue35                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW140;
        union
        {
            struct
            {
                /// uint32_t 141
                uint32_t                 InversePixelValue35                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW141;
        union
        {
            struct
            {
                /// uint32_t 142
                uint32_t                 ForwardGChGammaCorrectedValue35                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW142;
        union
        {
            struct
            {
                /// uint32_t 143
                uint32_t                 ForwardPixelValue35                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW143;
        union
        {
            struct
            {
                /// uint32_t 144
                uint32_t                 InverseGChGammaCorrectedValue36                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW144;
        union
        {
            struct
            {
                /// uint32_t 145
                uint32_t                 InversePixelValue36                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW145;
        union
        {
            struct
            {
                /// uint32_t 146
                uint32_t                 ForwardGChGammaCorrectedValue36                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW146;
        union
        {
            struct
            {
                /// uint32_t 147
                uint32_t                 ForwardPixelValue36                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW147;
        union
        {
            struct
            {
                /// uint32_t 148
                uint32_t                 InverseGChGammaCorrectedValue37                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW148;
        union
        {
            struct
            {
                /// uint32_t 149
                uint32_t                 InversePixelValue37                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW149;
        union
        {
            struct
            {
                /// uint32_t 150
                uint32_t                 ForwardGChGammaCorrectedValue37                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW150;
        union
        {
            struct
            {
                /// uint32_t 151
                uint32_t                 ForwardPixelValue37                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW151;
        union
        {
            struct
            {
                /// uint32_t 152
                uint32_t                 InverseGChGammaCorrectedValue38                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW152;
        union
        {
            struct
            {
                /// uint32_t 153
                uint32_t                 InversePixelValue38                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW153;
        union
        {
            struct
            {
                /// uint32_t 154
                uint32_t                 ForwardGChGammaCorrectedValue38                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW154;
        union
        {
            struct
            {
                /// uint32_t 155
                uint32_t                 ForwardPixelValue38                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW155;
        union
        {
            struct
            {
                /// uint32_t 156
                uint32_t                 InverseGChGammaCorrectedValue39                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW156;
        union
        {
            struct
            {
                /// uint32_t 157
                uint32_t                 InversePixelValue39                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW157;
        union
        {
            struct
            {
                /// uint32_t 158
                uint32_t                 ForwardGChGammaCorrectedValue39                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW158;
        union
        {
            struct
            {
                /// uint32_t 159
                uint32_t                 ForwardPixelValue39                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW159;
        union
        {
            struct
            {
                /// uint32_t 160
                uint32_t                 InverseGChGammaCorrectedValue40                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW160;
        union
        {
            struct
            {
                /// uint32_t 161
                uint32_t                 InversePixelValue40                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW161;
        union
        {
            struct
            {
                /// uint32_t 162
                uint32_t                 ForwardGChGammaCorrectedValue40                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW162;
        union
        {
            struct
            {
                /// uint32_t 163
                uint32_t                 ForwardPixelValue40                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW163;
        union
        {
            struct
            {
                /// uint32_t 164
                uint32_t                 InverseGChGammaCorrectedValue41                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW164;
        union
        {
            struct
            {
                /// uint32_t 165
                uint32_t                 InversePixelValue41                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW165;
        union
        {
            struct
            {
                /// uint32_t 166
                uint32_t                 ForwardGChGammaCorrectedValue41                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW166;
        union
        {
            struct
            {
                /// uint32_t 167
                uint32_t                 ForwardPixelValue41                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW167;
        union
        {
            struct
            {
                /// uint32_t 168
                uint32_t                 InverseGChGammaCorrectedValue42                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW168;
        union
        {
            struct
            {
                /// uint32_t 169
                uint32_t                 InversePixelValue42                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW169;
        union
        {
            struct
            {
                /// uint32_t 170
                uint32_t                 ForwardGChGammaCorrectedValue42                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW170;
        union
        {
            struct
            {
                /// uint32_t 171
                uint32_t                 ForwardPixelValue42                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW171;
        union
        {
            struct
            {
                /// uint32_t 172
                uint32_t                 InverseGChGammaCorrectedValue43                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW172;
        union
        {
            struct
            {
                /// uint32_t 173
                uint32_t                 InversePixelValue43                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW173;
        union
        {
            struct
            {
                /// uint32_t 174
                uint32_t                 ForwardGChGammaCorrectedValue43                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW174;
        union
        {
            struct
            {
                /// uint32_t 175
                uint32_t                 ForwardPixelValue43                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW175;
        union
        {
            struct
            {
                /// uint32_t 176
                uint32_t                 InverseGChGammaCorrectedValue44                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW176;
        union
        {
            struct
            {
                /// uint32_t 177
                uint32_t                 InversePixelValue44                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW177;
        union
        {
            struct
            {
                /// uint32_t 178
                uint32_t                 ForwardGChGammaCorrectedValue44                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW178;
        union
        {
            struct
            {
                /// uint32_t 179
                uint32_t                 ForwardPixelValue44                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW179;
        union
        {
            struct
            {
                /// uint32_t 180
                uint32_t                 InverseGChGammaCorrectedValue45                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW180;
        union
        {
            struct
            {
                /// uint32_t 181
                uint32_t                 InversePixelValue45                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW181;
        union
        {
            struct
            {
                /// uint32_t 182
                uint32_t                 ForwardGChGammaCorrectedValue45                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW182;
        union
        {
            struct
            {
                /// uint32_t 183
                uint32_t                 ForwardPixelValue45                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW183;
        union
        {
            struct
            {
                /// uint32_t 184
                uint32_t                 InverseGChGammaCorrectedValue46                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW184;
        union
        {
            struct
            {
                /// uint32_t 185
                uint32_t                 InversePixelValue46                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW185;
        union
        {
            struct
            {
                /// uint32_t 186
                uint32_t                 ForwardGChGammaCorrectedValue46                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW186;
        union
        {
            struct
            {
                /// uint32_t 187
                uint32_t                 ForwardPixelValue46                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW187;
        union
        {
            struct
            {
                /// uint32_t 188
                uint32_t                 InverseGChGammaCorrectedValue47                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW188;
        union
        {
            struct
            {
                /// uint32_t 189
                uint32_t                 InversePixelValue47                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW189;
        union
        {
            struct
            {
                /// uint32_t 190
                uint32_t                 ForwardGChGammaCorrectedValue47                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW190;
        union
        {
            struct
            {
                /// uint32_t 191
                uint32_t                 ForwardPixelValue47                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW191;
        union
        {
            struct
            {
                /// uint32_t 192
                uint32_t                 InverseGChGammaCorrectedValue48                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW192;
        union
        {
            struct
            {
                /// uint32_t 193
                uint32_t                 InversePixelValue48                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW193;
        union
        {
            struct
            {
                /// uint32_t 194
                uint32_t                 ForwardGChGammaCorrectedValue48                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW194;
        union
        {
            struct
            {
                /// uint32_t 195
                uint32_t                 ForwardPixelValue48                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW195;
        union
        {
            struct
            {
                /// uint32_t 196
                uint32_t                 InverseGChGammaCorrectedValue49                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW196;
        union
        {
            struct
            {
                /// uint32_t 197
                uint32_t                 InversePixelValue49                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW197;
        union
        {
            struct
            {
                /// uint32_t 198
                uint32_t                 ForwardGChGammaCorrectedValue49                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW198;
        union
        {
            struct
            {
                /// uint32_t 199
                uint32_t                 ForwardPixelValue49                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW199;
        union
        {
            struct
            {
                /// uint32_t 200
                uint32_t                 InverseGChGammaCorrectedValue50                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW200;
        union
        {
            struct
            {
                /// uint32_t 201
                uint32_t                 InversePixelValue50                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW201;
        union
        {
            struct
            {
                /// uint32_t 202
                uint32_t                 ForwardGChGammaCorrectedValue50                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW202;
        union
        {
            struct
            {
                /// uint32_t 203
                uint32_t                 ForwardPixelValue50                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW203;
        union
        {
            struct
            {
                /// uint32_t 204
                uint32_t                 InverseGChGammaCorrectedValue51                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW204;
        union
        {
            struct
            {
                /// uint32_t 205
                uint32_t                 InversePixelValue51                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW205;
        union
        {
            struct
            {
                /// uint32_t 206
                uint32_t                 ForwardGChGammaCorrectedValue51                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW206;
        union
        {
            struct
            {
                /// uint32_t 207
                uint32_t                 ForwardPixelValue51                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW207;
        union
        {
            struct
            {
                /// uint32_t 208
                uint32_t                 InverseGChGammaCorrectedValue52                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW208;
        union
        {
            struct
            {
                /// uint32_t 209
                uint32_t                 InversePixelValue52                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW209;
        union
        {
            struct
            {
                /// uint32_t 210
                uint32_t                 ForwardGChGammaCorrectedValue52                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW210;
        union
        {
            struct
            {
                /// uint32_t 211
                uint32_t                 ForwardPixelValue52                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW211;
        union
        {
            struct
            {
                /// uint32_t 212
                uint32_t                 InverseGChGammaCorrectedValue53                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW212;
        union
        {
            struct
            {
                /// uint32_t 213
                uint32_t                 InversePixelValue53                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW213;
        union
        {
            struct
            {
                /// uint32_t 214
                uint32_t                 ForwardGChGammaCorrectedValue53                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW214;
        union
        {
            struct
            {
                /// uint32_t 215
                uint32_t                 ForwardPixelValue53                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW215;
        union
        {
            struct
            {
                /// uint32_t 216
                uint32_t                 InverseGChGammaCorrectedValue54                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW216;
        union
        {
            struct
            {
                /// uint32_t 217
                uint32_t                 InversePixelValue54                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW217;
        union
        {
            struct
            {
                /// uint32_t 218
                uint32_t                 ForwardGChGammaCorrectedValue54                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW218;
        union
        {
            struct
            {
                /// uint32_t 219
                uint32_t                 ForwardPixelValue54                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW219;
        union
        {
            struct
            {
                /// uint32_t 220
                uint32_t                 InverseGChGammaCorrectedValue55                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW220;
        union
        {
            struct
            {
                /// uint32_t 221
                uint32_t                 InversePixelValue55                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW221;
        union
        {
            struct
            {
                /// uint32_t 222
                uint32_t                 ForwardGChGammaCorrectedValue55                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW222;
        union
        {
            struct
            {
                /// uint32_t 223
                uint32_t                 ForwardPixelValue55                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW223;
        union
        {
            struct
            {
                /// uint32_t 224
                uint32_t                 InverseGChGammaCorrectedValue56                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW224;
        union
        {
            struct
            {
                /// uint32_t 225
                uint32_t                 InversePixelValue56                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW225;
        union
        {
            struct
            {
                /// uint32_t 226
                uint32_t                 ForwardGChGammaCorrectedValue56                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW226;
        union
        {
            struct
            {
                /// uint32_t 227
                uint32_t                 ForwardPixelValue56                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW227;
        union
        {
            struct
            {
                /// uint32_t 228
                uint32_t                 InverseGChGammaCorrectedValue57                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW228;
        union
        {
            struct
            {
                /// uint32_t 229
                uint32_t                 InversePixelValue57                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW229;
        union
        {
            struct
            {
                /// uint32_t 230
                uint32_t                 ForwardGChGammaCorrectedValue57                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW230;
        union
        {
            struct
            {
                /// uint32_t 231
                uint32_t                 ForwardPixelValue57                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW231;
        union
        {
            struct
            {
                /// uint32_t 232
                uint32_t                 InverseGChGammaCorrectedValue58                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW232;
        union
        {
            struct
            {
                /// uint32_t 233
                uint32_t                 InversePixelValue58                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW233;
        union
        {
            struct
            {
                /// uint32_t 234
                uint32_t                 ForwardGChGammaCorrectedValue58                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW234;
        union
        {
            struct
            {
                /// uint32_t 235
                uint32_t                 ForwardPixelValue58                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW235;
        union
        {
            struct
            {
                /// uint32_t 236
                uint32_t                 InverseGChGammaCorrectedValue59                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW236;
        union
        {
            struct
            {
                /// uint32_t 237
                uint32_t                 InversePixelValue59                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW237;
        union
        {
            struct
            {
                /// uint32_t 238
                uint32_t                 ForwardGChGammaCorrectedValue59                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW238;
        union
        {
            struct
            {
                /// uint32_t 239
                uint32_t                 ForwardPixelValue59                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW239;
        union
        {
            struct
            {
                /// uint32_t 240
                uint32_t                 InverseGChGammaCorrectedValue60                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW240;
        union
        {
            struct
            {
                /// uint32_t 241
                uint32_t                 InversePixelValue60                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW241;
        union
        {
            struct
            {
                /// uint32_t 242
                uint32_t                 ForwardGChGammaCorrectedValue60                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW242;
        union
        {
            struct
            {
                /// uint32_t 243
                uint32_t                 ForwardPixelValue60                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW243;
        union
        {
            struct
            {
                /// uint32_t 244
                uint32_t                 InverseGChGammaCorrectedValue61                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW244;
        union
        {
            struct
            {
                /// uint32_t 245
                uint32_t                 InversePixelValue61                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW245;
        union
        {
            struct
            {
                /// uint32_t 246
                uint32_t                 ForwardGChGammaCorrectedValue61                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW246;
        union
        {
            struct
            {
                /// uint32_t 247
                uint32_t                 ForwardPixelValue61                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW247;
        union
        {
            struct
            {
                /// uint32_t 248
                uint32_t                 InverseGChGammaCorrectedValue62                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW248;
        union
        {
            struct
            {
                /// uint32_t 249
                uint32_t                 InversePixelValue62                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW249;
        union
        {
            struct
            {
                /// uint32_t 250
                uint32_t                 ForwardGChGammaCorrectedValue62                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW250;
        union
        {
            struct
            {
                /// uint32_t 251
                uint32_t                 ForwardPixelValue62                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW251;
        union
        {
            struct
            {
                /// uint32_t 252
                uint32_t                 InverseGChGammaCorrectedValue63                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW252;
        union
        {
            struct
            {
                /// uint32_t 253
                uint32_t                 InversePixelValue63                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW253;
        union
        {
            struct
            {
                /// uint32_t 254
                uint32_t                 ForwardGChGammaCorrectedValue63                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW254;
        union
        {
            struct
            {
                /// uint32_t 255
                uint32_t                 ForwardPixelValue63                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW255;
        union
        {
            struct
            {
                /// uint32_t 256
                uint32_t                 InverseGChGammaCorrectedValue64                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW256;
        union
        {
            struct
            {
                /// uint32_t 257
                uint32_t                 InversePixelValue64                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW257;
        union
        {
            struct
            {
                /// uint32_t 258
                uint32_t                 ForwardGChGammaCorrectedValue64                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW258;
        union
        {
            struct
            {
                /// uint32_t 259
                uint32_t                 ForwardPixelValue64                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW259;
        union
        {
            struct
            {
                /// uint32_t 260
                uint32_t                 InverseGChGammaCorrectedValue65                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW260;
        union
        {
            struct
            {
                /// uint32_t 261
                uint32_t                 InversePixelValue65                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW261;
        union
        {
            struct
            {
                /// uint32_t 262
                uint32_t                 ForwardGChGammaCorrectedValue65                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW262;
        union
        {
            struct
            {
                /// uint32_t 263
                uint32_t                 ForwardPixelValue65                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW263;
        union
        {
            struct
            {
                /// uint32_t 264
                uint32_t                 InverseGChGammaCorrectedValue66                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW264;
        union
        {
            struct
            {
                /// uint32_t 265
                uint32_t                 InversePixelValue66                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW265;
        union
        {
            struct
            {
                /// uint32_t 266
                uint32_t                 ForwardGChGammaCorrectedValue66                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW266;
        union
        {
            struct
            {
                /// uint32_t 267
                uint32_t                 ForwardPixelValue66                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW267;
        union
        {
            struct
            {
                /// uint32_t 268
                uint32_t                 InverseGChGammaCorrectedValue67                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW268;
        union
        {
            struct
            {
                /// uint32_t 269
                uint32_t                 InversePixelValue67                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW269;
        union
        {
            struct
            {
                /// uint32_t 270
                uint32_t                 ForwardGChGammaCorrectedValue67                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW270;
        union
        {
            struct
            {
                /// uint32_t 271
                uint32_t                 ForwardPixelValue67                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW271;
        union
        {
            struct
            {
                /// uint32_t 272
                uint32_t                 InverseGChGammaCorrectedValue68                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW272;
        union
        {
            struct
            {
                /// uint32_t 273
                uint32_t                 InversePixelValue68                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW273;
        union
        {
            struct
            {
                /// uint32_t 274
                uint32_t                 ForwardGChGammaCorrectedValue68                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW274;
        union
        {
            struct
            {
                /// uint32_t 275
                uint32_t                 ForwardPixelValue68                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW275;
        union
        {
            struct
            {
                /// uint32_t 276
                uint32_t                 InverseGChGammaCorrectedValue69                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW276;
        union
        {
            struct
            {
                /// uint32_t 277
                uint32_t                 InversePixelValue69                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW277;
        union
        {
            struct
            {
                /// uint32_t 278
                uint32_t                 ForwardGChGammaCorrectedValue69                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW278;
        union
        {
            struct
            {
                /// uint32_t 279
                uint32_t                 ForwardPixelValue69                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW279;
        union
        {
            struct
            {
                /// uint32_t 280
                uint32_t                 InverseGChGammaCorrectedValue70                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW280;
        union
        {
            struct
            {
                /// uint32_t 281
                uint32_t                 InversePixelValue70                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW281;
        union
        {
            struct
            {
                /// uint32_t 282
                uint32_t                 ForwardGChGammaCorrectedValue70                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW282;
        union
        {
            struct
            {
                /// uint32_t 283
                uint32_t                 ForwardPixelValue70                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW283;
        union
        {
            struct
            {
                /// uint32_t 284
                uint32_t                 InverseGChGammaCorrectedValue71                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW284;
        union
        {
            struct
            {
                /// uint32_t 285
                uint32_t                 InversePixelValue71                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW285;
        union
        {
            struct
            {
                /// uint32_t 286
                uint32_t                 ForwardGChGammaCorrectedValue71                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW286;
        union
        {
            struct
            {
                /// uint32_t 287
                uint32_t                 ForwardPixelValue71                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW287;
        union
        {
            struct
            {
                /// uint32_t 288
                uint32_t                 InverseGChGammaCorrectedValue72                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW288;
        union
        {
            struct
            {
                /// uint32_t 289
                uint32_t                 InversePixelValue72                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW289;
        union
        {
            struct
            {
                /// uint32_t 290
                uint32_t                 ForwardGChGammaCorrectedValue72                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW290;
        union
        {
            struct
            {
                /// uint32_t 291
                uint32_t                 ForwardPixelValue72                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW291;
        union
        {
            struct
            {
                /// uint32_t 292
                uint32_t                 InverseGChGammaCorrectedValue73                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW292;
        union
        {
            struct
            {
                /// uint32_t 293
                uint32_t                 InversePixelValue73                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW293;
        union
        {
            struct
            {
                /// uint32_t 294
                uint32_t                 ForwardGChGammaCorrectedValue73                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW294;
        union
        {
            struct
            {
                /// uint32_t 295
                uint32_t                 ForwardPixelValue73                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW295;
        union
        {
            struct
            {
                /// uint32_t 296
                uint32_t                 InverseGChGammaCorrectedValue74                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW296;
        union
        {
            struct
            {
                /// uint32_t 297
                uint32_t                 InversePixelValue74                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW297;
        union
        {
            struct
            {
                /// uint32_t 298
                uint32_t                 ForwardGChGammaCorrectedValue74                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW298;
        union
        {
            struct
            {
                /// uint32_t 299
                uint32_t                 ForwardPixelValue74                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW299;
        union
        {
            struct
            {
                /// uint32_t 300
                uint32_t                 InverseGChGammaCorrectedValue75                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW300;
        union
        {
            struct
            {
                /// uint32_t 301
                uint32_t                 InversePixelValue75                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW301;
        union
        {
            struct
            {
                /// uint32_t 302
                uint32_t                 ForwardGChGammaCorrectedValue75                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW302;
        union
        {
            struct
            {
                /// uint32_t 303
                uint32_t                 ForwardPixelValue75                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW303;
        union
        {
            struct
            {
                /// uint32_t 304
                uint32_t                 InverseGChGammaCorrectedValue76                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW304;
        union
        {
            struct
            {
                /// uint32_t 305
                uint32_t                 InversePixelValue76                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW305;
        union
        {
            struct
            {
                /// uint32_t 306
                uint32_t                 ForwardGChGammaCorrectedValue76                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW306;
        union
        {
            struct
            {
                /// uint32_t 307
                uint32_t                 ForwardPixelValue76                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW307;
        union
        {
            struct
            {
                /// uint32_t 308
                uint32_t                 InverseGChGammaCorrectedValue77                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW308;
        union
        {
            struct
            {
                /// uint32_t 309
                uint32_t                 InversePixelValue77                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW309;
        union
        {
            struct
            {
                /// uint32_t 310
                uint32_t                 ForwardGChGammaCorrectedValue77                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW310;
        union
        {
            struct
            {
                /// uint32_t 311
                uint32_t                 ForwardPixelValue77                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW311;
        union
        {
            struct
            {
                /// uint32_t 312
                uint32_t                 InverseGChGammaCorrectedValue78                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW312;
        union
        {
            struct
            {
                /// uint32_t 313
                uint32_t                 InversePixelValue78                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW313;
        union
        {
            struct
            {
                /// uint32_t 314
                uint32_t                 ForwardGChGammaCorrectedValue78                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW314;
        union
        {
            struct
            {
                /// uint32_t 315
                uint32_t                 ForwardPixelValue78                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW315;
        union
        {
            struct
            {
                /// uint32_t 316
                uint32_t                 InverseGChGammaCorrectedValue79                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW316;
        union
        {
            struct
            {
                /// uint32_t 317
                uint32_t                 InversePixelValue79                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW317;
        union
        {
            struct
            {
                /// uint32_t 318
                uint32_t                 ForwardGChGammaCorrectedValue79                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW318;
        union
        {
            struct
            {
                /// uint32_t 319
                uint32_t                 ForwardPixelValue79                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW319;
        union
        {
            struct
            {
                /// uint32_t 320
                uint32_t                 InverseGChGammaCorrectedValue80                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW320;
        union
        {
            struct
            {
                /// uint32_t 321
                uint32_t                 InversePixelValue80                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW321;
        union
        {
            struct
            {
                /// uint32_t 322
                uint32_t                 ForwardGChGammaCorrectedValue80                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW322;
        union
        {
            struct
            {
                /// uint32_t 323
                uint32_t                 ForwardPixelValue80                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW323;
        union
        {
            struct
            {
                /// uint32_t 324
                uint32_t                 InverseGChGammaCorrectedValue81                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW324;
        union
        {
            struct
            {
                /// uint32_t 325
                uint32_t                 InversePixelValue81                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW325;
        union
        {
            struct
            {
                /// uint32_t 326
                uint32_t                 ForwardGChGammaCorrectedValue81                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW326;
        union
        {
            struct
            {
                /// uint32_t 327
                uint32_t                 ForwardPixelValue81                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW327;
        union
        {
            struct
            {
                /// uint32_t 328
                uint32_t                 InverseGChGammaCorrectedValue82                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW328;
        union
        {
            struct
            {
                /// uint32_t 329
                uint32_t                 InversePixelValue82                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW329;
        union
        {
            struct
            {
                /// uint32_t 330
                uint32_t                 ForwardGChGammaCorrectedValue82                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW330;
        union
        {
            struct
            {
                /// uint32_t 331
                uint32_t                 ForwardPixelValue82                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW331;
        union
        {
            struct
            {
                /// uint32_t 332
                uint32_t                 InverseGChGammaCorrectedValue83                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW332;
        union
        {
            struct
            {
                /// uint32_t 333
                uint32_t                 InversePixelValue83                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW333;
        union
        {
            struct
            {
                /// uint32_t 334
                uint32_t                 ForwardGChGammaCorrectedValue83                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW334;
        union
        {
            struct
            {
                /// uint32_t 335
                uint32_t                 ForwardPixelValue83                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW335;
        union
        {
            struct
            {
                /// uint32_t 336
                uint32_t                 InverseGChGammaCorrectedValue84                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW336;
        union
        {
            struct
            {
                /// uint32_t 337
                uint32_t                 InversePixelValue84                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW337;
        union
        {
            struct
            {
                /// uint32_t 338
                uint32_t                 ForwardGChGammaCorrectedValue84                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW338;
        union
        {
            struct
            {
                /// uint32_t 339
                uint32_t                 ForwardPixelValue84                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW339;
        union
        {
            struct
            {
                /// uint32_t 340
                uint32_t                 InverseGChGammaCorrectedValue85                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW340;
        union
        {
            struct
            {
                /// uint32_t 341
                uint32_t                 InversePixelValue85                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW341;
        union
        {
            struct
            {
                /// uint32_t 342
                uint32_t                 ForwardGChGammaCorrectedValue85                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW342;
        union
        {
            struct
            {
                /// uint32_t 343
                uint32_t                 ForwardPixelValue85                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW343;
        union
        {
            struct
            {
                /// uint32_t 344
                uint32_t                 InverseGChGammaCorrectedValue86                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW344;
        union
        {
            struct
            {
                /// uint32_t 345
                uint32_t                 InversePixelValue86                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW345;
        union
        {
            struct
            {
                /// uint32_t 346
                uint32_t                 ForwardGChGammaCorrectedValue86                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW346;
        union
        {
            struct
            {
                /// uint32_t 347
                uint32_t                 ForwardPixelValue86                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW347;
        union
        {
            struct
            {
                /// uint32_t 348
                uint32_t                 InverseGChGammaCorrectedValue87                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW348;
        union
        {
            struct
            {
                /// uint32_t 349
                uint32_t                 InversePixelValue87                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW349;
        union
        {
            struct
            {
                /// uint32_t 350
                uint32_t                 ForwardGChGammaCorrectedValue87                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW350;
        union
        {
            struct
            {
                /// uint32_t 351
                uint32_t                 ForwardPixelValue87                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW351;
        union
        {
            struct
            {
                /// uint32_t 352
                uint32_t                 InverseGChGammaCorrectedValue88                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW352;
        union
        {
            struct
            {
                /// uint32_t 353
                uint32_t                 InversePixelValue88                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW353;
        union
        {
            struct
            {
                /// uint32_t 354
                uint32_t                 ForwardGChGammaCorrectedValue88                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW354;
        union
        {
            struct
            {
                /// uint32_t 355
                uint32_t                 ForwardPixelValue88                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW355;
        union
        {
            struct
            {
                /// uint32_t 356
                uint32_t                 InverseGChGammaCorrectedValue89                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW356;
        union
        {
            struct
            {
                /// uint32_t 357
                uint32_t                 InversePixelValue89                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW357;
        union
        {
            struct
            {
                /// uint32_t 358
                uint32_t                 ForwardGChGammaCorrectedValue89                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW358;
        union
        {
            struct
            {
                /// uint32_t 359
                uint32_t                 ForwardPixelValue89                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW359;
        union
        {
            struct
            {
                /// uint32_t 360
                uint32_t                 InverseGChGammaCorrectedValue90                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW360;
        union
        {
            struct
            {
                /// uint32_t 361
                uint32_t                 InversePixelValue90                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW361;
        union
        {
            struct
            {
                /// uint32_t 362
                uint32_t                 ForwardGChGammaCorrectedValue90                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW362;
        union
        {
            struct
            {
                /// uint32_t 363
                uint32_t                 ForwardPixelValue90                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW363;
        union
        {
            struct
            {
                /// uint32_t 364
                uint32_t                 InverseGChGammaCorrectedValue91                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW364;
        union
        {
            struct
            {
                /// uint32_t 365
                uint32_t                 InversePixelValue91                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW365;
        union
        {
            struct
            {
                /// uint32_t 366
                uint32_t                 ForwardGChGammaCorrectedValue91                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW366;
        union
        {
            struct
            {
                /// uint32_t 367
                uint32_t                 ForwardPixelValue91                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW367;
        union
        {
            struct
            {
                /// uint32_t 368
                uint32_t                 InverseGChGammaCorrectedValue92                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW368;
        union
        {
            struct
            {
                /// uint32_t 369
                uint32_t                 InversePixelValue92                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW369;
        union
        {
            struct
            {
                /// uint32_t 370
                uint32_t                 ForwardGChGammaCorrectedValue92                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW370;
        union
        {
            struct
            {
                /// uint32_t 371
                uint32_t                 ForwardPixelValue92                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW371;
        union
        {
            struct
            {
                /// uint32_t 372
                uint32_t                 InverseGChGammaCorrectedValue93                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW372;
        union
        {
            struct
            {
                /// uint32_t 373
                uint32_t                 InversePixelValue93                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW373;
        union
        {
            struct
            {
                /// uint32_t 374
                uint32_t                 ForwardGChGammaCorrectedValue93                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW374;
        union
        {
            struct
            {
                /// uint32_t 375
                uint32_t                 ForwardPixelValue93                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW375;
        union
        {
            struct
            {
                /// uint32_t 376
                uint32_t                 InverseGChGammaCorrectedValue94                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW376;
        union
        {
            struct
            {
                /// uint32_t 377
                uint32_t                 InversePixelValue94                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW377;
        union
        {
            struct
            {
                /// uint32_t 378
                uint32_t                 ForwardGChGammaCorrectedValue94                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW378;
        union
        {
            struct
            {
                /// uint32_t 379
                uint32_t                 ForwardPixelValue94                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW379;
        union
        {
            struct
            {
                /// uint32_t 380
                uint32_t                 InverseGChGammaCorrectedValue95                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW380;
        union
        {
            struct
            {
                /// uint32_t 381
                uint32_t                 InversePixelValue95                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW381;
        union
        {
            struct
            {
                /// uint32_t 382
                uint32_t                 ForwardGChGammaCorrectedValue95                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW382;
        union
        {
            struct
            {
                /// uint32_t 383
                uint32_t                 ForwardPixelValue95                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW383;
        union
        {
            struct
            {
                /// uint32_t 384
                uint32_t                 InverseGChGammaCorrectedValue96                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW384;
        union
        {
            struct
            {
                /// uint32_t 385
                uint32_t                 InversePixelValue96                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW385;
        union
        {
            struct
            {
                /// uint32_t 386
                uint32_t                 ForwardGChGammaCorrectedValue96                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW386;
        union
        {
            struct
            {
                /// uint32_t 387
                uint32_t                 ForwardPixelValue96                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW387;
        union
        {
            struct
            {
                /// uint32_t 388
                uint32_t                 InverseGChGammaCorrectedValue97                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW388;
        union
        {
            struct
            {
                /// uint32_t 389
                uint32_t                 InversePixelValue97                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW389;
        union
        {
            struct
            {
                /// uint32_t 390
                uint32_t                 ForwardGChGammaCorrectedValue97                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW390;
        union
        {
            struct
            {
                /// uint32_t 391
                uint32_t                 ForwardPixelValue97                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW391;
        union
        {
            struct
            {
                /// uint32_t 392
                uint32_t                 InverseGChGammaCorrectedValue98                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW392;
        union
        {
            struct
            {
                /// uint32_t 393
                uint32_t                 InversePixelValue98                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW393;
        union
        {
            struct
            {
                /// uint32_t 394
                uint32_t                 ForwardGChGammaCorrectedValue98                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW394;
        union
        {
            struct
            {
                /// uint32_t 395
                uint32_t                 ForwardPixelValue98                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW395;
        union
        {
            struct
            {
                /// uint32_t 396
                uint32_t                 InverseGChGammaCorrectedValue99                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW396;
        union
        {
            struct
            {
                /// uint32_t 397
                uint32_t                 InversePixelValue99                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW397;
        union
        {
            struct
            {
                /// uint32_t 398
                uint32_t                 ForwardGChGammaCorrectedValue99                  : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW398;
        union
        {
            struct
            {
                /// uint32_t 399
                uint32_t                 ForwardPixelValue99                              : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW399;
        union
        {
            struct
            {
                /// uint32_t 400
                uint32_t                 InverseGChGammaCorrectedValue100                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW400;
        union
        {
            struct
            {
                /// uint32_t 401
                uint32_t                 InversePixelValue100                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW401;
        union
        {
            struct
            {
                /// uint32_t 402
                uint32_t                 ForwardGChGammaCorrectedValue100                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW402;
        union
        {
            struct
            {
                /// uint32_t 403
                uint32_t                 ForwardPixelValue100                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW403;
        union
        {
            struct
            {
                /// uint32_t 404
                uint32_t                 InverseGChGammaCorrectedValue101                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW404;
        union
        {
            struct
            {
                /// uint32_t 405
                uint32_t                 InversePixelValue101                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW405;
        union
        {
            struct
            {
                /// uint32_t 406
                uint32_t                 ForwardGChGammaCorrectedValue101                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW406;
        union
        {
            struct
            {
                /// uint32_t 407
                uint32_t                 ForwardPixelValue101                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW407;
        union
        {
            struct
            {
                /// uint32_t 408
                uint32_t                 InverseGChGammaCorrectedValue102                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW408;
        union
        {
            struct
            {
                /// uint32_t 409
                uint32_t                 InversePixelValue102                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW409;
        union
        {
            struct
            {
                /// uint32_t 410
                uint32_t                 ForwardGChGammaCorrectedValue102                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW410;
        union
        {
            struct
            {
                /// uint32_t 411
                uint32_t                 ForwardPixelValue102                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW411;
        union
        {
            struct
            {
                /// uint32_t 412
                uint32_t                 InverseGChGammaCorrectedValue103                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW412;
        union
        {
            struct
            {
                /// uint32_t 413
                uint32_t                 InversePixelValue103                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW413;
        union
        {
            struct
            {
                /// uint32_t 414
                uint32_t                 ForwardGChGammaCorrectedValue103                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW414;
        union
        {
            struct
            {
                /// uint32_t 415
                uint32_t                 ForwardPixelValue103                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW415;
        union
        {
            struct
            {
                /// uint32_t 416
                uint32_t                 InverseGChGammaCorrectedValue104                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW416;
        union
        {
            struct
            {
                /// uint32_t 417
                uint32_t                 InversePixelValue104                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW417;
        union
        {
            struct
            {
                /// uint32_t 418
                uint32_t                 ForwardGChGammaCorrectedValue104                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW418;
        union
        {
            struct
            {
                /// uint32_t 419
                uint32_t                 ForwardPixelValue104                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW419;
        union
        {
            struct
            {
                /// uint32_t 420
                uint32_t                 InverseGChGammaCorrectedValue105                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW420;
        union
        {
            struct
            {
                /// uint32_t 421
                uint32_t                 InversePixelValue105                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW421;
        union
        {
            struct
            {
                /// uint32_t 422
                uint32_t                 ForwardGChGammaCorrectedValue105                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW422;
        union
        {
            struct
            {
                /// uint32_t 423
                uint32_t                 ForwardPixelValue105                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW423;
        union
        {
            struct
            {
                /// uint32_t 424
                uint32_t                 InverseGChGammaCorrectedValue106                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW424;
        union
        {
            struct
            {
                /// uint32_t 425
                uint32_t                 InversePixelValue106                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW425;
        union
        {
            struct
            {
                /// uint32_t 426
                uint32_t                 ForwardGChGammaCorrectedValue106                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW426;
        union
        {
            struct
            {
                /// uint32_t 427
                uint32_t                 ForwardPixelValue106                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW427;
        union
        {
            struct
            {
                /// uint32_t 428
                uint32_t                 InverseGChGammaCorrectedValue107                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW428;
        union
        {
            struct
            {
                /// uint32_t 429
                uint32_t                 InversePixelValue107                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW429;
        union
        {
            struct
            {
                /// uint32_t 430
                uint32_t                 ForwardGChGammaCorrectedValue107                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW430;
        union
        {
            struct
            {
                /// uint32_t 431
                uint32_t                 ForwardPixelValue107                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW431;
        union
        {
            struct
            {
                /// uint32_t 432
                uint32_t                 InverseGChGammaCorrectedValue108                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW432;
        union
        {
            struct
            {
                /// uint32_t 433
                uint32_t                 InversePixelValue108                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW433;
        union
        {
            struct
            {
                /// uint32_t 434
                uint32_t                 ForwardGChGammaCorrectedValue108                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW434;
        union
        {
            struct
            {
                /// uint32_t 435
                uint32_t                 ForwardPixelValue108                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW435;
        union
        {
            struct
            {
                /// uint32_t 436
                uint32_t                 InverseGChGammaCorrectedValue109                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW436;
        union
        {
            struct
            {
                /// uint32_t 437
                uint32_t                 InversePixelValue109                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW437;
        union
        {
            struct
            {
                /// uint32_t 438
                uint32_t                 ForwardGChGammaCorrectedValue109                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW438;
        union
        {
            struct
            {
                /// uint32_t 439
                uint32_t                 ForwardPixelValue109                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW439;
        union
        {
            struct
            {
                /// uint32_t 440
                uint32_t                 InverseGChGammaCorrectedValue110                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW440;
        union
        {
            struct
            {
                /// uint32_t 441
                uint32_t                 InversePixelValue110                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW441;
        union
        {
            struct
            {
                /// uint32_t 442
                uint32_t                 ForwardGChGammaCorrectedValue110                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW442;
        union
        {
            struct
            {
                /// uint32_t 443
                uint32_t                 ForwardPixelValue110                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW443;
        union
        {
            struct
            {
                /// uint32_t 444
                uint32_t                 InverseGChGammaCorrectedValue111                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW444;
        union
        {
            struct
            {
                /// uint32_t 445
                uint32_t                 InversePixelValue111                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW445;
        union
        {
            struct
            {
                /// uint32_t 446
                uint32_t                 ForwardGChGammaCorrectedValue111                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW446;
        union
        {
            struct
            {
                /// uint32_t 447
                uint32_t                 ForwardPixelValue111                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW447;
        union
        {
            struct
            {
                /// uint32_t 448
                uint32_t                 InverseGChGammaCorrectedValue112                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW448;
        union
        {
            struct
            {
                /// uint32_t 449
                uint32_t                 InversePixelValue112                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW449;
        union
        {
            struct
            {
                /// uint32_t 450
                uint32_t                 ForwardGChGammaCorrectedValue112                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW450;
        union
        {
            struct
            {
                /// uint32_t 451
                uint32_t                 ForwardPixelValue112                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW451;
        union
        {
            struct
            {
                /// uint32_t 452
                uint32_t                 InverseGChGammaCorrectedValue113                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW452;
        union
        {
            struct
            {
                /// uint32_t 453
                uint32_t                 InversePixelValue113                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW453;
        union
        {
            struct
            {
                /// uint32_t 454
                uint32_t                 ForwardGChGammaCorrectedValue113                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW454;
        union
        {
            struct
            {
                /// uint32_t 455
                uint32_t                 ForwardPixelValue113                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW455;
        union
        {
            struct
            {
                /// uint32_t 456
                uint32_t                 InverseGChGammaCorrectedValue114                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW456;
        union
        {
            struct
            {
                /// uint32_t 457
                uint32_t                 InversePixelValue114                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW457;
        union
        {
            struct
            {
                /// uint32_t 458
                uint32_t                 ForwardGChGammaCorrectedValue114                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW458;
        union
        {
            struct
            {
                /// uint32_t 459
                uint32_t                 ForwardPixelValue114                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW459;
        union
        {
            struct
            {
                /// uint32_t 460
                uint32_t                 InverseGChGammaCorrectedValue115                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW460;
        union
        {
            struct
            {
                /// uint32_t 461
                uint32_t                 InversePixelValue115                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW461;
        union
        {
            struct
            {
                /// uint32_t 462
                uint32_t                 ForwardGChGammaCorrectedValue115                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW462;
        union
        {
            struct
            {
                /// uint32_t 463
                uint32_t                 ForwardPixelValue115                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW463;
        union
        {
            struct
            {
                /// uint32_t 464
                uint32_t                 InverseGChGammaCorrectedValue116                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW464;
        union
        {
            struct
            {
                /// uint32_t 465
                uint32_t                 InversePixelValue116                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW465;
        union
        {
            struct
            {
                /// uint32_t 466
                uint32_t                 ForwardGChGammaCorrectedValue116                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW466;
        union
        {
            struct
            {
                /// uint32_t 467
                uint32_t                 ForwardPixelValue116                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW467;
        union
        {
            struct
            {
                /// uint32_t 468
                uint32_t                 InverseGChGammaCorrectedValue117                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW468;
        union
        {
            struct
            {
                /// uint32_t 469
                uint32_t                 InversePixelValue117                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW469;
        union
        {
            struct
            {
                /// uint32_t 470
                uint32_t                 ForwardGChGammaCorrectedValue117                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW470;
        union
        {
            struct
            {
                /// uint32_t 471
                uint32_t                 ForwardPixelValue117                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW471;
        union
        {
            struct
            {
                /// uint32_t 472
                uint32_t                 InverseGChGammaCorrectedValue118                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW472;
        union
        {
            struct
            {
                /// uint32_t 473
                uint32_t                 InversePixelValue118                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW473;
        union
        {
            struct
            {
                /// uint32_t 474
                uint32_t                 ForwardGChGammaCorrectedValue118                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW474;
        union
        {
            struct
            {
                /// uint32_t 475
                uint32_t                 ForwardPixelValue118                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW475;
        union
        {
            struct
            {
                /// uint32_t 476
                uint32_t                 InverseGChGammaCorrectedValue119                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW476;
        union
        {
            struct
            {
                /// uint32_t 477
                uint32_t                 InversePixelValue119                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW477;
        union
        {
            struct
            {
                /// uint32_t 478
                uint32_t                 ForwardGChGammaCorrectedValue119                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW478;
        union
        {
            struct
            {
                /// uint32_t 479
                uint32_t                 ForwardPixelValue119                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW479;
        union
        {
            struct
            {
                /// uint32_t 480
                uint32_t                 InverseGChGammaCorrectedValue120                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW480;
        union
        {
            struct
            {
                /// uint32_t 481
                uint32_t                 InversePixelValue120                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW481;
        union
        {
            struct
            {
                /// uint32_t 482
                uint32_t                 ForwardGChGammaCorrectedValue120                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW482;
        union
        {
            struct
            {
                /// uint32_t 483
                uint32_t                 ForwardPixelValue120                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW483;
        union
        {
            struct
            {
                /// uint32_t 484
                uint32_t                 InverseGChGammaCorrectedValue121                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW484;
        union
        {
            struct
            {
                /// uint32_t 485
                uint32_t                 InversePixelValue121                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW485;
        union
        {
            struct
            {
                /// uint32_t 486
                uint32_t                 ForwardGChGammaCorrectedValue121                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW486;
        union
        {
            struct
            {
                /// uint32_t 487
                uint32_t                 ForwardPixelValue121                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW487;
        union
        {
            struct
            {
                /// uint32_t 488
                uint32_t                 InverseGChGammaCorrectedValue122                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW488;
        union
        {
            struct
            {
                /// uint32_t 489
                uint32_t                 InversePixelValue122                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW489;
        union
        {
            struct
            {
                /// uint32_t 490
                uint32_t                 ForwardGChGammaCorrectedValue122                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW490;
        union
        {
            struct
            {
                /// uint32_t 491
                uint32_t                 ForwardPixelValue122                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW491;
        union
        {
            struct
            {
                /// uint32_t 492
                uint32_t                 InverseGChGammaCorrectedValue123                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW492;
        union
        {
            struct
            {
                /// uint32_t 493
                uint32_t                 InversePixelValue123                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW493;
        union
        {
            struct
            {
                /// uint32_t 494
                uint32_t                 ForwardGChGammaCorrectedValue123                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW494;
        union
        {
            struct
            {
                /// uint32_t 495
                uint32_t                 ForwardPixelValue123                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW495;
        union
        {
            struct
            {
                /// uint32_t 496
                uint32_t                 InverseGChGammaCorrectedValue124                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW496;
        union
        {
            struct
            {
                /// uint32_t 497
                uint32_t                 InversePixelValue124                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW497;
        union
        {
            struct
            {
                /// uint32_t 498
                uint32_t                 ForwardGChGammaCorrectedValue124                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW498;
        union
        {
            struct
            {
                /// uint32_t 499
                uint32_t                 ForwardPixelValue124                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW499;
        union
        {
            struct
            {
                /// uint32_t 500
                uint32_t                 InverseGChGammaCorrectedValue125                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW500;
        union
        {
            struct
            {
                /// uint32_t 501
                uint32_t                 InversePixelValue125                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW501;
        union
        {
            struct
            {
                /// uint32_t 502
                uint32_t                 ForwardGChGammaCorrectedValue125                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW502;
        union
        {
            struct
            {
                /// uint32_t 503
                uint32_t                 ForwardPixelValue125                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW503;
        union
        {
            struct
            {
                /// uint32_t 504
                uint32_t                 InverseGChGammaCorrectedValue126                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW504;
        union
        {
            struct
            {
                /// uint32_t 505
                uint32_t                 InversePixelValue126                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW505;
        union
        {
            struct
            {
                /// uint32_t 506
                uint32_t                 ForwardGChGammaCorrectedValue126                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW506;
        union
        {
            struct
            {
                /// uint32_t 507
                uint32_t                 ForwardPixelValue126                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW507;
        union
        {
            struct
            {
                /// uint32_t 508
                uint32_t                 InverseGChGammaCorrectedValue127                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW508;
        union
        {
            struct
            {
                /// uint32_t 509
                uint32_t                 InversePixelValue127                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW509;
        union
        {
            struct
            {
                /// uint32_t 510
                uint32_t                 ForwardGChGammaCorrectedValue127                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW510;
        union
        {
            struct
            {
                /// uint32_t 511
                uint32_t                 ForwardPixelValue127                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW511;
        union
        {
            struct
            {
                /// uint32_t 512
                uint32_t                 InverseGChGammaCorrectedValue128                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW512;
        union
        {
            struct
            {
                /// uint32_t 513
                uint32_t                 InversePixelValue128                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW513;
        union
        {
            struct
            {
                /// uint32_t 514
                uint32_t                 ForwardGChGammaCorrectedValue128                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW514;
        union
        {
            struct
            {
                /// uint32_t 515
                uint32_t                 ForwardPixelValue128                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW515;
        union
        {
            struct
            {
                /// uint32_t 516
                uint32_t                 InverseGChGammaCorrectedValue129                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW516;
        union
        {
            struct
            {
                /// uint32_t 517
                uint32_t                 InversePixelValue129                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW517;
        union
        {
            struct
            {
                /// uint32_t 518
                uint32_t                 ForwardGChGammaCorrectedValue129                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW518;
        union
        {
            struct
            {
                /// uint32_t 519
                uint32_t                 ForwardPixelValue129                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW519;
        union
        {
            struct
            {
                /// uint32_t 520
                uint32_t                 InverseGChGammaCorrectedValue130                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW520;
        union
        {
            struct
            {
                /// uint32_t 521
                uint32_t                 InversePixelValue130                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW521;
        union
        {
            struct
            {
                /// uint32_t 522
                uint32_t                 ForwardGChGammaCorrectedValue130                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW522;
        union
        {
            struct
            {
                /// uint32_t 523
                uint32_t                 ForwardPixelValue130                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW523;
        union
        {
            struct
            {
                /// uint32_t 524
                uint32_t                 InverseGChGammaCorrectedValue131                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW524;
        union
        {
            struct
            {
                /// uint32_t 525
                uint32_t                 InversePixelValue131                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW525;
        union
        {
            struct
            {
                /// uint32_t 526
                uint32_t                 ForwardGChGammaCorrectedValue131                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW526;
        union
        {
            struct
            {
                /// uint32_t 527
                uint32_t                 ForwardPixelValue131                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW527;
        union
        {
            struct
            {
                /// uint32_t 528
                uint32_t                 InverseGChGammaCorrectedValue132                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW528;
        union
        {
            struct
            {
                /// uint32_t 529
                uint32_t                 InversePixelValue132                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW529;
        union
        {
            struct
            {
                /// uint32_t 530
                uint32_t                 ForwardGChGammaCorrectedValue132                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW530;
        union
        {
            struct
            {
                /// uint32_t 531
                uint32_t                 ForwardPixelValue132                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW531;
        union
        {
            struct
            {
                /// uint32_t 532
                uint32_t                 InverseGChGammaCorrectedValue133                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW532;
        union
        {
            struct
            {
                /// uint32_t 533
                uint32_t                 InversePixelValue133                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW533;
        union
        {
            struct
            {
                /// uint32_t 534
                uint32_t                 ForwardGChGammaCorrectedValue133                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW534;
        union
        {
            struct
            {
                /// uint32_t 535
                uint32_t                 ForwardPixelValue133                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW535;
        union
        {
            struct
            {
                /// uint32_t 536
                uint32_t                 InverseGChGammaCorrectedValue134                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW536;
        union
        {
            struct
            {
                /// uint32_t 537
                uint32_t                 InversePixelValue134                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW537;
        union
        {
            struct
            {
                /// uint32_t 538
                uint32_t                 ForwardGChGammaCorrectedValue134                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW538;
        union
        {
            struct
            {
                /// uint32_t 539
                uint32_t                 ForwardPixelValue134                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW539;
        union
        {
            struct
            {
                /// uint32_t 540
                uint32_t                 InverseGChGammaCorrectedValue135                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW540;
        union
        {
            struct
            {
                /// uint32_t 541
                uint32_t                 InversePixelValue135                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW541;
        union
        {
            struct
            {
                /// uint32_t 542
                uint32_t                 ForwardGChGammaCorrectedValue135                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW542;
        union
        {
            struct
            {
                /// uint32_t 543
                uint32_t                 ForwardPixelValue135                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW543;
        union
        {
            struct
            {
                /// uint32_t 544
                uint32_t                 InverseGChGammaCorrectedValue136                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW544;
        union
        {
            struct
            {
                /// uint32_t 545
                uint32_t                 InversePixelValue136                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW545;
        union
        {
            struct
            {
                /// uint32_t 546
                uint32_t                 ForwardGChGammaCorrectedValue136                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW546;
        union
        {
            struct
            {
                /// uint32_t 547
                uint32_t                 ForwardPixelValue136                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW547;
        union
        {
            struct
            {
                /// uint32_t 548
                uint32_t                 InverseGChGammaCorrectedValue137                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW548;
        union
        {
            struct
            {
                /// uint32_t 549
                uint32_t                 InversePixelValue137                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW549;
        union
        {
            struct
            {
                /// uint32_t 550
                uint32_t                 ForwardGChGammaCorrectedValue137                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW550;
        union
        {
            struct
            {
                /// uint32_t 551
                uint32_t                 ForwardPixelValue137                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW551;
        union
        {
            struct
            {
                /// uint32_t 552
                uint32_t                 InverseGChGammaCorrectedValue138                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW552;
        union
        {
            struct
            {
                /// uint32_t 553
                uint32_t                 InversePixelValue138                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW553;
        union
        {
            struct
            {
                /// uint32_t 554
                uint32_t                 ForwardGChGammaCorrectedValue138                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW554;
        union
        {
            struct
            {
                /// uint32_t 555
                uint32_t                 ForwardPixelValue138                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW555;
        union
        {
            struct
            {
                /// uint32_t 556
                uint32_t                 InverseGChGammaCorrectedValue139                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW556;
        union
        {
            struct
            {
                /// uint32_t 557
                uint32_t                 InversePixelValue139                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW557;
        union
        {
            struct
            {
                /// uint32_t 558
                uint32_t                 ForwardGChGammaCorrectedValue139                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW558;
        union
        {
            struct
            {
                /// uint32_t 559
                uint32_t                 ForwardPixelValue139                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW559;
        union
        {
            struct
            {
                /// uint32_t 560
                uint32_t                 InverseGChGammaCorrectedValue140                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW560;
        union
        {
            struct
            {
                /// uint32_t 561
                uint32_t                 InversePixelValue140                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW561;
        union
        {
            struct
            {
                /// uint32_t 562
                uint32_t                 ForwardGChGammaCorrectedValue140                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW562;
        union
        {
            struct
            {
                /// uint32_t 563
                uint32_t                 ForwardPixelValue140                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW563;
        union
        {
            struct
            {
                /// uint32_t 564
                uint32_t                 InverseGChGammaCorrectedValue141                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW564;
        union
        {
            struct
            {
                /// uint32_t 565
                uint32_t                 InversePixelValue141                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW565;
        union
        {
            struct
            {
                /// uint32_t 566
                uint32_t                 ForwardGChGammaCorrectedValue141                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW566;
        union
        {
            struct
            {
                /// uint32_t 567
                uint32_t                 ForwardPixelValue141                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW567;
        union
        {
            struct
            {
                /// uint32_t 568
                uint32_t                 InverseGChGammaCorrectedValue142                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW568;
        union
        {
            struct
            {
                /// uint32_t 569
                uint32_t                 InversePixelValue142                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW569;
        union
        {
            struct
            {
                /// uint32_t 570
                uint32_t                 ForwardGChGammaCorrectedValue142                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW570;
        union
        {
            struct
            {
                /// uint32_t 571
                uint32_t                 ForwardPixelValue142                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW571;
        union
        {
            struct
            {
                /// uint32_t 572
                uint32_t                 InverseGChGammaCorrectedValue143                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW572;
        union
        {
            struct
            {
                /// uint32_t 573
                uint32_t                 InversePixelValue143                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW573;
        union
        {
            struct
            {
                /// uint32_t 574
                uint32_t                 ForwardGChGammaCorrectedValue143                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW574;
        union
        {
            struct
            {
                /// uint32_t 575
                uint32_t                 ForwardPixelValue143                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW575;
        union
        {
            struct
            {
                /// uint32_t 576
                uint32_t                 InverseGChGammaCorrectedValue144                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW576;
        union
        {
            struct
            {
                /// uint32_t 577
                uint32_t                 InversePixelValue144                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW577;
        union
        {
            struct
            {
                /// uint32_t 578
                uint32_t                 ForwardGChGammaCorrectedValue144                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW578;
        union
        {
            struct
            {
                /// uint32_t 579
                uint32_t                 ForwardPixelValue144                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW579;
        union
        {
            struct
            {
                /// uint32_t 580
                uint32_t                 InverseGChGammaCorrectedValue145                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW580;
        union
        {
            struct
            {
                /// uint32_t 581
                uint32_t                 InversePixelValue145                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW581;
        union
        {
            struct
            {
                /// uint32_t 582
                uint32_t                 ForwardGChGammaCorrectedValue145                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW582;
        union
        {
            struct
            {
                /// uint32_t 583
                uint32_t                 ForwardPixelValue145                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW583;
        union
        {
            struct
            {
                /// uint32_t 584
                uint32_t                 InverseGChGammaCorrectedValue146                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW584;
        union
        {
            struct
            {
                /// uint32_t 585
                uint32_t                 InversePixelValue146                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW585;
        union
        {
            struct
            {
                /// uint32_t 586
                uint32_t                 ForwardGChGammaCorrectedValue146                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW586;
        union
        {
            struct
            {
                /// uint32_t 587
                uint32_t                 ForwardPixelValue146                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW587;
        union
        {
            struct
            {
                /// uint32_t 588
                uint32_t                 InverseGChGammaCorrectedValue147                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW588;
        union
        {
            struct
            {
                /// uint32_t 589
                uint32_t                 InversePixelValue147                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW589;
        union
        {
            struct
            {
                /// uint32_t 590
                uint32_t                 ForwardGChGammaCorrectedValue147                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW590;
        union
        {
            struct
            {
                /// uint32_t 591
                uint32_t                 ForwardPixelValue147                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW591;
        union
        {
            struct
            {
                /// uint32_t 592
                uint32_t                 InverseGChGammaCorrectedValue148                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW592;
        union
        {
            struct
            {
                /// uint32_t 593
                uint32_t                 InversePixelValue148                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW593;
        union
        {
            struct
            {
                /// uint32_t 594
                uint32_t                 ForwardGChGammaCorrectedValue148                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW594;
        union
        {
            struct
            {
                /// uint32_t 595
                uint32_t                 ForwardPixelValue148                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW595;
        union
        {
            struct
            {
                /// uint32_t 596
                uint32_t                 InverseGChGammaCorrectedValue149                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW596;
        union
        {
            struct
            {
                /// uint32_t 597
                uint32_t                 InversePixelValue149                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW597;
        union
        {
            struct
            {
                /// uint32_t 598
                uint32_t                 ForwardGChGammaCorrectedValue149                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW598;
        union
        {
            struct
            {
                /// uint32_t 599
                uint32_t                 ForwardPixelValue149                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW599;
        union
        {
            struct
            {
                /// uint32_t 600
                uint32_t                 InverseGChGammaCorrectedValue150                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW600;
        union
        {
            struct
            {
                /// uint32_t 601
                uint32_t                 InversePixelValue150                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW601;
        union
        {
            struct
            {
                /// uint32_t 602
                uint32_t                 ForwardGChGammaCorrectedValue150                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW602;
        union
        {
            struct
            {
                /// uint32_t 603
                uint32_t                 ForwardPixelValue150                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW603;
        union
        {
            struct
            {
                /// uint32_t 604
                uint32_t                 InverseGChGammaCorrectedValue151                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW604;
        union
        {
            struct
            {
                /// uint32_t 605
                uint32_t                 InversePixelValue151                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW605;
        union
        {
            struct
            {
                /// uint32_t 606
                uint32_t                 ForwardGChGammaCorrectedValue151                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW606;
        union
        {
            struct
            {
                /// uint32_t 607
                uint32_t                 ForwardPixelValue151                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW607;
        union
        {
            struct
            {
                /// uint32_t 608
                uint32_t                 InverseGChGammaCorrectedValue152                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW608;
        union
        {
            struct
            {
                /// uint32_t 609
                uint32_t                 InversePixelValue152                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW609;
        union
        {
            struct
            {
                /// uint32_t 610
                uint32_t                 ForwardGChGammaCorrectedValue152                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW610;
        union
        {
            struct
            {
                /// uint32_t 611
                uint32_t                 ForwardPixelValue152                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW611;
        union
        {
            struct
            {
                /// uint32_t 612
                uint32_t                 InverseGChGammaCorrectedValue153                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW612;
        union
        {
            struct
            {
                /// uint32_t 613
                uint32_t                 InversePixelValue153                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW613;
        union
        {
            struct
            {
                /// uint32_t 614
                uint32_t                 ForwardGChGammaCorrectedValue153                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW614;
        union
        {
            struct
            {
                /// uint32_t 615
                uint32_t                 ForwardPixelValue153                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW615;
        union
        {
            struct
            {
                /// uint32_t 616
                uint32_t                 InverseGChGammaCorrectedValue154                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW616;
        union
        {
            struct
            {
                /// uint32_t 617
                uint32_t                 InversePixelValue154                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW617;
        union
        {
            struct
            {
                /// uint32_t 618
                uint32_t                 ForwardGChGammaCorrectedValue154                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW618;
        union
        {
            struct
            {
                /// uint32_t 619
                uint32_t                 ForwardPixelValue154                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW619;
        union
        {
            struct
            {
                /// uint32_t 620
                uint32_t                 InverseGChGammaCorrectedValue155                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW620;
        union
        {
            struct
            {
                /// uint32_t 621
                uint32_t                 InversePixelValue155                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW621;
        union
        {
            struct
            {
                /// uint32_t 622
                uint32_t                 ForwardGChGammaCorrectedValue155                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW622;
        union
        {
            struct
            {
                /// uint32_t 623
                uint32_t                 ForwardPixelValue155                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW623;
        union
        {
            struct
            {
                /// uint32_t 624
                uint32_t                 InverseGChGammaCorrectedValue156                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW624;
        union
        {
            struct
            {
                /// uint32_t 625
                uint32_t                 InversePixelValue156                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW625;
        union
        {
            struct
            {
                /// uint32_t 626
                uint32_t                 ForwardGChGammaCorrectedValue156                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW626;
        union
        {
            struct
            {
                /// uint32_t 627
                uint32_t                 ForwardPixelValue156                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW627;
        union
        {
            struct
            {
                /// uint32_t 628
                uint32_t                 InverseGChGammaCorrectedValue157                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW628;
        union
        {
            struct
            {
                /// uint32_t 629
                uint32_t                 InversePixelValue157                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW629;
        union
        {
            struct
            {
                /// uint32_t 630
                uint32_t                 ForwardGChGammaCorrectedValue157                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW630;
        union
        {
            struct
            {
                /// uint32_t 631
                uint32_t                 ForwardPixelValue157                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW631;
        union
        {
            struct
            {
                /// uint32_t 632
                uint32_t                 InverseGChGammaCorrectedValue158                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW632;
        union
        {
            struct
            {
                /// uint32_t 633
                uint32_t                 InversePixelValue158                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW633;
        union
        {
            struct
            {
                /// uint32_t 634
                uint32_t                 ForwardGChGammaCorrectedValue158                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW634;
        union
        {
            struct
            {
                /// uint32_t 635
                uint32_t                 ForwardPixelValue158                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW635;
        union
        {
            struct
            {
                /// uint32_t 636
                uint32_t                 InverseGChGammaCorrectedValue159                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW636;
        union
        {
            struct
            {
                /// uint32_t 637
                uint32_t                 InversePixelValue159                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW637;
        union
        {
            struct
            {
                /// uint32_t 638
                uint32_t                 ForwardGChGammaCorrectedValue159                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW638;
        union
        {
            struct
            {
                /// uint32_t 639
                uint32_t                 ForwardPixelValue159                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW639;
        union
        {
            struct
            {
                /// uint32_t 640
                uint32_t                 InverseGChGammaCorrectedValue160                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW640;
        union
        {
            struct
            {
                /// uint32_t 641
                uint32_t                 InversePixelValue160                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW641;
        union
        {
            struct
            {
                /// uint32_t 642
                uint32_t                 ForwardGChGammaCorrectedValue160                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW642;
        union
        {
            struct
            {
                /// uint32_t 643
                uint32_t                 ForwardPixelValue160                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW643;
        union
        {
            struct
            {
                /// uint32_t 644
                uint32_t                 InverseGChGammaCorrectedValue161                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW644;
        union
        {
            struct
            {
                /// uint32_t 645
                uint32_t                 InversePixelValue161                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW645;
        union
        {
            struct
            {
                /// uint32_t 646
                uint32_t                 ForwardGChGammaCorrectedValue161                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW646;
        union
        {
            struct
            {
                /// uint32_t 647
                uint32_t                 ForwardPixelValue161                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW647;
        union
        {
            struct
            {
                /// uint32_t 648
                uint32_t                 InverseGChGammaCorrectedValue162                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW648;
        union
        {
            struct
            {
                /// uint32_t 649
                uint32_t                 InversePixelValue162                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW649;
        union
        {
            struct
            {
                /// uint32_t 650
                uint32_t                 ForwardGChGammaCorrectedValue162                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW650;
        union
        {
            struct
            {
                /// uint32_t 651
                uint32_t                 ForwardPixelValue162                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW651;
        union
        {
            struct
            {
                /// uint32_t 652
                uint32_t                 InverseGChGammaCorrectedValue163                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW652;
        union
        {
            struct
            {
                /// uint32_t 653
                uint32_t                 InversePixelValue163                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW653;
        union
        {
            struct
            {
                /// uint32_t 654
                uint32_t                 ForwardGChGammaCorrectedValue163                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW654;
        union
        {
            struct
            {
                /// uint32_t 655
                uint32_t                 ForwardPixelValue163                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW655;
        union
        {
            struct
            {
                /// uint32_t 656
                uint32_t                 InverseGChGammaCorrectedValue164                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW656;
        union
        {
            struct
            {
                /// uint32_t 657
                uint32_t                 InversePixelValue164                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW657;
        union
        {
            struct
            {
                /// uint32_t 658
                uint32_t                 ForwardGChGammaCorrectedValue164                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW658;
        union
        {
            struct
            {
                /// uint32_t 659
                uint32_t                 ForwardPixelValue164                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW659;
        union
        {
            struct
            {
                /// uint32_t 660
                uint32_t                 InverseGChGammaCorrectedValue165                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW660;
        union
        {
            struct
            {
                /// uint32_t 661
                uint32_t                 InversePixelValue165                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW661;
        union
        {
            struct
            {
                /// uint32_t 662
                uint32_t                 ForwardGChGammaCorrectedValue165                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW662;
        union
        {
            struct
            {
                /// uint32_t 663
                uint32_t                 ForwardPixelValue165                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW663;
        union
        {
            struct
            {
                /// uint32_t 664
                uint32_t                 InverseGChGammaCorrectedValue166                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW664;
        union
        {
            struct
            {
                /// uint32_t 665
                uint32_t                 InversePixelValue166                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW665;
        union
        {
            struct
            {
                /// uint32_t 666
                uint32_t                 ForwardGChGammaCorrectedValue166                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW666;
        union
        {
            struct
            {
                /// uint32_t 667
                uint32_t                 ForwardPixelValue166                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW667;
        union
        {
            struct
            {
                /// uint32_t 668
                uint32_t                 InverseGChGammaCorrectedValue167                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW668;
        union
        {
            struct
            {
                /// uint32_t 669
                uint32_t                 InversePixelValue167                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW669;
        union
        {
            struct
            {
                /// uint32_t 670
                uint32_t                 ForwardGChGammaCorrectedValue167                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW670;
        union
        {
            struct
            {
                /// uint32_t 671
                uint32_t                 ForwardPixelValue167                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW671;
        union
        {
            struct
            {
                /// uint32_t 672
                uint32_t                 InverseGChGammaCorrectedValue168                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW672;
        union
        {
            struct
            {
                /// uint32_t 673
                uint32_t                 InversePixelValue168                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW673;
        union
        {
            struct
            {
                /// uint32_t 674
                uint32_t                 ForwardGChGammaCorrectedValue168                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW674;
        union
        {
            struct
            {
                /// uint32_t 675
                uint32_t                 ForwardPixelValue168                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW675;
        union
        {
            struct
            {
                /// uint32_t 676
                uint32_t                 InverseGChGammaCorrectedValue169                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW676;
        union
        {
            struct
            {
                /// uint32_t 677
                uint32_t                 InversePixelValue169                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW677;
        union
        {
            struct
            {
                /// uint32_t 678
                uint32_t                 ForwardGChGammaCorrectedValue169                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW678;
        union
        {
            struct
            {
                /// uint32_t 679
                uint32_t                 ForwardPixelValue169                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW679;
        union
        {
            struct
            {
                /// uint32_t 680
                uint32_t                 InverseGChGammaCorrectedValue170                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW680;
        union
        {
            struct
            {
                /// uint32_t 681
                uint32_t                 InversePixelValue170                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW681;
        union
        {
            struct
            {
                /// uint32_t 682
                uint32_t                 ForwardGChGammaCorrectedValue170                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW682;
        union
        {
            struct
            {
                /// uint32_t 683
                uint32_t                 ForwardPixelValue170                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW683;
        union
        {
            struct
            {
                /// uint32_t 684
                uint32_t                 InverseGChGammaCorrectedValue171                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW684;
        union
        {
            struct
            {
                /// uint32_t 685
                uint32_t                 InversePixelValue171                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW685;
        union
        {
            struct
            {
                /// uint32_t 686
                uint32_t                 ForwardGChGammaCorrectedValue171                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW686;
        union
        {
            struct
            {
                /// uint32_t 687
                uint32_t                 ForwardPixelValue171                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW687;
        union
        {
            struct
            {
                /// uint32_t 688
                uint32_t                 InverseGChGammaCorrectedValue172                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW688;
        union
        {
            struct
            {
                /// uint32_t 689
                uint32_t                 InversePixelValue172                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW689;
        union
        {
            struct
            {
                /// uint32_t 690
                uint32_t                 ForwardGChGammaCorrectedValue172                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW690;
        union
        {
            struct
            {
                /// uint32_t 691
                uint32_t                 ForwardPixelValue172                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW691;
        union
        {
            struct
            {
                /// uint32_t 692
                uint32_t                 InverseGChGammaCorrectedValue173                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW692;
        union
        {
            struct
            {
                /// uint32_t 693
                uint32_t                 InversePixelValue173                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW693;
        union
        {
            struct
            {
                /// uint32_t 694
                uint32_t                 ForwardGChGammaCorrectedValue173                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW694;
        union
        {
            struct
            {
                /// uint32_t 695
                uint32_t                 ForwardPixelValue173                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW695;
        union
        {
            struct
            {
                /// uint32_t 696
                uint32_t                 InverseGChGammaCorrectedValue174                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW696;
        union
        {
            struct
            {
                /// uint32_t 697
                uint32_t                 InversePixelValue174                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW697;
        union
        {
            struct
            {
                /// uint32_t 698
                uint32_t                 ForwardGChGammaCorrectedValue174                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW698;
        union
        {
            struct
            {
                /// uint32_t 699
                uint32_t                 ForwardPixelValue174                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW699;
        union
        {
            struct
            {
                /// uint32_t 700
                uint32_t                 InverseGChGammaCorrectedValue175                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW700;
        union
        {
            struct
            {
                /// uint32_t 701
                uint32_t                 InversePixelValue175                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW701;
        union
        {
            struct
            {
                /// uint32_t 702
                uint32_t                 ForwardGChGammaCorrectedValue175                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW702;
        union
        {
            struct
            {
                /// uint32_t 703
                uint32_t                 ForwardPixelValue175                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW703;
        union
        {
            struct
            {
                /// uint32_t 704
                uint32_t                 InverseGChGammaCorrectedValue176                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW704;
        union
        {
            struct
            {
                /// uint32_t 705
                uint32_t                 InversePixelValue176                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW705;
        union
        {
            struct
            {
                /// uint32_t 706
                uint32_t                 ForwardGChGammaCorrectedValue176                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW706;
        union
        {
            struct
            {
                /// uint32_t 707
                uint32_t                 ForwardPixelValue176                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW707;
        union
        {
            struct
            {
                /// uint32_t 708
                uint32_t                 InverseGChGammaCorrectedValue177                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW708;
        union
        {
            struct
            {
                /// uint32_t 709
                uint32_t                 InversePixelValue177                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW709;
        union
        {
            struct
            {
                /// uint32_t 710
                uint32_t                 ForwardGChGammaCorrectedValue177                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW710;
        union
        {
            struct
            {
                /// uint32_t 711
                uint32_t                 ForwardPixelValue177                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW711;
        union
        {
            struct
            {
                /// uint32_t 712
                uint32_t                 InverseGChGammaCorrectedValue178                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW712;
        union
        {
            struct
            {
                /// uint32_t 713
                uint32_t                 InversePixelValue178                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW713;
        union
        {
            struct
            {
                /// uint32_t 714
                uint32_t                 ForwardGChGammaCorrectedValue178                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW714;
        union
        {
            struct
            {
                /// uint32_t 715
                uint32_t                 ForwardPixelValue178                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW715;
        union
        {
            struct
            {
                /// uint32_t 716
                uint32_t                 InverseGChGammaCorrectedValue179                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW716;
        union
        {
            struct
            {
                /// uint32_t 717
                uint32_t                 InversePixelValue179                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW717;
        union
        {
            struct
            {
                /// uint32_t 718
                uint32_t                 ForwardGChGammaCorrectedValue179                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW718;
        union
        {
            struct
            {
                /// uint32_t 719
                uint32_t                 ForwardPixelValue179                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW719;
        union
        {
            struct
            {
                /// uint32_t 720
                uint32_t                 InverseGChGammaCorrectedValue180                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW720;
        union
        {
            struct
            {
                /// uint32_t 721
                uint32_t                 InversePixelValue180                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW721;
        union
        {
            struct
            {
                /// uint32_t 722
                uint32_t                 ForwardGChGammaCorrectedValue180                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW722;
        union
        {
            struct
            {
                /// uint32_t 723
                uint32_t                 ForwardPixelValue180                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW723;
        union
        {
            struct
            {
                /// uint32_t 724
                uint32_t                 InverseGChGammaCorrectedValue181                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW724;
        union
        {
            struct
            {
                /// uint32_t 725
                uint32_t                 InversePixelValue181                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW725;
        union
        {
            struct
            {
                /// uint32_t 726
                uint32_t                 ForwardGChGammaCorrectedValue181                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW726;
        union
        {
            struct
            {
                /// uint32_t 727
                uint32_t                 ForwardPixelValue181                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW727;
        union
        {
            struct
            {
                /// uint32_t 728
                uint32_t                 InverseGChGammaCorrectedValue182                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW728;
        union
        {
            struct
            {
                /// uint32_t 729
                uint32_t                 InversePixelValue182                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW729;
        union
        {
            struct
            {
                /// uint32_t 730
                uint32_t                 ForwardGChGammaCorrectedValue182                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW730;
        union
        {
            struct
            {
                /// uint32_t 731
                uint32_t                 ForwardPixelValue182                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW731;
        union
        {
            struct
            {
                /// uint32_t 732
                uint32_t                 InverseGChGammaCorrectedValue183                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW732;
        union
        {
            struct
            {
                /// uint32_t 733
                uint32_t                 InversePixelValue183                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW733;
        union
        {
            struct
            {
                /// uint32_t 734
                uint32_t                 ForwardGChGammaCorrectedValue183                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW734;
        union
        {
            struct
            {
                /// uint32_t 735
                uint32_t                 ForwardPixelValue183                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW735;
        union
        {
            struct
            {
                /// uint32_t 736
                uint32_t                 InverseGChGammaCorrectedValue184                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW736;
        union
        {
            struct
            {
                /// uint32_t 737
                uint32_t                 InversePixelValue184                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW737;
        union
        {
            struct
            {
                /// uint32_t 738
                uint32_t                 ForwardGChGammaCorrectedValue184                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW738;
        union
        {
            struct
            {
                /// uint32_t 739
                uint32_t                 ForwardPixelValue184                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW739;
        union
        {
            struct
            {
                /// uint32_t 740
                uint32_t                 InverseGChGammaCorrectedValue185                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW740;
        union
        {
            struct
            {
                /// uint32_t 741
                uint32_t                 InversePixelValue185                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW741;
        union
        {
            struct
            {
                /// uint32_t 742
                uint32_t                 ForwardGChGammaCorrectedValue185                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW742;
        union
        {
            struct
            {
                /// uint32_t 743
                uint32_t                 ForwardPixelValue185                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW743;
        union
        {
            struct
            {
                /// uint32_t 744
                uint32_t                 InverseGChGammaCorrectedValue186                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW744;
        union
        {
            struct
            {
                /// uint32_t 745
                uint32_t                 InversePixelValue186                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW745;
        union
        {
            struct
            {
                /// uint32_t 746
                uint32_t                 ForwardGChGammaCorrectedValue186                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW746;
        union
        {
            struct
            {
                /// uint32_t 747
                uint32_t                 ForwardPixelValue186                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW747;
        union
        {
            struct
            {
                /// uint32_t 748
                uint32_t                 InverseGChGammaCorrectedValue187                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW748;
        union
        {
            struct
            {
                /// uint32_t 749
                uint32_t                 InversePixelValue187                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW749;
        union
        {
            struct
            {
                /// uint32_t 750
                uint32_t                 ForwardGChGammaCorrectedValue187                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW750;
        union
        {
            struct
            {
                /// uint32_t 751
                uint32_t                 ForwardPixelValue187                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW751;
        union
        {
            struct
            {
                /// uint32_t 752
                uint32_t                 InverseGChGammaCorrectedValue188                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW752;
        union
        {
            struct
            {
                /// uint32_t 753
                uint32_t                 InversePixelValue188                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW753;
        union
        {
            struct
            {
                /// uint32_t 754
                uint32_t                 ForwardGChGammaCorrectedValue188                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW754;
        union
        {
            struct
            {
                /// uint32_t 755
                uint32_t                 ForwardPixelValue188                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW755;
        union
        {
            struct
            {
                /// uint32_t 756
                uint32_t                 InverseGChGammaCorrectedValue189                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW756;
        union
        {
            struct
            {
                /// uint32_t 757
                uint32_t                 InversePixelValue189                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW757;
        union
        {
            struct
            {
                /// uint32_t 758
                uint32_t                 ForwardGChGammaCorrectedValue189                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW758;
        union
        {
            struct
            {
                /// uint32_t 759
                uint32_t                 ForwardPixelValue189                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW759;
        union
        {
            struct
            {
                /// uint32_t 760
                uint32_t                 InverseGChGammaCorrectedValue190                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW760;
        union
        {
            struct
            {
                /// uint32_t 761
                uint32_t                 InversePixelValue190                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW761;
        union
        {
            struct
            {
                /// uint32_t 762
                uint32_t                 ForwardGChGammaCorrectedValue190                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW762;
        union
        {
            struct
            {
                /// uint32_t 763
                uint32_t                 ForwardPixelValue190                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW763;
        union
        {
            struct
            {
                /// uint32_t 764
                uint32_t                 InverseGChGammaCorrectedValue191                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW764;
        union
        {
            struct
            {
                /// uint32_t 765
                uint32_t                 InversePixelValue191                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW765;
        union
        {
            struct
            {
                /// uint32_t 766
                uint32_t                 ForwardGChGammaCorrectedValue191                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW766;
        union
        {
            struct
            {
                /// uint32_t 767
                uint32_t                 ForwardPixelValue191                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW767;
        union
        {
            struct
            {
                /// uint32_t 768
                uint32_t                 InverseGChGammaCorrectedValue192                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW768;
        union
        {
            struct
            {
                /// uint32_t 769
                uint32_t                 InversePixelValue192                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW769;
        union
        {
            struct
            {
                /// uint32_t 770
                uint32_t                 ForwardGChGammaCorrectedValue192                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW770;
        union
        {
            struct
            {
                /// uint32_t 771
                uint32_t                 ForwardPixelValue192                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW771;
        union
        {
            struct
            {
                /// uint32_t 772
                uint32_t                 InverseGChGammaCorrectedValue193                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW772;
        union
        {
            struct
            {
                /// uint32_t 773
                uint32_t                 InversePixelValue193                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW773;
        union
        {
            struct
            {
                /// uint32_t 774
                uint32_t                 ForwardGChGammaCorrectedValue193                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW774;
        union
        {
            struct
            {
                /// uint32_t 775
                uint32_t                 ForwardPixelValue193                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW775;
        union
        {
            struct
            {
                /// uint32_t 776
                uint32_t                 InverseGChGammaCorrectedValue194                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW776;
        union
        {
            struct
            {
                /// uint32_t 777
                uint32_t                 InversePixelValue194                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW777;
        union
        {
            struct
            {
                /// uint32_t 778
                uint32_t                 ForwardGChGammaCorrectedValue194                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW778;
        union
        {
            struct
            {
                /// uint32_t 779
                uint32_t                 ForwardPixelValue194                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW779;
        union
        {
            struct
            {
                /// uint32_t 780
                uint32_t                 InverseGChGammaCorrectedValue195                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW780;
        union
        {
            struct
            {
                /// uint32_t 781
                uint32_t                 InversePixelValue195                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW781;
        union
        {
            struct
            {
                /// uint32_t 782
                uint32_t                 ForwardGChGammaCorrectedValue195                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW782;
        union
        {
            struct
            {
                /// uint32_t 783
                uint32_t                 ForwardPixelValue195                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW783;
        union
        {
            struct
            {
                /// uint32_t 784
                uint32_t                 InverseGChGammaCorrectedValue196                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW784;
        union
        {
            struct
            {
                /// uint32_t 785
                uint32_t                 InversePixelValue196                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW785;
        union
        {
            struct
            {
                /// uint32_t 786
                uint32_t                 ForwardGChGammaCorrectedValue196                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW786;
        union
        {
            struct
            {
                /// uint32_t 787
                uint32_t                 ForwardPixelValue196                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW787;
        union
        {
            struct
            {
                /// uint32_t 788
                uint32_t                 InverseGChGammaCorrectedValue197                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW788;
        union
        {
            struct
            {
                /// uint32_t 789
                uint32_t                 InversePixelValue197                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW789;
        union
        {
            struct
            {
                /// uint32_t 790
                uint32_t                 ForwardGChGammaCorrectedValue197                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW790;
        union
        {
            struct
            {
                /// uint32_t 791
                uint32_t                 ForwardPixelValue197                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW791;
        union
        {
            struct
            {
                /// uint32_t 792
                uint32_t                 InverseGChGammaCorrectedValue198                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW792;
        union
        {
            struct
            {
                /// uint32_t 793
                uint32_t                 InversePixelValue198                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW793;
        union
        {
            struct
            {
                /// uint32_t 794
                uint32_t                 ForwardGChGammaCorrectedValue198                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW794;
        union
        {
            struct
            {
                /// uint32_t 795
                uint32_t                 ForwardPixelValue198                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW795;
        union
        {
            struct
            {
                /// uint32_t 796
                uint32_t                 InverseGChGammaCorrectedValue199                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW796;
        union
        {
            struct
            {
                /// uint32_t 797
                uint32_t                 InversePixelValue199                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW797;
        union
        {
            struct
            {
                /// uint32_t 798
                uint32_t                 ForwardGChGammaCorrectedValue199                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW798;
        union
        {
            struct
            {
                /// uint32_t 799
                uint32_t                 ForwardPixelValue199                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW799;
        union
        {
            struct
            {
                /// uint32_t 800
                uint32_t                 InverseGChGammaCorrectedValue200                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW800;
        union
        {
            struct
            {
                /// uint32_t 801
                uint32_t                 InversePixelValue200                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW801;
        union
        {
            struct
            {
                /// uint32_t 802
                uint32_t                 ForwardGChGammaCorrectedValue200                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW802;
        union
        {
            struct
            {
                /// uint32_t 803
                uint32_t                 ForwardPixelValue200                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW803;
        union
        {
            struct
            {
                /// uint32_t 804
                uint32_t                 InverseGChGammaCorrectedValue201                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW804;
        union
        {
            struct
            {
                /// uint32_t 805
                uint32_t                 InversePixelValue201                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW805;
        union
        {
            struct
            {
                /// uint32_t 806
                uint32_t                 ForwardGChGammaCorrectedValue201                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW806;
        union
        {
            struct
            {
                /// uint32_t 807
                uint32_t                 ForwardPixelValue201                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW807;
        union
        {
            struct
            {
                /// uint32_t 808
                uint32_t                 InverseGChGammaCorrectedValue202                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW808;
        union
        {
            struct
            {
                /// uint32_t 809
                uint32_t                 InversePixelValue202                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW809;
        union
        {
            struct
            {
                /// uint32_t 810
                uint32_t                 ForwardGChGammaCorrectedValue202                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW810;
        union
        {
            struct
            {
                /// uint32_t 811
                uint32_t                 ForwardPixelValue202                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW811;
        union
        {
            struct
            {
                /// uint32_t 812
                uint32_t                 InverseGChGammaCorrectedValue203                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW812;
        union
        {
            struct
            {
                /// uint32_t 813
                uint32_t                 InversePixelValue203                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW813;
        union
        {
            struct
            {
                /// uint32_t 814
                uint32_t                 ForwardGChGammaCorrectedValue203                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW814;
        union
        {
            struct
            {
                /// uint32_t 815
                uint32_t                 ForwardPixelValue203                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW815;
        union
        {
            struct
            {
                /// uint32_t 816
                uint32_t                 InverseGChGammaCorrectedValue204                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW816;
        union
        {
            struct
            {
                /// uint32_t 817
                uint32_t                 InversePixelValue204                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW817;
        union
        {
            struct
            {
                /// uint32_t 818
                uint32_t                 ForwardGChGammaCorrectedValue204                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW818;
        union
        {
            struct
            {
                /// uint32_t 819
                uint32_t                 ForwardPixelValue204                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW819;
        union
        {
            struct
            {
                /// uint32_t 820
                uint32_t                 InverseGChGammaCorrectedValue205                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW820;
        union
        {
            struct
            {
                /// uint32_t 821
                uint32_t                 InversePixelValue205                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW821;
        union
        {
            struct
            {
                /// uint32_t 822
                uint32_t                 ForwardGChGammaCorrectedValue205                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW822;
        union
        {
            struct
            {
                /// uint32_t 823
                uint32_t                 ForwardPixelValue205                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW823;
        union
        {
            struct
            {
                /// uint32_t 824
                uint32_t                 InverseGChGammaCorrectedValue206                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW824;
        union
        {
            struct
            {
                /// uint32_t 825
                uint32_t                 InversePixelValue206                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW825;
        union
        {
            struct
            {
                /// uint32_t 826
                uint32_t                 ForwardGChGammaCorrectedValue206                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW826;
        union
        {
            struct
            {
                /// uint32_t 827
                uint32_t                 ForwardPixelValue206                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW827;
        union
        {
            struct
            {
                /// uint32_t 828
                uint32_t                 InverseGChGammaCorrectedValue207                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW828;
        union
        {
            struct
            {
                /// uint32_t 829
                uint32_t                 InversePixelValue207                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW829;
        union
        {
            struct
            {
                /// uint32_t 830
                uint32_t                 ForwardGChGammaCorrectedValue207                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW830;
        union
        {
            struct
            {
                /// uint32_t 831
                uint32_t                 ForwardPixelValue207                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW831;
        union
        {
            struct
            {
                /// uint32_t 832
                uint32_t                 InverseGChGammaCorrectedValue208                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW832;
        union
        {
            struct
            {
                /// uint32_t 833
                uint32_t                 InversePixelValue208                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW833;
        union
        {
            struct
            {
                /// uint32_t 834
                uint32_t                 ForwardGChGammaCorrectedValue208                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW834;
        union
        {
            struct
            {
                /// uint32_t 835
                uint32_t                 ForwardPixelValue208                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW835;
        union
        {
            struct
            {
                /// uint32_t 836
                uint32_t                 InverseGChGammaCorrectedValue209                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW836;
        union
        {
            struct
            {
                /// uint32_t 837
                uint32_t                 InversePixelValue209                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW837;
        union
        {
            struct
            {
                /// uint32_t 838
                uint32_t                 ForwardGChGammaCorrectedValue209                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW838;
        union
        {
            struct
            {
                /// uint32_t 839
                uint32_t                 ForwardPixelValue209                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW839;
        union
        {
            struct
            {
                /// uint32_t 840
                uint32_t                 InverseGChGammaCorrectedValue210                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW840;
        union
        {
            struct
            {
                /// uint32_t 841
                uint32_t                 InversePixelValue210                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW841;
        union
        {
            struct
            {
                /// uint32_t 842
                uint32_t                 ForwardGChGammaCorrectedValue210                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW842;
        union
        {
            struct
            {
                /// uint32_t 843
                uint32_t                 ForwardPixelValue210                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW843;
        union
        {
            struct
            {
                /// uint32_t 844
                uint32_t                 InverseGChGammaCorrectedValue211                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW844;
        union
        {
            struct
            {
                /// uint32_t 845
                uint32_t                 InversePixelValue211                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW845;
        union
        {
            struct
            {
                /// uint32_t 846
                uint32_t                 ForwardGChGammaCorrectedValue211                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW846;
        union
        {
            struct
            {
                /// uint32_t 847
                uint32_t                 ForwardPixelValue211                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW847;
        union
        {
            struct
            {
                /// uint32_t 848
                uint32_t                 InverseGChGammaCorrectedValue212                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW848;
        union
        {
            struct
            {
                /// uint32_t 849
                uint32_t                 InversePixelValue212                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW849;
        union
        {
            struct
            {
                /// uint32_t 850
                uint32_t                 ForwardGChGammaCorrectedValue212                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW850;
        union
        {
            struct
            {
                /// uint32_t 851
                uint32_t                 ForwardPixelValue212                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW851;
        union
        {
            struct
            {
                /// uint32_t 852
                uint32_t                 InverseGChGammaCorrectedValue213                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW852;
        union
        {
            struct
            {
                /// uint32_t 853
                uint32_t                 InversePixelValue213                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW853;
        union
        {
            struct
            {
                /// uint32_t 854
                uint32_t                 ForwardGChGammaCorrectedValue213                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW854;
        union
        {
            struct
            {
                /// uint32_t 855
                uint32_t                 ForwardPixelValue213                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW855;
        union
        {
            struct
            {
                /// uint32_t 856
                uint32_t                 InverseGChGammaCorrectedValue214                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW856;
        union
        {
            struct
            {
                /// uint32_t 857
                uint32_t                 InversePixelValue214                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW857;
        union
        {
            struct
            {
                /// uint32_t 858
                uint32_t                 ForwardGChGammaCorrectedValue214                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW858;
        union
        {
            struct
            {
                /// uint32_t 859
                uint32_t                 ForwardPixelValue214                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW859;
        union
        {
            struct
            {
                /// uint32_t 860
                uint32_t                 InverseGChGammaCorrectedValue215                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW860;
        union
        {
            struct
            {
                /// uint32_t 861
                uint32_t                 InversePixelValue215                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW861;
        union
        {
            struct
            {
                /// uint32_t 862
                uint32_t                 ForwardGChGammaCorrectedValue215                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW862;
        union
        {
            struct
            {
                /// uint32_t 863
                uint32_t                 ForwardPixelValue215                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW863;
        union
        {
            struct
            {
                /// uint32_t 864
                uint32_t                 InverseGChGammaCorrectedValue216                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW864;
        union
        {
            struct
            {
                /// uint32_t 865
                uint32_t                 InversePixelValue216                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW865;
        union
        {
            struct
            {
                /// uint32_t 866
                uint32_t                 ForwardGChGammaCorrectedValue216                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW866;
        union
        {
            struct
            {
                /// uint32_t 867
                uint32_t                 ForwardPixelValue216                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW867;
        union
        {
            struct
            {
                /// uint32_t 868
                uint32_t                 InverseGChGammaCorrectedValue217                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW868;
        union
        {
            struct
            {
                /// uint32_t 869
                uint32_t                 InversePixelValue217                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW869;
        union
        {
            struct
            {
                /// uint32_t 870
                uint32_t                 ForwardGChGammaCorrectedValue217                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW870;
        union
        {
            struct
            {
                /// uint32_t 871
                uint32_t                 ForwardPixelValue217                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW871;
        union
        {
            struct
            {
                /// uint32_t 872
                uint32_t                 InverseGChGammaCorrectedValue218                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW872;
        union
        {
            struct
            {
                /// uint32_t 873
                uint32_t                 InversePixelValue218                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW873;
        union
        {
            struct
            {
                /// uint32_t 874
                uint32_t                 ForwardGChGammaCorrectedValue218                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW874;
        union
        {
            struct
            {
                /// uint32_t 875
                uint32_t                 ForwardPixelValue218                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW875;
        union
        {
            struct
            {
                /// uint32_t 876
                uint32_t                 InverseGChGammaCorrectedValue219                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW876;
        union
        {
            struct
            {
                /// uint32_t 877
                uint32_t                 InversePixelValue219                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW877;
        union
        {
            struct
            {
                /// uint32_t 878
                uint32_t                 ForwardGChGammaCorrectedValue219                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW878;
        union
        {
            struct
            {
                /// uint32_t 879
                uint32_t                 ForwardPixelValue219                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW879;
        union
        {
            struct
            {
                /// uint32_t 880
                uint32_t                 InverseGChGammaCorrectedValue220                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW880;
        union
        {
            struct
            {
                /// uint32_t 881
                uint32_t                 InversePixelValue220                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW881;
        union
        {
            struct
            {
                /// uint32_t 882
                uint32_t                 ForwardGChGammaCorrectedValue220                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW882;
        union
        {
            struct
            {
                /// uint32_t 883
                uint32_t                 ForwardPixelValue220                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW883;
        union
        {
            struct
            {
                /// uint32_t 884
                uint32_t                 InverseGChGammaCorrectedValue221                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW884;
        union
        {
            struct
            {
                /// uint32_t 885
                uint32_t                 InversePixelValue221                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW885;
        union
        {
            struct
            {
                /// uint32_t 886
                uint32_t                 ForwardGChGammaCorrectedValue221                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW886;
        union
        {
            struct
            {
                /// uint32_t 887
                uint32_t                 ForwardPixelValue221                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW887;
        union
        {
            struct
            {
                /// uint32_t 888
                uint32_t                 InverseGChGammaCorrectedValue222                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW888;
        union
        {
            struct
            {
                /// uint32_t 889
                uint32_t                 InversePixelValue222                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW889;
        union
        {
            struct
            {
                /// uint32_t 890
                uint32_t                 ForwardGChGammaCorrectedValue222                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW890;
        union
        {
            struct
            {
                /// uint32_t 891
                uint32_t                 ForwardPixelValue222                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW891;
        union
        {
            struct
            {
                /// uint32_t 892
                uint32_t                 InverseGChGammaCorrectedValue223                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW892;
        union
        {
            struct
            {
                /// uint32_t 893
                uint32_t                 InversePixelValue223                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW893;
        union
        {
            struct
            {
                /// uint32_t 894
                uint32_t                 ForwardGChGammaCorrectedValue223                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW894;
        union
        {
            struct
            {
                /// uint32_t 895
                uint32_t                 ForwardPixelValue223                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW895;
        union
        {
            struct
            {
                /// uint32_t 896
                uint32_t                 InverseGChGammaCorrectedValue224                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW896;
        union
        {
            struct
            {
                /// uint32_t 897
                uint32_t                 InversePixelValue224                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW897;
        union
        {
            struct
            {
                /// uint32_t 898
                uint32_t                 ForwardGChGammaCorrectedValue224                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW898;
        union
        {
            struct
            {
                /// uint32_t 899
                uint32_t                 ForwardPixelValue224                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW899;
        union
        {
            struct
            {
                /// uint32_t 900
                uint32_t                 InverseGChGammaCorrectedValue225                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW900;
        union
        {
            struct
            {
                /// uint32_t 901
                uint32_t                 InversePixelValue225                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW901;
        union
        {
            struct
            {
                /// uint32_t 902
                uint32_t                 ForwardGChGammaCorrectedValue225                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW902;
        union
        {
            struct
            {
                /// uint32_t 903
                uint32_t                 ForwardPixelValue225                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW903;
        union
        {
            struct
            {
                /// uint32_t 904
                uint32_t                 InverseGChGammaCorrectedValue226                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW904;
        union
        {
            struct
            {
                /// uint32_t 905
                uint32_t                 InversePixelValue226                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW905;
        union
        {
            struct
            {
                /// uint32_t 906
                uint32_t                 ForwardGChGammaCorrectedValue226                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW906;
        union
        {
            struct
            {
                /// uint32_t 907
                uint32_t                 ForwardPixelValue226                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW907;
        union
        {
            struct
            {
                /// uint32_t 908
                uint32_t                 InverseGChGammaCorrectedValue227                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW908;
        union
        {
            struct
            {
                /// uint32_t 909
                uint32_t                 InversePixelValue227                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW909;
        union
        {
            struct
            {
                /// uint32_t 910
                uint32_t                 ForwardGChGammaCorrectedValue227                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW910;
        union
        {
            struct
            {
                /// uint32_t 911
                uint32_t                 ForwardPixelValue227                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW911;
        union
        {
            struct
            {
                /// uint32_t 912
                uint32_t                 InverseGChGammaCorrectedValue228                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW912;
        union
        {
            struct
            {
                /// uint32_t 913
                uint32_t                 InversePixelValue228                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW913;
        union
        {
            struct
            {
                /// uint32_t 914
                uint32_t                 ForwardGChGammaCorrectedValue228                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW914;
        union
        {
            struct
            {
                /// uint32_t 915
                uint32_t                 ForwardPixelValue228                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW915;
        union
        {
            struct
            {
                /// uint32_t 916
                uint32_t                 InverseGChGammaCorrectedValue229                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW916;
        union
        {
            struct
            {
                /// uint32_t 917
                uint32_t                 InversePixelValue229                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW917;
        union
        {
            struct
            {
                /// uint32_t 918
                uint32_t                 ForwardGChGammaCorrectedValue229                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW918;
        union
        {
            struct
            {
                /// uint32_t 919
                uint32_t                 ForwardPixelValue229                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW919;
        union
        {
            struct
            {
                /// uint32_t 920
                uint32_t                 InverseGChGammaCorrectedValue230                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW920;
        union
        {
            struct
            {
                /// uint32_t 921
                uint32_t                 InversePixelValue230                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW921;
        union
        {
            struct
            {
                /// uint32_t 922
                uint32_t                 ForwardGChGammaCorrectedValue230                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW922;
        union
        {
            struct
            {
                /// uint32_t 923
                uint32_t                 ForwardPixelValue230                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW923;
        union
        {
            struct
            {
                /// uint32_t 924
                uint32_t                 InverseGChGammaCorrectedValue231                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW924;
        union
        {
            struct
            {
                /// uint32_t 925
                uint32_t                 InversePixelValue231                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW925;
        union
        {
            struct
            {
                /// uint32_t 926
                uint32_t                 ForwardGChGammaCorrectedValue231                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW926;
        union
        {
            struct
            {
                /// uint32_t 927
                uint32_t                 ForwardPixelValue231                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW927;
        union
        {
            struct
            {
                /// uint32_t 928
                uint32_t                 InverseGChGammaCorrectedValue232                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW928;
        union
        {
            struct
            {
                /// uint32_t 929
                uint32_t                 InversePixelValue232                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW929;
        union
        {
            struct
            {
                /// uint32_t 930
                uint32_t                 ForwardGChGammaCorrectedValue232                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW930;
        union
        {
            struct
            {
                /// uint32_t 931
                uint32_t                 ForwardPixelValue232                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW931;
        union
        {
            struct
            {
                /// uint32_t 932
                uint32_t                 InverseGChGammaCorrectedValue233                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW932;
        union
        {
            struct
            {
                /// uint32_t 933
                uint32_t                 InversePixelValue233                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW933;
        union
        {
            struct
            {
                /// uint32_t 934
                uint32_t                 ForwardGChGammaCorrectedValue233                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW934;
        union
        {
            struct
            {
                /// uint32_t 935
                uint32_t                 ForwardPixelValue233                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW935;
        union
        {
            struct
            {
                /// uint32_t 936
                uint32_t                 InverseGChGammaCorrectedValue234                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW936;
        union
        {
            struct
            {
                /// uint32_t 937
                uint32_t                 InversePixelValue234                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW937;
        union
        {
            struct
            {
                /// uint32_t 938
                uint32_t                 ForwardGChGammaCorrectedValue234                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW938;
        union
        {
            struct
            {
                /// uint32_t 939
                uint32_t                 ForwardPixelValue234                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW939;
        union
        {
            struct
            {
                /// uint32_t 940
                uint32_t                 InverseGChGammaCorrectedValue235                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW940;
        union
        {
            struct
            {
                /// uint32_t 941
                uint32_t                 InversePixelValue235                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW941;
        union
        {
            struct
            {
                /// uint32_t 942
                uint32_t                 ForwardGChGammaCorrectedValue235                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW942;
        union
        {
            struct
            {
                /// uint32_t 943
                uint32_t                 ForwardPixelValue235                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW943;
        union
        {
            struct
            {
                /// uint32_t 944
                uint32_t                 InverseGChGammaCorrectedValue236                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW944;
        union
        {
            struct
            {
                /// uint32_t 945
                uint32_t                 InversePixelValue236                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW945;
        union
        {
            struct
            {
                /// uint32_t 946
                uint32_t                 ForwardGChGammaCorrectedValue236                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW946;
        union
        {
            struct
            {
                /// uint32_t 947
                uint32_t                 ForwardPixelValue236                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW947;
        union
        {
            struct
            {
                /// uint32_t 948
                uint32_t                 InverseGChGammaCorrectedValue237                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW948;
        union
        {
            struct
            {
                /// uint32_t 949
                uint32_t                 InversePixelValue237                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW949;
        union
        {
            struct
            {
                /// uint32_t 950
                uint32_t                 ForwardGChGammaCorrectedValue237                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW950;
        union
        {
            struct
            {
                /// uint32_t 951
                uint32_t                 ForwardPixelValue237                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW951;
        union
        {
            struct
            {
                /// uint32_t 952
                uint32_t                 InverseGChGammaCorrectedValue238                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW952;
        union
        {
            struct
            {
                /// uint32_t 953
                uint32_t                 InversePixelValue238                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW953;
        union
        {
            struct
            {
                /// uint32_t 954
                uint32_t                 ForwardGChGammaCorrectedValue238                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW954;
        union
        {
            struct
            {
                /// uint32_t 955
                uint32_t                 ForwardPixelValue238                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW955;
        union
        {
            struct
            {
                /// uint32_t 956
                uint32_t                 InverseGChGammaCorrectedValue239                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW956;
        union
        {
            struct
            {
                /// uint32_t 957
                uint32_t                 InversePixelValue239                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW957;
        union
        {
            struct
            {
                /// uint32_t 958
                uint32_t                 ForwardGChGammaCorrectedValue239                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW958;
        union
        {
            struct
            {
                /// uint32_t 959
                uint32_t                 ForwardPixelValue239                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW959;
        union
        {
            struct
            {
                /// uint32_t 960
                uint32_t                 InverseGChGammaCorrectedValue240                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW960;
        union
        {
            struct
            {
                /// uint32_t 961
                uint32_t                 InversePixelValue240                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW961;
        union
        {
            struct
            {
                /// uint32_t 962
                uint32_t                 ForwardGChGammaCorrectedValue240                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW962;
        union
        {
            struct
            {
                /// uint32_t 963
                uint32_t                 ForwardPixelValue240                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW963;
        union
        {
            struct
            {
                /// uint32_t 964
                uint32_t                 InverseGChGammaCorrectedValue241                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW964;
        union
        {
            struct
            {
                /// uint32_t 965
                uint32_t                 InversePixelValue241                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW965;
        union
        {
            struct
            {
                /// uint32_t 966
                uint32_t                 ForwardGChGammaCorrectedValue241                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW966;
        union
        {
            struct
            {
                /// uint32_t 967
                uint32_t                 ForwardPixelValue241                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW967;
        union
        {
            struct
            {
                /// uint32_t 968
                uint32_t                 InverseGChGammaCorrectedValue242                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW968;
        union
        {
            struct
            {
                /// uint32_t 969
                uint32_t                 InversePixelValue242                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW969;
        union
        {
            struct
            {
                /// uint32_t 970
                uint32_t                 ForwardGChGammaCorrectedValue242                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW970;
        union
        {
            struct
            {
                /// uint32_t 971
                uint32_t                 ForwardPixelValue242                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW971;
        union
        {
            struct
            {
                /// uint32_t 972
                uint32_t                 InverseGChGammaCorrectedValue243                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW972;
        union
        {
            struct
            {
                /// uint32_t 973
                uint32_t                 InversePixelValue243                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW973;
        union
        {
            struct
            {
                /// uint32_t 974
                uint32_t                 ForwardGChGammaCorrectedValue243                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW974;
        union
        {
            struct
            {
                /// uint32_t 975
                uint32_t                 ForwardPixelValue243                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW975;
        union
        {
            struct
            {
                /// uint32_t 976
                uint32_t                 InverseGChGammaCorrectedValue244                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW976;
        union
        {
            struct
            {
                /// uint32_t 977
                uint32_t                 InversePixelValue244                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW977;
        union
        {
            struct
            {
                /// uint32_t 978
                uint32_t                 ForwardGChGammaCorrectedValue244                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW978;
        union
        {
            struct
            {
                /// uint32_t 979
                uint32_t                 ForwardPixelValue244                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW979;
        union
        {
            struct
            {
                /// uint32_t 980
                uint32_t                 InverseGChGammaCorrectedValue245                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW980;
        union
        {
            struct
            {
                /// uint32_t 981
                uint32_t                 InversePixelValue245                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW981;
        union
        {
            struct
            {
                /// uint32_t 982
                uint32_t                 ForwardGChGammaCorrectedValue245                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW982;
        union
        {
            struct
            {
                /// uint32_t 983
                uint32_t                 ForwardPixelValue245                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW983;
        union
        {
            struct
            {
                /// uint32_t 984
                uint32_t                 InverseGChGammaCorrectedValue246                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW984;
        union
        {
            struct
            {
                /// uint32_t 985
                uint32_t                 InversePixelValue246                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW985;
        union
        {
            struct
            {
                /// uint32_t 986
                uint32_t                 ForwardGChGammaCorrectedValue246                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW986;
        union
        {
            struct
            {
                /// uint32_t 987
                uint32_t                 ForwardPixelValue246                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW987;
        union
        {
            struct
            {
                /// uint32_t 988
                uint32_t                 InverseGChGammaCorrectedValue247                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW988;
        union
        {
            struct
            {
                /// uint32_t 989
                uint32_t                 InversePixelValue247                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW989;
        union
        {
            struct
            {
                /// uint32_t 990
                uint32_t                 ForwardGChGammaCorrectedValue247                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW990;
        union
        {
            struct
            {
                /// uint32_t 991
                uint32_t                 ForwardPixelValue247                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW991;
        union
        {
            struct
            {
                /// uint32_t 992
                uint32_t                 InverseGChGammaCorrectedValue248                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW992;
        union
        {
            struct
            {
                /// uint32_t 993
                uint32_t                 InversePixelValue248                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW993;
        union
        {
            struct
            {
                /// uint32_t 994
                uint32_t                 ForwardGChGammaCorrectedValue248                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW994;
        union
        {
            struct
            {
                /// uint32_t 995
                uint32_t                 ForwardPixelValue248                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW995;
        union
        {
            struct
            {
                /// uint32_t 996
                uint32_t                 InverseGChGammaCorrectedValue249                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW996;
        union
        {
            struct
            {
                /// uint32_t 997
                uint32_t                 InversePixelValue249                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW997;
        union
        {
            struct
            {
                /// uint32_t 998
                uint32_t                 ForwardGChGammaCorrectedValue249                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW998;
        union
        {
            struct
            {
                /// uint32_t 999
                uint32_t                 ForwardPixelValue249                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW999;
        union
        {
            struct
            {
                /// uint32_t 1000
                uint32_t                 InverseGChGammaCorrectedValue250                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1000;
        union
        {
            struct
            {
                /// uint32_t 1001
                uint32_t                 InversePixelValue250                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1001;
        union
        {
            struct
            {
                /// uint32_t 1002
                uint32_t                 ForwardGChGammaCorrectedValue250                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1002;
        union
        {
            struct
            {
                /// uint32_t 1003
                uint32_t                 ForwardPixelValue250                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1003;
        union
        {
            struct
            {
                /// uint32_t 1004
                uint32_t                 InverseGChGammaCorrectedValue251                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1004;
        union
        {
            struct
            {
                /// uint32_t 1005
                uint32_t                 InversePixelValue251                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1005;
        union
        {
            struct
            {
                /// uint32_t 1006
                uint32_t                 ForwardGChGammaCorrectedValue251                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1006;
        union
        {
            struct
            {
                /// uint32_t 1007
                uint32_t                 ForwardPixelValue251                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1007;
        union
        {
            struct
            {
                /// uint32_t 1008
                uint32_t                 InverseGChGammaCorrectedValue252                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1008;
        union
        {
            struct
            {
                /// uint32_t 1009
                uint32_t                 InversePixelValue252                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1009;
        union
        {
            struct
            {
                /// uint32_t 1010
                uint32_t                 ForwardGChGammaCorrectedValue252                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1010;
        union
        {
            struct
            {
                /// uint32_t 1011
                uint32_t                 ForwardPixelValue252                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1011;
        union
        {
            struct
            {
                /// uint32_t 1012
                uint32_t                 InverseGChGammaCorrectedValue253                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1012;
        union
        {
            struct
            {
                /// uint32_t 1013
                uint32_t                 InversePixelValue253                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1013;
        union
        {
            struct
            {
                /// uint32_t 1014
                uint32_t                 ForwardGChGammaCorrectedValue253                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1014;
        union
        {
            struct
            {
                /// uint32_t 1015
                uint32_t                 ForwardPixelValue253                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1015;
        union
        {
            struct
            {
                /// uint32_t 1016
                uint32_t                 InverseGChGammaCorrectedValue254                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1016;
        union
        {
            struct
            {
                /// uint32_t 1017
                uint32_t                 InversePixelValue254                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1017;
        union
        {
            struct
            {
                /// uint32_t 1018
                uint32_t                 ForwardGChGammaCorrectedValue254                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1018;
        union
        {
            struct
            {
                /// uint32_t 1019
                uint32_t                 ForwardPixelValue254                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1019;
        union
        {
            struct
            {
                /// uint32_t 1020
                uint32_t                 InverseGChGammaCorrectedValue255                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseBChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1020;
        union
        {
            struct
            {
                /// uint32_t 1021
                uint32_t                 InversePixelValue255                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 InverseRChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1021;
        union
        {
            struct
            {
                /// uint32_t 1022
                uint32_t                 ForwardGChGammaCorrectedValue255                 : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardBChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1022;
        union
        {
            struct
            {
                /// uint32_t 1023
                uint32_t                 ForwardPixelValue255                             : __CODEGEN_BITFIELD( 0, 15)    ; ///< U16
                uint32_t                 ForwardRChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; ///< U16
            };
            uint32_t                     Value;
        } DW1023;

        //! \name Local enumerations

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_0
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_0
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, ///<
        };
        enum INVERSE_PIXEL_VALUE_0
        {
            INVERSE_PIXEL_VALUE_0_UNNAMED0                                   = 0, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_0
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_0
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_0
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, ///<
        };
        enum FORWARD_PIXEL_VALUE_0
        {
            FORWARD_PIXEL_VALUE_0_UNNAMED0                                   = 0, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_0
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_1
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_1
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, ///<
        };
        enum INVERSE_PIXEL_VALUE_1
        {
            INVERSE_PIXEL_VALUE_1_UNNAMED256                                 = 256, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_1
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_1
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_1
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, ///<
        };
        enum FORWARD_PIXEL_VALUE_1
        {
            FORWARD_PIXEL_VALUE_1_UNNAMED256                                 = 256, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_1
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_2
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_2
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, ///<
        };
        enum INVERSE_PIXEL_VALUE_2
        {
            INVERSE_PIXEL_VALUE_2_UNNAMED512                                 = 512, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_2
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_2
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_2
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, ///<
        };
        enum FORWARD_PIXEL_VALUE_2
        {
            FORWARD_PIXEL_VALUE_2_UNNAMED512                                 = 512, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_2
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_3
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_3
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, ///<
        };
        enum INVERSE_PIXEL_VALUE_3
        {
            INVERSE_PIXEL_VALUE_3_UNNAMED768                                 = 768, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_3
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_3
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_3
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, ///<
        };
        enum FORWARD_PIXEL_VALUE_3
        {
            FORWARD_PIXEL_VALUE_3_UNNAMED768                                 = 768, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_3
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_4
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_4
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, ///<
        };
        enum INVERSE_PIXEL_VALUE_4
        {
            INVERSE_PIXEL_VALUE_4_UNNAMED1024                                = 1024, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_4
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_4
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_4
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, ///<
        };
        enum FORWARD_PIXEL_VALUE_4
        {
            FORWARD_PIXEL_VALUE_4_UNNAMED1024                                = 1024, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_4
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_5
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_5
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, ///<
        };
        enum INVERSE_PIXEL_VALUE_5
        {
            INVERSE_PIXEL_VALUE_5_UNNAMED1280                                = 1280, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_5
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_5
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_5
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, ///<
        };
        enum FORWARD_PIXEL_VALUE_5
        {
            FORWARD_PIXEL_VALUE_5_UNNAMED1280                                = 1280, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_5
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_6
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_6
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, ///<
        };
        enum INVERSE_PIXEL_VALUE_6
        {
            INVERSE_PIXEL_VALUE_6_UNNAMED1536                                = 1536, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_6
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_6
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_6
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, ///<
        };
        enum FORWARD_PIXEL_VALUE_6
        {
            FORWARD_PIXEL_VALUE_6_UNNAMED1536                                = 1536, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_6
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_7
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_7
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, ///<
        };
        enum INVERSE_PIXEL_VALUE_7
        {
            INVERSE_PIXEL_VALUE_7_UNNAMED1792                                = 1792, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_7
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_7
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_7
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, ///<
        };
        enum FORWARD_PIXEL_VALUE_7
        {
            FORWARD_PIXEL_VALUE_7_UNNAMED1792                                = 1792, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_7
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_8
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_8
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, ///<
        };
        enum INVERSE_PIXEL_VALUE_8
        {
            INVERSE_PIXEL_VALUE_8_UNNAMED2048                                = 2048, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_8
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_8
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_8
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, ///<
        };
        enum FORWARD_PIXEL_VALUE_8
        {
            FORWARD_PIXEL_VALUE_8_UNNAMED2048                                = 2048, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_8
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_9
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_9
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, ///<
        };
        enum INVERSE_PIXEL_VALUE_9
        {
            INVERSE_PIXEL_VALUE_9_UNNAMED2304                                = 2304, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_9
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_9
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_9
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, ///<
        };
        enum FORWARD_PIXEL_VALUE_9
        {
            FORWARD_PIXEL_VALUE_9_UNNAMED2304                                = 2304, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_9
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_10
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_10
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, ///<
        };
        enum INVERSE_PIXEL_VALUE_10
        {
            INVERSE_PIXEL_VALUE_10_UNNAMED2560                               = 2560, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_10
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_10
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_10
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, ///<
        };
        enum FORWARD_PIXEL_VALUE_10
        {
            FORWARD_PIXEL_VALUE_10_UNNAMED2560                               = 2560, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_10
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_11
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_11
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, ///<
        };
        enum INVERSE_PIXEL_VALUE_11
        {
            INVERSE_PIXEL_VALUE_11_UNNAMED2816                               = 2816, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_11
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_11
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_11
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, ///<
        };
        enum FORWARD_PIXEL_VALUE_11
        {
            FORWARD_PIXEL_VALUE_11_UNNAMED2816                               = 2816, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_11
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_12
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_12
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, ///<
        };
        enum INVERSE_PIXEL_VALUE_12
        {
            INVERSE_PIXEL_VALUE_12_UNNAMED3072                               = 3072, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_12
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_12
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_12
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, ///<
        };
        enum FORWARD_PIXEL_VALUE_12
        {
            FORWARD_PIXEL_VALUE_12_UNNAMED3072                               = 3072, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_12
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_13
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_13
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, ///<
        };
        enum INVERSE_PIXEL_VALUE_13
        {
            INVERSE_PIXEL_VALUE_13_UNNAMED3328                               = 3328, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_13
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_13
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_13
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, ///<
        };
        enum FORWARD_PIXEL_VALUE_13
        {
            FORWARD_PIXEL_VALUE_13_UNNAMED3328                               = 3328, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_13
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_14
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_14
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, ///<
        };
        enum INVERSE_PIXEL_VALUE_14
        {
            INVERSE_PIXEL_VALUE_14_UNNAMED3584                               = 3584, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_14
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_14
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_14
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, ///<
        };
        enum FORWARD_PIXEL_VALUE_14
        {
            FORWARD_PIXEL_VALUE_14_UNNAMED3584                               = 3584, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_14
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_15
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_15
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, ///<
        };
        enum INVERSE_PIXEL_VALUE_15
        {
            INVERSE_PIXEL_VALUE_15_UNNAMED3840                               = 3840, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_15
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_15
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_15
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, ///<
        };
        enum FORWARD_PIXEL_VALUE_15
        {
            FORWARD_PIXEL_VALUE_15_UNNAMED3840                               = 3840, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_15
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_16
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_16
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, ///<
        };
        enum INVERSE_PIXEL_VALUE_16
        {
            INVERSE_PIXEL_VALUE_16_UNNAMED4096                               = 4096, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_16
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_16
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_16
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, ///<
        };
        enum FORWARD_PIXEL_VALUE_16
        {
            FORWARD_PIXEL_VALUE_16_UNNAMED4096                               = 4096, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_16
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_17
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_17
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, ///<
        };
        enum INVERSE_PIXEL_VALUE_17
        {
            INVERSE_PIXEL_VALUE_17_UNNAMED4352                               = 4352, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_17
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_17
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_17
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, ///<
        };
        enum FORWARD_PIXEL_VALUE_17
        {
            FORWARD_PIXEL_VALUE_17_UNNAMED4352                               = 4352, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_17
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_18
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_18
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, ///<
        };
        enum INVERSE_PIXEL_VALUE_18
        {
            INVERSE_PIXEL_VALUE_18_UNNAMED4608                               = 4608, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_18
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_18
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_18
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, ///<
        };
        enum FORWARD_PIXEL_VALUE_18
        {
            FORWARD_PIXEL_VALUE_18_UNNAMED4608                               = 4608, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_18
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_19
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_19
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, ///<
        };
        enum INVERSE_PIXEL_VALUE_19
        {
            INVERSE_PIXEL_VALUE_19_UNNAMED4864                               = 4864, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_19
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_19
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_19
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, ///<
        };
        enum FORWARD_PIXEL_VALUE_19
        {
            FORWARD_PIXEL_VALUE_19_UNNAMED4864                               = 4864, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_19
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_20
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_20
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, ///<
        };
        enum INVERSE_PIXEL_VALUE_20
        {
            INVERSE_PIXEL_VALUE_20_UNNAMED5120                               = 5120, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_20
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_20
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_20
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, ///<
        };
        enum FORWARD_PIXEL_VALUE_20
        {
            FORWARD_PIXEL_VALUE_20_UNNAMED5120                               = 5120, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_20
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_21
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_21
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, ///<
        };
        enum INVERSE_PIXEL_VALUE_21
        {
            INVERSE_PIXEL_VALUE_21_UNNAMED5376                               = 5376, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_21
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_21
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_21
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, ///<
        };
        enum FORWARD_PIXEL_VALUE_21
        {
            FORWARD_PIXEL_VALUE_21_UNNAMED5376                               = 5376, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_21
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_22
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_22
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, ///<
        };
        enum INVERSE_PIXEL_VALUE_22
        {
            INVERSE_PIXEL_VALUE_22_UNNAMED5632                               = 5632, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_22
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_22
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_22
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, ///<
        };
        enum FORWARD_PIXEL_VALUE_22
        {
            FORWARD_PIXEL_VALUE_22_UNNAMED5632                               = 5632, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_22
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_23
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_23
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, ///<
        };
        enum INVERSE_PIXEL_VALUE_23
        {
            INVERSE_PIXEL_VALUE_23_UNNAMED5888                               = 5888, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_23
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_23
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_23
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, ///<
        };
        enum FORWARD_PIXEL_VALUE_23
        {
            FORWARD_PIXEL_VALUE_23_UNNAMED5888                               = 5888, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_23
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_24
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_24
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, ///<
        };
        enum INVERSE_PIXEL_VALUE_24
        {
            INVERSE_PIXEL_VALUE_24_UNNAMED6144                               = 6144, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_24
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_24
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_24
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, ///<
        };
        enum FORWARD_PIXEL_VALUE_24
        {
            FORWARD_PIXEL_VALUE_24_UNNAMED6144                               = 6144, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_24
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_25
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_25
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, ///<
        };
        enum INVERSE_PIXEL_VALUE_25
        {
            INVERSE_PIXEL_VALUE_25_UNNAMED6400                               = 6400, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_25
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_25
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_25
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, ///<
        };
        enum FORWARD_PIXEL_VALUE_25
        {
            FORWARD_PIXEL_VALUE_25_UNNAMED6400                               = 6400, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_25
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_26
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_26
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, ///<
        };
        enum INVERSE_PIXEL_VALUE_26
        {
            INVERSE_PIXEL_VALUE_26_UNNAMED6656                               = 6656, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_26
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_26
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_26
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, ///<
        };
        enum FORWARD_PIXEL_VALUE_26
        {
            FORWARD_PIXEL_VALUE_26_UNNAMED6656                               = 6656, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_26
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_27
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_27
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, ///<
        };
        enum INVERSE_PIXEL_VALUE_27
        {
            INVERSE_PIXEL_VALUE_27_UNNAMED6912                               = 6912, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_27
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_27
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_27
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, ///<
        };
        enum FORWARD_PIXEL_VALUE_27
        {
            FORWARD_PIXEL_VALUE_27_UNNAMED6912                               = 6912, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_27
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_28
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_28
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, ///<
        };
        enum INVERSE_PIXEL_VALUE_28
        {
            INVERSE_PIXEL_VALUE_28_UNNAMED7168                               = 7168, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_28
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_28
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_28
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, ///<
        };
        enum FORWARD_PIXEL_VALUE_28
        {
            FORWARD_PIXEL_VALUE_28_UNNAMED7168                               = 7168, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_28
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_29
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_29
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, ///<
        };
        enum INVERSE_PIXEL_VALUE_29
        {
            INVERSE_PIXEL_VALUE_29_UNNAMED7424                               = 7424, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_29
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_29
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_29
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, ///<
        };
        enum FORWARD_PIXEL_VALUE_29
        {
            FORWARD_PIXEL_VALUE_29_UNNAMED7424                               = 7424, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_29
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_30
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_30
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, ///<
        };
        enum INVERSE_PIXEL_VALUE_30
        {
            INVERSE_PIXEL_VALUE_30_UNNAMED7680                               = 7680, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_30
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_30
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_30
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, ///<
        };
        enum FORWARD_PIXEL_VALUE_30
        {
            FORWARD_PIXEL_VALUE_30_UNNAMED7680                               = 7680, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_30
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_31
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_31
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, ///<
        };
        enum INVERSE_PIXEL_VALUE_31
        {
            INVERSE_PIXEL_VALUE_31_UNNAMED7936                               = 7936, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_31
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_31
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_31
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, ///<
        };
        enum FORWARD_PIXEL_VALUE_31
        {
            FORWARD_PIXEL_VALUE_31_UNNAMED7936                               = 7936, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_31
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_32
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_32
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, ///<
        };
        enum INVERSE_PIXEL_VALUE_32
        {
            INVERSE_PIXEL_VALUE_32_UNNAMED8192                               = 8192, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_32
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_32
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_32
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, ///<
        };
        enum FORWARD_PIXEL_VALUE_32
        {
            FORWARD_PIXEL_VALUE_32_UNNAMED8192                               = 8192, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_32
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_33
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_33
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, ///<
        };
        enum INVERSE_PIXEL_VALUE_33
        {
            INVERSE_PIXEL_VALUE_33_UNNAMED8448                               = 8448, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_33
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_33
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_33
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, ///<
        };
        enum FORWARD_PIXEL_VALUE_33
        {
            FORWARD_PIXEL_VALUE_33_UNNAMED8448                               = 8448, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_33
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_34
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_34
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, ///<
        };
        enum INVERSE_PIXEL_VALUE_34
        {
            INVERSE_PIXEL_VALUE_34_UNNAMED8704                               = 8704, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_34
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_34
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_34
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, ///<
        };
        enum FORWARD_PIXEL_VALUE_34
        {
            FORWARD_PIXEL_VALUE_34_UNNAMED8704                               = 8704, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_34
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_35
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_35
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, ///<
        };
        enum INVERSE_PIXEL_VALUE_35
        {
            INVERSE_PIXEL_VALUE_35_UNNAMED8960                               = 8960, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_35
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_35
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_35
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, ///<
        };
        enum FORWARD_PIXEL_VALUE_35
        {
            FORWARD_PIXEL_VALUE_35_UNNAMED8960                               = 8960, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_35
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_36
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_36
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, ///<
        };
        enum INVERSE_PIXEL_VALUE_36
        {
            INVERSE_PIXEL_VALUE_36_UNNAMED9216                               = 9216, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_36
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_36
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_36
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, ///<
        };
        enum FORWARD_PIXEL_VALUE_36
        {
            FORWARD_PIXEL_VALUE_36_UNNAMED9216                               = 9216, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_36
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_37
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_37
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, ///<
        };
        enum INVERSE_PIXEL_VALUE_37
        {
            INVERSE_PIXEL_VALUE_37_UNNAMED9472                               = 9472, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_37
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_37
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_37
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, ///<
        };
        enum FORWARD_PIXEL_VALUE_37
        {
            FORWARD_PIXEL_VALUE_37_UNNAMED9472                               = 9472, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_37
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_38
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_38
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, ///<
        };
        enum INVERSE_PIXEL_VALUE_38
        {
            INVERSE_PIXEL_VALUE_38_UNNAMED9728                               = 9728, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_38
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_38
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_38
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, ///<
        };
        enum FORWARD_PIXEL_VALUE_38
        {
            FORWARD_PIXEL_VALUE_38_UNNAMED9728                               = 9728, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_38
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_39
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_39
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, ///<
        };
        enum INVERSE_PIXEL_VALUE_39
        {
            INVERSE_PIXEL_VALUE_39_UNNAMED9984                               = 9984, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_39
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_39
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_39
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, ///<
        };
        enum FORWARD_PIXEL_VALUE_39
        {
            FORWARD_PIXEL_VALUE_39_UNNAMED9984                               = 9984, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_39
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_40
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_40
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, ///<
        };
        enum INVERSE_PIXEL_VALUE_40
        {
            INVERSE_PIXEL_VALUE_40_UNNAMED10240                              = 10240, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_40
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_40
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_40
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, ///<
        };
        enum FORWARD_PIXEL_VALUE_40
        {
            FORWARD_PIXEL_VALUE_40_UNNAMED10240                              = 10240, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_40
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_41
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_41
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, ///<
        };
        enum INVERSE_PIXEL_VALUE_41
        {
            INVERSE_PIXEL_VALUE_41_UNNAMED10496                              = 10496, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_41
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_41
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_41
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, ///<
        };
        enum FORWARD_PIXEL_VALUE_41
        {
            FORWARD_PIXEL_VALUE_41_UNNAMED10496                              = 10496, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_41
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_42
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_42
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, ///<
        };
        enum INVERSE_PIXEL_VALUE_42
        {
            INVERSE_PIXEL_VALUE_42_UNNAMED10752                              = 10752, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_42
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_42
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_42
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, ///<
        };
        enum FORWARD_PIXEL_VALUE_42
        {
            FORWARD_PIXEL_VALUE_42_UNNAMED10752                              = 10752, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_42
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_43
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_43
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, ///<
        };
        enum INVERSE_PIXEL_VALUE_43
        {
            INVERSE_PIXEL_VALUE_43_UNNAMED11008                              = 11008, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_43
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_43
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_43
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, ///<
        };
        enum FORWARD_PIXEL_VALUE_43
        {
            FORWARD_PIXEL_VALUE_43_UNNAMED11008                              = 11008, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_43
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_44
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_44
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, ///<
        };
        enum INVERSE_PIXEL_VALUE_44
        {
            INVERSE_PIXEL_VALUE_44_UNNAMED11264                              = 11264, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_44
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_44
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_44
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, ///<
        };
        enum FORWARD_PIXEL_VALUE_44
        {
            FORWARD_PIXEL_VALUE_44_UNNAMED11264                              = 11264, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_44
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_45
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_45
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, ///<
        };
        enum INVERSE_PIXEL_VALUE_45
        {
            INVERSE_PIXEL_VALUE_45_UNNAMED11520                              = 11520, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_45
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_45
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_45
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, ///<
        };
        enum FORWARD_PIXEL_VALUE_45
        {
            FORWARD_PIXEL_VALUE_45_UNNAMED11520                              = 11520, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_45
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_46
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_46
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, ///<
        };
        enum INVERSE_PIXEL_VALUE_46
        {
            INVERSE_PIXEL_VALUE_46_UNNAMED11776                              = 11776, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_46
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_46
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_46
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, ///<
        };
        enum FORWARD_PIXEL_VALUE_46
        {
            FORWARD_PIXEL_VALUE_46_UNNAMED11776                              = 11776, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_46
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_47
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_47
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, ///<
        };
        enum INVERSE_PIXEL_VALUE_47
        {
            INVERSE_PIXEL_VALUE_47_UNNAMED12032                              = 12032, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_47
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_47
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_47
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, ///<
        };
        enum FORWARD_PIXEL_VALUE_47
        {
            FORWARD_PIXEL_VALUE_47_UNNAMED12032                              = 12032, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_47
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_48
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_48
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, ///<
        };
        enum INVERSE_PIXEL_VALUE_48
        {
            INVERSE_PIXEL_VALUE_48_UNNAMED12288                              = 12288, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_48
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_48
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_48
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, ///<
        };
        enum FORWARD_PIXEL_VALUE_48
        {
            FORWARD_PIXEL_VALUE_48_UNNAMED12288                              = 12288, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_48
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_49
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_49
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, ///<
        };
        enum INVERSE_PIXEL_VALUE_49
        {
            INVERSE_PIXEL_VALUE_49_UNNAMED12544                              = 12544, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_49
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_49
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_49
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, ///<
        };
        enum FORWARD_PIXEL_VALUE_49
        {
            FORWARD_PIXEL_VALUE_49_UNNAMED12544                              = 12544, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_49
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_50
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_50
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, ///<
        };
        enum INVERSE_PIXEL_VALUE_50
        {
            INVERSE_PIXEL_VALUE_50_UNNAMED12800                              = 12800, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_50
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_50
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_50
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, ///<
        };
        enum FORWARD_PIXEL_VALUE_50
        {
            FORWARD_PIXEL_VALUE_50_UNNAMED12800                              = 12800, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_50
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_51
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_51
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, ///<
        };
        enum INVERSE_PIXEL_VALUE_51
        {
            INVERSE_PIXEL_VALUE_51_UNNAMED13056                              = 13056, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_51
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_51
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_51
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, ///<
        };
        enum FORWARD_PIXEL_VALUE_51
        {
            FORWARD_PIXEL_VALUE_51_UNNAMED13056                              = 13056, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_51
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_52
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_52
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, ///<
        };
        enum INVERSE_PIXEL_VALUE_52
        {
            INVERSE_PIXEL_VALUE_52_UNNAMED13312                              = 13312, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_52
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_52
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_52
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, ///<
        };
        enum FORWARD_PIXEL_VALUE_52
        {
            FORWARD_PIXEL_VALUE_52_UNNAMED13312                              = 13312, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_52
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_53
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_53
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, ///<
        };
        enum INVERSE_PIXEL_VALUE_53
        {
            INVERSE_PIXEL_VALUE_53_UNNAMED13568                              = 13568, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_53
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_53
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_53
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, ///<
        };
        enum FORWARD_PIXEL_VALUE_53
        {
            FORWARD_PIXEL_VALUE_53_UNNAMED13568                              = 13568, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_53
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_54
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_54
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, ///<
        };
        enum INVERSE_PIXEL_VALUE_54
        {
            INVERSE_PIXEL_VALUE_54_UNNAMED13824                              = 13824, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_54
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_54
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_54
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, ///<
        };
        enum FORWARD_PIXEL_VALUE_54
        {
            FORWARD_PIXEL_VALUE_54_UNNAMED13824                              = 13824, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_54
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_55
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_55
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, ///<
        };
        enum INVERSE_PIXEL_VALUE_55
        {
            INVERSE_PIXEL_VALUE_55_UNNAMED14080                              = 14080, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_55
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_55
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_55
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, ///<
        };
        enum FORWARD_PIXEL_VALUE_55
        {
            FORWARD_PIXEL_VALUE_55_UNNAMED14080                              = 14080, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_55
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_56
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_56
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, ///<
        };
        enum INVERSE_PIXEL_VALUE_56
        {
            INVERSE_PIXEL_VALUE_56_UNNAMED14336                              = 14336, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_56
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_56
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_56
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, ///<
        };
        enum FORWARD_PIXEL_VALUE_56
        {
            FORWARD_PIXEL_VALUE_56_UNNAMED14336                              = 14336, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_56
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_57
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_57
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, ///<
        };
        enum INVERSE_PIXEL_VALUE_57
        {
            INVERSE_PIXEL_VALUE_57_UNNAMED14592                              = 14592, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_57
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_57
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_57
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, ///<
        };
        enum FORWARD_PIXEL_VALUE_57
        {
            FORWARD_PIXEL_VALUE_57_UNNAMED14592                              = 14592, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_57
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_58
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_58
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, ///<
        };
        enum INVERSE_PIXEL_VALUE_58
        {
            INVERSE_PIXEL_VALUE_58_UNNAMED14848                              = 14848, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_58
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_58
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_58
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, ///<
        };
        enum FORWARD_PIXEL_VALUE_58
        {
            FORWARD_PIXEL_VALUE_58_UNNAMED14848                              = 14848, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_58
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_59
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_59
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, ///<
        };
        enum INVERSE_PIXEL_VALUE_59
        {
            INVERSE_PIXEL_VALUE_59_UNNAMED15104                              = 15104, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_59
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_59
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_59
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, ///<
        };
        enum FORWARD_PIXEL_VALUE_59
        {
            FORWARD_PIXEL_VALUE_59_UNNAMED15104                              = 15104, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_59
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_60
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_60
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, ///<
        };
        enum INVERSE_PIXEL_VALUE_60
        {
            INVERSE_PIXEL_VALUE_60_UNNAMED15360                              = 15360, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_60
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_60
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_60
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, ///<
        };
        enum FORWARD_PIXEL_VALUE_60
        {
            FORWARD_PIXEL_VALUE_60_UNNAMED15360                              = 15360, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_60
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_61
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_61
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, ///<
        };
        enum INVERSE_PIXEL_VALUE_61
        {
            INVERSE_PIXEL_VALUE_61_UNNAMED15616                              = 15616, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_61
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_61
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_61
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, ///<
        };
        enum FORWARD_PIXEL_VALUE_61
        {
            FORWARD_PIXEL_VALUE_61_UNNAMED15616                              = 15616, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_61
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_62
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_62
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, ///<
        };
        enum INVERSE_PIXEL_VALUE_62
        {
            INVERSE_PIXEL_VALUE_62_UNNAMED15872                              = 15872, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_62
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_62
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_62
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, ///<
        };
        enum FORWARD_PIXEL_VALUE_62
        {
            FORWARD_PIXEL_VALUE_62_UNNAMED15872                              = 15872, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_62
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_63
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_63
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, ///<
        };
        enum INVERSE_PIXEL_VALUE_63
        {
            INVERSE_PIXEL_VALUE_63_UNNAMED16128                              = 16128, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_63
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_63
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_63
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, ///<
        };
        enum FORWARD_PIXEL_VALUE_63
        {
            FORWARD_PIXEL_VALUE_63_UNNAMED16128                              = 16128, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_63
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_64
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_64
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, ///<
        };
        enum INVERSE_PIXEL_VALUE_64
        {
            INVERSE_PIXEL_VALUE_64_UNNAMED16384                              = 16384, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_64
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_64
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_64
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, ///<
        };
        enum FORWARD_PIXEL_VALUE_64
        {
            FORWARD_PIXEL_VALUE_64_UNNAMED16384                              = 16384, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_64
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_65
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_65
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, ///<
        };
        enum INVERSE_PIXEL_VALUE_65
        {
            INVERSE_PIXEL_VALUE_65_UNNAMED16640                              = 16640, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_65
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_65
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_65
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, ///<
        };
        enum FORWARD_PIXEL_VALUE_65
        {
            FORWARD_PIXEL_VALUE_65_UNNAMED16640                              = 16640, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_65
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_66
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_66
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, ///<
        };
        enum INVERSE_PIXEL_VALUE_66
        {
            INVERSE_PIXEL_VALUE_66_UNNAMED16896                              = 16896, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_66
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_66
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_66
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, ///<
        };
        enum FORWARD_PIXEL_VALUE_66
        {
            FORWARD_PIXEL_VALUE_66_UNNAMED16896                              = 16896, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_66
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_67
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_67
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, ///<
        };
        enum INVERSE_PIXEL_VALUE_67
        {
            INVERSE_PIXEL_VALUE_67_UNNAMED17152                              = 17152, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_67
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_67
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_67
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, ///<
        };
        enum FORWARD_PIXEL_VALUE_67
        {
            FORWARD_PIXEL_VALUE_67_UNNAMED17152                              = 17152, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_67
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_68
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_68
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, ///<
        };
        enum INVERSE_PIXEL_VALUE_68
        {
            INVERSE_PIXEL_VALUE_68_UNNAMED17408                              = 17408, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_68
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_68
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_68
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, ///<
        };
        enum FORWARD_PIXEL_VALUE_68
        {
            FORWARD_PIXEL_VALUE_68_UNNAMED17408                              = 17408, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_68
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_69
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_69
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, ///<
        };
        enum INVERSE_PIXEL_VALUE_69
        {
            INVERSE_PIXEL_VALUE_69_UNNAMED17664                              = 17664, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_69
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_69
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_69
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, ///<
        };
        enum FORWARD_PIXEL_VALUE_69
        {
            FORWARD_PIXEL_VALUE_69_UNNAMED17664                              = 17664, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_69
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_70
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_70
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, ///<
        };
        enum INVERSE_PIXEL_VALUE_70
        {
            INVERSE_PIXEL_VALUE_70_UNNAMED17920                              = 17920, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_70
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_70
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_70
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, ///<
        };
        enum FORWARD_PIXEL_VALUE_70
        {
            FORWARD_PIXEL_VALUE_70_UNNAMED17920                              = 17920, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_70
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_71
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_71
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, ///<
        };
        enum INVERSE_PIXEL_VALUE_71
        {
            INVERSE_PIXEL_VALUE_71_UNNAMED18176                              = 18176, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_71
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_71
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_71
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, ///<
        };
        enum FORWARD_PIXEL_VALUE_71
        {
            FORWARD_PIXEL_VALUE_71_UNNAMED18176                              = 18176, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_71
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_72
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_72
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, ///<
        };
        enum INVERSE_PIXEL_VALUE_72
        {
            INVERSE_PIXEL_VALUE_72_UNNAMED18432                              = 18432, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_72
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_72
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_72
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, ///<
        };
        enum FORWARD_PIXEL_VALUE_72
        {
            FORWARD_PIXEL_VALUE_72_UNNAMED18432                              = 18432, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_72
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_73
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_73
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, ///<
        };
        enum INVERSE_PIXEL_VALUE_73
        {
            INVERSE_PIXEL_VALUE_73_UNNAMED18688                              = 18688, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_73
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_73
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_73
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, ///<
        };
        enum FORWARD_PIXEL_VALUE_73
        {
            FORWARD_PIXEL_VALUE_73_UNNAMED18688                              = 18688, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_73
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_74
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_74
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, ///<
        };
        enum INVERSE_PIXEL_VALUE_74
        {
            INVERSE_PIXEL_VALUE_74_UNNAMED18944                              = 18944, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_74
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_74
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_74
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, ///<
        };
        enum FORWARD_PIXEL_VALUE_74
        {
            FORWARD_PIXEL_VALUE_74_UNNAMED18944                              = 18944, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_74
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_75
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_75
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, ///<
        };
        enum INVERSE_PIXEL_VALUE_75
        {
            INVERSE_PIXEL_VALUE_75_UNNAMED19200                              = 19200, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_75
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_75
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_75
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, ///<
        };
        enum FORWARD_PIXEL_VALUE_75
        {
            FORWARD_PIXEL_VALUE_75_UNNAMED19200                              = 19200, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_75
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_76
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_76
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, ///<
        };
        enum INVERSE_PIXEL_VALUE_76
        {
            INVERSE_PIXEL_VALUE_76_UNNAMED19456                              = 19456, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_76
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_76
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_76
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, ///<
        };
        enum FORWARD_PIXEL_VALUE_76
        {
            FORWARD_PIXEL_VALUE_76_UNNAMED19456                              = 19456, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_76
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_77
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_77
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, ///<
        };
        enum INVERSE_PIXEL_VALUE_77
        {
            INVERSE_PIXEL_VALUE_77_UNNAMED19712                              = 19712, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_77
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_77
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_77
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, ///<
        };
        enum FORWARD_PIXEL_VALUE_77
        {
            FORWARD_PIXEL_VALUE_77_UNNAMED19712                              = 19712, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_77
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_78
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_78
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, ///<
        };
        enum INVERSE_PIXEL_VALUE_78
        {
            INVERSE_PIXEL_VALUE_78_UNNAMED19968                              = 19968, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_78
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_78
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_78
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, ///<
        };
        enum FORWARD_PIXEL_VALUE_78
        {
            FORWARD_PIXEL_VALUE_78_UNNAMED19968                              = 19968, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_78
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_79
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_79
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, ///<
        };
        enum INVERSE_PIXEL_VALUE_79
        {
            INVERSE_PIXEL_VALUE_79_UNNAMED20224                              = 20224, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_79
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_79
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_79
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, ///<
        };
        enum FORWARD_PIXEL_VALUE_79
        {
            FORWARD_PIXEL_VALUE_79_UNNAMED20224                              = 20224, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_79
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_80
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_80
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, ///<
        };
        enum INVERSE_PIXEL_VALUE_80
        {
            INVERSE_PIXEL_VALUE_80_UNNAMED20480                              = 20480, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_80
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_80
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_80
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, ///<
        };
        enum FORWARD_PIXEL_VALUE_80
        {
            FORWARD_PIXEL_VALUE_80_UNNAMED20480                              = 20480, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_80
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_81
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_81
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, ///<
        };
        enum INVERSE_PIXEL_VALUE_81
        {
            INVERSE_PIXEL_VALUE_81_UNNAMED20736                              = 20736, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_81
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_81
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_81
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, ///<
        };
        enum FORWARD_PIXEL_VALUE_81
        {
            FORWARD_PIXEL_VALUE_81_UNNAMED20736                              = 20736, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_81
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_82
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_82
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, ///<
        };
        enum INVERSE_PIXEL_VALUE_82
        {
            INVERSE_PIXEL_VALUE_82_UNNAMED20992                              = 20992, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_82
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_82
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_82
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, ///<
        };
        enum FORWARD_PIXEL_VALUE_82
        {
            FORWARD_PIXEL_VALUE_82_UNNAMED20992                              = 20992, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_82
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_83
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_83
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, ///<
        };
        enum INVERSE_PIXEL_VALUE_83
        {
            INVERSE_PIXEL_VALUE_83_UNNAMED21248                              = 21248, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_83
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_83
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_83
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, ///<
        };
        enum FORWARD_PIXEL_VALUE_83
        {
            FORWARD_PIXEL_VALUE_83_UNNAMED21248                              = 21248, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_83
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_84
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_84
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, ///<
        };
        enum INVERSE_PIXEL_VALUE_84
        {
            INVERSE_PIXEL_VALUE_84_UNNAMED21504                              = 21504, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_84
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_84
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_84
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, ///<
        };
        enum FORWARD_PIXEL_VALUE_84
        {
            FORWARD_PIXEL_VALUE_84_UNNAMED21504                              = 21504, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_84
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_85
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_85
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, ///<
        };
        enum INVERSE_PIXEL_VALUE_85
        {
            INVERSE_PIXEL_VALUE_85_UNNAMED21760                              = 21760, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_85
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_85
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_85
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, ///<
        };
        enum FORWARD_PIXEL_VALUE_85
        {
            FORWARD_PIXEL_VALUE_85_UNNAMED21760                              = 21760, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_85
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_86
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_86
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, ///<
        };
        enum INVERSE_PIXEL_VALUE_86
        {
            INVERSE_PIXEL_VALUE_86_UNNAMED22016                              = 22016, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_86
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_86
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_86
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, ///<
        };
        enum FORWARD_PIXEL_VALUE_86
        {
            FORWARD_PIXEL_VALUE_86_UNNAMED22016                              = 22016, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_86
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_87
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_87
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, ///<
        };
        enum INVERSE_PIXEL_VALUE_87
        {
            INVERSE_PIXEL_VALUE_87_UNNAMED22272                              = 22272, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_87
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_87
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_87
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, ///<
        };
        enum FORWARD_PIXEL_VALUE_87
        {
            FORWARD_PIXEL_VALUE_87_UNNAMED22272                              = 22272, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_87
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_88
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_88
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, ///<
        };
        enum INVERSE_PIXEL_VALUE_88
        {
            INVERSE_PIXEL_VALUE_88_UNNAMED22528                              = 22528, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_88
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_88
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_88
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, ///<
        };
        enum FORWARD_PIXEL_VALUE_88
        {
            FORWARD_PIXEL_VALUE_88_UNNAMED22528                              = 22528, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_88
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_89
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_89
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, ///<
        };
        enum INVERSE_PIXEL_VALUE_89
        {
            INVERSE_PIXEL_VALUE_89_UNNAMED22784                              = 22784, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_89
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_89
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_89
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, ///<
        };
        enum FORWARD_PIXEL_VALUE_89
        {
            FORWARD_PIXEL_VALUE_89_UNNAMED22784                              = 22784, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_89
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_90
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_90
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, ///<
        };
        enum INVERSE_PIXEL_VALUE_90
        {
            INVERSE_PIXEL_VALUE_90_UNNAMED23040                              = 23040, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_90
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_90
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_90
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, ///<
        };
        enum FORWARD_PIXEL_VALUE_90
        {
            FORWARD_PIXEL_VALUE_90_UNNAMED23040                              = 23040, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_90
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_91
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_91
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, ///<
        };
        enum INVERSE_PIXEL_VALUE_91
        {
            INVERSE_PIXEL_VALUE_91_UNNAMED23296                              = 23296, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_91
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_91
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_91
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, ///<
        };
        enum FORWARD_PIXEL_VALUE_91
        {
            FORWARD_PIXEL_VALUE_91_UNNAMED23296                              = 23296, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_91
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_92
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_92
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, ///<
        };
        enum INVERSE_PIXEL_VALUE_92
        {
            INVERSE_PIXEL_VALUE_92_UNNAMED23552                              = 23552, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_92
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_92
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_92
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, ///<
        };
        enum FORWARD_PIXEL_VALUE_92
        {
            FORWARD_PIXEL_VALUE_92_UNNAMED23552                              = 23552, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_92
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_93
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_93
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, ///<
        };
        enum INVERSE_PIXEL_VALUE_93
        {
            INVERSE_PIXEL_VALUE_93_UNNAMED23808                              = 23808, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_93
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_93
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_93
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, ///<
        };
        enum FORWARD_PIXEL_VALUE_93
        {
            FORWARD_PIXEL_VALUE_93_UNNAMED23808                              = 23808, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_93
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_94
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_94
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, ///<
        };
        enum INVERSE_PIXEL_VALUE_94
        {
            INVERSE_PIXEL_VALUE_94_UNNAMED24064                              = 24064, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_94
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_94
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_94
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, ///<
        };
        enum FORWARD_PIXEL_VALUE_94
        {
            FORWARD_PIXEL_VALUE_94_UNNAMED24064                              = 24064, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_94
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_95
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_95
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, ///<
        };
        enum INVERSE_PIXEL_VALUE_95
        {
            INVERSE_PIXEL_VALUE_95_UNNAMED24320                              = 24320, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_95
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_95
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_95
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, ///<
        };
        enum FORWARD_PIXEL_VALUE_95
        {
            FORWARD_PIXEL_VALUE_95_UNNAMED24320                              = 24320, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_95
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_96
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_96
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, ///<
        };
        enum INVERSE_PIXEL_VALUE_96
        {
            INVERSE_PIXEL_VALUE_96_UNNAMED24576                              = 24576, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_96
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_96
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_96
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, ///<
        };
        enum FORWARD_PIXEL_VALUE_96
        {
            FORWARD_PIXEL_VALUE_96_UNNAMED24576                              = 24576, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_96
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_97
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_97
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, ///<
        };
        enum INVERSE_PIXEL_VALUE_97
        {
            INVERSE_PIXEL_VALUE_97_UNNAMED24832                              = 24832, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_97
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_97
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_97
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, ///<
        };
        enum FORWARD_PIXEL_VALUE_97
        {
            FORWARD_PIXEL_VALUE_97_UNNAMED24832                              = 24832, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_97
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_98
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_98
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, ///<
        };
        enum INVERSE_PIXEL_VALUE_98
        {
            INVERSE_PIXEL_VALUE_98_UNNAMED25088                              = 25088, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_98
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_98
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_98
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, ///<
        };
        enum FORWARD_PIXEL_VALUE_98
        {
            FORWARD_PIXEL_VALUE_98_UNNAMED25088                              = 25088, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_98
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_99
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_99
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, ///<
        };
        enum INVERSE_PIXEL_VALUE_99
        {
            INVERSE_PIXEL_VALUE_99_UNNAMED25344                              = 25344, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_99
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_99
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_99
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, ///<
        };
        enum FORWARD_PIXEL_VALUE_99
        {
            FORWARD_PIXEL_VALUE_99_UNNAMED25344                              = 25344, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_99
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_100
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_100
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, ///<
        };
        enum INVERSE_PIXEL_VALUE_100
        {
            INVERSE_PIXEL_VALUE_100_UNNAMED25600                             = 25600, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_100
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_100
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_100
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, ///<
        };
        enum FORWARD_PIXEL_VALUE_100
        {
            FORWARD_PIXEL_VALUE_100_UNNAMED25600                             = 25600, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_100
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_101
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_101
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, ///<
        };
        enum INVERSE_PIXEL_VALUE_101
        {
            INVERSE_PIXEL_VALUE_101_UNNAMED25856                             = 25856, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_101
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_101
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_101
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, ///<
        };
        enum FORWARD_PIXEL_VALUE_101
        {
            FORWARD_PIXEL_VALUE_101_UNNAMED25856                             = 25856, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_101
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_102
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_102
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, ///<
        };
        enum INVERSE_PIXEL_VALUE_102
        {
            INVERSE_PIXEL_VALUE_102_UNNAMED26112                             = 26112, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_102
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_102
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_102
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, ///<
        };
        enum FORWARD_PIXEL_VALUE_102
        {
            FORWARD_PIXEL_VALUE_102_UNNAMED26112                             = 26112, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_102
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_103
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_103
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, ///<
        };
        enum INVERSE_PIXEL_VALUE_103
        {
            INVERSE_PIXEL_VALUE_103_UNNAMED26368                             = 26368, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_103
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_103
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_103
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, ///<
        };
        enum FORWARD_PIXEL_VALUE_103
        {
            FORWARD_PIXEL_VALUE_103_UNNAMED26368                             = 26368, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_103
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_104
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_104
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, ///<
        };
        enum INVERSE_PIXEL_VALUE_104
        {
            INVERSE_PIXEL_VALUE_104_UNNAMED26624                             = 26624, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_104
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_104
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_104
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, ///<
        };
        enum FORWARD_PIXEL_VALUE_104
        {
            FORWARD_PIXEL_VALUE_104_UNNAMED26624                             = 26624, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_104
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_105
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_105
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, ///<
        };
        enum INVERSE_PIXEL_VALUE_105
        {
            INVERSE_PIXEL_VALUE_105_UNNAMED26880                             = 26880, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_105
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_105
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_105
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, ///<
        };
        enum FORWARD_PIXEL_VALUE_105
        {
            FORWARD_PIXEL_VALUE_105_UNNAMED26880                             = 26880, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_105
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_106
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_106
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, ///<
        };
        enum INVERSE_PIXEL_VALUE_106
        {
            INVERSE_PIXEL_VALUE_106_UNNAMED27136                             = 27136, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_106
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_106
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_106
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, ///<
        };
        enum FORWARD_PIXEL_VALUE_106
        {
            FORWARD_PIXEL_VALUE_106_UNNAMED27136                             = 27136, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_106
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_107
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_107
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, ///<
        };
        enum INVERSE_PIXEL_VALUE_107
        {
            INVERSE_PIXEL_VALUE_107_UNNAMED27392                             = 27392, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_107
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_107
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_107
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, ///<
        };
        enum FORWARD_PIXEL_VALUE_107
        {
            FORWARD_PIXEL_VALUE_107_UNNAMED27392                             = 27392, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_107
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_108
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_108
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, ///<
        };
        enum INVERSE_PIXEL_VALUE_108
        {
            INVERSE_PIXEL_VALUE_108_UNNAMED27648                             = 27648, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_108
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_108
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_108
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, ///<
        };
        enum FORWARD_PIXEL_VALUE_108
        {
            FORWARD_PIXEL_VALUE_108_UNNAMED27648                             = 27648, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_108
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_109
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_109
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, ///<
        };
        enum INVERSE_PIXEL_VALUE_109
        {
            INVERSE_PIXEL_VALUE_109_UNNAMED27904                             = 27904, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_109
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_109
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_109
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, ///<
        };
        enum FORWARD_PIXEL_VALUE_109
        {
            FORWARD_PIXEL_VALUE_109_UNNAMED27904                             = 27904, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_109
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_110
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_110
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, ///<
        };
        enum INVERSE_PIXEL_VALUE_110
        {
            INVERSE_PIXEL_VALUE_110_UNNAMED28160                             = 28160, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_110
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_110
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_110
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, ///<
        };
        enum FORWARD_PIXEL_VALUE_110
        {
            FORWARD_PIXEL_VALUE_110_UNNAMED28160                             = 28160, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_110
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_111
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_111
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, ///<
        };
        enum INVERSE_PIXEL_VALUE_111
        {
            INVERSE_PIXEL_VALUE_111_UNNAMED28416                             = 28416, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_111
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_111
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_111
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, ///<
        };
        enum FORWARD_PIXEL_VALUE_111
        {
            FORWARD_PIXEL_VALUE_111_UNNAMED28416                             = 28416, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_111
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_112
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_112
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, ///<
        };
        enum INVERSE_PIXEL_VALUE_112
        {
            INVERSE_PIXEL_VALUE_112_UNNAMED28672                             = 28672, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_112
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_112
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_112
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, ///<
        };
        enum FORWARD_PIXEL_VALUE_112
        {
            FORWARD_PIXEL_VALUE_112_UNNAMED28672                             = 28672, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_112
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_113
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_113
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, ///<
        };
        enum INVERSE_PIXEL_VALUE_113
        {
            INVERSE_PIXEL_VALUE_113_UNNAMED28928                             = 28928, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_113
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_113
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_113
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, ///<
        };
        enum FORWARD_PIXEL_VALUE_113
        {
            FORWARD_PIXEL_VALUE_113_UNNAMED28928                             = 28928, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_113
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_114
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_114
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, ///<
        };
        enum INVERSE_PIXEL_VALUE_114
        {
            INVERSE_PIXEL_VALUE_114_UNNAMED29184                             = 29184, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_114
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_114
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_114
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, ///<
        };
        enum FORWARD_PIXEL_VALUE_114
        {
            FORWARD_PIXEL_VALUE_114_UNNAMED29184                             = 29184, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_114
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_115
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_115
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, ///<
        };
        enum INVERSE_PIXEL_VALUE_115
        {
            INVERSE_PIXEL_VALUE_115_UNNAMED29440                             = 29440, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_115
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_115
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_115
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, ///<
        };
        enum FORWARD_PIXEL_VALUE_115
        {
            FORWARD_PIXEL_VALUE_115_UNNAMED29440                             = 29440, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_115
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_116
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_116
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, ///<
        };
        enum INVERSE_PIXEL_VALUE_116
        {
            INVERSE_PIXEL_VALUE_116_UNNAMED29696                             = 29696, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_116
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_116
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_116
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, ///<
        };
        enum FORWARD_PIXEL_VALUE_116
        {
            FORWARD_PIXEL_VALUE_116_UNNAMED29696                             = 29696, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_116
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_117
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_117
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, ///<
        };
        enum INVERSE_PIXEL_VALUE_117
        {
            INVERSE_PIXEL_VALUE_117_UNNAMED29952                             = 29952, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_117
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_117
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_117
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, ///<
        };
        enum FORWARD_PIXEL_VALUE_117
        {
            FORWARD_PIXEL_VALUE_117_UNNAMED29952                             = 29952, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_117
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_118
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_118
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, ///<
        };
        enum INVERSE_PIXEL_VALUE_118
        {
            INVERSE_PIXEL_VALUE_118_UNNAMED30208                             = 30208, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_118
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_118
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_118
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, ///<
        };
        enum FORWARD_PIXEL_VALUE_118
        {
            FORWARD_PIXEL_VALUE_118_UNNAMED30208                             = 30208, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_118
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_119
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_119
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, ///<
        };
        enum INVERSE_PIXEL_VALUE_119
        {
            INVERSE_PIXEL_VALUE_119_UNNAMED30464                             = 30464, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_119
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_119
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_119
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, ///<
        };
        enum FORWARD_PIXEL_VALUE_119
        {
            FORWARD_PIXEL_VALUE_119_UNNAMED30464                             = 30464, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_119
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_120
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_120
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, ///<
        };
        enum INVERSE_PIXEL_VALUE_120
        {
            INVERSE_PIXEL_VALUE_120_UNNAMED30720                             = 30720, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_120
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_120
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_120
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, ///<
        };
        enum FORWARD_PIXEL_VALUE_120
        {
            FORWARD_PIXEL_VALUE_120_UNNAMED30720                             = 30720, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_120
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_121
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_121
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, ///<
        };
        enum INVERSE_PIXEL_VALUE_121
        {
            INVERSE_PIXEL_VALUE_121_UNNAMED30976                             = 30976, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_121
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_121
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_121
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, ///<
        };
        enum FORWARD_PIXEL_VALUE_121
        {
            FORWARD_PIXEL_VALUE_121_UNNAMED30976                             = 30976, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_121
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_122
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_122
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, ///<
        };
        enum INVERSE_PIXEL_VALUE_122
        {
            INVERSE_PIXEL_VALUE_122_UNNAMED31232                             = 31232, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_122
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_122
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_122
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, ///<
        };
        enum FORWARD_PIXEL_VALUE_122
        {
            FORWARD_PIXEL_VALUE_122_UNNAMED31232                             = 31232, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_122
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_123
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_123
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, ///<
        };
        enum INVERSE_PIXEL_VALUE_123
        {
            INVERSE_PIXEL_VALUE_123_UNNAMED31488                             = 31488, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_123
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_123
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_123
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, ///<
        };
        enum FORWARD_PIXEL_VALUE_123
        {
            FORWARD_PIXEL_VALUE_123_UNNAMED31488                             = 31488, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_123
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_124
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_124
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, ///<
        };
        enum INVERSE_PIXEL_VALUE_124
        {
            INVERSE_PIXEL_VALUE_124_UNNAMED31744                             = 31744, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_124
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_124
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_124
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, ///<
        };
        enum FORWARD_PIXEL_VALUE_124
        {
            FORWARD_PIXEL_VALUE_124_UNNAMED31744                             = 31744, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_124
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_125
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_125
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, ///<
        };
        enum INVERSE_PIXEL_VALUE_125
        {
            INVERSE_PIXEL_VALUE_125_UNNAMED32000                             = 32000, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_125
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_125
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_125
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, ///<
        };
        enum FORWARD_PIXEL_VALUE_125
        {
            FORWARD_PIXEL_VALUE_125_UNNAMED32000                             = 32000, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_125
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_126
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_126
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, ///<
        };
        enum INVERSE_PIXEL_VALUE_126
        {
            INVERSE_PIXEL_VALUE_126_UNNAMED32256                             = 32256, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_126
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_126
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_126
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, ///<
        };
        enum FORWARD_PIXEL_VALUE_126
        {
            FORWARD_PIXEL_VALUE_126_UNNAMED32256                             = 32256, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_126
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_127
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_127
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, ///<
        };
        enum INVERSE_PIXEL_VALUE_127
        {
            INVERSE_PIXEL_VALUE_127_UNNAMED32512                             = 32512, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_127
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_127
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_127
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, ///<
        };
        enum FORWARD_PIXEL_VALUE_127
        {
            FORWARD_PIXEL_VALUE_127_UNNAMED32512                             = 32512, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_127
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_128
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_128
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, ///<
        };
        enum INVERSE_PIXEL_VALUE_128
        {
            INVERSE_PIXEL_VALUE_128_UNNAMED32768                             = 32768, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_128
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_128
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_128
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, ///<
        };
        enum FORWARD_PIXEL_VALUE_128
        {
            FORWARD_PIXEL_VALUE_128_UNNAMED32768                             = 32768, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_128
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_129
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_129
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, ///<
        };
        enum INVERSE_PIXEL_VALUE_129
        {
            INVERSE_PIXEL_VALUE_129_UNNAMED33024                             = 33024, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_129
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_129
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_129
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, ///<
        };
        enum FORWARD_PIXEL_VALUE_129
        {
            FORWARD_PIXEL_VALUE_129_UNNAMED33024                             = 33024, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_129
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_130
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_130
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, ///<
        };
        enum INVERSE_PIXEL_VALUE_130
        {
            INVERSE_PIXEL_VALUE_130_UNNAMED33280                             = 33280, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_130
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_130
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_130
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, ///<
        };
        enum FORWARD_PIXEL_VALUE_130
        {
            FORWARD_PIXEL_VALUE_130_UNNAMED33280                             = 33280, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_130
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_131
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_131
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, ///<
        };
        enum INVERSE_PIXEL_VALUE_131
        {
            INVERSE_PIXEL_VALUE_131_UNNAMED33536                             = 33536, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_131
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_131
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_131
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, ///<
        };
        enum FORWARD_PIXEL_VALUE_131
        {
            FORWARD_PIXEL_VALUE_131_UNNAMED33536                             = 33536, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_131
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_132
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_132
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, ///<
        };
        enum INVERSE_PIXEL_VALUE_132
        {
            INVERSE_PIXEL_VALUE_132_UNNAMED33792                             = 33792, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_132
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_132
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_132
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, ///<
        };
        enum FORWARD_PIXEL_VALUE_132
        {
            FORWARD_PIXEL_VALUE_132_UNNAMED33792                             = 33792, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_132
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_133
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_133
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, ///<
        };
        enum INVERSE_PIXEL_VALUE_133
        {
            INVERSE_PIXEL_VALUE_133_UNNAMED34048                             = 34048, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_133
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_133
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_133
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, ///<
        };
        enum FORWARD_PIXEL_VALUE_133
        {
            FORWARD_PIXEL_VALUE_133_UNNAMED34048                             = 34048, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_133
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_134
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_134
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, ///<
        };
        enum INVERSE_PIXEL_VALUE_134
        {
            INVERSE_PIXEL_VALUE_134_UNNAMED34304                             = 34304, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_134
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_134
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_134
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, ///<
        };
        enum FORWARD_PIXEL_VALUE_134
        {
            FORWARD_PIXEL_VALUE_134_UNNAMED34304                             = 34304, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_134
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_135
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_135
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, ///<
        };
        enum INVERSE_PIXEL_VALUE_135
        {
            INVERSE_PIXEL_VALUE_135_UNNAMED34560                             = 34560, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_135
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_135
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_135
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, ///<
        };
        enum FORWARD_PIXEL_VALUE_135
        {
            FORWARD_PIXEL_VALUE_135_UNNAMED34560                             = 34560, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_135
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_136
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_136
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, ///<
        };
        enum INVERSE_PIXEL_VALUE_136
        {
            INVERSE_PIXEL_VALUE_136_UNNAMED34816                             = 34816, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_136
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_136
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_136
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, ///<
        };
        enum FORWARD_PIXEL_VALUE_136
        {
            FORWARD_PIXEL_VALUE_136_UNNAMED34816                             = 34816, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_136
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_137
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_137
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, ///<
        };
        enum INVERSE_PIXEL_VALUE_137
        {
            INVERSE_PIXEL_VALUE_137_UNNAMED35072                             = 35072, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_137
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_137
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_137
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, ///<
        };
        enum FORWARD_PIXEL_VALUE_137
        {
            FORWARD_PIXEL_VALUE_137_UNNAMED35072                             = 35072, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_137
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_138
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_138
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, ///<
        };
        enum INVERSE_PIXEL_VALUE_138
        {
            INVERSE_PIXEL_VALUE_138_UNNAMED35328                             = 35328, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_138
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_138
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_138
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, ///<
        };
        enum FORWARD_PIXEL_VALUE_138
        {
            FORWARD_PIXEL_VALUE_138_UNNAMED35328                             = 35328, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_138
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_139
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_139
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, ///<
        };
        enum INVERSE_PIXEL_VALUE_139
        {
            INVERSE_PIXEL_VALUE_139_UNNAMED35584                             = 35584, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_139
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_139
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_139
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, ///<
        };
        enum FORWARD_PIXEL_VALUE_139
        {
            FORWARD_PIXEL_VALUE_139_UNNAMED35584                             = 35584, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_139
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_140
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_140_UNNAMED35840              = 35840, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_140
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_140_UNNAMED35840              = 35840, ///<
        };
        enum INVERSE_PIXEL_VALUE_140
        {
            INVERSE_PIXEL_VALUE_140_UNNAMED35840                             = 35840, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_140
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_140_UNNAMED35840              = 35840, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_140
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_140_UNNAMED35840              = 35840, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_140
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_140_UNNAMED35840              = 35840, ///<
        };
        enum FORWARD_PIXEL_VALUE_140
        {
            FORWARD_PIXEL_VALUE_140_UNNAMED35840                             = 35840, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_140
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_140_UNNAMED35840              = 35840, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_141
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_141_UNNAMED36096              = 36096, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_141
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_141_UNNAMED36096              = 36096, ///<
        };
        enum INVERSE_PIXEL_VALUE_141
        {
            INVERSE_PIXEL_VALUE_141_UNNAMED36096                             = 36096, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_141
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_141_UNNAMED36096              = 36096, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_141
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_141_UNNAMED36096              = 36096, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_141
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_141_UNNAMED36096              = 36096, ///<
        };
        enum FORWARD_PIXEL_VALUE_141
        {
            FORWARD_PIXEL_VALUE_141_UNNAMED36096                             = 36096, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_141
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_141_UNNAMED36096              = 36096, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_142
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_142_UNNAMED36352              = 36352, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_142
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_142_UNNAMED36352              = 36352, ///<
        };
        enum INVERSE_PIXEL_VALUE_142
        {
            INVERSE_PIXEL_VALUE_142_UNNAMED36352                             = 36352, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_142
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_142_UNNAMED36352              = 36352, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_142
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_142_UNNAMED36352              = 36352, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_142
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_142_UNNAMED36352              = 36352, ///<
        };
        enum FORWARD_PIXEL_VALUE_142
        {
            FORWARD_PIXEL_VALUE_142_UNNAMED36352                             = 36352, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_142
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_142_UNNAMED36352              = 36352, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_143
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_143_UNNAMED36608              = 36608, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_143
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_143_UNNAMED36608              = 36608, ///<
        };
        enum INVERSE_PIXEL_VALUE_143
        {
            INVERSE_PIXEL_VALUE_143_UNNAMED36608                             = 36608, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_143
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_143_UNNAMED36608              = 36608, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_143
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_143_UNNAMED36608              = 36608, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_143
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_143_UNNAMED36608              = 36608, ///<
        };
        enum FORWARD_PIXEL_VALUE_143
        {
            FORWARD_PIXEL_VALUE_143_UNNAMED36608                             = 36608, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_143
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_143_UNNAMED36608              = 36608, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_144
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_144_UNNAMED36864              = 36864, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_144
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_144_UNNAMED36864              = 36864, ///<
        };
        enum INVERSE_PIXEL_VALUE_144
        {
            INVERSE_PIXEL_VALUE_144_UNNAMED36864                             = 36864, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_144
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_144_UNNAMED36864              = 36864, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_144
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_144_UNNAMED36864              = 36864, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_144
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_144_UNNAMED36864              = 36864, ///<
        };
        enum FORWARD_PIXEL_VALUE_144
        {
            FORWARD_PIXEL_VALUE_144_UNNAMED36864                             = 36864, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_144
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_144_UNNAMED36864              = 36864, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_145
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_145_UNNAMED37120              = 37120, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_145
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_145_UNNAMED37120              = 37120, ///<
        };
        enum INVERSE_PIXEL_VALUE_145
        {
            INVERSE_PIXEL_VALUE_145_UNNAMED37120                             = 37120, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_145
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_145_UNNAMED37120              = 37120, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_145
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_145_UNNAMED37120              = 37120, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_145
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_145_UNNAMED37120              = 37120, ///<
        };
        enum FORWARD_PIXEL_VALUE_145
        {
            FORWARD_PIXEL_VALUE_145_UNNAMED37120                             = 37120, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_145
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_145_UNNAMED37120              = 37120, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_146
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_146_UNNAMED37376              = 37376, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_146
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_146_UNNAMED37376              = 37376, ///<
        };
        enum INVERSE_PIXEL_VALUE_146
        {
            INVERSE_PIXEL_VALUE_146_UNNAMED37376                             = 37376, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_146
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_146_UNNAMED37376              = 37376, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_146
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_146_UNNAMED37376              = 37376, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_146
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_146_UNNAMED37376              = 37376, ///<
        };
        enum FORWARD_PIXEL_VALUE_146
        {
            FORWARD_PIXEL_VALUE_146_UNNAMED37376                             = 37376, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_146
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_146_UNNAMED37376              = 37376, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_147
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_147_UNNAMED37632              = 37632, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_147
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_147_UNNAMED37632              = 37632, ///<
        };
        enum INVERSE_PIXEL_VALUE_147
        {
            INVERSE_PIXEL_VALUE_147_UNNAMED37632                             = 37632, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_147
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_147_UNNAMED37632              = 37632, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_147
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_147_UNNAMED37632              = 37632, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_147
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_147_UNNAMED37632              = 37632, ///<
        };
        enum FORWARD_PIXEL_VALUE_147
        {
            FORWARD_PIXEL_VALUE_147_UNNAMED37632                             = 37632, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_147
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_147_UNNAMED37632              = 37632, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_148
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_148_UNNAMED37888              = 37888, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_148
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_148_UNNAMED37888              = 37888, ///<
        };
        enum INVERSE_PIXEL_VALUE_148
        {
            INVERSE_PIXEL_VALUE_148_UNNAMED37888                             = 37888, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_148
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_148_UNNAMED37888              = 37888, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_148
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_148_UNNAMED37888              = 37888, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_148
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_148_UNNAMED37888              = 37888, ///<
        };
        enum FORWARD_PIXEL_VALUE_148
        {
            FORWARD_PIXEL_VALUE_148_UNNAMED37888                             = 37888, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_148
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_148_UNNAMED37888              = 37888, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_149
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_149_UNNAMED38144              = 38144, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_149
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_149_UNNAMED38144              = 38144, ///<
        };
        enum INVERSE_PIXEL_VALUE_149
        {
            INVERSE_PIXEL_VALUE_149_UNNAMED38144                             = 38144, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_149
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_149_UNNAMED38144              = 38144, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_149
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_149_UNNAMED38144              = 38144, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_149
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_149_UNNAMED38144              = 38144, ///<
        };
        enum FORWARD_PIXEL_VALUE_149
        {
            FORWARD_PIXEL_VALUE_149_UNNAMED38144                             = 38144, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_149
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_149_UNNAMED38144              = 38144, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_150
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_150_UNNAMED38400              = 38400, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_150
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_150_UNNAMED38400              = 38400, ///<
        };
        enum INVERSE_PIXEL_VALUE_150
        {
            INVERSE_PIXEL_VALUE_150_UNNAMED38400                             = 38400, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_150
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_150_UNNAMED38400              = 38400, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_150
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_150_UNNAMED38400              = 38400, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_150
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_150_UNNAMED38400              = 38400, ///<
        };
        enum FORWARD_PIXEL_VALUE_150
        {
            FORWARD_PIXEL_VALUE_150_UNNAMED38400                             = 38400, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_150
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_150_UNNAMED38400              = 38400, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_151
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_151_UNNAMED38656              = 38656, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_151
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_151_UNNAMED38656              = 38656, ///<
        };
        enum INVERSE_PIXEL_VALUE_151
        {
            INVERSE_PIXEL_VALUE_151_UNNAMED38656                             = 38656, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_151
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_151_UNNAMED38656              = 38656, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_151
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_151_UNNAMED38656              = 38656, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_151
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_151_UNNAMED38656              = 38656, ///<
        };
        enum FORWARD_PIXEL_VALUE_151
        {
            FORWARD_PIXEL_VALUE_151_UNNAMED38656                             = 38656, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_151
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_151_UNNAMED38656              = 38656, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_152
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_152_UNNAMED38912              = 38912, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_152
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_152_UNNAMED38912              = 38912, ///<
        };
        enum INVERSE_PIXEL_VALUE_152
        {
            INVERSE_PIXEL_VALUE_152_UNNAMED38912                             = 38912, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_152
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_152_UNNAMED38912              = 38912, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_152
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_152_UNNAMED38912              = 38912, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_152
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_152_UNNAMED38912              = 38912, ///<
        };
        enum FORWARD_PIXEL_VALUE_152
        {
            FORWARD_PIXEL_VALUE_152_UNNAMED38912                             = 38912, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_152
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_152_UNNAMED38912              = 38912, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_153
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_153_UNNAMED39168              = 39168, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_153
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_153_UNNAMED39168              = 39168, ///<
        };
        enum INVERSE_PIXEL_VALUE_153
        {
            INVERSE_PIXEL_VALUE_153_UNNAMED39168                             = 39168, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_153
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_153_UNNAMED39168              = 39168, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_153
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_153_UNNAMED39168              = 39168, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_153
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_153_UNNAMED39168              = 39168, ///<
        };
        enum FORWARD_PIXEL_VALUE_153
        {
            FORWARD_PIXEL_VALUE_153_UNNAMED39168                             = 39168, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_153
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_153_UNNAMED39168              = 39168, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_154
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_154_UNNAMED39424              = 39424, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_154
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_154_UNNAMED39424              = 39424, ///<
        };
        enum INVERSE_PIXEL_VALUE_154
        {
            INVERSE_PIXEL_VALUE_154_UNNAMED39424                             = 39424, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_154
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_154_UNNAMED39424              = 39424, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_154
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_154_UNNAMED39424              = 39424, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_154
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_154_UNNAMED39424              = 39424, ///<
        };
        enum FORWARD_PIXEL_VALUE_154
        {
            FORWARD_PIXEL_VALUE_154_UNNAMED39424                             = 39424, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_154
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_154_UNNAMED39424              = 39424, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_155
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_155_UNNAMED39680              = 39680, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_155
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_155_UNNAMED39680              = 39680, ///<
        };
        enum INVERSE_PIXEL_VALUE_155
        {
            INVERSE_PIXEL_VALUE_155_UNNAMED39680                             = 39680, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_155
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_155_UNNAMED39680              = 39680, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_155
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_155_UNNAMED39680              = 39680, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_155
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_155_UNNAMED39680              = 39680, ///<
        };
        enum FORWARD_PIXEL_VALUE_155
        {
            FORWARD_PIXEL_VALUE_155_UNNAMED39680                             = 39680, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_155
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_155_UNNAMED39680              = 39680, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_156
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_156_UNNAMED39936              = 39936, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_156
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_156_UNNAMED39936              = 39936, ///<
        };
        enum INVERSE_PIXEL_VALUE_156
        {
            INVERSE_PIXEL_VALUE_156_UNNAMED39936                             = 39936, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_156
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_156_UNNAMED39936              = 39936, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_156
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_156_UNNAMED39936              = 39936, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_156
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_156_UNNAMED39936              = 39936, ///<
        };
        enum FORWARD_PIXEL_VALUE_156
        {
            FORWARD_PIXEL_VALUE_156_UNNAMED39936                             = 39936, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_156
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_156_UNNAMED39936              = 39936, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_157
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_157_UNNAMED40192              = 40192, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_157
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_157_UNNAMED40192              = 40192, ///<
        };
        enum INVERSE_PIXEL_VALUE_157
        {
            INVERSE_PIXEL_VALUE_157_UNNAMED40192                             = 40192, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_157
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_157_UNNAMED40192              = 40192, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_157
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_157_UNNAMED40192              = 40192, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_157
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_157_UNNAMED40192              = 40192, ///<
        };
        enum FORWARD_PIXEL_VALUE_157
        {
            FORWARD_PIXEL_VALUE_157_UNNAMED40192                             = 40192, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_157
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_157_UNNAMED40192              = 40192, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_158
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_158_UNNAMED40448              = 40448, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_158
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_158_UNNAMED40448              = 40448, ///<
        };
        enum INVERSE_PIXEL_VALUE_158
        {
            INVERSE_PIXEL_VALUE_158_UNNAMED40448                             = 40448, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_158
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_158_UNNAMED40448              = 40448, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_158
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_158_UNNAMED40448              = 40448, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_158
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_158_UNNAMED40448              = 40448, ///<
        };
        enum FORWARD_PIXEL_VALUE_158
        {
            FORWARD_PIXEL_VALUE_158_UNNAMED40448                             = 40448, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_158
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_158_UNNAMED40448              = 40448, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_159
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_159_UNNAMED40704              = 40704, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_159
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_159_UNNAMED40704              = 40704, ///<
        };
        enum INVERSE_PIXEL_VALUE_159
        {
            INVERSE_PIXEL_VALUE_159_UNNAMED40704                             = 40704, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_159
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_159_UNNAMED40704              = 40704, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_159
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_159_UNNAMED40704              = 40704, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_159
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_159_UNNAMED40704              = 40704, ///<
        };
        enum FORWARD_PIXEL_VALUE_159
        {
            FORWARD_PIXEL_VALUE_159_UNNAMED40704                             = 40704, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_159
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_159_UNNAMED40704              = 40704, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_160
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_160_UNNAMED40960              = 40960, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_160
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_160_UNNAMED40960              = 40960, ///<
        };
        enum INVERSE_PIXEL_VALUE_160
        {
            INVERSE_PIXEL_VALUE_160_UNNAMED40960                             = 40960, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_160
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_160_UNNAMED40960              = 40960, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_160
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_160_UNNAMED40960              = 40960, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_160
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_160_UNNAMED40960              = 40960, ///<
        };
        enum FORWARD_PIXEL_VALUE_160
        {
            FORWARD_PIXEL_VALUE_160_UNNAMED40960                             = 40960, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_160
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_160_UNNAMED40960              = 40960, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_161
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_161_UNNAMED41216              = 41216, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_161
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_161_UNNAMED41216              = 41216, ///<
        };
        enum INVERSE_PIXEL_VALUE_161
        {
            INVERSE_PIXEL_VALUE_161_UNNAMED41216                             = 41216, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_161
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_161_UNNAMED41216              = 41216, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_161
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_161_UNNAMED41216              = 41216, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_161
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_161_UNNAMED41216              = 41216, ///<
        };
        enum FORWARD_PIXEL_VALUE_161
        {
            FORWARD_PIXEL_VALUE_161_UNNAMED41216                             = 41216, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_161
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_161_UNNAMED41216              = 41216, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_162
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_162_UNNAMED41472              = 41472, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_162
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_162_UNNAMED41472              = 41472, ///<
        };
        enum INVERSE_PIXEL_VALUE_162
        {
            INVERSE_PIXEL_VALUE_162_UNNAMED41472                             = 41472, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_162
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_162_UNNAMED41472              = 41472, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_162
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_162_UNNAMED41472              = 41472, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_162
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_162_UNNAMED41472              = 41472, ///<
        };
        enum FORWARD_PIXEL_VALUE_162
        {
            FORWARD_PIXEL_VALUE_162_UNNAMED41472                             = 41472, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_162
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_162_UNNAMED41472              = 41472, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_163
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_163_UNNAMED41728              = 41728, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_163
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_163_UNNAMED41728              = 41728, ///<
        };
        enum INVERSE_PIXEL_VALUE_163
        {
            INVERSE_PIXEL_VALUE_163_UNNAMED41728                             = 41728, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_163
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_163_UNNAMED41728              = 41728, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_163
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_163_UNNAMED41728              = 41728, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_163
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_163_UNNAMED41728              = 41728, ///<
        };
        enum FORWARD_PIXEL_VALUE_163
        {
            FORWARD_PIXEL_VALUE_163_UNNAMED41728                             = 41728, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_163
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_163_UNNAMED41728              = 41728, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_164
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_164_UNNAMED41984              = 41984, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_164
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_164_UNNAMED41984              = 41984, ///<
        };
        enum INVERSE_PIXEL_VALUE_164
        {
            INVERSE_PIXEL_VALUE_164_UNNAMED41984                             = 41984, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_164
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_164_UNNAMED41984              = 41984, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_164
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_164_UNNAMED41984              = 41984, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_164
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_164_UNNAMED41984              = 41984, ///<
        };
        enum FORWARD_PIXEL_VALUE_164
        {
            FORWARD_PIXEL_VALUE_164_UNNAMED41984                             = 41984, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_164
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_164_UNNAMED41984              = 41984, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_165
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_165_UNNAMED42240              = 42240, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_165
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_165_UNNAMED42240              = 42240, ///<
        };
        enum INVERSE_PIXEL_VALUE_165
        {
            INVERSE_PIXEL_VALUE_165_UNNAMED42240                             = 42240, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_165
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_165_UNNAMED42240              = 42240, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_165
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_165_UNNAMED42240              = 42240, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_165
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_165_UNNAMED42240              = 42240, ///<
        };
        enum FORWARD_PIXEL_VALUE_165
        {
            FORWARD_PIXEL_VALUE_165_UNNAMED42240                             = 42240, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_165
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_165_UNNAMED42240              = 42240, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_166
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_166_UNNAMED42496              = 42496, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_166
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_166_UNNAMED42496              = 42496, ///<
        };
        enum INVERSE_PIXEL_VALUE_166
        {
            INVERSE_PIXEL_VALUE_166_UNNAMED42496                             = 42496, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_166
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_166_UNNAMED42496              = 42496, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_166
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_166_UNNAMED42496              = 42496, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_166
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_166_UNNAMED42496              = 42496, ///<
        };
        enum FORWARD_PIXEL_VALUE_166
        {
            FORWARD_PIXEL_VALUE_166_UNNAMED42496                             = 42496, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_166
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_166_UNNAMED42496              = 42496, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_167
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_167_UNNAMED42752              = 42752, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_167
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_167_UNNAMED42752              = 42752, ///<
        };
        enum INVERSE_PIXEL_VALUE_167
        {
            INVERSE_PIXEL_VALUE_167_UNNAMED42752                             = 42752, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_167
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_167_UNNAMED42752              = 42752, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_167
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_167_UNNAMED42752              = 42752, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_167
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_167_UNNAMED42752              = 42752, ///<
        };
        enum FORWARD_PIXEL_VALUE_167
        {
            FORWARD_PIXEL_VALUE_167_UNNAMED42752                             = 42752, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_167
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_167_UNNAMED42752              = 42752, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_168
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_168_UNNAMED43008              = 43008, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_168
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_168_UNNAMED43008              = 43008, ///<
        };
        enum INVERSE_PIXEL_VALUE_168
        {
            INVERSE_PIXEL_VALUE_168_UNNAMED43008                             = 43008, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_168
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_168_UNNAMED43008              = 43008, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_168
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_168_UNNAMED43008              = 43008, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_168
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_168_UNNAMED43008              = 43008, ///<
        };
        enum FORWARD_PIXEL_VALUE_168
        {
            FORWARD_PIXEL_VALUE_168_UNNAMED43008                             = 43008, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_168
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_168_UNNAMED43008              = 43008, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_169
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_169_UNNAMED43264              = 43264, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_169
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_169_UNNAMED43264              = 43264, ///<
        };
        enum INVERSE_PIXEL_VALUE_169
        {
            INVERSE_PIXEL_VALUE_169_UNNAMED43264                             = 43264, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_169
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_169_UNNAMED43264              = 43264, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_169
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_169_UNNAMED43264              = 43264, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_169
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_169_UNNAMED43264              = 43264, ///<
        };
        enum FORWARD_PIXEL_VALUE_169
        {
            FORWARD_PIXEL_VALUE_169_UNNAMED43264                             = 43264, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_169
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_169_UNNAMED43264              = 43264, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_170
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_170_UNNAMED43520              = 43520, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_170
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_170_UNNAMED43520              = 43520, ///<
        };
        enum INVERSE_PIXEL_VALUE_170
        {
            INVERSE_PIXEL_VALUE_170_UNNAMED43520                             = 43520, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_170
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_170_UNNAMED43520              = 43520, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_170
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_170_UNNAMED43520              = 43520, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_170
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_170_UNNAMED43520              = 43520, ///<
        };
        enum FORWARD_PIXEL_VALUE_170
        {
            FORWARD_PIXEL_VALUE_170_UNNAMED43520                             = 43520, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_170
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_170_UNNAMED43520              = 43520, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_171
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_171_UNNAMED43776              = 43776, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_171
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_171_UNNAMED43776              = 43776, ///<
        };
        enum INVERSE_PIXEL_VALUE_171
        {
            INVERSE_PIXEL_VALUE_171_UNNAMED43776                             = 43776, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_171
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_171_UNNAMED43776              = 43776, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_171
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_171_UNNAMED43776              = 43776, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_171
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_171_UNNAMED43776              = 43776, ///<
        };
        enum FORWARD_PIXEL_VALUE_171
        {
            FORWARD_PIXEL_VALUE_171_UNNAMED43776                             = 43776, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_171
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_171_UNNAMED43776              = 43776, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_172
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_172_UNNAMED44032              = 44032, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_172
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_172_UNNAMED44032              = 44032, ///<
        };
        enum INVERSE_PIXEL_VALUE_172
        {
            INVERSE_PIXEL_VALUE_172_UNNAMED44032                             = 44032, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_172
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_172_UNNAMED44032              = 44032, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_172
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_172_UNNAMED44032              = 44032, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_172
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_172_UNNAMED44032              = 44032, ///<
        };
        enum FORWARD_PIXEL_VALUE_172
        {
            FORWARD_PIXEL_VALUE_172_UNNAMED44032                             = 44032, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_172
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_172_UNNAMED44032              = 44032, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_173
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_173_UNNAMED44288              = 44288, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_173
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_173_UNNAMED44288              = 44288, ///<
        };
        enum INVERSE_PIXEL_VALUE_173
        {
            INVERSE_PIXEL_VALUE_173_UNNAMED44288                             = 44288, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_173
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_173_UNNAMED44288              = 44288, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_173
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_173_UNNAMED44288              = 44288, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_173
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_173_UNNAMED44288              = 44288, ///<
        };
        enum FORWARD_PIXEL_VALUE_173
        {
            FORWARD_PIXEL_VALUE_173_UNNAMED44288                             = 44288, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_173
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_173_UNNAMED44288              = 44288, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_174
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_174_UNNAMED44544              = 44544, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_174
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_174_UNNAMED44544              = 44544, ///<
        };
        enum INVERSE_PIXEL_VALUE_174
        {
            INVERSE_PIXEL_VALUE_174_UNNAMED44544                             = 44544, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_174
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_174_UNNAMED44544              = 44544, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_174
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_174_UNNAMED44544              = 44544, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_174
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_174_UNNAMED44544              = 44544, ///<
        };
        enum FORWARD_PIXEL_VALUE_174
        {
            FORWARD_PIXEL_VALUE_174_UNNAMED44544                             = 44544, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_174
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_174_UNNAMED44544              = 44544, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_175
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_175_UNNAMED44800              = 44800, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_175
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_175_UNNAMED44800              = 44800, ///<
        };
        enum INVERSE_PIXEL_VALUE_175
        {
            INVERSE_PIXEL_VALUE_175_UNNAMED44800                             = 44800, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_175
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_175_UNNAMED44800              = 44800, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_175
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_175_UNNAMED44800              = 44800, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_175
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_175_UNNAMED44800              = 44800, ///<
        };
        enum FORWARD_PIXEL_VALUE_175
        {
            FORWARD_PIXEL_VALUE_175_UNNAMED44800                             = 44800, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_175
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_175_UNNAMED44800              = 44800, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_176
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_176_UNNAMED45056              = 45056, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_176
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_176_UNNAMED45056              = 45056, ///<
        };
        enum INVERSE_PIXEL_VALUE_176
        {
            INVERSE_PIXEL_VALUE_176_UNNAMED45056                             = 45056, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_176
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_176_UNNAMED45056              = 45056, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_176
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_176_UNNAMED45056              = 45056, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_176
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_176_UNNAMED45056              = 45056, ///<
        };
        enum FORWARD_PIXEL_VALUE_176
        {
            FORWARD_PIXEL_VALUE_176_UNNAMED45056                             = 45056, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_176
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_176_UNNAMED45056              = 45056, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_177
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_177_UNNAMED45312              = 45312, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_177
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_177_UNNAMED45312              = 45312, ///<
        };
        enum INVERSE_PIXEL_VALUE_177
        {
            INVERSE_PIXEL_VALUE_177_UNNAMED45312                             = 45312, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_177
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_177_UNNAMED45312              = 45312, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_177
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_177_UNNAMED45312              = 45312, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_177
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_177_UNNAMED45312              = 45312, ///<
        };
        enum FORWARD_PIXEL_VALUE_177
        {
            FORWARD_PIXEL_VALUE_177_UNNAMED45312                             = 45312, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_177
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_177_UNNAMED45312              = 45312, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_178
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_178_UNNAMED45568              = 45568, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_178
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_178_UNNAMED45568              = 45568, ///<
        };
        enum INVERSE_PIXEL_VALUE_178
        {
            INVERSE_PIXEL_VALUE_178_UNNAMED45568                             = 45568, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_178
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_178_UNNAMED45568              = 45568, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_178
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_178_UNNAMED45568              = 45568, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_178
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_178_UNNAMED45568              = 45568, ///<
        };
        enum FORWARD_PIXEL_VALUE_178
        {
            FORWARD_PIXEL_VALUE_178_UNNAMED45568                             = 45568, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_178
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_178_UNNAMED45568              = 45568, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_179
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_179_UNNAMED45824              = 45824, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_179
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_179_UNNAMED45824              = 45824, ///<
        };
        enum INVERSE_PIXEL_VALUE_179
        {
            INVERSE_PIXEL_VALUE_179_UNNAMED45824                             = 45824, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_179
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_179_UNNAMED45824              = 45824, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_179
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_179_UNNAMED45824              = 45824, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_179
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_179_UNNAMED45824              = 45824, ///<
        };
        enum FORWARD_PIXEL_VALUE_179
        {
            FORWARD_PIXEL_VALUE_179_UNNAMED45824                             = 45824, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_179
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_179_UNNAMED45824              = 45824, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_180
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_180_UNNAMED46080              = 46080, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_180
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_180_UNNAMED46080              = 46080, ///<
        };
        enum INVERSE_PIXEL_VALUE_180
        {
            INVERSE_PIXEL_VALUE_180_UNNAMED46080                             = 46080, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_180
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_180_UNNAMED46080              = 46080, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_180
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_180_UNNAMED46080              = 46080, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_180
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_180_UNNAMED46080              = 46080, ///<
        };
        enum FORWARD_PIXEL_VALUE_180
        {
            FORWARD_PIXEL_VALUE_180_UNNAMED46080                             = 46080, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_180
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_180_UNNAMED46080              = 46080, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_181
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_181_UNNAMED46336              = 46336, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_181
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_181_UNNAMED46336              = 46336, ///<
        };
        enum INVERSE_PIXEL_VALUE_181
        {
            INVERSE_PIXEL_VALUE_181_UNNAMED46336                             = 46336, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_181
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_181_UNNAMED46336              = 46336, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_181
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_181_UNNAMED46336              = 46336, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_181
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_181_UNNAMED46336              = 46336, ///<
        };
        enum FORWARD_PIXEL_VALUE_181
        {
            FORWARD_PIXEL_VALUE_181_UNNAMED46336                             = 46336, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_181
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_181_UNNAMED46336              = 46336, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_182
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_182_UNNAMED46592              = 46592, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_182
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_182_UNNAMED46592              = 46592, ///<
        };
        enum INVERSE_PIXEL_VALUE_182
        {
            INVERSE_PIXEL_VALUE_182_UNNAMED46592                             = 46592, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_182
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_182_UNNAMED46592              = 46592, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_182
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_182_UNNAMED46592              = 46592, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_182
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_182_UNNAMED46592              = 46592, ///<
        };
        enum FORWARD_PIXEL_VALUE_182
        {
            FORWARD_PIXEL_VALUE_182_UNNAMED46592                             = 46592, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_182
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_182_UNNAMED46592              = 46592, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_183
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_183_UNNAMED46848              = 46848, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_183
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_183_UNNAMED46848              = 46848, ///<
        };
        enum INVERSE_PIXEL_VALUE_183
        {
            INVERSE_PIXEL_VALUE_183_UNNAMED46848                             = 46848, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_183
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_183_UNNAMED46848              = 46848, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_183
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_183_UNNAMED46848              = 46848, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_183
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_183_UNNAMED46848              = 46848, ///<
        };
        enum FORWARD_PIXEL_VALUE_183
        {
            FORWARD_PIXEL_VALUE_183_UNNAMED46848                             = 46848, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_183
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_183_UNNAMED46848              = 46848, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_184
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_184_UNNAMED47104              = 47104, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_184
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_184_UNNAMED47104              = 47104, ///<
        };
        enum INVERSE_PIXEL_VALUE_184
        {
            INVERSE_PIXEL_VALUE_184_UNNAMED47104                             = 47104, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_184
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_184_UNNAMED47104              = 47104, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_184
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_184_UNNAMED47104              = 47104, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_184
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_184_UNNAMED47104              = 47104, ///<
        };
        enum FORWARD_PIXEL_VALUE_184
        {
            FORWARD_PIXEL_VALUE_184_UNNAMED47104                             = 47104, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_184
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_184_UNNAMED47104              = 47104, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_185
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_185_UNNAMED47360              = 47360, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_185
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_185_UNNAMED47360              = 47360, ///<
        };
        enum INVERSE_PIXEL_VALUE_185
        {
            INVERSE_PIXEL_VALUE_185_UNNAMED47360                             = 47360, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_185
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_185_UNNAMED47360              = 47360, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_185
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_185_UNNAMED47360              = 47360, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_185
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_185_UNNAMED47360              = 47360, ///<
        };
        enum FORWARD_PIXEL_VALUE_185
        {
            FORWARD_PIXEL_VALUE_185_UNNAMED47360                             = 47360, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_185
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_185_UNNAMED47360              = 47360, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_186
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_186_UNNAMED47616              = 47616, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_186
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_186_UNNAMED47616              = 47616, ///<
        };
        enum INVERSE_PIXEL_VALUE_186
        {
            INVERSE_PIXEL_VALUE_186_UNNAMED47616                             = 47616, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_186
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_186_UNNAMED47616              = 47616, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_186
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_186_UNNAMED47616              = 47616, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_186
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_186_UNNAMED47616              = 47616, ///<
        };
        enum FORWARD_PIXEL_VALUE_186
        {
            FORWARD_PIXEL_VALUE_186_UNNAMED47616                             = 47616, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_186
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_186_UNNAMED47616              = 47616, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_187
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_187_UNNAMED47872              = 47872, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_187
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_187_UNNAMED47872              = 47872, ///<
        };
        enum INVERSE_PIXEL_VALUE_187
        {
            INVERSE_PIXEL_VALUE_187_UNNAMED47872                             = 47872, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_187
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_187_UNNAMED47872              = 47872, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_187
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_187_UNNAMED47872              = 47872, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_187
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_187_UNNAMED47872              = 47872, ///<
        };
        enum FORWARD_PIXEL_VALUE_187
        {
            FORWARD_PIXEL_VALUE_187_UNNAMED47872                             = 47872, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_187
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_187_UNNAMED47872              = 47872, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_188
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_188_UNNAMED48128              = 48128, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_188
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_188_UNNAMED48128              = 48128, ///<
        };
        enum INVERSE_PIXEL_VALUE_188
        {
            INVERSE_PIXEL_VALUE_188_UNNAMED48128                             = 48128, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_188
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_188_UNNAMED48128              = 48128, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_188
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_188_UNNAMED48128              = 48128, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_188
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_188_UNNAMED48128              = 48128, ///<
        };
        enum FORWARD_PIXEL_VALUE_188
        {
            FORWARD_PIXEL_VALUE_188_UNNAMED48128                             = 48128, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_188
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_188_UNNAMED48128              = 48128, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_189
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_189_UNNAMED48384              = 48384, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_189
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_189_UNNAMED48384              = 48384, ///<
        };
        enum INVERSE_PIXEL_VALUE_189
        {
            INVERSE_PIXEL_VALUE_189_UNNAMED48384                             = 48384, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_189
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_189_UNNAMED48384              = 48384, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_189
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_189_UNNAMED48384              = 48384, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_189
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_189_UNNAMED48384              = 48384, ///<
        };
        enum FORWARD_PIXEL_VALUE_189
        {
            FORWARD_PIXEL_VALUE_189_UNNAMED48384                             = 48384, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_189
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_189_UNNAMED48384              = 48384, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_190
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_190_UNNAMED48640              = 48640, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_190
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_190_UNNAMED48640              = 48640, ///<
        };
        enum INVERSE_PIXEL_VALUE_190
        {
            INVERSE_PIXEL_VALUE_190_UNNAMED48640                             = 48640, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_190
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_190_UNNAMED48640              = 48640, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_190
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_190_UNNAMED48640              = 48640, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_190
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_190_UNNAMED48640              = 48640, ///<
        };
        enum FORWARD_PIXEL_VALUE_190
        {
            FORWARD_PIXEL_VALUE_190_UNNAMED48640                             = 48640, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_190
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_190_UNNAMED48640              = 48640, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_191
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_191_UNNAMED48896              = 48896, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_191
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_191_UNNAMED48896              = 48896, ///<
        };
        enum INVERSE_PIXEL_VALUE_191
        {
            INVERSE_PIXEL_VALUE_191_UNNAMED48896                             = 48896, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_191
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_191_UNNAMED48896              = 48896, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_191
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_191_UNNAMED48896              = 48896, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_191
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_191_UNNAMED48896              = 48896, ///<
        };
        enum FORWARD_PIXEL_VALUE_191
        {
            FORWARD_PIXEL_VALUE_191_UNNAMED48896                             = 48896, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_191
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_191_UNNAMED48896              = 48896, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_192
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_192_UNNAMED49152              = 49152, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_192
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_192_UNNAMED49152              = 49152, ///<
        };
        enum INVERSE_PIXEL_VALUE_192
        {
            INVERSE_PIXEL_VALUE_192_UNNAMED49152                             = 49152, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_192
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_192_UNNAMED49152              = 49152, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_192
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_192_UNNAMED49152              = 49152, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_192
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_192_UNNAMED49152              = 49152, ///<
        };
        enum FORWARD_PIXEL_VALUE_192
        {
            FORWARD_PIXEL_VALUE_192_UNNAMED49152                             = 49152, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_192
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_192_UNNAMED49152              = 49152, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_193
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_193_UNNAMED49408              = 49408, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_193
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_193_UNNAMED49408              = 49408, ///<
        };
        enum INVERSE_PIXEL_VALUE_193
        {
            INVERSE_PIXEL_VALUE_193_UNNAMED49408                             = 49408, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_193
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_193_UNNAMED49408              = 49408, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_193
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_193_UNNAMED49408              = 49408, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_193
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_193_UNNAMED49408              = 49408, ///<
        };
        enum FORWARD_PIXEL_VALUE_193
        {
            FORWARD_PIXEL_VALUE_193_UNNAMED49408                             = 49408, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_193
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_193_UNNAMED49408              = 49408, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_194
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_194_UNNAMED49664              = 49664, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_194
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_194_UNNAMED49664              = 49664, ///<
        };
        enum INVERSE_PIXEL_VALUE_194
        {
            INVERSE_PIXEL_VALUE_194_UNNAMED49664                             = 49664, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_194
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_194_UNNAMED49664              = 49664, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_194
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_194_UNNAMED49664              = 49664, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_194
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_194_UNNAMED49664              = 49664, ///<
        };
        enum FORWARD_PIXEL_VALUE_194
        {
            FORWARD_PIXEL_VALUE_194_UNNAMED49664                             = 49664, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_194
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_194_UNNAMED49664              = 49664, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_195
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_195_UNNAMED49920              = 49920, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_195
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_195_UNNAMED49920              = 49920, ///<
        };
        enum INVERSE_PIXEL_VALUE_195
        {
            INVERSE_PIXEL_VALUE_195_UNNAMED49920                             = 49920, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_195
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_195_UNNAMED49920              = 49920, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_195
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_195_UNNAMED49920              = 49920, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_195
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_195_UNNAMED49920              = 49920, ///<
        };
        enum FORWARD_PIXEL_VALUE_195
        {
            FORWARD_PIXEL_VALUE_195_UNNAMED49920                             = 49920, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_195
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_195_UNNAMED49920              = 49920, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_196
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_196_UNNAMED50176              = 50176, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_196
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_196_UNNAMED50176              = 50176, ///<
        };
        enum INVERSE_PIXEL_VALUE_196
        {
            INVERSE_PIXEL_VALUE_196_UNNAMED50176                             = 50176, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_196
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_196_UNNAMED50176              = 50176, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_196
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_196_UNNAMED50176              = 50176, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_196
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_196_UNNAMED50176              = 50176, ///<
        };
        enum FORWARD_PIXEL_VALUE_196
        {
            FORWARD_PIXEL_VALUE_196_UNNAMED50176                             = 50176, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_196
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_196_UNNAMED50176              = 50176, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_197
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_197_UNNAMED50432              = 50432, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_197
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_197_UNNAMED50432              = 50432, ///<
        };
        enum INVERSE_PIXEL_VALUE_197
        {
            INVERSE_PIXEL_VALUE_197_UNNAMED50432                             = 50432, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_197
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_197_UNNAMED50432              = 50432, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_197
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_197_UNNAMED50432              = 50432, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_197
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_197_UNNAMED50432              = 50432, ///<
        };
        enum FORWARD_PIXEL_VALUE_197
        {
            FORWARD_PIXEL_VALUE_197_UNNAMED50432                             = 50432, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_197
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_197_UNNAMED50432              = 50432, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_198
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_198_UNNAMED50688              = 50688, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_198
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_198_UNNAMED50688              = 50688, ///<
        };
        enum INVERSE_PIXEL_VALUE_198
        {
            INVERSE_PIXEL_VALUE_198_UNNAMED50688                             = 50688, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_198
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_198_UNNAMED50688              = 50688, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_198
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_198_UNNAMED50688              = 50688, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_198
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_198_UNNAMED50688              = 50688, ///<
        };
        enum FORWARD_PIXEL_VALUE_198
        {
            FORWARD_PIXEL_VALUE_198_UNNAMED50688                             = 50688, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_198
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_198_UNNAMED50688              = 50688, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_199
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_199_UNNAMED50944              = 50944, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_199
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_199_UNNAMED50944              = 50944, ///<
        };
        enum INVERSE_PIXEL_VALUE_199
        {
            INVERSE_PIXEL_VALUE_199_UNNAMED50944                             = 50944, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_199
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_199_UNNAMED50944              = 50944, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_199
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_199_UNNAMED50944              = 50944, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_199
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_199_UNNAMED50944              = 50944, ///<
        };
        enum FORWARD_PIXEL_VALUE_199
        {
            FORWARD_PIXEL_VALUE_199_UNNAMED50944                             = 50944, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_199
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_199_UNNAMED50944              = 50944, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_200
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_200_UNNAMED51200              = 51200, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_200
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_200_UNNAMED51200              = 51200, ///<
        };
        enum INVERSE_PIXEL_VALUE_200
        {
            INVERSE_PIXEL_VALUE_200_UNNAMED51200                             = 51200, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_200
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_200_UNNAMED51200              = 51200, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_200
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_200_UNNAMED51200              = 51200, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_200
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_200_UNNAMED51200              = 51200, ///<
        };
        enum FORWARD_PIXEL_VALUE_200
        {
            FORWARD_PIXEL_VALUE_200_UNNAMED51200                             = 51200, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_200
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_200_UNNAMED51200              = 51200, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_201
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_201_UNNAMED51456              = 51456, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_201
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_201_UNNAMED51456              = 51456, ///<
        };
        enum INVERSE_PIXEL_VALUE_201
        {
            INVERSE_PIXEL_VALUE_201_UNNAMED51456                             = 51456, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_201
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_201_UNNAMED51456              = 51456, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_201
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_201_UNNAMED51456              = 51456, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_201
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_201_UNNAMED51456              = 51456, ///<
        };
        enum FORWARD_PIXEL_VALUE_201
        {
            FORWARD_PIXEL_VALUE_201_UNNAMED51456                             = 51456, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_201
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_201_UNNAMED51456              = 51456, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_202
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_202_UNNAMED51712              = 51712, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_202
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_202_UNNAMED51712              = 51712, ///<
        };
        enum INVERSE_PIXEL_VALUE_202
        {
            INVERSE_PIXEL_VALUE_202_UNNAMED51712                             = 51712, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_202
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_202_UNNAMED51712              = 51712, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_202
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_202_UNNAMED51712              = 51712, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_202
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_202_UNNAMED51712              = 51712, ///<
        };
        enum FORWARD_PIXEL_VALUE_202
        {
            FORWARD_PIXEL_VALUE_202_UNNAMED51712                             = 51712, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_202
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_202_UNNAMED51712              = 51712, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_203
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_203_UNNAMED51968              = 51968, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_203
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_203_UNNAMED51968              = 51968, ///<
        };
        enum INVERSE_PIXEL_VALUE_203
        {
            INVERSE_PIXEL_VALUE_203_UNNAMED51968                             = 51968, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_203
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_203_UNNAMED51968              = 51968, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_203
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_203_UNNAMED51968              = 51968, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_203
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_203_UNNAMED51968              = 51968, ///<
        };
        enum FORWARD_PIXEL_VALUE_203
        {
            FORWARD_PIXEL_VALUE_203_UNNAMED51968                             = 51968, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_203
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_203_UNNAMED51968              = 51968, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_204
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_204_UNNAMED52224              = 52224, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_204
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_204_UNNAMED52224              = 52224, ///<
        };
        enum INVERSE_PIXEL_VALUE_204
        {
            INVERSE_PIXEL_VALUE_204_UNNAMED52224                             = 52224, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_204
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_204_UNNAMED52224              = 52224, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_204
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_204_UNNAMED52224              = 52224, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_204
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_204_UNNAMED52224              = 52224, ///<
        };
        enum FORWARD_PIXEL_VALUE_204
        {
            FORWARD_PIXEL_VALUE_204_UNNAMED52224                             = 52224, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_204
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_204_UNNAMED52224              = 52224, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_205
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_205_UNNAMED52480              = 52480, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_205
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_205_UNNAMED52480              = 52480, ///<
        };
        enum INVERSE_PIXEL_VALUE_205
        {
            INVERSE_PIXEL_VALUE_205_UNNAMED52480                             = 52480, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_205
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_205_UNNAMED52480              = 52480, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_205
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_205_UNNAMED52480              = 52480, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_205
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_205_UNNAMED52480              = 52480, ///<
        };
        enum FORWARD_PIXEL_VALUE_205
        {
            FORWARD_PIXEL_VALUE_205_UNNAMED52480                             = 52480, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_205
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_205_UNNAMED52480              = 52480, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_206
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_206_UNNAMED52736              = 52736, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_206
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_206_UNNAMED52736              = 52736, ///<
        };
        enum INVERSE_PIXEL_VALUE_206
        {
            INVERSE_PIXEL_VALUE_206_UNNAMED52736                             = 52736, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_206
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_206_UNNAMED52736              = 52736, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_206
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_206_UNNAMED52736              = 52736, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_206
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_206_UNNAMED52736              = 52736, ///<
        };
        enum FORWARD_PIXEL_VALUE_206
        {
            FORWARD_PIXEL_VALUE_206_UNNAMED52736                             = 52736, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_206
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_206_UNNAMED52736              = 52736, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_207
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_207_UNNAMED52992              = 52992, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_207
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_207_UNNAMED52992              = 52992, ///<
        };
        enum INVERSE_PIXEL_VALUE_207
        {
            INVERSE_PIXEL_VALUE_207_UNNAMED52992                             = 52992, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_207
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_207_UNNAMED52992              = 52992, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_207
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_207_UNNAMED52992              = 52992, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_207
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_207_UNNAMED52992              = 52992, ///<
        };
        enum FORWARD_PIXEL_VALUE_207
        {
            FORWARD_PIXEL_VALUE_207_UNNAMED52992                             = 52992, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_207
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_207_UNNAMED52992              = 52992, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_208
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_208_UNNAMED53248              = 53248, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_208
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_208_UNNAMED53248              = 53248, ///<
        };
        enum INVERSE_PIXEL_VALUE_208
        {
            INVERSE_PIXEL_VALUE_208_UNNAMED53248                             = 53248, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_208
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_208_UNNAMED53248              = 53248, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_208
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_208_UNNAMED53248              = 53248, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_208
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_208_UNNAMED53248              = 53248, ///<
        };
        enum FORWARD_PIXEL_VALUE_208
        {
            FORWARD_PIXEL_VALUE_208_UNNAMED53248                             = 53248, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_208
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_208_UNNAMED53248              = 53248, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_209
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_209_UNNAMED53504              = 53504, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_209
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_209_UNNAMED53504              = 53504, ///<
        };
        enum INVERSE_PIXEL_VALUE_209
        {
            INVERSE_PIXEL_VALUE_209_UNNAMED53504                             = 53504, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_209
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_209_UNNAMED53504              = 53504, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_209
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_209_UNNAMED53504              = 53504, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_209
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_209_UNNAMED53504              = 53504, ///<
        };
        enum FORWARD_PIXEL_VALUE_209
        {
            FORWARD_PIXEL_VALUE_209_UNNAMED53504                             = 53504, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_209
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_209_UNNAMED53504              = 53504, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_210
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_210_UNNAMED53760              = 53760, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_210
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_210_UNNAMED53760              = 53760, ///<
        };
        enum INVERSE_PIXEL_VALUE_210
        {
            INVERSE_PIXEL_VALUE_210_UNNAMED53760                             = 53760, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_210
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_210_UNNAMED53760              = 53760, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_210
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_210_UNNAMED53760              = 53760, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_210
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_210_UNNAMED53760              = 53760, ///<
        };
        enum FORWARD_PIXEL_VALUE_210
        {
            FORWARD_PIXEL_VALUE_210_UNNAMED53760                             = 53760, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_210
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_210_UNNAMED53760              = 53760, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_211
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_211_UNNAMED54016              = 54016, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_211
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_211_UNNAMED54016              = 54016, ///<
        };
        enum INVERSE_PIXEL_VALUE_211
        {
            INVERSE_PIXEL_VALUE_211_UNNAMED54016                             = 54016, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_211
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_211_UNNAMED54016              = 54016, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_211
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_211_UNNAMED54016              = 54016, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_211
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_211_UNNAMED54016              = 54016, ///<
        };
        enum FORWARD_PIXEL_VALUE_211
        {
            FORWARD_PIXEL_VALUE_211_UNNAMED54016                             = 54016, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_211
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_211_UNNAMED54016              = 54016, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_212
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_212_UNNAMED54272              = 54272, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_212
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_212_UNNAMED54272              = 54272, ///<
        };
        enum INVERSE_PIXEL_VALUE_212
        {
            INVERSE_PIXEL_VALUE_212_UNNAMED54272                             = 54272, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_212
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_212_UNNAMED54272              = 54272, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_212
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_212_UNNAMED54272              = 54272, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_212
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_212_UNNAMED54272              = 54272, ///<
        };
        enum FORWARD_PIXEL_VALUE_212
        {
            FORWARD_PIXEL_VALUE_212_UNNAMED54272                             = 54272, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_212
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_212_UNNAMED54272              = 54272, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_213
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_213_UNNAMED54528              = 54528, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_213
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_213_UNNAMED54528              = 54528, ///<
        };
        enum INVERSE_PIXEL_VALUE_213
        {
            INVERSE_PIXEL_VALUE_213_UNNAMED54528                             = 54528, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_213
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_213_UNNAMED54528              = 54528, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_213
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_213_UNNAMED54528              = 54528, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_213
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_213_UNNAMED54528              = 54528, ///<
        };
        enum FORWARD_PIXEL_VALUE_213
        {
            FORWARD_PIXEL_VALUE_213_UNNAMED54528                             = 54528, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_213
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_213_UNNAMED54528              = 54528, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_214
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_214_UNNAMED54784              = 54784, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_214
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_214_UNNAMED54784              = 54784, ///<
        };
        enum INVERSE_PIXEL_VALUE_214
        {
            INVERSE_PIXEL_VALUE_214_UNNAMED54784                             = 54784, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_214
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_214_UNNAMED54784              = 54784, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_214
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_214_UNNAMED54784              = 54784, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_214
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_214_UNNAMED54784              = 54784, ///<
        };
        enum FORWARD_PIXEL_VALUE_214
        {
            FORWARD_PIXEL_VALUE_214_UNNAMED54784                             = 54784, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_214
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_214_UNNAMED54784              = 54784, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_215
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_215_UNNAMED55040              = 55040, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_215
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_215_UNNAMED55040              = 55040, ///<
        };
        enum INVERSE_PIXEL_VALUE_215
        {
            INVERSE_PIXEL_VALUE_215_UNNAMED55040                             = 55040, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_215
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_215_UNNAMED55040              = 55040, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_215
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_215_UNNAMED55040              = 55040, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_215
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_215_UNNAMED55040              = 55040, ///<
        };
        enum FORWARD_PIXEL_VALUE_215
        {
            FORWARD_PIXEL_VALUE_215_UNNAMED55040                             = 55040, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_215
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_215_UNNAMED55040              = 55040, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_216
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_216_UNNAMED55296              = 55296, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_216
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_216_UNNAMED55296              = 55296, ///<
        };
        enum INVERSE_PIXEL_VALUE_216
        {
            INVERSE_PIXEL_VALUE_216_UNNAMED55296                             = 55296, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_216
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_216_UNNAMED55296              = 55296, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_216
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_216_UNNAMED55296              = 55296, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_216
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_216_UNNAMED55296              = 55296, ///<
        };
        enum FORWARD_PIXEL_VALUE_216
        {
            FORWARD_PIXEL_VALUE_216_UNNAMED55296                             = 55296, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_216
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_216_UNNAMED55296              = 55296, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_217
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_217_UNNAMED55552              = 55552, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_217
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_217_UNNAMED55552              = 55552, ///<
        };
        enum INVERSE_PIXEL_VALUE_217
        {
            INVERSE_PIXEL_VALUE_217_UNNAMED55552                             = 55552, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_217
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_217_UNNAMED55552              = 55552, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_217
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_217_UNNAMED55552              = 55552, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_217
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_217_UNNAMED55552              = 55552, ///<
        };
        enum FORWARD_PIXEL_VALUE_217
        {
            FORWARD_PIXEL_VALUE_217_UNNAMED55552                             = 55552, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_217
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_217_UNNAMED55552              = 55552, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_218
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_218_UNNAMED55808              = 55808, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_218
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_218_UNNAMED55808              = 55808, ///<
        };
        enum INVERSE_PIXEL_VALUE_218
        {
            INVERSE_PIXEL_VALUE_218_UNNAMED55808                             = 55808, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_218
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_218_UNNAMED55808              = 55808, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_218
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_218_UNNAMED55808              = 55808, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_218
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_218_UNNAMED55808              = 55808, ///<
        };
        enum FORWARD_PIXEL_VALUE_218
        {
            FORWARD_PIXEL_VALUE_218_UNNAMED55808                             = 55808, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_218
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_218_UNNAMED55808              = 55808, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_219
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_219_UNNAMED56064              = 56064, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_219
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_219_UNNAMED56064              = 56064, ///<
        };
        enum INVERSE_PIXEL_VALUE_219
        {
            INVERSE_PIXEL_VALUE_219_UNNAMED56064                             = 56064, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_219
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_219_UNNAMED56064              = 56064, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_219
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_219_UNNAMED56064              = 56064, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_219
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_219_UNNAMED56064              = 56064, ///<
        };
        enum FORWARD_PIXEL_VALUE_219
        {
            FORWARD_PIXEL_VALUE_219_UNNAMED56064                             = 56064, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_219
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_219_UNNAMED56064              = 56064, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_220
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_220_UNNAMED56320              = 56320, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_220
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_220_UNNAMED56320              = 56320, ///<
        };
        enum INVERSE_PIXEL_VALUE_220
        {
            INVERSE_PIXEL_VALUE_220_UNNAMED56320                             = 56320, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_220
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_220_UNNAMED56320              = 56320, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_220
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_220_UNNAMED56320              = 56320, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_220
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_220_UNNAMED56320              = 56320, ///<
        };
        enum FORWARD_PIXEL_VALUE_220
        {
            FORWARD_PIXEL_VALUE_220_UNNAMED56320                             = 56320, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_220
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_220_UNNAMED56320              = 56320, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_221
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_221_UNNAMED56576              = 56576, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_221
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_221_UNNAMED56576              = 56576, ///<
        };
        enum INVERSE_PIXEL_VALUE_221
        {
            INVERSE_PIXEL_VALUE_221_UNNAMED56576                             = 56576, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_221
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_221_UNNAMED56576              = 56576, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_221
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_221_UNNAMED56576              = 56576, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_221
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_221_UNNAMED56576              = 56576, ///<
        };
        enum FORWARD_PIXEL_VALUE_221
        {
            FORWARD_PIXEL_VALUE_221_UNNAMED56576                             = 56576, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_221
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_221_UNNAMED56576              = 56576, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_222
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_222_UNNAMED56832              = 56832, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_222
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_222_UNNAMED56832              = 56832, ///<
        };
        enum INVERSE_PIXEL_VALUE_222
        {
            INVERSE_PIXEL_VALUE_222_UNNAMED56832                             = 56832, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_222
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_222_UNNAMED56832              = 56832, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_222
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_222_UNNAMED56832              = 56832, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_222
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_222_UNNAMED56832              = 56832, ///<
        };
        enum FORWARD_PIXEL_VALUE_222
        {
            FORWARD_PIXEL_VALUE_222_UNNAMED56832                             = 56832, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_222
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_222_UNNAMED56832              = 56832, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_223
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_223_UNNAMED57088              = 57088, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_223
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_223_UNNAMED57088              = 57088, ///<
        };
        enum INVERSE_PIXEL_VALUE_223
        {
            INVERSE_PIXEL_VALUE_223_UNNAMED57088                             = 57088, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_223
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_223_UNNAMED57088              = 57088, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_223
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_223_UNNAMED57088              = 57088, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_223
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_223_UNNAMED57088              = 57088, ///<
        };
        enum FORWARD_PIXEL_VALUE_223
        {
            FORWARD_PIXEL_VALUE_223_UNNAMED57088                             = 57088, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_223
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_223_UNNAMED57088              = 57088, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_224
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_224_UNNAMED57344              = 57344, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_224
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_224_UNNAMED57344              = 57344, ///<
        };
        enum INVERSE_PIXEL_VALUE_224
        {
            INVERSE_PIXEL_VALUE_224_UNNAMED57344                             = 57344, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_224
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_224_UNNAMED57344              = 57344, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_224
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_224_UNNAMED57344              = 57344, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_224
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_224_UNNAMED57344              = 57344, ///<
        };
        enum FORWARD_PIXEL_VALUE_224
        {
            FORWARD_PIXEL_VALUE_224_UNNAMED57344                             = 57344, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_224
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_224_UNNAMED57344              = 57344, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_225
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_225_UNNAMED57600              = 57600, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_225
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_225_UNNAMED57600              = 57600, ///<
        };
        enum INVERSE_PIXEL_VALUE_225
        {
            INVERSE_PIXEL_VALUE_225_UNNAMED57600                             = 57600, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_225
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_225_UNNAMED57600              = 57600, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_225
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_225_UNNAMED57600              = 57600, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_225
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_225_UNNAMED57600              = 57600, ///<
        };
        enum FORWARD_PIXEL_VALUE_225
        {
            FORWARD_PIXEL_VALUE_225_UNNAMED57600                             = 57600, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_225
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_225_UNNAMED57600              = 57600, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_226
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_226_UNNAMED57856              = 57856, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_226
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_226_UNNAMED57856              = 57856, ///<
        };
        enum INVERSE_PIXEL_VALUE_226
        {
            INVERSE_PIXEL_VALUE_226_UNNAMED57856                             = 57856, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_226
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_226_UNNAMED57856              = 57856, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_226
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_226_UNNAMED57856              = 57856, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_226
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_226_UNNAMED57856              = 57856, ///<
        };
        enum FORWARD_PIXEL_VALUE_226
        {
            FORWARD_PIXEL_VALUE_226_UNNAMED57856                             = 57856, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_226
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_226_UNNAMED57856              = 57856, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_227
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_227_UNNAMED58112              = 58112, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_227
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_227_UNNAMED58112              = 58112, ///<
        };
        enum INVERSE_PIXEL_VALUE_227
        {
            INVERSE_PIXEL_VALUE_227_UNNAMED58112                             = 58112, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_227
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_227_UNNAMED58112              = 58112, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_227
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_227_UNNAMED58112              = 58112, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_227
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_227_UNNAMED58112              = 58112, ///<
        };
        enum FORWARD_PIXEL_VALUE_227
        {
            FORWARD_PIXEL_VALUE_227_UNNAMED58112                             = 58112, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_227
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_227_UNNAMED58112              = 58112, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_228
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_228_UNNAMED58368              = 58368, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_228
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_228_UNNAMED58368              = 58368, ///<
        };
        enum INVERSE_PIXEL_VALUE_228
        {
            INVERSE_PIXEL_VALUE_228_UNNAMED58368                             = 58368, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_228
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_228_UNNAMED58368              = 58368, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_228
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_228_UNNAMED58368              = 58368, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_228
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_228_UNNAMED58368              = 58368, ///<
        };
        enum FORWARD_PIXEL_VALUE_228
        {
            FORWARD_PIXEL_VALUE_228_UNNAMED58368                             = 58368, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_228
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_228_UNNAMED58368              = 58368, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_229
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_229_UNNAMED58624              = 58624, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_229
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_229_UNNAMED58624              = 58624, ///<
        };
        enum INVERSE_PIXEL_VALUE_229
        {
            INVERSE_PIXEL_VALUE_229_UNNAMED58624                             = 58624, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_229
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_229_UNNAMED58624              = 58624, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_229
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_229_UNNAMED58624              = 58624, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_229
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_229_UNNAMED58624              = 58624, ///<
        };
        enum FORWARD_PIXEL_VALUE_229
        {
            FORWARD_PIXEL_VALUE_229_UNNAMED58624                             = 58624, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_229
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_229_UNNAMED58624              = 58624, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_230
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_230_UNNAMED58880              = 58880, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_230
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_230_UNNAMED58880              = 58880, ///<
        };
        enum INVERSE_PIXEL_VALUE_230
        {
            INVERSE_PIXEL_VALUE_230_UNNAMED58880                             = 58880, ///<
        };
        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_230
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_230_UNNAMED58880              = 58880, ///<
        };
        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_230
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_230_UNNAMED58880              = 58880, ///<
        };
        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_230
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_230_UNNAMED58880              = 58880, ///<
        };
        enum FORWARD_PIXEL_VALUE_230
        {
            FORWARD_PIXEL_VALUE_230_UNNAMED58880                             = 58880, ///<
        };
        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_230
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_230_UNNAMED58880              = 58880, ///<
        };
        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_231
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_231_UNNAMED59136              = 59136, ///<
        };
        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_231
        {
            INVERSE_B_CH_GAMM