inline size_t Scan::modVectSize() const
{
    return d_modVect.size();
}

inline void Scan::rmImport(ModData &data, std::string const &modName)
{
    data.rmImport(d_moduleNameIdx[modName]);
}

inline void Scan::setExtern(size_t idx)
{
    d_modVect[idx].setExtern();
}

inline void Scan::setNr(size_t nr)
{
    d_nr = nr;
}

inline  ModData const &Scan::modVect(size_t idx) const
{
    return d_modVect[idx];
}
        
inline Scan::Path const &Scan::cwd() const
{
    return d_cwd;
}

inline Scan::Vect &Scan::modVect()
{
    return d_modVect;
}

inline Scan::Vect const &Scan::modVect() const
{
    return d_modVect;
}

inline Scan::ModMap &Scan::moduleNameIdx()
{
    return d_moduleNameIdx;
}

    // idx in d_modVect: return its name as a gcm filename
inline std::string Scan::gcmName(size_t idx) const
{
    return col2hyphen( d_modVect[idx].modName() ) + ".gcm";
}
