#ifndef INCLUDED_MODDATA_
#define INCLUDED_MODDATA_

#include <unordered_set>
#include <string>
#include <filesystem>

struct ModData
{
    enum Type                   // module type (see also data.cc)
    {
        UNKNOWN,
        LOCAL,
        EXTERN
    };

    private:
        using Path          = std::filesystem::path;
        using Set           = std::unordered_set<size_t>;

        Type d_type;
        Path d_source;          // source path of this module relative to cwd 
        std::string d_modName;  // name of this module

        Set d_imports;          // modules imported by this module

        size_t d_nr;            // prefix before .o filenames

        static char const *s_type[];    // module type NTBSs

    public:
        ModData(std::string const &modName,     // by default UNKNOWN
                Type type = UNKNOWN,
                Path const &source = Path{});

        Set const &imports() const;                                     // .f
        void imports(size_t idx);                                       // .f

        std::string const &modName() const;                             // .f
        void rmImport(size_t idx);                                      // .f
        void setExtern();                                               // .f

        void setLocal(Path const &source);                              // 1.cc
        void setLocal(size_t nr, Path const &source);                   // 2.cc

        std::string nr() const;                                         // .f
        Path const &source() const;                                     // .f
        std::string str() const;                                        // .f
        Type type() const;                                              // .f
        char const *typeTxt() const;                                    // .f
};

#include "moddata.f"
        
#endif



