#include "main.ih"

namespace
{
    Arg::LongOption longOpts[] =
    {
        Arg::LongOption{"clean",        'C'},
        Arg::LongOption{"colors",       'c'},
        Arg::LongOption{"dependencies", 'd'},
        Arg::LongOption{"extern",       'e'},
        Arg::LongOption{"extension",    'x'},
        Arg::LongOption{"file",         'f'},
        Arg::LongOption{"help",         'h'},
        Arg::LongOption{"ignore",       'i'},
        Arg::LongOption{"quiet",        'q'},
        Arg::LongOption{"subdir",       's'},
        Arg::LongOption{"version",      'v'},
        Arg::LongOption{"verbose",      'V'},
        Arg::LongOption{"extension",    'x'},
    };
    auto longEnd = longOpts + size(longOpts);
}

int main(int argc, char **argv)
try
{
    Arg const &arg = Arg::initialize("cCde:f:hi:qsvVx:", longOpts, longEnd, 
                                                         argc, argv);
    arg.versionHelp(usage, VERSION, 0);

    Modules modules;            // CLASSES or --noclasses must be present
                                // defines gcm.cache, tmp/o and gcm.cache/usr
    if (modules.clean())
        return 0;

    modules.fill();             // determine the locations of the modules

    if (modules.circular())
        return 1;

    modules.compile();
}
catch (...)
{
    return handleException();
}

