/* indicator.c generated by valac 0.56.17, the Vala compiler
 * generated from indicator.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2015-2025 Takao Fujiwara <takao.fujiwara1@gmail.com>
 * Copyright(c) 2015 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */
/* This class extends AppIndicator because
 * AppIndicator misses "Activate" dbus method in the definition
 * for left click on the indicator.
 */
/* I have no idea to exempt this file to make ibus_ui_gtk3_vala.stamp*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <ibus.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <cairo-gobject.h>
#include <libdbusmenu-gtk/client.h>
#include <libdbusmenu-gtk/dbusmenu-gtk.h>
#include <libdbusmenu-gtk/menu.h>
#include <libdbusmenu-gtk/menuitem.h>
#include <libdbusmenu-gtk/parser.h>

#define INDICATOR_DEFAULT_ITEM_PATH "/org/ayatana/NotificationItem"
#define INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE "org.kde.StatusNotifierItem"
#define INDICATOR_NOTIFICATION_WATCHER_DBUS_IFACE "org.kde.StatusNotifierWatcher"
#define INDICATOR_NOTIFICATION_WATCHER_DBUS_ADDR "org.kde.StatusNotifierWatcher"
#define INDICATOR_NOTIFICATION_WATCHER_DBUS_OBJ "/StatusNotifierWatcher"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_INDICATOR (indicator_get_type ())
#define INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR, Indicator))
#define INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR, IndicatorClass))
#define IS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR))
#define IS_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR))
#define INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR, IndicatorClass))

typedef struct _Indicator Indicator;
typedef struct _IndicatorClass IndicatorClass;
typedef struct _IndicatorPrivate IndicatorPrivate;
enum  {
	INDICATOR_0_PROPERTY,
	INDICATOR_ID_PROPERTY,
	INDICATOR_CATEGORY_S_PROPERTY,
	INDICATOR_STATUS_S_PROPERTY,
	INDICATOR_ICON_NAME_PROPERTY,
	INDICATOR_ICON_DESC_PROPERTY,
	INDICATOR_ATTENTION_ICON_NAME_PROPERTY,
	INDICATOR_ATTENTION_ICON_DESC_PROPERTY,
	INDICATOR_TITLE_PROPERTY,
	INDICATOR_ICON_THEME_PATH_PROPERTY,
	INDICATOR_CONNECTED_PROPERTY,
	INDICATOR_LABEL_S_PROPERTY,
	INDICATOR_LABEL_GUIDE_S_PROPERTY,
	INDICATOR_ORDERING_INDEX_PROPERTY,
	INDICATOR_ICON_VECTOR_PROPERTY,
	INDICATOR_NUM_PROPERTIES
};
static GParamSpec* indicator_properties[INDICATOR_NUM_PROPERTIES];
typedef enum  {
	INDICATOR_CATEGORY_APPLICATION_STATUS,
	INDICATOR_CATEGORY_COMMUNICATIONS,
	INDICATOR_CATEGORY_SYSTEM_SERVICES,
	INDICATOR_CATEGORY_HARDWARE,
	INDICATOR_CATEGORY_OTHER
} IndicatorCategory;

#define INDICATOR_TYPE_CATEGORY (indicator_category_get_type ())
typedef enum  {
	INDICATOR_STATUS_PASSIVE,
	INDICATOR_STATUS_ACTIVE,
	INDICATOR_STATUS_ATTENTION
} IndicatorStatus;

#define INDICATOR_TYPE_STATUS (indicator_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_dbus_node_info_unref0(var) ((var == NULL) ? NULL : (var = (g_dbus_node_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
enum  {
	INDICATOR_CONTEXT_MENU_SIGNAL,
	INDICATOR_ACTIVATE_SIGNAL,
	INDICATOR_SECONDARY_ACTIVATE_SIGNAL,
	INDICATOR_REGISTERED_STATUS_NOTIFIER_ITEM_SIGNAL,
	INDICATOR_NUM_SIGNALS
};
static guint indicator_signals[INDICATOR_NUM_SIGNALS] = {0};

struct _Indicator {
	IBusService parent_instance;
	IndicatorPrivate * priv;
};

struct _IndicatorClass {
	IBusServiceClass parent_class;
};

struct _IndicatorPrivate {
	gchar* _id;
	gchar* _category_s;
	gchar* _status_s;
	gchar* _icon_name;
	gchar* _icon_desc;
	gchar* _attention_icon_name;
	gchar* _attention_icon_desc;
	gchar* _title;
	gchar* _icon_theme_path;
	gboolean _connected;
	gchar* _label_s;
	gchar* _label_guide_s;
	guint32 _ordering_index;
	GVariant* _icon_vector;
	GDBusNodeInfo* m_watcher_node_info;
	GDBusInterfaceInfo* m_watcher_interface_info;
	gboolean m_registered;
	GDBusProxy* m_proxy;
	gint m_context_menu_x;
	gint m_context_menu_y;
	gint m_activate_menu_x;
	gint m_activate_menu_y;
	GdkWindow* m_indicator_window;
	GtkMenu* m_menu;
	DbusmenuServer* m_dbusmenu_server;
};

VALA_EXTERN gchar* _notification_item;
VALA_EXTERN gchar* _notification_watcher;
static gint Indicator_private_offset;
static gpointer indicator_parent_class = NULL;

VALA_EXTERN GType indicator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indicator, g_object_unref)
VALA_EXTERN GType indicator_category_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* indicator_category_to_nick (IndicatorCategory self);
VALA_EXTERN GType indicator_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* indicator_status_to_nick (IndicatorStatus self);
VALA_EXTERN Indicator* indicator_new (const gchar* id,
                          IndicatorCategory category);
VALA_EXTERN Indicator* indicator_construct (GType object_type,
                                const gchar* id,
                                IndicatorCategory category);
VALA_EXTERN void indicator_set_status_s (Indicator* self,
                             const gchar* value);
VALA_EXTERN void indicator_set_icon_name (Indicator* self,
                              const gchar* value);
VALA_EXTERN void indicator_set_icon_desc (Indicator* self,
                              const gchar* value);
VALA_EXTERN void indicator_set_title (Indicator* self,
                          const gchar* value);
VALA_EXTERN void indicator_set_icon_theme_path (Indicator* self,
                                    const gchar* value);
VALA_EXTERN void indicator_set_attention_icon_name (Indicator* self,
                                        const gchar* value);
VALA_EXTERN void indicator_set_attention_icon_desc (Indicator* self,
                                        const gchar* value);
VALA_EXTERN void indicator_set_label_s (Indicator* self,
                            const gchar* value);
VALA_EXTERN void indicator_set_label_guide_s (Indicator* self,
                                  const gchar* value);
static void indicator_name_appeared_handler (Indicator* self,
                                      GDBusConnection* connection,
                                      const gchar* name,
                                      const gchar* name_owner);
static void _indicator_name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   const gchar* name_owner,
                                                                   gpointer self);
static void indicator_name_vanished_handler (Indicator* self,
                                      GDBusConnection* connection,
                                      const gchar* name);
static void _indicator_name_vanished_handler_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self);
static void __lambda7_ (Indicator* self,
                 GObject* obj,
                 GAsyncResult* res);
static void indicator_check_connect (Indicator* self);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void __lambda4_ (Indicator* self,
                 GObject* obj,
                 GAsyncResult* res);
static void indicator_bus_watcher_ready (Indicator* self,
                                  GObject* obj,
                                  GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void ___lambda5_ (Indicator* self,
                  GObject* obj,
                  GParamSpec* pspec);
static void ____lambda5__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda6_ (Indicator* self,
                 GObject* p_obj,
                 GAsyncResult* p_res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _indicator_context_menu_cb (Indicator* self,
                                 GDBusConnection* connection,
                                 GVariant* parameters,
                                 GDBusMethodInvocation* invocation);
static GdkWindow* indicator_query_gdk_window (Indicator* self);
static void _indicator_activate_menu_cb (Indicator* self,
                                  GDBusConnection* connection,
                                  GVariant* parameters,
                                  GDBusMethodInvocation* invocation);
VALA_EXTERN GdkX11Display* binding_common_get_xdisplay (gboolean check_only);
static GVariant* _indicator_get_id (Indicator* self,
                             GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_id (Indicator* self);
static GVariant* _indicator_get_category (Indicator* self,
                                   GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_category_s (Indicator* self);
static GVariant* _indicator_get_status (Indicator* self,
                                 GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_status_s (Indicator* self);
static GVariant* _indicator_get_icon_name (Indicator* self,
                                    GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_icon_name (Indicator* self);
static GVariant* _indicator_get_icon_vector (Indicator* self,
                                      GDBusConnection* connection);
VALA_EXTERN GVariant* indicator_get_icon_vector (Indicator* self);
static GVariant* _indicator_get_icon_desc (Indicator* self,
                                    GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_icon_desc (Indicator* self);
static GVariant* _indicator_get_attention_icon_name (Indicator* self,
                                              GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_attention_icon_name (Indicator* self);
static GVariant* _indicator_get_attention_icon_desc (Indicator* self,
                                              GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_attention_icon_desc (Indicator* self);
static GVariant* _indicator_get_title (Indicator* self,
                                GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_title (Indicator* self);
static GVariant* _indicator_get_icon_theme_path (Indicator* self,
                                          GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_icon_theme_path (Indicator* self);
static GVariant* _indicator_get_menu (Indicator* self,
                               GDBusConnection* connection);
static GVariant* _indicator_get_xayatana_label (Indicator* self,
                                         GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_label_s (Indicator* self);
static GVariant* _indicator_get_xayatana_label_guide (Indicator* self,
                                               GDBusConnection* connection);
VALA_EXTERN const gchar* indicator_get_label_guide_s (Indicator* self);
static GVariant* _indicator_get_xayatana_ordering_index (Indicator* self,
                                                  GDBusConnection* connection);
VALA_EXTERN guint32 indicator_get_ordering_index (Indicator* self);
static void indicator_real_service_method_call (IBusService* base,
                                         GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation);
static GVariant* indicator_real_service_get_property (IBusService* base,
                                               GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error);
static gboolean indicator_real_service_set_property (IBusService* base,
                                              GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error);
VALA_EXTERN void indicator_set_status (Indicator* self,
                           IndicatorStatus status);
VALA_EXTERN void indicator_set_icon_full (Indicator* self,
                              const gchar* icon_name,
                              const gchar* icon_desc);
VALA_EXTERN void indicator_set_icon_vector (Indicator* self,
                                GVariant* value);
VALA_EXTERN void indicator_set_cairo_image_surface_full (Indicator* self,
                                             cairo_surface_t* image,
                                             const gchar* icon_desc);
VALA_EXTERN void indicator_set_menu (Indicator* self,
                         GtkMenu* menu);
VALA_EXTERN void indicator_position_context_menu (Indicator* self,
                                      GtkMenu* menu,
                                      gint* x,
                                      gint* y,
                                      gboolean* push_in);
VALA_EXTERN void indicator_position_activate_menu (Indicator* self,
                                       GtkMenu* menu,
                                       gint* x,
                                       gint* y,
                                       gboolean* push_in);
VALA_EXTERN void indicator_unregister_connection (Indicator* self);
static void indicator_set_id (Indicator* self,
                       const gchar* value);
static void indicator_set_category_s (Indicator* self,
                               const gchar* value);
VALA_EXTERN gboolean indicator_get_connected (Indicator* self);
VALA_EXTERN void indicator_set_connected (Indicator* self,
                              gboolean value);
VALA_EXTERN void indicator_set_ordering_index (Indicator* self,
                                   guint32 value);
static void g_cclosure_user_marshal_VOID__INT_INT_OBJECT_UINT_UINT (GClosure * closure,
                                                             GValue * return_value,
                                                             guint n_param_values,
                                                             const GValue * param_values,
                                                             gpointer invocation_hint,
                                                             gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT_OBJECT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void indicator_finalize (GObject * obj);
static GType indicator_get_type_once (void);
static void _vala_indicator_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_indicator_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
indicator_get_instance_private (Indicator* self)
{
	return G_STRUCT_MEMBER_P (self, Indicator_private_offset);
}

gchar*
indicator_category_to_nick (IndicatorCategory self)
{
	gchar* result;
	switch (self) {
		case INDICATOR_CATEGORY_APPLICATION_STATUS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ApplicationStatus");
			result = _tmp0_;
			return result;
		}
		case INDICATOR_CATEGORY_COMMUNICATIONS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Communications");
			result = _tmp1_;
			return result;
		}
		case INDICATOR_CATEGORY_SYSTEM_SERVICES:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SystemServices");
			result = _tmp2_;
			return result;
		}
		case INDICATOR_CATEGORY_HARDWARE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Hardware");
			result = _tmp3_;
			return result;
		}
		case INDICATOR_CATEGORY_OTHER:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Other");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
indicator_category_get_type_once (void)
{
	static const GEnumValue values[] = {{INDICATOR_CATEGORY_APPLICATION_STATUS, "INDICATOR_CATEGORY_APPLICATION_STATUS", "application-status"}, {INDICATOR_CATEGORY_COMMUNICATIONS, "INDICATOR_CATEGORY_COMMUNICATIONS", "communications"}, {INDICATOR_CATEGORY_SYSTEM_SERVICES, "INDICATOR_CATEGORY_SYSTEM_SERVICES", "system-services"}, {INDICATOR_CATEGORY_HARDWARE, "INDICATOR_CATEGORY_HARDWARE", "hardware"}, {INDICATOR_CATEGORY_OTHER, "INDICATOR_CATEGORY_OTHER", "other"}, {0, NULL, NULL}};
	GType indicator_category_type_id;
	indicator_category_type_id = g_enum_register_static ("IndicatorCategory", values);
	return indicator_category_type_id;
}

GType
indicator_category_get_type (void)
{
	static volatile gsize indicator_category_type_id__once = 0;
	if (g_once_init_enter (&indicator_category_type_id__once)) {
		GType indicator_category_type_id;
		indicator_category_type_id = indicator_category_get_type_once ();
		g_once_init_leave (&indicator_category_type_id__once, indicator_category_type_id);
	}
	return indicator_category_type_id__once;
}

gchar*
indicator_status_to_nick (IndicatorStatus self)
{
	gchar* result;
	switch (self) {
		case INDICATOR_STATUS_PASSIVE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Passive");
			result = _tmp0_;
			return result;
		}
		case INDICATOR_STATUS_ACTIVE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Active");
			result = _tmp1_;
			return result;
		}
		case INDICATOR_STATUS_ATTENTION:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("NeedsAttention");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
indicator_status_get_type_once (void)
{
	static const GEnumValue values[] = {{INDICATOR_STATUS_PASSIVE, "INDICATOR_STATUS_PASSIVE", "passive"}, {INDICATOR_STATUS_ACTIVE, "INDICATOR_STATUS_ACTIVE", "active"}, {INDICATOR_STATUS_ATTENTION, "INDICATOR_STATUS_ATTENTION", "attention"}, {0, NULL, NULL}};
	GType indicator_status_type_id;
	indicator_status_type_id = g_enum_register_static ("IndicatorStatus", values);
	return indicator_status_type_id;
}

GType
indicator_status_get_type (void)
{
	static volatile gsize indicator_status_type_id__once = 0;
	if (g_once_init_enter (&indicator_status_type_id__once)) {
		GType indicator_status_type_id;
		indicator_status_type_id = indicator_status_get_type_once ();
		g_once_init_leave (&indicator_status_type_id__once, indicator_status_type_id);
	}
	return indicator_status_type_id__once;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static void
_indicator_name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              const gchar* name_owner,
                                                              gpointer self)
{
	indicator_name_appeared_handler ((Indicator*) self, connection, name, name_owner);
}

static void
_indicator_name_vanished_handler_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self)
{
	indicator_name_vanished_handler ((Indicator*) self, connection, name);
}

static void
__lambda7_ (Indicator* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		_tmp1_ = g_bus_get_finish (res, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_object_set ((IBusService*) self, "connection", _tmp0_, NULL);
		indicator_check_connect (self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("indicator.vala:152: Failed to get the session bus: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda7_ ((Indicator*) self, source_object, res);
	g_object_unref (self);
}

Indicator*
indicator_construct (GType object_type,
                     const gchar* id,
                     IndicatorCategory category)
{
	Indicator * self = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint n = 0;
	const gchar* _tmp8_;
	GDBusNodeInfo* _tmp17_;
	GDBusInterfaceInfo* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strconcat (INDICATOR_DEFAULT_ITEM_PATH "/", id, NULL);
	path = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = string_delimit (_tmp1_, "-", '_');
	_g_free0 (path);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = indicator_category_to_nick (category);
	_tmp5_ = _tmp4_;
	self = (Indicator*) g_object_new (object_type, "object-path", _tmp3_, "id", id, "category-s", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_tmp6_ = indicator_status_to_nick (INDICATOR_STATUS_PASSIVE);
	_tmp7_ = _tmp6_;
	indicator_set_status_s (self, _tmp7_);
	_g_free0 (_tmp7_);
	indicator_set_icon_name (self, "ibus");
	indicator_set_icon_desc (self, "");
	indicator_set_title (self, "");
	indicator_set_icon_theme_path (self, "");
	indicator_set_attention_icon_name (self, "");
	indicator_set_attention_icon_desc (self, "");
	indicator_set_label_s (self, "");
	indicator_set_label_guide_s (self, "");
	n = ibus_service_class_free_interfaces (G_TYPE_INSTANCE_GET_CLASS (self, ibus_service_get_type (), IBusServiceClass), 0);
	ibus_service_class_free_interfaces (G_TYPE_INSTANCE_GET_CLASS (self, ibus_service_get_type (), IBusServiceClass), -n);
	_tmp8_ = _notification_item;
	ibus_service_class_add_interfaces (G_TYPE_INSTANCE_GET_CLASS (self, ibus_service_get_type (), IBusServiceClass), _tmp8_);
	{
		GDBusNodeInfo* _tmp9_ = NULL;
		const gchar* _tmp10_;
		GDBusNodeInfo* _tmp11_;
		GDBusNodeInfo* _tmp12_;
		_tmp10_ = _notification_watcher;
		_tmp11_ = g_dbus_node_info_new_for_xml (_tmp10_, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_dbus_node_info_unref0 (self->priv->m_watcher_node_info);
		self->priv->m_watcher_node_info = _tmp12_;
		_g_dbus_node_info_unref0 (_tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strconcat ("Failed to create dbus node info: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		g_warning ("indicator.vala:136: %s", _tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
		_g_free0 (path);
		return self;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp17_ = self->priv->m_watcher_node_info;
	_tmp18_ = g_dbus_node_info_lookup_interface (_tmp17_, INDICATOR_NOTIFICATION_WATCHER_DBUS_IFACE);
	self->priv->m_watcher_interface_info = _tmp18_;
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, INDICATOR_NOTIFICATION_WATCHER_DBUS_ADDR, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_indicator_name_appeared_handler_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _indicator_name_appeared_handler_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_indicator_name_vanished_handler_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _indicator_name_vanished_handler_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	g_bus_get (G_BUS_TYPE_SESSION, NULL, ___lambda7__gasync_ready_callback, g_object_ref (self));
	_g_free0 (path);
	return self;
}

Indicator*
indicator_new (const gchar* id,
               IndicatorCategory category)
{
	return indicator_construct (TYPE_INDICATOR, id, category);
}

static void
__lambda4_ (Indicator* self,
            GObject* obj,
            GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	indicator_bus_watcher_ready (self, obj, res);
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((Indicator*) self, source_object, res);
	g_object_unref (self);
}

static void
indicator_name_appeared_handler (Indicator* self,
                                 GDBusConnection* connection,
                                 const gchar* name,
                                 const gchar* name_owner)
{
	GDBusInterfaceInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	_tmp0_ = self->priv->m_watcher_interface_info;
	g_dbus_proxy_new (connection, G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, _tmp0_, INDICATOR_NOTIFICATION_WATCHER_DBUS_ADDR, INDICATOR_NOTIFICATION_WATCHER_DBUS_OBJ, INDICATOR_NOTIFICATION_WATCHER_DBUS_IFACE, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self));
}

static void
indicator_name_vanished_handler (Indicator* self,
                                 GDBusConnection* connection,
                                 const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	_g_object_unref0 (self->priv->m_proxy);
	self->priv->m_proxy = NULL;
}

static void
indicator_check_connect (Indicator* self)
{
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp2_;
	gboolean _tmp3_;
	GtkMenu* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_object_get ((IBusService*) self, "connection", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->m_menu;
	if (_tmp4_ == NULL) {
		return;
	}
	{
		if (!self->priv->m_registered) {
			gboolean _tmp5_ = FALSE;
			GDBusConnection* _tmp6_;
			GDBusConnection* _tmp7_;
			GDBusConnection* _tmp8_;
			gboolean _tmp9_;
			g_object_get ((IBusService*) self, "connection", &_tmp6_, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = ibus_service_register ((IBusService*) self, _tmp8_, &_inner_error0_);
			_g_object_unref0 (_tmp8_);
			_tmp5_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (!_tmp5_) {
				return;
			} else {
				self->priv->m_registered = TRUE;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strconcat ("Failed to register the application indicator xml: ", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		g_warning ("indicator.vala:196: %s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5_ (Indicator* self,
             GObject* obj,
             GParamSpec* pspec)
{
	gchar* name = NULL;
	GDBusProxy* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->m_proxy;
	_tmp1_ = g_dbus_proxy_get_name_owner (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ != NULL) {
		indicator_check_connect (self);
	}
	_g_free0 (name);
}

static void
____lambda5__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda5_ ((Indicator*) self, _sender, pspec);
}

static void
__lambda6_ (Indicator* self,
            GObject* p_obj,
            GAsyncResult* p_res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (p_res != NULL);
	{
		GDBusProxy* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp0_ = self->priv->m_proxy;
		_tmp1_ = g_dbus_proxy_call_finish (_tmp0_, p_res, &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_variant_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (self, indicator_signals[INDICATOR_REGISTERED_STATUS_NOTIFIER_ITEM_SIGNAL], 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_strconcat ("Failed to call " "RegisterStatusNotifierItem: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		g_warning ("indicator.vala:234: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ ((Indicator*) self, source_object, res);
	g_object_unref (self);
}

static void
indicator_bus_watcher_ready (Indicator* self,
                             GObject* obj,
                             GAsyncResult* res)
{
	gchar* name = NULL;
	GDBusProxy* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GDBusProxy* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (res != NULL) {
		GDBusProxy* _tmp7_;
		{
			GDBusProxy* _tmp0_ = NULL;
			GDBusProxy* _tmp1_;
			GDBusProxy* _tmp2_;
			_tmp1_ = g_dbus_proxy_new_finish (res, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (self->priv->m_proxy);
			self->priv->m_proxy = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			_tmp5_ = g_strconcat ("Failed to call dbus proxy: ", _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			g_warning ("indicator.vala:208: %s", _tmp6_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp7_ = self->priv->m_proxy;
		g_signal_connect_object ((GObject*) _tmp7_, "notify::g-name-owner", (GCallback) ____lambda5__g_object_notify, self, 0);
	}
	_tmp8_ = self->priv->m_proxy;
	_tmp9_ = g_dbus_proxy_get_name_owner (_tmp8_);
	name = _tmp9_;
	_tmp10_ = name;
	if (_tmp10_ == NULL) {
		_g_free0 (name);
		return;
	}
	_tmp11_ = self->priv->m_proxy;
	_tmp12_ = ibus_service_get_object_path ((IBusService*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_new ("(s)", _tmp13_, NULL);
	g_variant_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	g_dbus_proxy_call (_tmp11_, "RegisterStatusNotifierItem", _tmp15_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, ___lambda6__gasync_ready_callback, g_object_ref (self));
	_g_variant_unref0 (_tmp15_);
	_g_free0 (name);
}

static void
_indicator_context_menu_cb (Indicator* self,
                            GDBusConnection* connection,
                            GVariant* parameters,
                            GDBusMethodInvocation* invocation)
{
	GVariant* var_x = NULL;
	GVariant* _tmp0_;
	GVariant* var_y = NULL;
	GVariant* _tmp1_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (parameters != NULL);
	g_return_if_fail (invocation != NULL);
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 0);
	var_x = _tmp0_;
	_tmp1_ = g_variant_get_child_value (parameters, (gsize) 1);
	var_y = _tmp1_;
	self->priv->m_context_menu_x = (gint) g_variant_get_int32 (var_x);
	self->priv->m_context_menu_y = (gint) g_variant_get_int32 (var_y);
	_tmp2_ = indicator_query_gdk_window (self);
	window = _tmp2_;
	g_signal_emit (self, indicator_signals[INDICATOR_CONTEXT_MENU_SIGNAL], 0, self->priv->m_context_menu_x, self->priv->m_context_menu_y, window, (guint) 2, (guint) 0);
	_g_object_unref0 (window);
	_g_variant_unref0 (var_y);
	_g_variant_unref0 (var_x);
}

static void
_indicator_activate_menu_cb (Indicator* self,
                             GDBusConnection* connection,
                             GVariant* parameters,
                             GDBusMethodInvocation* invocation)
{
	GVariant* var_x = NULL;
	GVariant* _tmp0_;
	GVariant* var_y = NULL;
	GVariant* _tmp1_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (parameters != NULL);
	g_return_if_fail (invocation != NULL);
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 0);
	var_x = _tmp0_;
	_tmp1_ = g_variant_get_child_value (parameters, (gsize) 1);
	var_y = _tmp1_;
	self->priv->m_activate_menu_x = (gint) g_variant_get_int32 (var_x);
	self->priv->m_activate_menu_y = (gint) g_variant_get_int32 (var_y);
	_tmp2_ = indicator_query_gdk_window (self);
	window = _tmp2_;
	g_signal_emit (self, indicator_signals[INDICATOR_ACTIVATE_SIGNAL], 0, self->priv->m_activate_menu_x, self->priv->m_activate_menu_y, window);
	_g_object_unref0 (window);
	_g_variant_unref0 (var_y);
	_g_variant_unref0 (var_x);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GdkWindow*
indicator_query_gdk_window (Indicator* self)
{
	GdkWindow* _tmp0_;
	GdkX11Display* display = NULL;
	GdkX11Display* _tmp3_;
	GdkX11Display* _tmp4_;
	Display* xdisplay = NULL;
	GdkX11Display* _tmp5_;
	Display* _tmp6_;
	Window current = 0;
	Display* _tmp7_;
	Window parent = 0;
	Window child = 0;
	gint root_x = 0;
	gint root_y = 0;
	gint win_x = 0;
	gint win_y = 0;
	guint mask = 0U;
	gboolean retval = FALSE;
	Display* _tmp22_;
	GdkX11Display* _tmp23_;
	GdkX11Window* _tmp24_;
	GdkWindow* _tmp25_;
	GdkWindow* _tmp26_;
	GdkX11Display* _tmp29_;
	GdkX11Window* _tmp30_;
	GdkWindow* _tmp31_;
	GdkWindow* _tmp32_;
	GdkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_indicator_window;
	if (_tmp0_ != NULL) {
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		_tmp1_ = self->priv->m_indicator_window;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = binding_common_get_xdisplay (FALSE);
	display = _tmp3_;
	_tmp4_ = display;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (display);
		return result;
	}
	_tmp5_ = display;
	_tmp6_ = gdk_x11_display_get_xdisplay (_tmp5_);
	xdisplay = _tmp6_;
	_tmp7_ = xdisplay;
	current = DefaultRootWindow (_tmp7_);
	parent = (Window) 0;
	child = (Window) 0;
	mask = (guint) 0;
	win_y = 0;
	win_x = win_y;
	root_y = win_x;
	root_x = root_y;
	while (TRUE) {
		Display* _tmp8_;
		Window _tmp9_ = 0;
		Window _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		guint _tmp15_ = 0U;
		gboolean _tmp16_;
		_tmp8_ = xdisplay;
		_tmp16_ = XQueryPointer (_tmp8_, current, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
		parent = _tmp9_;
		child = _tmp10_;
		root_x = _tmp11_;
		root_y = _tmp12_;
		win_x = _tmp13_;
		win_y = _tmp14_;
		mask = _tmp15_;
		retval = _tmp16_;
		if (!retval) {
			break;
		}
		if (child == ((Window) 0)) {
			break;
		}
		current = child;
	}
	if (!retval) {
		gchar* format = NULL;
		gchar* _tmp17_;
		gchar* message = NULL;
		const gchar* _tmp18_;
		Display* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp17_ = g_strdup ("XQueryPointer is failed: current: %x root: %x " "child: %x (%d, %d), (%d, %d), %u");
		format = _tmp17_;
		_tmp18_ = format;
		_tmp19_ = xdisplay;
		_tmp20_ = g_strdup_printf (_tmp18_, (guint) current, (guint) DefaultRootWindow (_tmp19_), (guint) child, root_x, root_y, win_x, win_y, mask);
		message = _tmp20_;
		_tmp21_ = message;
		g_warning ("indicator.vala:301: XQueryPointer is failed: %s", _tmp21_);
		result = NULL;
		_g_free0 (message);
		_g_free0 (format);
		_g_object_unref0 (display);
		return result;
	}
	_tmp22_ = xdisplay;
	if (current == DefaultRootWindow (_tmp22_)) {
		g_warning ("indicator.vala:305: The query window is root window");
	}
	_tmp23_ = display;
	_tmp24_ = gdk_x11_window_lookup_for_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp23_) : NULL, current);
	_tmp25_ = _g_object_ref0 ((GdkWindow*) _tmp24_);
	_g_object_unref0 (self->priv->m_indicator_window);
	self->priv->m_indicator_window = _tmp25_;
	_tmp26_ = self->priv->m_indicator_window;
	if (_tmp26_ != NULL) {
		GdkWindow* _tmp27_;
		GdkWindow* _tmp28_;
		_tmp27_ = self->priv->m_indicator_window;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		result = _tmp28_;
		_g_object_unref0 (display);
		return result;
	}
	_tmp29_ = display;
	_tmp30_ = (GdkX11Window*) gdk_x11_window_foreign_new_for_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp29_) : NULL, current);
	_g_object_unref0 (self->priv->m_indicator_window);
	self->priv->m_indicator_window = (GdkWindow*) _tmp30_;
	_tmp31_ = self->priv->m_indicator_window;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	result = _tmp32_;
	_g_object_unref0 (display);
	return result;
}

static GVariant*
_indicator_get_id (Indicator* self,
                   GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_id;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_category (Indicator* self,
                         GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_category_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_status (Indicator* self,
                       GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_status_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_icon_name (Indicator* self,
                          GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static GVariant*
_indicator_get_icon_vector (Indicator* self,
                            GDBusConnection* connection)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_vector;
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_icon_desc (Indicator* self,
                          GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_desc;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_attention_icon_name (Indicator* self,
                                    GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_name;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_attention_icon_desc (Indicator* self,
                                    GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_desc;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_title (Indicator* self,
                      GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_title;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_icon_theme_path (Indicator* self,
                                GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_theme_path;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_menu (Indicator* self,
                     GDBusConnection* connection)
{
	DbusmenuServer* _tmp0_;
	GVariant* _tmp5_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->m_dbusmenu_server;
	if (_tmp0_ != NULL) {
		gchar* o = NULL;
		DbusmenuServer* _tmp1_;
		gchar* _tmp2_ = NULL;
		GVariant* variant = NULL;
		const gchar* _tmp3_;
		GVariant* _tmp4_;
		_tmp1_ = self->priv->m_dbusmenu_server;
		g_object_get ((GObject*) _tmp1_, DBUSMENU_SERVER_PROP_DBUS_OBJECT, &_tmp2_, NULL);
		_g_free0 (o);
		o = _tmp2_;
		_tmp3_ = o;
		_tmp4_ = g_variant_new ("o", _tmp3_, NULL);
		g_variant_ref_sink (_tmp4_);
		variant = _tmp4_;
		result = variant;
		_g_free0 (o);
		return result;
	}
	_tmp5_ = g_variant_new ("o", "/", NULL);
	g_variant_ref_sink (_tmp5_);
	result = _tmp5_;
	return result;
}

static GVariant*
_indicator_get_xayatana_label (Indicator* self,
                               GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_label_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_xayatana_label_guide (Indicator* self,
                                     GDBusConnection* connection)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_label_guide_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static GVariant*
_indicator_get_xayatana_ordering_index (Indicator* self,
                                        GDBusConnection* connection)
{
	guint32 _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_ordering_index;
	_tmp1_ = g_variant_new_uint32 (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}

static void
indicator_real_service_method_call (IBusService* base,
                                    GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* method_name,
                                    GVariant* parameters,
                                    GDBusMethodInvocation* invocation)
{
	Indicator * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (Indicator*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (method_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_return_if_fail (invocation != NULL);
	_tmp0_ = ibus_service_get_object_path ((IBusService*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (g_strcmp0 (object_path, _tmp1_) == 0);
	g_return_if_fail (g_strcmp0 (interface_name, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE) == 0);
	if (g_strcmp0 (method_name, "Activate") == 0) {
		_indicator_activate_menu_cb (self, connection, parameters, invocation);
		return;
	}
	if (g_strcmp0 (method_name, "ContextMenu") == 0) {
		_indicator_context_menu_cb (self, connection, parameters, invocation);
		return;
	}
	if (g_strcmp0 (method_name, "SecondaryActivate") == 0) {
		g_signal_emit (self, indicator_signals[INDICATOR_SECONDARY_ACTIVATE_SIGNAL], 0);
		return;
	}
	_tmp2_ = g_strconcat ("service_method_call() does not handle the method: ", method_name, NULL);
	_tmp3_ = _tmp2_;
	g_warning ("indicator.vala:426: %s", _tmp3_);
	_g_free0 (_tmp3_);
}

static GVariant*
indicator_real_service_get_property (IBusService* base,
                                     GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GError** error)
{
	Indicator * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _result_ = NULL;
	GVariant* _tmp30_;
	GError* _inner_error0_ = NULL;
	GVariant* result;
	self = (Indicator*) base;
	g_return_val_if_fail (connection != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = ibus_service_get_object_path ((IBusService*) self);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (object_path, _tmp1_) != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("%s != %s", object_path, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (g_strcmp0 (interface_name, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE) != 0) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		_tmp8_ = g_strdup_printf ("%s != %s", interface_name, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_result_ = NULL;
	if (g_strcmp0 (property_name, "Id") == 0) {
		GVariant* _tmp12_;
		_tmp12_ = _indicator_get_id (self, connection);
		_g_variant_unref0 (_result_);
		_result_ = _tmp12_;
	} else {
		if (g_strcmp0 (property_name, "Category") == 0) {
			GVariant* _tmp13_;
			_tmp13_ = _indicator_get_category (self, connection);
			_g_variant_unref0 (_result_);
			_result_ = _tmp13_;
		} else {
			if (g_strcmp0 (property_name, "Status") == 0) {
				GVariant* _tmp14_;
				_tmp14_ = _indicator_get_status (self, connection);
				_g_variant_unref0 (_result_);
				_result_ = _tmp14_;
			} else {
				if (g_strcmp0 (property_name, "IconName") == 0) {
					GVariant* _tmp15_;
					_tmp15_ = _indicator_get_icon_name (self, connection);
					_g_variant_unref0 (_result_);
					_result_ = _tmp15_;
				} else {
					if (g_strcmp0 (property_name, "IconPixmap") == 0) {
						GVariant* _tmp16_;
						_tmp16_ = _indicator_get_icon_vector (self, connection);
						_g_variant_unref0 (_result_);
						_result_ = _tmp16_;
					} else {
						if (g_strcmp0 (property_name, "IconAccessibleDesc") == 0) {
							GVariant* _tmp17_;
							_tmp17_ = _indicator_get_icon_desc (self, connection);
							_g_variant_unref0 (_result_);
							_result_ = _tmp17_;
						} else {
							if (g_strcmp0 (property_name, "AttentionIconName") == 0) {
								GVariant* _tmp18_;
								_tmp18_ = _indicator_get_attention_icon_name (self, connection);
								_g_variant_unref0 (_result_);
								_result_ = _tmp18_;
							} else {
								if (g_strcmp0 (property_name, "AttentionAccessibleDesc") == 0) {
									GVariant* _tmp19_;
									_tmp19_ = _indicator_get_attention_icon_desc (self, connection);
									_g_variant_unref0 (_result_);
									_result_ = _tmp19_;
								} else {
									if (g_strcmp0 (property_name, "Title") == 0) {
										GVariant* _tmp20_;
										_tmp20_ = _indicator_get_title (self, connection);
										_g_variant_unref0 (_result_);
										_result_ = _tmp20_;
									} else {
										if (g_strcmp0 (property_name, "IconThemePath") == 0) {
											GVariant* _tmp21_;
											_tmp21_ = _indicator_get_icon_theme_path (self, connection);
											_g_variant_unref0 (_result_);
											_result_ = _tmp21_;
										} else {
											if (g_strcmp0 (property_name, "Menu") == 0) {
												GVariant* _tmp22_;
												_tmp22_ = _indicator_get_menu (self, connection);
												_g_variant_unref0 (_result_);
												_result_ = _tmp22_;
											} else {
												if (g_strcmp0 (property_name, "XAyatanaLabel") == 0) {
													GVariant* _tmp23_;
													_tmp23_ = _indicator_get_xayatana_label (self, connection);
													_g_variant_unref0 (_result_);
													_result_ = _tmp23_;
												} else {
													if (g_strcmp0 (property_name, "XAyatanaLabelGuide") == 0) {
														GVariant* _tmp24_;
														_tmp24_ = _indicator_get_xayatana_label_guide (self, connection);
														_g_variant_unref0 (_result_);
														_result_ = _tmp24_;
													} else {
														if (g_strcmp0 (property_name, "XAyatanaOrderingIndex") == 0) {
															GVariant* _tmp25_;
															_tmp25_ = _indicator_get_xayatana_ordering_index (self, connection);
															_g_variant_unref0 (_result_);
															_result_ = _tmp25_;
														} else {
															gchar* _tmp26_;
															gchar* _tmp27_;
															GError* _tmp28_;
															GError* _tmp29_;
															_tmp26_ = g_strconcat ("IBus.Indicator does not handle the property: ", property_name, NULL);
															_tmp27_ = _tmp26_;
															_tmp28_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_PROPERTY, _tmp27_);
															_tmp29_ = _tmp28_;
															_g_free0 (_tmp27_);
															_inner_error0_ = _tmp29_;
															g_propagate_error (error, _inner_error0_);
															_g_variant_unref0 (_result_);
															return NULL;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp30_ = _result_;
	if (_tmp30_ == NULL) {
		gchar* _tmp31_;
		gchar* _tmp32_;
		GError* _tmp33_;
		GError* _tmp34_;
		_tmp31_ = g_strconcat ("IBus.Indicator returns null for the property ", property_name, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, _tmp32_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		_inner_error0_ = _tmp34_;
		g_propagate_error (error, _inner_error0_);
		_g_variant_unref0 (_result_);
		return NULL;
	}
	result = _result_;
	return result;
}

static gboolean
indicator_real_service_set_property (IBusService* base,
                                     GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GVariant* value,
                                     GError** error)
{
	Indicator * self;
	gboolean result;
	self = (Indicator*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	g_return_val_if_fail (interface_name != NULL, FALSE);
	g_return_val_if_fail (property_name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	result = FALSE;
	return result;
}

void
indicator_set_status (Indicator* self,
                      IndicatorStatus status)
{
	gchar* status_s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GDBusConnection* _tmp4_;
	GDBusConnection* _tmp5_;
	GDBusConnection* _tmp6_;
	gboolean _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = indicator_status_to_nick (status);
	status_s = _tmp0_;
	_tmp1_ = self->priv->_status_s;
	_tmp2_ = status_s;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		_g_free0 (status_s);
		return;
	}
	_tmp3_ = status_s;
	indicator_set_status_s (self, _tmp3_);
	g_object_get ((IBusService*) self, "connection", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ == NULL;
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		_g_free0 (status_s);
		return;
	}
	{
		GDBusConnection* _tmp8_;
		GDBusConnection* _tmp9_;
		GDBusConnection* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		g_object_get ((IBusService*) self, "connection", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = status_s;
		_tmp14_ = g_variant_new ("(s)", _tmp13_, NULL);
		g_variant_ref_sink (_tmp14_);
		_tmp15_ = _tmp14_;
		g_dbus_connection_emit_signal (_tmp10_, NULL, _tmp12_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE, "NewStatus", _tmp15_, &_inner_error0_);
		_g_variant_unref0 (_tmp15_);
		_g_object_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("indicator.vala:524: Unable to send signal for NewIcon: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (status_s);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (status_s);
}

void
indicator_set_icon_full (Indicator* self,
                         const gchar* icon_name,
                         const gchar* icon_desc)
{
	gboolean changed = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	GDBusConnection* _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	changed = FALSE;
	_tmp0_ = self->priv->_icon_name;
	if (g_strcmp0 (_tmp0_, icon_name) != 0) {
		indicator_set_icon_name (self, icon_name);
		indicator_set_icon_vector (self, NULL);
		changed = TRUE;
	}
	_tmp1_ = self->priv->_icon_desc;
	if (g_strcmp0 (_tmp1_, icon_desc) != 0) {
		indicator_set_icon_desc (self, icon_desc);
		changed = TRUE;
	}
	if (!changed) {
		return;
	}
	g_object_get ((IBusService*) self, "connection", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == NULL;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !self->priv->m_registered;
	}
	if (_tmp2_) {
		return;
	}
	{
		GDBusConnection* _tmp7_;
		GDBusConnection* _tmp8_;
		GDBusConnection* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		g_object_get ((IBusService*) self, "connection", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp11_ = _tmp10_;
		g_dbus_connection_emit_signal (_tmp9_, NULL, _tmp11_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE, "NewIcon", NULL, &_inner_error0_);
		_g_object_unref0 (_tmp9_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("indicator.vala:558: Unable to send signal for NewIcon: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
indicator_set_cairo_image_surface_full (Indicator* self,
                                        cairo_surface_t* image,
                                        const gchar* icon_desc)
{
	gint width = 0;
	gint height = 0;
	gint stride = 0;
	guint8* data = NULL;
	guchar* _tmp0_;
	gint data_length1;
	gint _data_size_;
	GBytes* bytes = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	GBytes* _tmp2_;
	GVariant* bs = NULL;
	const GVariantType* _tmp3_;
	GBytes* _tmp4_;
	GVariant* _tmp5_;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariantBuilder* _tmp8_;
	GVariantBuilder* _tmp9_;
	GVariantBuilder* _tmp10_;
	GVariantType* _tmp11_;
	GVariantType* _tmp12_;
	GVariantBuilder* _tmp13_;
	GVariantBuilder* _tmp14_;
	GVariantBuilder* _tmp15_;
	GVariant* _tmp16_;
	GVariantBuilder* _tmp17_;
	GVariantBuilder* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	const gchar* _tmp21_;
	GDBusConnection* _tmp22_;
	GDBusConnection* _tmp23_;
	GDBusConnection* _tmp24_;
	gboolean _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	width = cairo_image_surface_get_width (image);
	height = cairo_image_surface_get_height (image);
	stride = cairo_image_surface_get_stride (image);
	_tmp0_ = cairo_image_surface_get_data (image);
	data = (guint8*) _tmp0_;
	data_length1 = (-1 * sizeof (guchar)) / sizeof (guint8);
	_data_size_ = data_length1;
	data_length1 = stride * height;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = g_bytes_new (_tmp1_, _tmp1__length1);
	bytes = _tmp2_;
	_tmp3_ = G_VARIANT_TYPE_BYTESTRING;
	_tmp4_ = bytes;
	_tmp5_ = g_variant_new_from_bytes (_tmp3_, _tmp4_, TRUE);
	g_variant_ref_sink (_tmp5_);
	bs = _tmp5_;
	_tmp6_ = g_variant_type_new ("a(iiay)");
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_builder_new (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_type_free0 (_tmp7_);
	builder = _tmp9_;
	_tmp10_ = builder;
	_tmp11_ = g_variant_type_new ("(iiay)");
	_tmp12_ = _tmp11_;
	g_variant_builder_open (_tmp10_, _tmp12_);
	_g_variant_type_free0 (_tmp12_);
	_tmp13_ = builder;
	g_variant_builder_add (_tmp13_, "i", width, NULL);
	_tmp14_ = builder;
	g_variant_builder_add (_tmp14_, "i", height, NULL);
	_tmp15_ = builder;
	_tmp16_ = bs;
	g_variant_builder_add_value (_tmp15_, _tmp16_);
	_tmp17_ = builder;
	g_variant_builder_close (_tmp17_);
	_tmp18_ = builder;
	_tmp19_ = g_variant_new ("a(iiay)", _tmp18_, NULL);
	g_variant_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	indicator_set_icon_vector (self, _tmp20_);
	_g_variant_unref0 (_tmp20_);
	indicator_set_icon_name (self, "");
	_tmp21_ = self->priv->_icon_desc;
	if (g_strcmp0 (_tmp21_, icon_desc) != 0) {
		indicator_set_icon_desc (self, icon_desc);
	}
	g_object_get ((IBusService*) self, "connection", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_ == NULL;
	_g_object_unref0 (_tmp24_);
	if (_tmp25_) {
		_g_variant_builder_unref0 (builder);
		_g_variant_unref0 (bs);
		_g_bytes_unref0 (bytes);
		return;
	}
	{
		GDBusConnection* _tmp26_;
		GDBusConnection* _tmp27_;
		GDBusConnection* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		g_object_get ((IBusService*) self, "connection", &_tmp26_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp30_ = _tmp29_;
		g_dbus_connection_emit_signal (_tmp28_, NULL, _tmp30_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE, "NewIcon", NULL, &_inner_error0_);
		_g_object_unref0 (_tmp28_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("indicator.vala:602: Unable to send signal for NewIcon: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_builder_unref0 (builder);
		_g_variant_unref0 (bs);
		_g_bytes_unref0 (bytes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_variant_builder_unref0 (builder);
	_g_variant_unref0 (bs);
	_g_bytes_unref0 (bytes);
}

void
indicator_set_menu (Indicator* self,
                    GtkMenu* menu)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkMenu* _tmp2_;
	DbusmenuServer* _tmp3_;
	DbusmenuMenuitem* root = NULL;
	DbusmenuMenuitem* _tmp9_;
	DbusmenuServer* _tmp10_;
	DbusmenuMenuitem* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = ibus_service_get_object_path ((IBusService*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = _g_object_ref0 (menu);
	_g_object_unref0 (self->priv->m_menu);
	self->priv->m_menu = _tmp2_;
	_tmp3_ = self->priv->m_dbusmenu_server;
	if (_tmp3_ == NULL) {
		gchar* path = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		DbusmenuServer* _tmp8_;
		_tmp4_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "/Menu", NULL);
		path = _tmp6_;
		_tmp7_ = path;
		_tmp8_ = dbusmenu_server_new (_tmp7_);
		_g_object_unref0 (self->priv->m_dbusmenu_server);
		self->priv->m_dbusmenu_server = _tmp8_;
		_g_free0 (path);
	}
	_tmp9_ = dbusmenu_gtk_parse_menu_structure ((GtkWidget*) menu);
	root = _tmp9_;
	_tmp10_ = self->priv->m_dbusmenu_server;
	_tmp11_ = root;
	dbusmenu_server_set_root (_tmp10_, _tmp11_);
	indicator_check_connect (self);
	_g_object_unref0 (root);
}

void
indicator_position_context_menu (Indicator* self,
                                 GtkMenu* menu,
                                 gint* x,
                                 gint* y,
                                 gboolean* push_in)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_vala_x = self->priv->m_context_menu_x;
	_vala_y = self->priv->m_context_menu_y;
	_vala_push_in = FALSE;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

void
indicator_position_activate_menu (Indicator* self,
                                  GtkMenu* menu,
                                  gint* x,
                                  gint* y,
                                  gboolean* push_in)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_vala_x = self->priv->m_activate_menu_x;
	_vala_y = self->priv->m_activate_menu_y;
	_vala_push_in = FALSE;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

/**
     * unregister_connection:
     *
     * "Destroy" dbus method is not called for the indicator's connection
     * when panel's connection is disconnected because the dbus connection
     * is a shared session bus so need to call
     * g_dbus_connection_unregister_object() by manual here
     * so that g_object_unref(m_panel) will be called later with an idle method,
     * which was assigned in the arguments of
     * g_dbus_connection_register_object()
     */
void
indicator_unregister_connection (Indicator* self)
{
	GDBusConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ibus_service_get_connection ((IBusService*) self);
	ibus_service_unregister ((IBusService*) self, _tmp0_);
}

const gchar*
indicator_get_id (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
indicator_set_id (Indicator* self,
                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ID_PROPERTY]);
	}
}

const gchar*
indicator_get_category_s (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category_s;
	result = _tmp0_;
	return result;
}

static void
indicator_set_category_s (Indicator* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_category_s (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category_s);
		self->priv->_category_s = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_CATEGORY_S_PROPERTY]);
	}
}

const gchar*
indicator_get_status_s (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status_s;
	result = _tmp0_;
	return result;
}

void
indicator_set_status_s (Indicator* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_status_s (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_status_s);
		self->priv->_status_s = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_STATUS_S_PROPERTY]);
	}
}

const gchar*
indicator_get_icon_name (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

void
indicator_set_icon_name (Indicator* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_NAME_PROPERTY]);
	}
}

const gchar*
indicator_get_icon_desc (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_desc;
	result = _tmp0_;
	return result;
}

void
indicator_set_icon_desc (Indicator* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_icon_desc (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_desc);
		self->priv->_icon_desc = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_DESC_PROPERTY]);
	}
}

const gchar*
indicator_get_attention_icon_name (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_name;
	result = _tmp0_;
	return result;
}

void
indicator_set_attention_icon_name (Indicator* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_attention_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_attention_icon_name);
		self->priv->_attention_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ATTENTION_ICON_NAME_PROPERTY]);
	}
}

const gchar*
indicator_get_attention_icon_desc (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_desc;
	result = _tmp0_;
	return result;
}

void
indicator_set_attention_icon_desc (Indicator* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_attention_icon_desc (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_attention_icon_desc);
		self->priv->_attention_icon_desc = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ATTENTION_ICON_DESC_PROPERTY]);
	}
}

const gchar*
indicator_get_title (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
indicator_set_title (Indicator* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_TITLE_PROPERTY]);
	}
}

const gchar*
indicator_get_icon_theme_path (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_theme_path;
	result = _tmp0_;
	return result;
}

void
indicator_set_icon_theme_path (Indicator* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_icon_theme_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_theme_path);
		self->priv->_icon_theme_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_THEME_PATH_PROPERTY]);
	}
}

gboolean
indicator_get_connected (Indicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_connected;
	return result;
}

void
indicator_set_connected (Indicator* self,
                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_connected (self);
	if (old_value != value) {
		self->priv->_connected = value;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_CONNECTED_PROPERTY]);
	}
}

const gchar*
indicator_get_label_s (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_s;
	result = _tmp0_;
	return result;
}

void
indicator_set_label_s (Indicator* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_label_s (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_s);
		self->priv->_label_s = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_LABEL_S_PROPERTY]);
	}
}

const gchar*
indicator_get_label_guide_s (Indicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_guide_s;
	result = _tmp0_;
	return result;
}

void
indicator_set_label_guide_s (Indicator* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_label_guide_s (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_guide_s);
		self->priv->_label_guide_s = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_LABEL_GUIDE_S_PROPERTY]);
	}
}

guint32
indicator_get_ordering_index (Indicator* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_ordering_index;
	return result;
}

void
indicator_set_ordering_index (Indicator* self,
                              guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_ordering_index (self);
	if (old_value != value) {
		self->priv->_ordering_index = value;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ORDERING_INDEX_PROPERTY]);
	}
}

GVariant*
indicator_get_icon_vector (Indicator* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_vector;
	result = _tmp0_;
	return result;
}

void
indicator_set_icon_vector (Indicator* self,
                           GVariant* value)
{
	GVariant* old_value;
	g_return_if_fail (self != NULL);
	old_value = indicator_get_icon_vector (self);
	if (old_value != value) {
		GVariant* _tmp0_;
		_tmp0_ = _g_variant_ref0 (value);
		_g_variant_unref0 (self->priv->_icon_vector);
		self->priv->_icon_vector = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_VECTOR_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT_OBJECT_UINT_UINT (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_OBJECT_UINT_UINT) (gpointer data1, gint arg_1, gint arg_2, gpointer arg_3, guint arg_4, guint arg_5, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_OBJECT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_OBJECT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_object (param_values + 3), g_value_get_uint (param_values + 4), g_value_get_uint (param_values + 5), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_INT_OBJECT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_OBJECT) (gpointer data1, gint arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_object (param_values + 3), data2);
}

static void
indicator_class_init (IndicatorClass * klass,
                      gpointer klass_data)
{
	indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Indicator_private_offset);
	((IBusServiceClass *) klass)->service_method_call = (void (*) (IBusService*, GDBusConnection*, const gchar*, const gchar*, const gchar*, const gchar*, GVariant*, GDBusMethodInvocation*)) indicator_real_service_method_call;
	((IBusServiceClass *) klass)->service_get_property = (GVariant* (*) (IBusService*, GDBusConnection*, const gchar*, const gchar*, const gchar*, const gchar*, GError**)) indicator_real_service_get_property;
	((IBusServiceClass *) klass)->service_set_property = (gboolean (*) (IBusService*, GDBusConnection*, const gchar*, const gchar*, const gchar*, const gchar*, GVariant*, GError**)) indicator_real_service_set_property;
	G_OBJECT_CLASS (klass)->get_property = _vala_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ID_PROPERTY, indicator_properties[INDICATOR_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_CATEGORY_S_PROPERTY, indicator_properties[INDICATOR_CATEGORY_S_PROPERTY] = g_param_spec_string ("category-s", "category-s", "category-s", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_STATUS_S_PROPERTY, indicator_properties[INDICATOR_STATUS_S_PROPERTY] = g_param_spec_string ("status-s", "status-s", "status-s", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_NAME_PROPERTY, indicator_properties[INDICATOR_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_DESC_PROPERTY, indicator_properties[INDICATOR_ICON_DESC_PROPERTY] = g_param_spec_string ("icon-desc", "icon-desc", "icon-desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ATTENTION_ICON_NAME_PROPERTY, indicator_properties[INDICATOR_ATTENTION_ICON_NAME_PROPERTY] = g_param_spec_string ("attention-icon-name", "attention-icon-name", "attention-icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ATTENTION_ICON_DESC_PROPERTY, indicator_properties[INDICATOR_ATTENTION_ICON_DESC_PROPERTY] = g_param_spec_string ("attention-icon-desc", "attention-icon-desc", "attention-icon-desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_TITLE_PROPERTY, indicator_properties[INDICATOR_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_THEME_PATH_PROPERTY, indicator_properties[INDICATOR_ICON_THEME_PATH_PROPERTY] = g_param_spec_string ("icon-theme-path", "icon-theme-path", "icon-theme-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_CONNECTED_PROPERTY, indicator_properties[INDICATOR_CONNECTED_PROPERTY] = g_param_spec_boolean ("connected", "connected", "connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_LABEL_S_PROPERTY, indicator_properties[INDICATOR_LABEL_S_PROPERTY] = g_param_spec_string ("label-s", "label-s", "label-s", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_LABEL_GUIDE_S_PROPERTY, indicator_properties[INDICATOR_LABEL_GUIDE_S_PROPERTY] = g_param_spec_string ("label-guide-s", "label-guide-s", "label-guide-s", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ORDERING_INDEX_PROPERTY, indicator_properties[INDICATOR_ORDERING_INDEX_PROPERTY] = g_param_spec_uint ("ordering-index", "ordering-index", "ordering-index", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_VECTOR_PROPERTY, indicator_properties[INDICATOR_ICON_VECTOR_PROPERTY] = g_param_spec_variant ("icon-vector", "icon-vector", "icon-vector", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	indicator_signals[INDICATOR_CONTEXT_MENU_SIGNAL] = g_signal_new ("context-menu", TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_OBJECT_UINT_UINT, G_TYPE_NONE, 5, G_TYPE_INT, G_TYPE_INT, gdk_window_get_type (), G_TYPE_UINT, G_TYPE_UINT);
	indicator_signals[INDICATOR_ACTIVATE_SIGNAL] = g_signal_new ("activate", TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_OBJECT, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, gdk_window_get_type ());
	indicator_signals[INDICATOR_SECONDARY_ACTIVATE_SIGNAL] = g_signal_new ("secondary-activate", TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	indicator_signals[INDICATOR_REGISTERED_STATUS_NOTIFIER_ITEM_SIGNAL] = g_signal_new ("registered-status-notifier-item", TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
indicator_instance_init (Indicator * self,
                         gpointer klass)
{
	self->priv = indicator_get_instance_private (self);
}

static void
indicator_finalize (GObject * obj)
{
	Indicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INDICATOR, Indicator);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_category_s);
	_g_free0 (self->priv->_status_s);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_icon_desc);
	_g_free0 (self->priv->_attention_icon_name);
	_g_free0 (self->priv->_attention_icon_desc);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_icon_theme_path);
	_g_free0 (self->priv->_label_s);
	_g_free0 (self->priv->_label_guide_s);
	_g_variant_unref0 (self->priv->_icon_vector);
	_g_dbus_node_info_unref0 (self->priv->m_watcher_node_info);
	_g_object_unref0 (self->priv->m_proxy);
	_g_object_unref0 (self->priv->m_indicator_window);
	_g_object_unref0 (self->priv->m_menu);
	_g_object_unref0 (self->priv->m_dbusmenu_server);
	G_OBJECT_CLASS (indicator_parent_class)->finalize (obj);
}

static GType
indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (IndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Indicator), 0, (GInstanceInitFunc) indicator_instance_init, NULL };
	GType indicator_type_id;
	indicator_type_id = g_type_register_static (ibus_service_get_type (), "Indicator", &g_define_type_info, 0);
	Indicator_private_offset = g_type_add_instance_private (indicator_type_id, sizeof (IndicatorPrivate));
	return indicator_type_id;
}

GType
indicator_get_type (void)
{
	static volatile gsize indicator_type_id__once = 0;
	if (g_once_init_enter (&indicator_type_id__once)) {
		GType indicator_type_id;
		indicator_type_id = indicator_get_type_once ();
		g_once_init_leave (&indicator_type_id__once, indicator_type_id);
	}
	return indicator_type_id__once;
}

static void
_vala_indicator_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Indicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR, Indicator);
	switch (property_id) {
		case INDICATOR_ID_PROPERTY:
		g_value_set_string (value, indicator_get_id (self));
		break;
		case INDICATOR_CATEGORY_S_PROPERTY:
		g_value_set_string (value, indicator_get_category_s (self));
		break;
		case INDICATOR_STATUS_S_PROPERTY:
		g_value_set_string (value, indicator_get_status_s (self));
		break;
		case INDICATOR_ICON_NAME_PROPERTY:
		g_value_set_string (value, indicator_get_icon_name (self));
		break;
		case INDICATOR_ICON_DESC_PROPERTY:
		g_value_set_string (value, indicator_get_icon_desc (self));
		break;
		case INDICATOR_ATTENTION_ICON_NAME_PROPERTY:
		g_value_set_string (value, indicator_get_attention_icon_name (self));
		break;
		case INDICATOR_ATTENTION_ICON_DESC_PROPERTY:
		g_value_set_string (value, indicator_get_attention_icon_desc (self));
		break;
		case INDICATOR_TITLE_PROPERTY:
		g_value_set_string (value, indicator_get_title (self));
		break;
		case INDICATOR_ICON_THEME_PATH_PROPERTY:
		g_value_set_string (value, indicator_get_icon_theme_path (self));
		break;
		case INDICATOR_CONNECTED_PROPERTY:
		g_value_set_boolean (value, indicator_get_connected (self));
		break;
		case INDICATOR_LABEL_S_PROPERTY:
		g_value_set_string (value, indicator_get_label_s (self));
		break;
		case INDICATOR_LABEL_GUIDE_S_PROPERTY:
		g_value_set_string (value, indicator_get_label_guide_s (self));
		break;
		case INDICATOR_ORDERING_INDEX_PROPERTY:
		g_value_set_uint (value, indicator_get_ordering_index (self));
		break;
		case INDICATOR_ICON_VECTOR_PROPERTY:
		g_value_set_variant (value, indicator_get_icon_vector (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_indicator_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	Indicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR, Indicator);
	switch (property_id) {
		case INDICATOR_ID_PROPERTY:
		indicator_set_id (self, g_value_get_string (value));
		break;
		case INDICATOR_CATEGORY_S_PROPERTY:
		indicator_set_category_s (self, g_value_get_string (value));
		break;
		case INDICATOR_STATUS_S_PROPERTY:
		indicator_set_status_s (self, g_value_get_string (value));
		break;
		case INDICATOR_ICON_NAME_PROPERTY:
		indicator_set_icon_name (self, g_value_get_string (value));
		break;
		case INDICATOR_ICON_DESC_PROPERTY:
		indicator_set_icon_desc (self, g_value_get_string (value));
		break;
		case INDICATOR_ATTENTION_ICON_NAME_PROPERTY:
		indicator_set_attention_icon_name (self, g_value_get_string (value));
		break;
		case INDICATOR_ATTENTION_ICON_DESC_PROPERTY:
		indicator_set_attention_icon_desc (self, g_value_get_string (value));
		break;
		case INDICATOR_TITLE_PROPERTY:
		indicator_set_title (self, g_value_get_string (value));
		break;
		case INDICATOR_ICON_THEME_PATH_PROPERTY:
		indicator_set_icon_theme_path (self, g_value_get_string (value));
		break;
		case INDICATOR_CONNECTED_PROPERTY:
		indicator_set_connected (self, g_value_get_boolean (value));
		break;
		case INDICATOR_LABEL_S_PROPERTY:
		indicator_set_label_s (self, g_value_get_string (value));
		break;
		case INDICATOR_LABEL_GUIDE_S_PROPERTY:
		indicator_set_label_guide_s (self, g_value_get_string (value));
		break;
		case INDICATOR_ORDERING_INDEX_PROPERTY:
		indicator_set_ordering_index (self, g_value_get_uint (value));
		break;
		case INDICATOR_ICON_VECTOR_PROPERTY:
		indicator_set_icon_vector (self, g_value_get_variant (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

