/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.ExceptionUtils;

public class ApplicationContextFacade
implements ServletContext {
    private final Map<String, Class<?>[]> classCache;
    private final Map<String, Method> objectCache;
    private final ApplicationContext context;

    public ApplicationContextFacade(ApplicationContext applicationContext) {
        this.context = applicationContext;
        this.classCache = new HashMap<String, Class<?>[]>();
        this.objectCache = new ConcurrentHashMap<String, Method>();
        this.initClassCache();
    }

    private void initClassCache() {
        Class[] classArray = new Class[]{String.class};
        this.classCache.put("getContext", classArray);
        this.classCache.put("getMimeType", classArray);
        this.classCache.put("getResourcePaths", classArray);
        this.classCache.put("getResource", classArray);
        this.classCache.put("getResourceAsStream", classArray);
        this.classCache.put("getRequestDispatcher", classArray);
        this.classCache.put("getNamedDispatcher", classArray);
        this.classCache.put("getServlet", classArray);
        this.classCache.put("setInitParameter", new Class[]{String.class, String.class});
        this.classCache.put("createServlet", new Class[]{Class.class});
        this.classCache.put("addServlet", new Class[]{String.class, String.class});
        this.classCache.put("createFilter", new Class[]{Class.class});
        this.classCache.put("addFilter", new Class[]{String.class, String.class});
        this.classCache.put("createListener", new Class[]{Class.class});
        this.classCache.put("addListener", classArray);
        this.classCache.put("getFilterRegistration", classArray);
        this.classCache.put("getServletRegistration", classArray);
        this.classCache.put("getInitParameter", classArray);
        this.classCache.put("setAttribute", new Class[]{String.class, Object.class});
        this.classCache.put("removeAttribute", classArray);
        this.classCache.put("getRealPath", classArray);
        this.classCache.put("getAttribute", classArray);
        this.classCache.put("log", classArray);
        this.classCache.put("setSessionTrackingModes", new Class[]{Set.class});
        this.classCache.put("addJspFile", new Class[]{String.class, String.class});
        this.classCache.put("declareRoles", new Class[]{String[].class});
        this.classCache.put("setSessionTimeout", new Class[]{Integer.TYPE});
        this.classCache.put("setRequestCharacterEncoding", new Class[]{String.class});
        this.classCache.put("setResponseCharacterEncoding", new Class[]{String.class});
    }

    public ServletContext getContext(String string) {
        ServletContext servletContext = null;
        servletContext = SecurityUtil.isPackageProtectionEnabled() ? (ServletContext)this.doPrivileged("getContext", new Object[]{string}) : this.context.getContext(string);
        if (servletContext != null && servletContext instanceof ApplicationContext) {
            servletContext = ((ApplicationContext)servletContext).getFacade();
        }
        return servletContext;
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public String getMimeType(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getMimeType", new Object[]{string});
        }
        return this.context.getMimeType(string);
    }

    public Set<String> getResourcePaths(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Set)this.doPrivileged("getResourcePaths", new Object[]{string});
        }
        return this.context.getResourcePaths(string);
    }

    public URL getResource(String string) throws MalformedURLException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                return (URL)this.invokeMethod(this.context, "getResource", new Object[]{string});
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (throwable instanceof MalformedURLException) {
                    throw (MalformedURLException)throwable;
                }
                return null;
            }
        }
        return this.context.getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (InputStream)this.doPrivileged("getResourceAsStream", new Object[]{string});
        }
        return this.context.getResourceAsStream(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (RequestDispatcher)this.doPrivileged("getRequestDispatcher", new Object[]{string});
        }
        return this.context.getRequestDispatcher(string);
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (RequestDispatcher)this.doPrivileged("getNamedDispatcher", new Object[]{string});
        }
        return this.context.getNamedDispatcher(string);
    }

    public void log(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("log", new Object[]{string});
        } else {
            this.context.log(string);
        }
    }

    public void log(String string, Throwable throwable) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("log", new Class[]{String.class, Throwable.class}, new Object[]{string, throwable});
        } else {
            this.context.log(string, throwable);
        }
    }

    public String getRealPath(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getRealPath", new Object[]{string});
        }
        return this.context.getRealPath(string);
    }

    public String getServerInfo() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getServerInfo", null);
        }
        return this.context.getServerInfo();
    }

    public String getInitParameter(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getInitParameter", new Object[]{string});
        }
        return this.context.getInitParameter(string);
    }

    public Enumeration<String> getInitParameterNames() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)this.doPrivileged("getInitParameterNames", null);
        }
        return this.context.getInitParameterNames();
    }

    public Object getAttribute(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return this.doPrivileged("getAttribute", new Object[]{string});
        }
        return this.context.getAttribute(string);
    }

    public Enumeration<String> getAttributeNames() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)this.doPrivileged("getAttributeNames", null);
        }
        return this.context.getAttributeNames();
    }

    public void setAttribute(String string, Object object) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("setAttribute", new Object[]{string, object});
        } else {
            this.context.setAttribute(string, object);
        }
    }

    public void removeAttribute(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("removeAttribute", new Object[]{string});
        } else {
            this.context.removeAttribute(string);
        }
    }

    public String getServletContextName() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getServletContextName", null);
        }
        return this.context.getServletContextName();
    }

    public String getContextPath() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getContextPath", null);
        }
        return this.context.getContextPath();
    }

    public FilterRegistration.Dynamic addFilter(String string, String string2) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration.Dynamic)this.doPrivileged("addFilter", new Object[]{string, string2});
        }
        return this.context.addFilter(string, string2);
    }

    public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration.Dynamic)this.doPrivileged("addFilter", new Class[]{String.class, Filter.class}, new Object[]{string, filter});
        }
        return this.context.addFilter(string, filter);
    }

    public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration.Dynamic)this.doPrivileged("addFilter", new Class[]{String.class, Class.class}, new Object[]{string, clazz});
        }
        return this.context.addFilter(string, clazz);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                return (T)((Filter)this.invokeMethod(this.context, "createFilter", new Object[]{clazz}));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (throwable instanceof ServletException) {
                    throw (ServletException)throwable;
                }
                return null;
            }
        }
        return this.context.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration)this.doPrivileged("getFilterRegistration", new Object[]{string});
        }
        return this.context.getFilterRegistration(string);
    }

    public ServletRegistration.Dynamic addServlet(String string, String string2) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration.Dynamic)this.doPrivileged("addServlet", new Object[]{string, string2});
        }
        return this.context.addServlet(string, string2);
    }

    public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration.Dynamic)this.doPrivileged("addServlet", new Class[]{String.class, Servlet.class}, new Object[]{string, servlet});
        }
        return this.context.addServlet(string, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration.Dynamic)this.doPrivileged("addServlet", new Class[]{String.class, Class.class}, new Object[]{string, clazz});
        }
        return this.context.addServlet(string, clazz);
    }

    public ServletRegistration.Dynamic addJspFile(String string, String string2) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration.Dynamic)this.doPrivileged("addJspFile", new Object[]{string, string2});
        }
        return this.context.addJspFile(string, string2);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                return (T)((Servlet)this.invokeMethod(this.context, "createServlet", new Object[]{clazz}));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (throwable instanceof ServletException) {
                    throw (ServletException)throwable;
                }
                return null;
            }
        }
        return this.context.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration)this.doPrivileged("getServletRegistration", new Object[]{string});
        }
        return this.context.getServletRegistration(string);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Set)this.doPrivileged("getDefaultSessionTrackingModes", null);
        }
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Set)this.doPrivileged("getEffectiveSessionTrackingModes", null);
        }
        return this.context.getEffectiveSessionTrackingModes();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (SessionCookieConfig)this.doPrivileged("getSessionCookieConfig", null);
        }
        return this.context.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("setSessionTrackingModes", new Object[]{set});
        } else {
            this.context.setSessionTrackingModes(set);
        }
    }

    public boolean setInitParameter(String string, String string2) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Boolean)this.doPrivileged("setInitParameter", new Object[]{string, string2});
        }
        return this.context.setInitParameter(string, string2);
    }

    public void addListener(Class<? extends EventListener> clazz) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("addListener", new Class[]{Class.class}, new Object[]{clazz});
        } else {
            this.context.addListener(clazz);
        }
    }

    public void addListener(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("addListener", new Object[]{string});
        } else {
            this.context.addListener(string);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("addListener", new Class[]{EventListener.class}, new Object[]{t});
        } else {
            this.context.addListener(t);
        }
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                return (T)((EventListener)this.invokeMethod(this.context, "createListener", new Object[]{clazz}));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (throwable instanceof ServletException) {
                    throw (ServletException)throwable;
                }
                return null;
            }
        }
        return this.context.createListener(clazz);
    }

    public void declareRoles(String ... stringArray) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("declareRoles", new Object[]{stringArray});
        } else {
            this.context.declareRoles(stringArray);
        }
    }

    public ClassLoader getClassLoader() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ClassLoader)this.doPrivileged("getClassLoader", null);
        }
        return this.context.getClassLoader();
    }

    public int getEffectiveMajorVersion() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Integer)this.doPrivileged("getEffectiveMajorVersion", null);
        }
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Integer)this.doPrivileged("getEffectiveMinorVersion", null);
        }
        return this.context.getEffectiveMinorVersion();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Map)this.doPrivileged("getFilterRegistrations", null);
        }
        return this.context.getFilterRegistrations();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (JspConfigDescriptor)this.doPrivileged("getJspConfigDescriptor", null);
        }
        return this.context.getJspConfigDescriptor();
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Map)this.doPrivileged("getServletRegistrations", null);
        }
        return this.context.getServletRegistrations();
    }

    public String getVirtualServerName() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getVirtualServerName", null);
        }
        return this.context.getVirtualServerName();
    }

    public int getSessionTimeout() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Integer)this.doPrivileged("getSessionTimeout", null);
        }
        return this.context.getSessionTimeout();
    }

    public void setSessionTimeout(int n) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("setSessionTimeout", new Object[]{n});
        } else {
            this.context.setSessionTimeout(n);
        }
    }

    public String getRequestCharacterEncoding() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getRequestCharacterEncoding", null);
        }
        return this.context.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("setRequestCharacterEncoding", new Object[]{string});
        } else {
            this.context.setRequestCharacterEncoding(string);
        }
    }

    public String getResponseCharacterEncoding() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getResponseCharacterEncoding", null);
        }
        return this.context.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("setResponseCharacterEncoding", new Object[]{string});
        } else {
            this.context.setResponseCharacterEncoding(string);
        }
    }

    private Object doPrivileged(String string, Object[] objectArray) {
        try {
            return this.invokeMethod(this.context, string, objectArray);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(ApplicationContext applicationContext, String string, Object[] objectArray) throws Throwable {
        try {
            Method method = this.objectCache.get(string);
            if (method == null) {
                method = applicationContext.getClass().getMethod(string, this.classCache.get(string));
                this.objectCache.put(string, method);
            }
            Object object = this.executeMethod(method, applicationContext, objectArray);
            return object;
        }
        catch (Exception exception) {
            this.handleException(exception);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            objectArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doPrivileged(String string, Class<?>[] classArray, Object[] objectArray) {
        try {
            Method method = this.context.getClass().getMethod(string, classArray);
            Object object = this.executeMethod(method, this.context, objectArray);
            return object;
        }
        catch (Exception exception) {
            try {
                this.handleException(exception);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                throw new RuntimeException(throwable.getMessage());
            }
            Object var5_8 = null;
            return var5_8;
        }
        finally {
            objectArray = null;
        }
    }

    private Object executeMethod(Method method, ApplicationContext applicationContext, Object[] objectArray) throws PrivilegedActionException, IllegalAccessException, InvocationTargetException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedExecuteMethod(method, applicationContext, objectArray));
        }
        return method.invoke((Object)applicationContext, objectArray);
    }

    private void handleException(Exception exception) throws Throwable {
        Throwable throwable;
        if (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        if (exception instanceof InvocationTargetException) {
            throwable = exception.getCause();
            if (throwable == null) {
                throwable = exception;
            }
        } else {
            throwable = exception;
        }
        throw throwable;
    }

    private static class PrivilegedExecuteMethod
    implements PrivilegedExceptionAction<Object> {
        private final Method method;
        private final ApplicationContext context;
        private final Object[] params;

        PrivilegedExecuteMethod(Method method, ApplicationContext applicationContext, Object[] objectArray) {
            this.method = method;
            this.context = applicationContext;
            this.params = objectArray;
        }

        @Override
        public Object run() throws Exception {
            return this.method.invoke((Object)this.context, this.params);
        }
    }
}

