/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import one.util.streamex.StreamEx;

class SemanticRules {
    private static final NodePattern frontedNonVerbalModifier = CommonPatterns.firstChildPhrase.noPos("VB.*").andOr(NodePattern.N.withDependent("cop", NodePattern.N.form("being")).noDependents("aux.*"), NodePattern.N.noDependents("cop|aux|aux:pass").noDependents("case", CommonPatterns.firstWord.pos("VBN")));
    static final NodePattern subjectModifier = NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|mark").andOr(NodePattern.N.pos("VBG|VBN"), frontedNonVerbalModifier).noDependents("advmod", NodePattern.N.form("when"));

    SemanticRules() {
    }

    static NodePattern danglingModifier() {
        NodePattern adjSemanticMismatch = new ConjSequence(NodePattern.N.potentialPos("JJ.*")).any(SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Subject));
        NodePattern npSemanticMismatch = new ConjSequence(NodePattern.N.pos("NN.*")).any(SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Subject));
        NodePattern verbObjSemanticMismatch = SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Object);
        NodePattern verbSubjSemanticMismatch = NodePattern.or(SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Subject), SemCompatibility.Possible.between(SemCompatibility.Relation.Subject, NodePointer.anchor(), NodePointer.marked("Noun")).markAs("Predicate").and(NodePattern.markedNodeMatches("MainClause", CommonPatterns.possiblySkipDown("xcomp", NodePattern.N.withDependent("i?obj|obl", SemCompatibility.Likely.between(SemCompatibility.Relation.Subject, NodePointer.marked("Predicate"), NodePointer.anchor()))))));
        NodePattern postNpModifier = EnglishTreePatterns.clause.afterHead().withPrevSibling(NodePattern.N.afterHead().withHeadRelation("nsubj.*|i?obj|obl").markAs("Noun")).andOr(NodePattern.markedNodeMatches("Noun", NodePattern.N.pos("PRP.*").message("This modifier phrase doesn\u2019t seem to relate to the nearest pronoun '$Noun'")), NodePattern.N.message("This modifier phrase doesn\u2019t seem to relate to the nearest noun '$Noun'"));
        NodePattern clauseSubjectModifier = NodePattern.markedNodeMatches("MainClause", NodePattern.N.withDependent("nsubj(:pass)?|expl", NodePattern.N.noLabel("PRODUCT|ORGANIZATION").markAs("Noun"))).message("This modifier phrase doesn\u2019t seem to relate to the subject '$Noun'");
        NodePattern passiveVbnModifier = NodePattern.N.pos("VBN").andOr(NodePattern.N.withDependent("aux:pass|cop", NodePattern.N.form("being")), NodePattern.N.noDependents("cop|aux|aux:pass"));
        NodePattern gerundModifier = NodePattern.or(NodePattern.N.pos("VBG"), NodePattern.N.pos("VBN").withDependent("aux", NodePattern.N.form("having")));
        NodePattern skipNsubjMainCl = CommonPatterns.skipUp("nsubj", NodePattern.N.markAs("MainClause"));
        NodePattern commonIntroPhrase = NodePattern.or(NodePattern.N.form("considering"), NodePattern.N.form("considered").withDependent("aux", NodePattern.N.form("having")));
        return subjectModifier.andNot(CommonPatterns.possiblySkipDown("conj", commonIntroPhrase)).andOr(NodePattern.N.withHead("advcl", skipNsubjMainCl), NodePattern.N.beforeHead().and(CommonPatterns.phraseEndsWithComma).withHead("acl|amod", skipNsubjMainCl)).andOr(postNpModifier, clauseSubjectModifier).andOr(frontedNonVerbalModifier.andOr(npSemanticMismatch, adjSemanticMismatch), new ConjSequence(passiveVbnModifier).any(verbObjSemanticMismatch), new ConjSequence(gerundModifier.noDependents("aux:pass")).any(verbSubjSemanticMismatch), new ConjSequence(gerundModifier.withDependent("aux:pass")).any(verbObjSemanticMismatch)).and(CommonPatterns.highlightPhrase());
    }

    private static NodePattern incompatibleWithNoun(SemCompatibility.Relation rel) {
        return SemCompatibility.Unlikely.between(rel, NodePointer.anchor(), NodePointer.marked("Noun"));
    }

    private record ConjSequence(NodePattern filter) {
        NodePattern any(NodePattern condition) {
            return NodePattern.custom((node, match) -> {
                for (Node conj : StreamEx.of((Object)node).append(node.findDependents("conj"))) {
                    if (this.filter.match(conj, match) == null) {
                        return null;
                    }
                    NodeMatch cm = condition.match(conj, match);
                    if (cm == null) continue;
                    return cm;
                }
                return null;
            });
        }
    }
}

