/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartHAxis
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartHAxis() {
        super(false, CommandChartHAxis.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartHAxis.class.getName(), RegexLeaf.start(), new RegexLeaf("h-axis"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "TITLE", "\"([^\"]+)\"")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(2, "RANGE", "(-?[0-9.]+)\\s*-->\\s*(-?[0-9.]+)")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "DATA", "\\[(.*)\\]")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("spacing"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "SPACING", "([0-9]+)"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "LABELRIGHT", "(label-right)")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "GRID", "(grid)")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String title = arg.getLazzy("TITLE", 0);
        String minStr = arg.getLazzy("RANGE", 0);
        String maxStr = arg.getLazzy("RANGE", 1);
        String data = arg.getLazzy("DATA", 0);
        String spacingStr = arg.getLazzy("SPACING", 0);
        String labelRightStr = arg.getLazzy("LABELRIGHT", 0);
        String gridStr = arg.getLazzy("GRID", 0);
        if (spacingStr != null) {
            try {
                int spacing = Integer.parseInt(spacingStr);
                if (spacing <= 0) {
                    return CommandExecutionResult.error("X-axis spacing must be greater than 0");
                }
                diagram.setXAxisTickSpacing(spacing);
            }
            catch (NumberFormatException e) {
                return CommandExecutionResult.error("Invalid number format in spacing value");
            }
        }
        if (labelRightStr != null) {
            diagram.setXAxisLabelPosition(ChartAxis.LabelPosition.RIGHT);
        }
        if (gridStr != null) {
            diagram.setXGridMode(ChartDiagram.GridMode.MAJOR);
        }
        if (minStr != null && maxStr != null) {
            try {
                double min = Double.parseDouble(minStr);
                double max = Double.parseDouble(maxStr);
                return diagram.setXAxis(title, min, max);
            }
            catch (NumberFormatException e) {
                return CommandExecutionResult.error("Invalid number format in axis range");
            }
        }
        List<String> labels = this.parseLabels(data);
        diagram.setXAxisTitle(title);
        return diagram.setXAxisLabels(labels);
    }

    private List<String> parseLabels(String data) {
        String[] parts;
        ArrayList<String> result = new ArrayList<String>();
        if (data == null || data.trim().isEmpty()) {
            return result;
        }
        for (String part : parts = data.split(",")) {
            String label = part.trim();
            if (label.startsWith("\"") && label.endsWith("\"")) {
                label = label.substring(1, label.length() - 1);
            }
            result.add(label);
        }
        return result;
    }
}

