/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.util.List;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;

public class LineRenderer {
    private final ISkinParam skinParam;
    private final double plotWidth;
    private final double plotHeight;
    private final int categoryCount;
    private final ChartAxis axis;
    private final ChartAxis xAxis;

    public LineRenderer(ISkinParam skinParam, double plotWidth, double plotHeight, int categoryCount, ChartAxis axis, ChartAxis xAxis) {
        this.skinParam = skinParam;
        this.plotWidth = plotWidth;
        this.plotHeight = plotHeight;
        this.categoryCount = categoryCount;
        this.axis = axis;
        this.xAxis = xAxis;
    }

    public void draw(UGraphic ug, ChartSeries series, HColor color) {
        if (this.categoryCount == 0 && !series.hasExplicitXValues()) {
            return;
        }
        List<Double> values = series.getValues();
        if (series.hasExplicitXValues()) {
            List<Double> xValues = series.getXValues();
            if (this.xAxis == null) {
                System.err.println("ERROR: xAxis is null in coordinate-pair mode!");
                return;
            }
            for (int i = 0; i < values.size() - 1; ++i) {
                double xVal1 = xValues.get(i);
                double yVal1 = values.get(i);
                double xVal2 = xValues.get(i + 1);
                double yVal2 = values.get(i + 1);
                double x1 = this.xAxis.valueToPixel(xVal1, 0.0, this.plotWidth);
                double y1 = this.plotHeight - (yVal1 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                double x2 = this.xAxis.valueToPixel(xVal2, 0.0, this.plotWidth);
                double y2 = this.plotHeight - (yVal2 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                ULine line = new ULine(x2 - x1, y2 - y1);
                ug.apply(color).apply(UStroke.withThickness(2.0)).apply(UTranslate.dx(x1).compose(UTranslate.dy(y1))).draw(line);
            }
        } else {
            double categoryWidth = this.plotWidth / (double)this.categoryCount;
            for (int i = 0; i < Math.min(values.size() - 1, this.categoryCount - 1); ++i) {
                double value1 = values.get(i);
                double value2 = values.get(i + 1);
                double x1 = ((double)i + 0.5) * categoryWidth;
                double y1 = this.plotHeight - (value1 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                double x2 = ((double)i + 1.5) * categoryWidth;
                double y2 = this.plotHeight - (value2 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                ULine line = new ULine(x2 - x1, y2 - y1);
                ug.apply(color).apply(UStroke.withThickness(2.0)).apply(UTranslate.dx(x1).compose(UTranslate.dy(y1))).draw(line);
            }
        }
    }
}

