/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.binder.internal;

import org.hibernate.AnnotationException;
import org.hibernate.annotations.DiscriminatorOptions;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;

public class DiscriminatorOptionsBinder
implements TypeBinder<DiscriminatorOptions> {
    @Override
    public void bind(DiscriminatorOptions options, MetadataBuildingContext context, PersistentClass persistentClass) {
        RootClass rootClass;
        if (persistentClass instanceof RootClass) {
            rootClass = (RootClass)persistentClass;
            if (!rootClass.hasDiscriminator()) {
                throw new AnnotationException("Root entity '" + rootClass.getEntityName() + "' is annotated '@DiscriminatorOptions' but has no discriminator column");
            }
        } else {
            throw new AnnotationException("Class '" + persistentClass.getClassName() + "' is not the root class of an entity inheritance hierarchy and may not be annotated '@DiscriminatorOptions'");
        }
        rootClass.setForceDiscriminator(options.force());
        rootClass.setDiscriminatorInsertable(options.insert());
    }

    @Override
    public void bind(DiscriminatorOptions options, MetadataBuildingContext context, Component embeddableClass) {
        throw new AnnotationException("Class '" + embeddableClass.getComponentClassName() + "' is an '@Embeddable' type and may not be annotated '@DiscriminatorOptions'");
    }
}

