/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaPackage;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Module {
    public static void define(ThreadContext context, RubyClass _Module) {
        _Module.defineMethods(context, Module.class);
    }

    @JRubyMethod(name={"import"}, visibility=Visibility.PRIVATE)
    public static IRubyObject import_(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        String name2;
        int i2;
        if (arg2 instanceof RubyString ? (i2 = (name2 = ((RubyString)arg2).decodeString()).lastIndexOf(46)) != -1 && i2 + 1 < name2.length() && Character.isUpperCase(name2.charAt(i2 + 1)) : arg2 instanceof RubyModule && ((RubyModule)arg2).getJavaProxy() && !(arg2 instanceof JavaPackage)) {
            return Module.java_import(context, self2, arg2, block);
        }
        return Module.include_package(context, self2, arg2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject java_import(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return arg2 instanceof RubyArray ? Module.java_import(context, self2, ((RubyArray)arg2).toJavaArrayMaybeUnsafe(), block) : Create.newArray(context, Module.javaImport(context, (RubyModule)self2, arg2, block));
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_import(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        IRubyObject[] classes = ((RubyArray)RubyArray.newArrayNoCopy(context.runtime, args2).flatten(context)).toJavaArrayMaybeUnsafe();
        for (int i2 = 0; i2 < classes.length; ++i2) {
            classes[i2] = Module.javaImport(context, (RubyModule)self2, classes[i2], block);
        }
        return Create.newArray(context, classes);
    }

    private static IRubyObject javaImport(ThreadContext context, RubyModule target2, IRubyObject klass, Block block) {
        String constant;
        Class javaClass;
        if (klass instanceof RubyString) {
            String className = klass.asJavaString();
            if (!JavaUtilities.validJavaIdentifier(className)) {
                throw Error.argumentError(context, "not a valid Java identifier: " + className);
            }
            if (className.contains("::")) {
                throw Error.argumentError(context, "must use Java style name: " + className);
            }
            javaClass = Java.getJavaClass(context, className);
        } else {
            if (klass instanceof JavaPackage) {
                throw Error.argumentError(context, "java_import does not work for Java packages (try include_package instead)");
            }
            if (klass instanceof RubyModule) {
                javaClass = JavaUtil.getJavaClass((RubyModule)klass, null);
                if (javaClass == null) {
                    throw Error.argumentError(context, "not a Java class or interface: " + String.valueOf(klass.inspect(context)));
                }
            } else {
                throw Error.argumentError(context, "invalid Java class or interface: " + String.valueOf(klass.inspect(context)) + " (of type " + String.valueOf(klass.getType()) + ")");
            }
        }
        if (block.isGiven()) {
            int i2 = javaClass.getName().lastIndexOf(46);
            String packageName = i2 != -1 ? javaClass.getName().substring(0, i2) : "";
            String className = javaClass.getSimpleName();
            IRubyObject ret = block.yieldSpecific(context, Create.newString(context, packageName), Create.newString(context, className));
            constant = ret.convertToString().asJavaString();
        } else {
            constant = javaClass.getSimpleName();
        }
        try {
            return Java.setProxyClass(context, target2, constant, javaClass);
        }
        catch (NameError e) {
            String message2 = "cannot import Java class " + javaClass.getName() + " as '" + constant + "' : " + String.valueOf(e.getException().getMessage());
            throw (RaiseException)Error.nameError(context, message2, constant).initCause(e);
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject java_alias(ThreadContext context, IRubyObject self2, IRubyObject new_id, IRubyObject old_id) {
        IncludedPackages includedPackages = Module.getIncludedPackages(context, (RubyModule)self2);
        if (!(new_id instanceof RubySymbol)) {
            new_id = new_id.convertToString().intern(context);
        }
        if (!(old_id instanceof RubySymbol)) {
            old_id = old_id.convertToString().intern(context);
        }
        includedPackages.javaAliases.put(((RubySymbol)new_id).idString(), ((RubySymbol)old_id).idString());
        return old_id;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject include_package(ThreadContext context, IRubyObject self2, IRubyObject pkg) {
        String packageName = pkg instanceof JavaPackage ? ((JavaPackage)pkg).getPackageName() : (pkg.respondsTo("package_name") ? pkg.callMethod(context, "package_name").convertToString().asJavaString() : pkg.convertToString().asJavaString());
        IncludedPackages includedPackages = Module.getIncludedPackages(context, (RubyModule)self2);
        return includedPackages.packages.add(packageName) ? pkg : context.nil;
    }

    private static IncludedPackages getIncludedPackages(ThreadContext context, RubyModule target2) {
        IncludedPackages includedPackages = (IncludedPackages)target2.getInternalVariable("includedPackages");
        if (includedPackages == null) {
            includedPackages = new IncludedPackages();
            target2.setInternalVariable("includedPackages", includedPackages);
            ConstMissingMethod method2 = new ConstMissingMethod(target2, includedPackages);
            Helpers.addInstanceMethod(target2.singletonClass(context), Convert.asSymbol(context, "const_missing"), method2, Visibility.PUBLIC, context);
        }
        return includedPackages;
    }

    private static class IncludedPackages {
        final Collection<String> packages = new LinkedHashSet<String>(8);
        final Map<String, String> javaAliases = new HashMap<String, String>(4);

        IncludedPackages() {
        }
    }

    private static final class ConstMissingMethod
    extends JavaMethod.JavaMethodOne {
        private final IncludedPackages includedPackages;

        ConstMissingMethod(RubyModule implClass, IncludedPackages includedPackages) {
            super(implClass, Visibility.PUBLIC, "const_missing");
            this.includedPackages = includedPackages;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klass, String name2, IRubyObject constant) {
            String constName = ((RubySymbol)constant).idString();
            String realName = this.includedPackages.javaAliases.getOrDefault(constName, constName);
            Class foundClass = null;
            for (String packageName : this.includedPackages.packages) {
                try {
                    foundClass = Java.loadJavaClass(context, packageName + "." + realName);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (foundClass == null) {
                try {
                    return Helpers.invokeSuper(context, self2, klass, "const_missing", constant, Block.NULL_BLOCK);
                }
                catch (NameError e) {
                    throw Error.nameError(context, String.valueOf(constant) + " not found in packages: " + this.joinedPackageNames(), constant);
                }
            }
            try {
                return Java.setProxyClass(context, (RubyModule)self2, constName, foundClass);
            }
            catch (NameError e) {
                String message2 = "cannot set Java class " + foundClass.getName() + " as '" + String.valueOf(constant) + "' : " + String.valueOf(e.getException().getMessage());
                throw Error.nameError(context, message2, constant);
            }
        }

        private String joinedPackageNames() {
            return String.join((CharSequence)", ", this.includedPackages.packages);
        }
    }
}

