/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.api.Convert;
import org.jruby.ast.DefNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.RootNode;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.builder.IRBuilderFactory;
import org.jruby.ir.builder.LazyMethodDefinitionAST;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.ToggleBacktraceInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.listeners.IRScopeListener;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.BuiltinClass;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.TemporaryIntVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.passes.BasicCompilerPassListener;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassListener;
import org.jruby.ir.passes.CompilerPassScheduler;
import org.jruby.ir.passes.DeadCodeElimination;
import org.jruby.ir.passes.OptimizeDelegationPass;
import org.jruby.ir.passes.OptimizeDynScopesPass;
import org.jruby.ir.util.IGVInstrListener;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.cli.Options;

public class IRManager {
    public static final String SAFE_COMPILER_PASSES = "";
    public static final String DEFAULT_BUILD_PASSES = "";
    public static final String DEFAULT_JIT_PASSES = "LocalOptimizationPass,DeadCodeElimination,OptimizeDynScopesPass,OptimizeDelegationPass,AddCallProtocolInstructions,AddMissingInitsPass";
    public static final String DEFAULT_INLINING_COMPILER_PASSES = "LocalOptimizationPass";
    public static final boolean IR_INLINER = Options.IR_INLINER.load();
    public static final int IR_INLINER_THRESHOLD = Options.IR_INLINER_THRESHOLD.load();
    public static final boolean IR_INLINER_VERBOSE = Options.IR_INLINER_VERBOSE.load();
    private final CompilerPass deadCodeEliminationPass = new DeadCodeElimination();
    private final CompilerPass optimizeDynScopesPass = new OptimizeDynScopesPass();
    private final CompilerPass optimizeDelegationPass = new OptimizeDelegationPass();
    private static final ByteList OBJECT = new ByteList(new byte[]{79, 98, 106, 101, 99, 116});
    private int dummyMetaClassCount = 0;
    private final IRModuleBody object;
    private final Nil nil = new Nil();
    private final Boolean tru = new Boolean(true);
    private final Boolean fals = new Boolean(false);
    private final BuiltinClass arrayClass = new BuiltinClass(BuiltinClass.Type.ARRAY);
    private final BuiltinClass hashClass = new BuiltinClass(BuiltinClass.Type.HASH);
    private final BuiltinClass objectClass = new BuiltinClass(BuiltinClass.Type.OBJECT);
    private final BuiltinClass symbolClass = new BuiltinClass(BuiltinClass.Type.SYMBOL);
    private final StandardError standardError = new StandardError();
    public final ToggleBacktraceInstr needsBacktrace = new ToggleBacktraceInstr(true);
    public final ToggleBacktraceInstr needsNoBacktrace = new ToggleBacktraceInstr(false);
    private final Set<CompilerPassListener> passListeners = new HashSet<CompilerPassListener>();
    private final CompilerPassListener defaultListener = new BasicCompilerPassListener();
    private InstructionsListener instrsListener = null;
    private IRScopeListener irScopeListener = null;
    private final List<CompilerPass> compilerPasses;
    private final List<CompilerPass> inliningCompilerPasses;
    private final List<CompilerPass> jitPasses;
    private final List<CompilerPass> safePasses;
    private final RubyInstanceConfig config;
    public final Ruby runtime;
    private IRBuilderFactory builderFactory;
    private static final int CLOSURE_PREFIX_CACHE_SIZE = 300;
    private final String[] closurePrefixCache = new String[300];
    private static final int FIXNUM_CACHE_HALF_SIZE = 16384;
    private final Fixnum[] fixnums = new Fixnum[32768];
    private final ReceiveSelfInstr receiveSelfInstr = new ReceiveSelfInstr(Self.SELF);
    private LineNumberInstr[] lineNumbers = new LineNumberInstr[3000];
    private TemporaryLocalVariable[] temporaryLocalVariables = new TemporaryLocalVariable[1600];

    public IRManager(Ruby runtime2, RubyInstanceConfig config) {
        this.runtime = runtime2;
        this.config = config;
        this.object = new IRClassBody(this, null, OBJECT, 0, null, false);
        this.compilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, "");
        this.inliningCompilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, DEFAULT_INLINING_COMPILER_PASSES);
        this.jitPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_JIT_PASSES, DEFAULT_JIT_PASSES);
        this.safePasses = CompilerPass.getPassesFromString(null, "");
        if (RubyInstanceConfig.IR_DEBUG_IGV != null) {
            this.instrsListener = new IGVInstrListener();
        }
    }

    public void setBuilderFactory(IRBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    public IRBuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public Nil getNil() {
        return this.nil;
    }

    public StandardError getStandardError() {
        return this.standardError;
    }

    public BuiltinClass getArrayClass() {
        return this.arrayClass;
    }

    public BuiltinClass getObjectClass() {
        return this.objectClass;
    }

    public BuiltinClass getHashClass() {
        return this.hashClass;
    }

    public Boolean getTrue() {
        return this.tru;
    }

    public Boolean getFalse() {
        return this.fals;
    }

    public IRModuleBody getObject() {
        return this.object;
    }

    public ToggleBacktraceInstr needsBacktrace(boolean needsIt) {
        return needsIt ? this.needsBacktrace : this.needsNoBacktrace;
    }

    public CompilerPassScheduler schedulePasses() {
        return IRManager.schedulePasses(this.compilerPasses);
    }

    public static CompilerPassScheduler schedulePasses(final List<CompilerPass> passes) {
        CompilerPassScheduler scheduler = new CompilerPassScheduler(){
            private final Iterator<CompilerPass> iterator;
            {
                this.iterator = passes.iterator();
            }

            @Override
            public Iterator<CompilerPass> iterator() {
                return this.iterator;
            }
        };
        return scheduler;
    }

    public List<CompilerPass> getCompilerPasses(IRScope scope) {
        return this.compilerPasses;
    }

    public List<CompilerPass> getInliningCompilerPasses(IRScope scope) {
        return this.inliningCompilerPasses;
    }

    public List<CompilerPass> getJITPasses(IRScope scope) {
        return this.jitPasses;
    }

    public List<CompilerPass> getSafePasses(IRScope scope) {
        return this.safePasses;
    }

    public Set<CompilerPassListener> getListeners() {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            this.addListener(this.defaultListener);
        } else {
            this.removeListener(this.defaultListener);
        }
        return this.passListeners;
    }

    public InstructionsListener getInstructionsListener() {
        return this.instrsListener;
    }

    public IRScopeListener getIRScopeListener() {
        return this.irScopeListener;
    }

    public void addListener(CompilerPassListener listener) {
        this.passListeners.add(listener);
    }

    public void removeListener(CompilerPassListener listener) {
        this.passListeners.remove(listener);
    }

    public void addListener(InstructionsListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.instrsListener != null) {
                throw new RuntimeException("InstructionsListener is set and other are currently not allowed");
            }
            this.instrsListener = listener;
        }
    }

    public void removeListener(InstructionsListener listener) {
        if (this.instrsListener.equals(listener)) {
            this.instrsListener = null;
        }
    }

    public void addListener(IRScopeListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.irScopeListener != null) {
                throw new RuntimeException("IRScopeListener is set and other are currently not allowed");
            }
            this.irScopeListener = listener;
        }
    }

    public String getClosurePrefix(int closureId) {
        if (closureId >= 300) {
            return "CL" + closureId + "_LBL";
        }
        Object prefix = this.closurePrefixCache[closureId];
        if (prefix == null) {
            this.closurePrefixCache[closureId] = prefix = "CL" + closureId + "_LBL";
        }
        return prefix;
    }

    public Fixnum newFixnum(long value2) {
        Fixnum fixnum;
        if (value2 < -16384L || value2 > 16384L) {
            return new Fixnum(value2);
        }
        int adjustedValue = (int)value2 + 16384;
        if (adjustedValue >= 0 && adjustedValue < this.fixnums.length) {
            fixnum = this.fixnums[adjustedValue];
            if (fixnum == null) {
                this.fixnums[adjustedValue] = fixnum = new Fixnum(value2);
            }
        } else {
            fixnum = new Fixnum(value2);
        }
        return fixnum;
    }

    public LineNumberInstr newLineNumber(int line) {
        if (line >= this.lineNumbers.length - 1) {
            this.growLineNumbersPool(line);
        }
        if (line < 0) {
            return new LineNumberInstr(line);
        }
        LineNumberInstr tempVar = this.lineNumbers[line];
        if (tempVar == null) {
            this.lineNumbers[line] = tempVar = new LineNumberInstr(line);
        }
        return tempVar;
    }

    public ReceiveSelfInstr getReceiveSelfInstr() {
        return this.receiveSelfInstr;
    }

    protected LineNumberInstr[] growLineNumbersPool(int index2) {
        int newLength = index2 * 2;
        LineNumberInstr[] newPool = new LineNumberInstr[newLength];
        System.arraycopy(this.lineNumbers, 0, newPool, 0, this.lineNumbers.length);
        this.lineNumbers = newPool;
        return newPool;
    }

    public void removeListener(IRScopeListener listener) {
        if (this.irScopeListener.equals(listener)) {
            this.irScopeListener = null;
        }
    }

    public RubySymbol getMetaClassName() {
        return this.runtime.newSymbol("<DUMMY_MC:" + this.dummyMetaClassCount++ + ">");
    }

    protected TemporaryLocalVariable[] growTemporaryVariablePool(int index2) {
        int newLength = index2 * 2;
        TemporaryLocalVariable[] newPool = new TemporaryLocalVariable[newLength];
        System.arraycopy(this.temporaryLocalVariables, 0, newPool, 0, this.temporaryLocalVariables.length);
        this.temporaryLocalVariables = newPool;
        return newPool;
    }

    public TemporaryLocalVariable newTemporaryLocalVariable(int index2) {
        TemporaryLocalVariable tempVar;
        if (index2 >= this.temporaryLocalVariables.length - 1) {
            this.growTemporaryVariablePool(index2);
        }
        if ((tempVar = this.temporaryLocalVariables[index2]) == null) {
            this.temporaryLocalVariables[index2] = tempVar = new TemporaryLocalVariable(index2);
        }
        return tempVar;
    }

    public TemporaryLocalVariable newTemporaryIntVariable(int index2) {
        TemporaryLocalVariable tempVar;
        if (index2 >= this.temporaryLocalVariables.length - 1) {
            this.growTemporaryVariablePool(index2);
        }
        if ((tempVar = this.temporaryLocalVariables[index2]) == null || !(tempVar instanceof TemporaryIntVariable)) {
            this.temporaryLocalVariables[index2] = tempVar = new TemporaryIntVariable(index2);
        }
        return tempVar;
    }

    protected void optimizeIfSimpleScope(FullInterpreterContext fic) {
        if (RubyInstanceConfig.IR_COMPILER_PASSES != null) {
            return;
        }
        EnumSet<IRFlags> flags2 = fic.getFlags();
        if (!flags2.contains((Object)IRFlags.REQUIRES_DYNSCOPE)) {
            if (fic.getScope().receivesClosureArg()) {
                this.optimizeDelegationPass.run(fic);
            }
            this.deadCodeEliminationPass.run(fic);
            this.optimizeDynScopesPass.run(fic);
        }
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    public IRMethod loadInternalMethod(ThreadContext context, IRubyObject self2, String method2) {
        try {
            RubyClass type2 = self2.getMetaClass();
            String fileName = "classpath:/jruby/ruby_implementations/" + String.valueOf(type2) + "/" + method2 + ".rb";
            FileResource file2 = JRubyFile.createResourceAsFile(context.runtime, fileName);
            ParseResult parseResult = this.parse(context, file2, fileName);
            IScopingNode scopeNode = (IScopingNode)((Object)((RootNode)parseResult.getAST()).childNodes().get(0));
            scopeNode.getScope().setModule(type2);
            DefNode defNode = (DefNode)((Object)scopeNode.getBodyNode());
            IRScriptBody script = new IRScriptBody(this, parseResult.getFile(), parseResult.getStaticScope());
            IRModuleBody containingScope = scopeNode instanceof ModuleNode ? new IRModuleBody(this, (IRScope)script, scopeNode.getCPath().getName().getBytes(), 0, scopeNode.getScope(), false) : new IRClassBody(this, (IRScope)script, scopeNode.getCPath().getName().getBytes(), 0, scopeNode.getScope(), false);
            LazyMethodDefinitionAST defn = new LazyMethodDefinitionAST(defNode);
            IRMethod newMethod = new IRMethod(this, containingScope, defn, Convert.asSymbol(context, method2).getBytes(), true, 0, defNode.getScope(), 0);
            newMethod.prepareForCompilation();
            return newMethod;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ParseResult parse(ThreadContext context, FileResource file2, String fileName) throws IOException {
        try (InputStream stream = file2.openInputStream();){
            ParseResult parseResult = context.runtime.getParserManager().parseFile(fileName, 0, stream, UTF8Encoding.INSTANCE);
            return parseResult;
        }
    }

    public BuiltinClass getSymbolClass() {
        return this.symbolClass;
    }
}

