#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 turtle
version:              1.6.2
visibility:           public
id:                   turtle-1.6.2-Lgf1tgBEu0aL7qToj3WBz2
key:                  turtle-1.6.2-Lgf1tgBEu0aL7qToj3WBz2
license:              BSD-3-Clause
copyright:            2015 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  ac7b7b1ffc5b7437328ac0aaa03a01a7
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-turtle
hs-libraries:         HSturtle-1.6.2-Lgf1tgBEu0aL7qToj3WBz2
depends:
    ansi-wl-pprint-1.0.2-8PdqdGNxOxyAJJq7Gv7caQ
    async-2.2.5-BExe3HBSFHr8hii1cT1bvS base-4.18.2.1
    bytestring-0.11.5.3 clock-0.8.4-7n7VUJdNxZy2oIUMx4fXQ1
    containers-0.6.7 directory-1.3.8.5 exceptions-0.10.7
    filepath-1.4.300.1 foldl-1.4.18-10k2ShlkIIw4qVg5KTr0w3
    hostname-1.0-EOhxbdAArOFEFh3i6bjNP6
    managed-1.0.11-2Pnugu46RECJRycwImdLZr
    optional-args-1.0.2-F0xejbU8T85GOpMOmS9nLh
    optparse-applicative-0.18.1.0-9I3qDpNxi1rBTnWffPMXX3
    process-1.6.19.0 stm-2.5.1.0
    streaming-commons-0.2.3.1-D1O7CCofCAb4YDJ83dqUtH
    temporary-1.3-7FXkQQKerYU7UfmRyKNwo9 text-2.0.2 time-1.12.2
    transformers-0.6.1.0 unix-2.8.4.0
    unix-compat-0.7.4.1-DqDzbwuaouv1yXLtKQLq3q

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

