/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.IconManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XmlIconProvider
extends IconProvider
implements DumbAware {
    @NonNls
    private static final String XSD_FILE_EXTENSION = "xsd";
    @NonNls
    private static final String WSDL_FILE_EXTENSION = "wsdl";

    XmlIconProvider() {
    }

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int _flags) {
        VirtualFile vf;
        if (element == null) {
            XmlIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof XmlFile && (vf = ((XmlFile)element).getVirtualFile()) != null) {
            String extension = vf.getExtension();
            if (XSD_FILE_EXTENSION.equals(extension)) {
                return IconManager.getInstance().createLayeredIcon((Iconable)element, AllIcons.FileTypes.XsdFile, ElementBase.transformFlags((PsiElement)element, (int)_flags));
            }
            if (WSDL_FILE_EXTENSION.equals(extension)) {
                return IconManager.getInstance().createLayeredIcon((Iconable)element, AllIcons.FileTypes.WsdlFile, ElementBase.transformFlags((PsiElement)element, (int)_flags));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/XmlIconProvider", "getIcon"));
    }
}

