/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyEnabledFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public final class GroovyFileType
extends LanguageFileType {
    @NotNull
    public static final GroovyFileType GROOVY_FILE_TYPE = new GroovyFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "groovy";
    @NlsSafe
    private static final String GROOVY_DESCRIPTION = "Groovy";

    private GroovyFileType() {
        super((Language)GroovyLanguage.INSTANCE);
    }

    @NotNull
    @NonNls
    public String getName() {
        return GROOVY_DESCRIPTION;
    }

    @NotNull
    public String getDescription() {
        return GROOVY_DESCRIPTION;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    @NotNull
    public static @NotNull FileType @NotNull [] getGroovyEnabledFileTypes() {
        LinkedHashSet result2 = new LinkedHashSet();
        result2.addAll(ContainerUtil.filter((Object[])FileTypeManager.getInstance().getRegisteredFileTypes(), GroovyFileType::isGroovyEnabledFileType));
        FileType[] fileTypeArray = result2.toArray(FileType.EMPTY_ARRAY);
        if (fileTypeArray == null) {
            GroovyFileType.$$$reportNull$$$0(0);
        }
        return fileTypeArray;
    }

    private static boolean isGroovyEnabledFileType(FileType ft) {
        return ft instanceof GroovyEnabledFileType || ft instanceof LanguageFileType && ((LanguageFileType)ft).getLanguage() == GroovyLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/GroovyFileType", "getGroovyEnabledFileTypes"));
    }
}

