/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.model.action.PeriodMonth;
import tr.view.action.DaysOfMonthDialog;

public class PeriodMonthlyPanel
extends JPanel {
    private final Dialog parent;
    private final PeriodMonth periodMonth;
    private ButtonGroup buttonGroup;
    private JComboBox dayCombo;
    private JButton daysButton;
    private JRadioButton eachRadio;
    private JComboBox nthCombo;
    private JRadioButton onTheRadio;

    public PeriodMonthlyPanel(Dialog parent, PeriodMonth periodMonth) {
        this.parent = parent;
        this.periodMonth = periodMonth;
        this.initView();
        this.eachRadio.setSelected(periodMonth.getOption() == PeriodMonth.Option.Each);
        this.onTheRadio.setSelected(periodMonth.getOption() == PeriodMonth.Option.OnThe);
        this.dayCombo.setModel(this.getDayComboModel());
        this.dayCombo.setSelectedItem(periodMonth.getOnTheDay());
        this.nthCombo.setModel(this.getNthComboModel());
        this.nthCombo.setSelectedItem(periodMonth.getOnTheNth());
        this.setEnabled(true);
    }

    private String getSelectedDaysText() {
        return this.periodMonth.getSelectedDaysText();
    }

    private ComboBoxModel getDayComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheDay>(PeriodMonth.OnTheDay.values());
    }

    private ComboBoxModel getNthComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheNth>(PeriodMonth.OnTheNth.values());
    }

    public void notifyStartDate(Date startDate) {
        if (startDate == null) {
            return;
        }
        if (this.periodMonth.getSelectedDays().size() > 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        this.periodMonth.select(Integer.valueOf(calendar.get(5)));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.daysButton.setEnabled(enabled && this.eachRadio.isSelected());
        this.nthCombo.setEnabled(enabled && this.onTheRadio.isSelected());
        this.dayCombo.setEnabled(enabled && this.onTheRadio.isSelected());
        this.eachRadio.setEnabled(enabled);
        this.onTheRadio.setEnabled(enabled);
    }

    private void initView() {
        this.eachRadio = new JRadioButton(this.getMsg("months.each"));
        this.eachRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.monthsRadioButtonAction(evt);
            }
        });
        this.daysButton = new JButton(this.getSelectedDaysText());
        this.daysButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.daysButtonAction(evt);
            }
        });
        this.onTheRadio = new JRadioButton(this.getMsg("months.on.the"));
        this.onTheRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.monthsRadioButtonAction(evt);
            }
        });
        this.nthCombo = new JComboBox();
        this.nthCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.onTheNthComboAction(evt);
            }
        });
        this.dayCombo = new JComboBox();
        this.dayCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.dayComboAction(evt);
            }
        });
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.eachRadio);
        this.buttonGroup.add(this.onTheRadio);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]0"));
        panel.add((Component)this.eachRadio, "");
        panel.add((Component)this.daysButton, "");
        panel.add((Component)this.onTheRadio, "");
        panel.add((Component)this.nthCombo, "");
        panel.add((Component)this.dayCombo, "wrap");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    private void dayComboAction(ActionEvent evt) {
        this.periodMonth.setOnTheDay((PeriodMonth.OnTheDay)this.dayCombo.getSelectedItem());
    }

    private void onTheNthComboAction(ActionEvent evt) {
        this.periodMonth.setOnTheNth((PeriodMonth.OnTheNth)this.nthCombo.getSelectedItem());
    }

    private void daysButtonAction(ActionEvent evt) {
        DaysOfMonthDialog dialog = new DaysOfMonthDialog(this.parent, this.daysButton);
        dialog.setPeriodMonth(this.periodMonth);
        dialog.setVisible(true);
        if (!dialog.cancelled()) {
            this.periodMonth.setSelectedDays(dialog.getSelectedDays());
            this.daysButton.setText(this.periodMonth.getSelectedDaysText());
        }
    }

    private void monthsRadioButtonAction(ActionEvent evt) {
        if (this.eachRadio.isSelected()) {
            this.periodMonth.setOption(PeriodMonth.Option.Each);
        } else {
            this.periodMonth.setOption(PeriodMonth.Option.OnThe);
        }
        this.setEnabled(true);
    }

    public String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private void initComponents() {
    }
}

