/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

class SimpleUserSearch
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:search";
    private DataForm form;
    private ReportedData data;

    SimpleUserSearch() {
        super(ELEMENT, NAMESPACE);
    }

    public void setForm(DataForm form) {
        this.form = form;
    }

    public ReportedData getReportedData() {
        return this.data;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.rightAngleBracket();
        buf.append(this.getItemsToSearch());
        return buf;
    }

    private String getItemsToSearch() {
        StringBuilder buf = new StringBuilder();
        if (this.form == null) {
            this.form = DataForm.from(this);
        }
        if (this.form == null) {
            return "";
        }
        for (FormField field : this.form.getFields()) {
            String name = field.getFieldName();
            String value2 = SimpleUserSearch.getSingleValue(field);
            if (value2.trim().length() <= 0) continue;
            buf.append('<').append(name).append('>').append(value2).append("</").append(name).append('>');
        }
        return buf.toString();
    }

    private static String getSingleValue(FormField formField) {
        List<String> values2 = formField.getValuesAsString();
        if (values2.isEmpty()) {
            return "";
        }
        return values2.get(0);
    }

    protected void parseItems(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ReportedData data = new ReportedData();
        data.addColumn(new ReportedData.Column("JID", "jid", FormField.Type.text_single));
        boolean done = false;
        ArrayList<ReportedData.Field> fields2 = new ArrayList<ReportedData.Field>();
        while (!done) {
            XmlPullParser.Event eventType;
            if (parser2.getAttributeCount() > 0) {
                String jid = parser2.getAttributeValue("", "jid");
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(jid);
                ReportedData.Field field = new ReportedData.Field("jid", valueList);
                fields2.add(field);
            }
            if ((eventType = parser2.next()) == XmlPullParser.Event.START_ELEMENT && parser2.getName().equals("item")) {
                fields2 = new ArrayList();
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser2.getName().equals("item")) {
                ReportedData.Row row = new ReportedData.Row(fields2);
                data.addRow(row);
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                String name = parser2.getName();
                String value2 = parser2.nextText();
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value2);
                ReportedData.Field field = new ReportedData.Field(name, valueList);
                fields2.add(field);
                boolean exists = false;
                for (ReportedData.Column column : data.getColumns()) {
                    if (!column.getVariable().equals(name)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                ReportedData.Column column = new ReportedData.Column(name, name, FormField.Type.text_single);
                data.addColumn(column);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals(ELEMENT)) continue;
            done = true;
        }
        this.data = data;
    }
}

