/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class UploadNotesTask {
    private NoteData noteData;

    public void uploadNotes(NoteData noteData, ProgressMonitor progressMonitor) {
        this.noteData = noteData;
        MainApplication.worker.submit(new UploadTask(I18n.tr("Uploading modified notes", new Object[0]), progressMonitor));
    }

    private class UploadTask
    extends PleaseWaitRunnable {
        private boolean isCanceled;
        private final Map<Note, Note> updatedNotes;
        private final Map<Note, Exception> failedNotes;

        UploadTask(String title, ProgressMonitor monitor) {
            super(title, monitor, false);
            this.updatedNotes = new HashMap<Note, Note>();
            this.failedNotes = new HashMap<Note, Exception>();
        }

        @Override
        protected void cancel() {
            Logging.debug("note upload canceled");
            this.isCanceled = true;
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor monitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            OsmApi api = OsmApi.getOsmApi();
            for (Note note : UploadNotesTask.this.noteData.getNotes()) {
                if (this.isCanceled) {
                    Logging.info("Note upload interrupted by user");
                    break;
                }
                for (NoteComment comment : note.getComments()) {
                    if (!comment.isNew()) continue;
                    Logging.debug("found note change to upload");
                    this.processNoteComment(monitor, api, note, comment);
                }
            }
        }

        private void processNoteComment(ProgressMonitor monitor, OsmApi api, Note note, NoteComment comment) {
            block9: {
                try {
                    Note newNote;
                    if (this.updatedNotes.containsKey(note)) {
                        note = this.updatedNotes.get(note);
                    }
                    switch (comment.getNoteAction()) {
                        case OPENED: {
                            Logging.debug("opening new note");
                            newNote = api.createNote(note.getLatLon(), comment.getText(), monitor);
                            break;
                        }
                        case CLOSED: {
                            Logging.debug("closing note {0}", note.getId());
                            newNote = api.closeNote(note, comment.getText(), monitor);
                            break;
                        }
                        case COMMENTED: {
                            Logging.debug("adding comment to note {0}", note.getId());
                            newNote = api.addCommentToNote(note, comment.getText(), monitor);
                            break;
                        }
                        case REOPENED: {
                            Logging.debug("reopening note {0}", note.getId());
                            newNote = api.reopenNote(note, comment.getText(), monitor);
                            break;
                        }
                        default: {
                            newNote = null;
                        }
                    }
                    this.updatedNotes.put(note, newNote);
                }
                catch (OsmTransferException e) {
                    Logging.error("Failed to upload note to server: {0}", note.getId());
                    Logging.error(e);
                    if (e instanceof OsmTransferCanceledException) break block9;
                    this.failedNotes.put(note, e);
                }
            }
        }

        @Override
        protected void finish() {
            if (Logging.isDebugEnabled()) {
                Logging.debug("finish called in notes upload task. Notes to update: {0}", this.updatedNotes.size());
            }
            UploadNotesTask.this.noteData.updateNotes(this.updatedNotes);
            if (!this.failedNotes.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<Note, Exception> entry : this.failedNotes.entrySet()) {
                    sb.append(I18n.tr("Note {0} failed: {1}", entry.getKey().getId(), entry.getValue().getMessage())).append('\n');
                }
                Logging.error("Notes failed to upload: " + sb.toString());
                JOptionPane.showMessageDialog(MainApplication.getMap(), sb.toString(), I18n.tr("Notes failed to upload", new Object[0]), 0);
                ExceptionDialogUtil.explainException(this.failedNotes.values().iterator().next());
            }
        }
    }
}

