/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationConfig
implements Cloneable {
    public static final ReplicationConfig BULK = new ReplicationConfig("BULK", 1);
    public static final ReplicationConfig DELAYCLIENT = new ReplicationConfig("DELAYCLIENT", 2);
    public static final ReplicationConfig NOAUTOINIT = new ReplicationConfig("NOAUTOINIT", 4);
    public static final ReplicationConfig NOWAIT = new ReplicationConfig("NOWAIT", 8);
    private String configName;
    private int flag;

    static ReplicationConfig fromInt(int n) {
        switch (n) {
            case 1: {
                return BULK;
            }
            case 2: {
                return DELAYCLIENT;
            }
            case 4: {
                return NOAUTOINIT;
            }
            case 8: {
                return NOWAIT;
            }
        }
        throw new IllegalArgumentException("Unknown replication config: " + n);
    }

    private ReplicationConfig(String string, int n) {
        this.configName = string;
        this.flag = n;
    }

    int getFlag() {
        return this.flag;
    }

    public String toString() {
        return "ReplicationConfig." + this.configName;
    }
}

