/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.intercept.CallInterceptorRegistry;
import org.gradle.internal.classpath.intercept.CallSiteDecorator;
import org.gradle.internal.instrumentation.api.groovybytecode.CallInterceptor;
import org.gradle.internal.instrumentation.api.groovybytecode.InterceptScope;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.internal.lazy.Lazy;

@NonNullApi
public interface CallInterceptorResolver {
    @Nullable
    public CallInterceptor resolveCallInterceptor(InterceptScope var1);

    public boolean isAwareOfCallSiteName(String var1);

    @NonNullApi
    public static final class ClosureCallInterceptorResolver
    implements CallInterceptorResolver {
        private static final Lazy<Map<BytecodeInterceptorFilter, ClosureCallInterceptorResolver>> RESOLVERS = Lazy.locking().of(() -> {
            EnumMap<BytecodeInterceptorFilter, ClosureCallInterceptorResolver> resolvers = new EnumMap<BytecodeInterceptorFilter, ClosureCallInterceptorResolver>(BytecodeInterceptorFilter.class);
            for (BytecodeInterceptorFilter filter : BytecodeInterceptorFilter.values()) {
                resolvers.put(filter, new ClosureCallInterceptorResolver(filter));
            }
            return resolvers;
        });
        private final BytecodeInterceptorFilter interceptorFilter;

        public ClosureCallInterceptorResolver(BytecodeInterceptorFilter interceptorFilter) {
            this.interceptorFilter = interceptorFilter;
        }

        @Override
        @Nullable
        public CallInterceptor resolveCallInterceptor(InterceptScope scope) {
            CallSiteDecorator currentDecorator = CallInterceptorRegistry.getGroovyCallDecorator(this.interceptorFilter);
            if (currentDecorator instanceof CallInterceptorResolver) {
                return ((CallInterceptorResolver)((Object)currentDecorator)).resolveCallInterceptor(scope);
            }
            return null;
        }

        @Override
        public boolean isAwareOfCallSiteName(String name) {
            CallSiteDecorator currentDecorator = CallInterceptorRegistry.getGroovyCallDecorator(this.interceptorFilter);
            if (currentDecorator instanceof CallInterceptorResolver) {
                return ((CallInterceptorResolver)((Object)currentDecorator)).isAwareOfCallSiteName(name);
            }
            return false;
        }

        public static CallInterceptorResolver of(BytecodeInterceptorFilter filter) {
            return (CallInterceptorResolver)((Map)RESOLVERS.get()).get(filter);
        }
    }
}

