/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.checkin;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactPresentationKey;
import com.almworks.tracklink.util.StringBundle;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactColumnInfo<T>
extends ColumnInfo<ArtifactInfo, T> {
    private final ArtifactPresentationKey<T> myKey;

    public ArtifactColumnInfo(ArtifactPresentationKey<T> key) {
        super(StringBundle.get("Column." + key.getName(), new Object[0]));
        this.myKey = key;
    }

    public T valueOf(ArtifactInfo info) {
        if (info.getApplicableKeys().contains(this.myKey)) {
            return (T)info.getPresentation(this.myKey);
        }
        return null;
    }

    public Comparator<ArtifactInfo> getComparator() {
        return new Comparator<ArtifactInfo>(){

            @Override
            public int compare(ArtifactInfo info1, ArtifactInfo info2) {
                boolean app2;
                if (info1 == null || info2 == null) {
                    return 0;
                }
                Object value1 = info1.getPresentation(ArtifactColumnInfo.this.myKey);
                Object value2 = info2.getPresentation(ArtifactColumnInfo.this.myKey);
                boolean app1 = value1 != null;
                boolean bl = app2 = value2 != null;
                if (!app1 && !app2) {
                    return 0;
                }
                if (app2 && !app1) {
                    return -1;
                }
                if (app1 && !app2) {
                    return -1;
                }
                return ArtifactColumnInfo.this.myKey.getComparator().compare(value1, value2);
            }
        };
    }

    public boolean isCellEditable(ArtifactInfo o) {
        return false;
    }

    public Class getColumnClass() {
        return this.myKey.getValueClass();
    }

    public void setName(String s) {
    }

    public void setValue(ArtifactInfo o, T aValue) {
    }
}

