/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.Constants;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class MultiLineMappedMatcherSmall
extends AbstractMatcher {
    private SearchPattern searchPattern;
    private Pattern pattern;
    private int fileMatches = 0;
    private int itemMatches = 0;

    public MultiLineMappedMatcherSmall(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
        this.pattern = TextRegexpUtil.makeTextPattern(searchPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        MatchingObject.Def def;
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        MappedByteBuffer mappedByteBuffer;
        block18: {
            block19: {
                MatchingObject.Def def2;
                block16: {
                    block17: {
                        FileInputStream fileInputStream;
                        mappedByteBuffer = null;
                        abstractInterruptibleChannel = null;
                        try {
                            MatchingObject.Def def3;
                            searchListener.fileContentMatchingStarted(fileObject.getPath());
                            File file = FileUtil.toFile((FileObject)fileObject);
                            fileInputStream = new FileInputStream(file);
                            abstractInterruptibleChannel = fileInputStream.getChannel();
                            int n = (int)((FileChannel)abstractInterruptibleChannel).size();
                            mappedByteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_ONLY, 0L, n);
                            Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
                            CharsetDecoder charsetDecoder = this.prepareDecoder(charset);
                            charsetDecoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                            CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
                            List<TextDetail> list = this.matchWholeFile(charBuffer, fileObject);
                            if (list == null) {
                                def2 = null;
                                if (abstractInterruptibleChannel == null) break block16;
                                break block17;
                            }
                            def = def3 = new MatchingObject.Def(fileObject, charsetDecoder.charset(), list);
                            if (abstractInterruptibleChannel == null) break block18;
                            break block19;
                        }
                        catch (Exception exception) {
                            searchListener.generalError(exception);
                            fileInputStream = null;
                            return fileInputStream;
                        }
                    }
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {
                        searchListener.generalError(iOException);
                    }
                }
                MatcherUtils.unmap(mappedByteBuffer);
                return def2;
            }
            try {
                abstractInterruptibleChannel.close();
            }
            catch (IOException iOException) {
                searchListener.generalError(iOException);
            }
        }
        MatcherUtils.unmap(mappedByteBuffer);
        return def;
        finally {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {
                    searchListener.generalError(iOException);
                }
            }
            MatcherUtils.unmap(mappedByteBuffer);
        }
    }

    private List<TextDetail> matchWholeFile(CharSequence charSequence, FileObject fileObject) throws DataObjectNotFoundException {
        Matcher matcher = this.pattern.matcher(charSequence);
        DataObject dataObject = null;
        LineInfoHelper lineInfoHelper = new LineInfoHelper(charSequence);
        LinkedList<TextDetail> linkedList = null;
        while (matcher.find()) {
            if (linkedList == null) {
                linkedList = new LinkedList<TextDetail>();
                dataObject = DataObject.find((FileObject)fileObject);
                ++this.fileMatches;
            }
            ++this.itemMatches;
            TextDetail textDetail = new TextDetail(dataObject, this.searchPattern);
            lineInfoHelper.findAndSetPositionInfo(textDetail, matcher.start(), matcher.end(), matcher.group());
            linkedList.add(textDetail);
            if (this.fileMatches < Constants.COUNT_LIMIT && this.itemMatches < Constants.DETAILS_COUNT_LIMIT) continue;
            break;
        }
        return linkedList;
    }

    @Override
    public void terminate() {
    }

    static class LineInfoHelper {
        private static final Pattern linePattern = Pattern.compile("(.*)(\\r\\n|\\n|\\r)");
        private CharSequence charSequence;
        private Matcher lineMatcher;
        private int lastStartPos = 0;
        private int currentLineNumber = 0;
        private int currentLineStart = -1;
        private int currentLineEnd = -1;
        private String lastLine = null;

        public LineInfoHelper(CharSequence charSequence) {
            this.charSequence = charSequence;
            this.lineMatcher = linePattern.matcher(charSequence);
        }

        public void findAndSetPositionInfo(TextDetail textDetail, int n, int n2, String string) {
            if (n < this.lastStartPos) {
                throw new IllegalStateException("Start offset lower than the previous one.");
            }
            this.updateStateForPosition(n);
            this.setTextDetailInfo(textDetail, n, n2, string);
        }

        private void updateStateForPosition(int n) {
            if (n > this.currentLineEnd) {
                boolean bl = false;
                while (this.lineMatcher.find()) {
                    ++this.currentLineNumber;
                    this.currentLineEnd = this.lineMatcher.end() - 1;
                    if (this.lineMatcher.end() <= n) continue;
                    this.currentLineStart = this.lineMatcher.start();
                    this.lastLine = this.lineMatcher.group().trim();
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (this.currentLineNumber == 0) {
                        this.setupOnlyLine();
                    } else {
                        this.setupLastLine();
                    }
                }
            }
        }

        private void setTextDetailInfo(TextDetail textDetail, int n, int n2, String string) {
            textDetail.setLine(this.currentLineNumber);
            textDetail.setStartOffset(n);
            textDetail.setEndOffset(n2);
            textDetail.setMarkLength(n2 - n);
            textDetail.setMatchedText(string);
            textDetail.setColumn(n - this.currentLineStart + 1);
            textDetail.setLineText(this.lastLine);
        }

        private void setupLastLine() {
            ++this.currentLineNumber;
            this.currentLineStart = this.currentLineEnd + 1;
            this.currentLineEnd = this.charSequence.length();
            this.lastLine = this.charSequence.subSequence(this.currentLineStart, this.currentLineEnd).toString().trim();
        }

        private void setupOnlyLine() {
            this.currentLineNumber = 1;
            String string = this.charSequence.toString();
            this.currentLineStart = 0;
            this.currentLineEnd = string.length();
            this.lastLine = string.trim();
        }
    }
}

