/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.RecentViewListAction;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class KeyboardPopupSwitcher
implements WindowFocusListener {
    private static final int TIME_TO_SHOW = 200;
    private static KeyboardPopupSwitcher instance;
    private static JWindow popup;
    private static boolean shown;
    private static Timer invokerTimer;
    private static boolean invokerTimerRunning;
    private static int hits;
    private static SwitcherTableItem[] items;
    private SwitcherTable pTable;
    private static int triggerKey;
    private static int reverseKey;
    private static int releaseKey;
    private int x;
    private int y;
    private boolean fwd = true;

    public static boolean processShortcut(KeyEvent keyEvent) {
        boolean bl;
        ModeImpl modeImpl;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (!windowManagerImpl.getMainWindow().isFocused()) {
            if (!WindowManagerImpl.isSeparateWindow(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                return false;
            }
        }
        if (Boolean.getBoolean("netbeans.winsys.ctrltab.editoronly") && !windowManagerImpl.isEditorMode(modeImpl = windowManagerImpl.getActiveMode())) {
            return false;
        }
        boolean bl2 = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 2;
        boolean bl3 = bl = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 3;
        if (KeyboardPopupSwitcher.isShown()) {
            assert (instance != null);
            instance.processKeyEvent(keyEvent);
            keyEvent.consume();
            return true;
        }
        if (bl2 || bl) {
            if (!KeyboardPopupSwitcher.isAlive()) {
                RecentViewListAction recentViewListAction = new RecentViewListAction();
                recentViewListAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "C-TAB", keyEvent.getModifiers()));
                return true;
            }
            KeyboardPopupSwitcher.processInterruption(keyEvent);
            keyEvent.consume();
            return true;
        }
        if (keyEvent.getKeyCode() == 17 && KeyboardPopupSwitcher.isAlive()) {
            KeyboardPopupSwitcher.processInterruption(keyEvent);
            return true;
        }
        return false;
    }

    public static void selectItem(SwitcherTableItem[] switcherTableItemArray, int n, int n2, boolean bl) {
        if (invokerTimerRunning) {
            return;
        }
        items = switcherTableItemArray;
        releaseKey = n;
        triggerKey = n2;
        invokerTimer = new Timer(200, new PopupInvoker(bl));
        invokerTimer.setRepeats(false);
        invokerTimer.start();
        invokerTimerRunning = true;
    }

    private static void cleanupInterrupter() {
        invokerTimerRunning = false;
        if (invokerTimer != null) {
            invokerTimer.stop();
        }
    }

    public static boolean isShown() {
        return shown;
    }

    private static boolean isAlive() {
        return invokerTimerRunning || shown;
    }

    private KeyboardPopupSwitcher(int n, boolean bl) {
        this.fwd = bl;
        this.pTable = new SwitcherTable(items);
        Dimension dimension = this.pTable.getPreferredSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        this.x = rectangle.x + (rectangle.width / 2 - dimension.width / 2);
        this.y = rectangle.y + (rectangle.height / 2 - dimension.height / 2);
        int n2 = this.pTable.getColumnCount();
        int n3 = this.pTable.getRowCount();
        assert (n2 > 0) : "There aren't any columns in the KeyboardPopupSwitcher's table";
        assert (n3 > 0) : "There aren't any rows in the KeyboardPopupSwitcher's table";
        this.changeTableSelection(n3 > n && n >= 0 ? n : n, 0);
    }

    private void showPopup() {
        if (!KeyboardPopupSwitcher.isShown()) {
            popup = new JWindow();
            popup.setAlwaysOnTop(true);
            popup.getContentPane().add((Component)this.pTable);
            popup.setLocation(this.x, this.y);
            popup.pack();
            popup.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManager.getDefault().getMainWindow().addWindowFocusListener(KeyboardPopupSwitcher.this);
                }
            });
            shown = true;
        }
    }

    private static void processInterruption(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == releaseKey && keyEvent.getID() == 402) {
            KeyboardPopupSwitcher.cleanupInterrupter();
            hits = 0;
            RecentViewListAction recentViewListAction = new RecentViewListAction();
            recentViewListAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "immediately", keyEvent.getModifiers()));
            keyEvent.consume();
        } else if (n == triggerKey && keyEvent.getModifiers() == 2 && keyEvent.getID() == 401) {
            keyEvent.consume();
            KeyboardPopupSwitcher.cleanupInterrupter();
            instance = new KeyboardPopupSwitcher(++hits + 1, true);
            instance.showPopup();
        }
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                int n = keyEvent.getKeyCode();
                if (n == reverseKey) {
                    this.fwd = false;
                } else if (n == triggerKey) {
                    int n2 = this.pTable.getRowCount() - 1;
                    int n3 = this.pTable.getColumnCount() - 1;
                    int n4 = this.pTable.getSelectedRow();
                    int n5 = this.pTable.getSelectedColumn();
                    int n6 = n4;
                    int n7 = n5;
                    if (this.fwd) {
                        if (n4 >= n2) {
                            n6 = 0;
                            n7 = n5 >= n3 ? 0 : ++n7;
                        } else if (this.pTable.getValueAt(++n6, n7) == null) {
                            n6 = 0;
                            n7 = 0;
                        }
                    } else if (n4 == 0) {
                        if (n5 == 0) {
                            n7 = n3;
                            n6 = this.pTable.getLastValidRow();
                        } else {
                            --n7;
                            n6 = n2;
                        }
                    } else {
                        --n6;
                    }
                    if (n6 >= 0 && n7 >= 0) {
                        this.changeTableSelection(n6, n7);
                    }
                }
                keyEvent.consume();
                break;
            }
            case 402: {
                int n = keyEvent.getKeyCode();
                if (n == reverseKey) {
                    this.fwd = true;
                    keyEvent.consume();
                    break;
                }
                if (n == 27) {
                    this.cancelSwitching();
                    break;
                }
                if (n != releaseKey) break;
                this.performSwitching();
            }
        }
    }

    private void changeTableSelection(int n, int n2) {
        this.pTable.changeSelection(n, n2, false, false);
        SwitcherTableItem switcherTableItem = this.pTable.getSelectedItem();
        if (switcherTableItem != null) {
            String string = switcherTableItem.getDescription();
            StatusDisplayer.getDefault().setStatusText(string != null ? string : "");
        }
    }

    private void cancelSwitching() {
        this.hideCurrentPopup();
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void performSwitching() {
        SwitcherTableItem switcherTableItem;
        if (popup != null && (switcherTableItem = this.pTable.getSelectedItem()) != null) {
            switcherTableItem.activate();
        }
        this.cancelSwitching();
    }

    private synchronized void hideCurrentPopup() {
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
        }
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        if (windowEvent.getOppositeWindow() != popup) {
            this.cancelSwitching();
        }
    }

    static {
        reverseKey = 16;
    }

    private class PopupHider
    implements Runnable {
        private JWindow toHide;

        public PopupHider(JWindow jWindow) {
            this.toHide = jWindow;
        }

        public void run() {
            this.toHide.setVisible(false);
            shown = false;
            hits = 0;
            WindowManager.getDefault().getMainWindow().removeWindowFocusListener(KeyboardPopupSwitcher.this);
        }
    }

    private static class PopupInvoker
    implements ActionListener {
        private boolean forward;

        public PopupInvoker(boolean bl) {
            this.forward = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (invokerTimerRunning) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(this.forward ? hits + 1 : items.length - hits - 1, this.forward);
                instance.showPopup();
            }
        }
    }
}

