/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.AbstractComponentMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class NameMatcher
extends AbstractComponentMatcher {
    private final String name;
    private final Class<? extends Component> type;

    public NameMatcher(@Nullable String name) {
        this(name, false);
    }

    public NameMatcher(@Nullable String name, boolean requireShowing) {
        this(name, Component.class, requireShowing);
    }

    public NameMatcher(@Nullable String name, @Nonnull Class<? extends Component> type) {
        this(name, type, false);
    }

    public NameMatcher(@Nullable String name, @Nonnull Class<? extends Component> type, boolean requireShowing) {
        super(requireShowing);
        this.name = Preconditions.checkNotNullOrEmpty((CharSequence)name).toString();
        this.type = (Class)Preconditions.checkNotNull(type);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        return Objects.areEqual((Object)this.name, (Object)c.getName()) && this.type.isInstance(c) && this.requireShowingMatches(c);
    }

    public String toString() {
        String format = "%s[name='%s', type=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.name, this.type.getName(), this.requireShowing());
    }
}

