/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.util.io.URLUtil;
import com.jetbrains.python.console.pydev.AbstractPyCodeCompletion;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class PydevXmlUtils {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newDefaultInstance();

    private PydevXmlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SAXParser getSAXParser() throws Exception {
        SAXParser parser;
        SAXParserFactory sAXParserFactory = parserFactory;
        synchronized (sAXParserFactory) {
            parser = parserFactory.newSAXParser();
        }
        return parser;
    }

    @Nullable
    private static String decode(String value) {
        if (value != null) {
            return URLUtil.decode((String)value);
        }
        return null;
    }

    public static List<PydevCompletionVariant> decodeCompletions(Object fromServer, String actTok) {
        ArrayList<PydevCompletionVariant> ret = new ArrayList<PydevCompletionVariant>();
        List completionList = PydevXmlUtils.objectToList(fromServer);
        for (Object o : completionList) {
            List comp = PydevXmlUtils.objectToList(o);
            int type2 = PydevXmlUtils.extractInt(comp.get(3));
            String args = AbstractPyCodeCompletion.getArgs((String)comp.get(2), type2, 1);
            String name2 = (String)comp.get(0);
            if (name2.contains(".") && name2.startsWith(actTok)) {
                name2 = name2.substring(actTok.length());
            }
            ret.add(new PydevCompletionVariant(name2, (String)comp.get(1), args, type2));
        }
        return ret;
    }

    public static List objectToList(Object object) {
        List<Object> list;
        if (object instanceof Collection) {
            list = new ArrayList((Collection)object);
        } else if (object instanceof Object[]) {
            list = Arrays.asList((Object[])object);
        } else {
            throw new IllegalStateException("cant handle type of " + String.valueOf(object));
        }
        return list;
    }

    public static int extractInt(Object objToGetInt) {
        if (objToGetInt instanceof Integer) {
            return (Integer)objToGetInt;
        }
        return Integer.parseInt(objToGetInt.toString());
    }

    public static List<PydevCompletionVariant> xmlToCompletions(String payload, String actionToken) throws Exception {
        SAXParser parser = PydevXmlUtils.getSAXParser();
        XMLToCompletionsInfo info = new XMLToCompletionsInfo();
        parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8)), (DefaultHandler)info);
        return PydevXmlUtils.decodeCompletions(info.getCompletions(), actionToken);
    }

    static class XMLToCompletionsInfo
    extends DefaultHandler {
        private final List<Object[]> completions = new ArrayList<Object[]>();

        XMLToCompletionsInfo() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("comp")) {
                Object[] comp = new Object[]{PydevXmlUtils.decode(attributes.getValue("p0")), PydevXmlUtils.decode(attributes.getValue("p1")), PydevXmlUtils.decode(attributes.getValue("p2")), PydevXmlUtils.decode(attributes.getValue("p3"))};
                this.completions.add(comp);
            }
        }

        public List<Object[]> getCompletions() {
            return this.completions;
        }
    }
}

