/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.UpdatedEntryProcessor;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class UpdateData<Key, Value> {
    private final int inputId;
    @NotNull
    private final IndexId<Key, Value> indexId;
    @NotNull
    private final ChangesProducer<Key, Value> changesProducer;
    @NotNull
    private final ForwardIndexUpdate forwardIndexUpdate;

    public UpdateData(int inputId, @NotNull IndexId<Key, Value> indexId, @NotNull ChangesProducer<Key, Value> producer, @NotNull ForwardIndexUpdate update) {
        if (indexId == null) {
            UpdateData.$$$reportNull$$$0(0);
        }
        if (producer == null) {
            UpdateData.$$$reportNull$$$0(1);
        }
        if (update == null) {
            UpdateData.$$$reportNull$$$0(2);
        }
        this.inputId = inputId;
        this.indexId = indexId;
        this.changesProducer = producer;
        this.forwardIndexUpdate = update;
    }

    public int inputId() {
        return this.inputId;
    }

    boolean iterateChanges(@NotNull UpdatedEntryProcessor<? super Key, ? super Value> changedEntriesProcessor) throws StorageException {
        if (changedEntriesProcessor == null) {
            UpdateData.$$$reportNull$$$0(3);
        }
        return this.changesProducer.forEachChange(changedEntriesProcessor);
    }

    void updateForwardIndex() throws IOException {
        this.forwardIndexUpdate.update();
    }

    public String toString() {
        return "UpdateData[" + this.indexId + ": #" + this.inputId + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedEntriesProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/UpdateData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface ChangesProducer<Key, Value> {
        public boolean forEachChange(@NotNull UpdatedEntryProcessor<? super Key, ? super Value> var1) throws StorageException;
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface ForwardIndexUpdate {
        public static final ForwardIndexUpdate NOOP = new ForwardIndexUpdate(){

            @Override
            public void update() {
            }

            public String toString() {
                return "NO_OP";
            }
        };

        public void update() throws IOException;
    }
}

