/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.util;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteMonitorTrigger;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.model.threatintel.IocFinding;
import org.opensearch.securityanalytics.model.threatintel.ThreatIntelAlert;
import org.opensearch.securityanalytics.threatIntel.iocscan.dto.PerIocTypeScanInputDto;
import org.opensearch.securityanalytics.threatIntel.model.monitor.ThreatIntelInput;
import org.opensearch.securityanalytics.threatIntel.model.monitor.ThreatIntelTrigger;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelMonitorDto;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelTriggerDto;
import org.opensearch.securityanalytics.util.XContentUtils;

public class ThreatIntelMonitorUtils {
    public static RemoteMonitorTrigger buildRemoteMonitorTrigger(ThreatIntelTriggerDto trigger) throws IOException {
        return new RemoteMonitorTrigger(trigger.getId(), trigger.getName(), trigger.getSeverity(), trigger.getActions(), XContentUtils.getBytesReference(new ThreatIntelTrigger(trigger.getDataSources(), trigger.getIocTypes())));
    }

    public static List<ThreatIntelTriggerDto> buildThreatIntelTriggerDtos(List<Trigger> triggers, NamedXContentRegistry namedXContentRegistry) throws IOException {
        ArrayList<ThreatIntelTriggerDto> triggerDtos = new ArrayList<ThreatIntelTriggerDto>();
        for (Trigger trigger : triggers) {
            RemoteMonitorTrigger remoteMonitorTrigger = (RemoteMonitorTrigger)trigger;
            ThreatIntelTrigger threatIntelTrigger = ThreatIntelMonitorUtils.getThreatIntelTriggerFromBytesReference(remoteMonitorTrigger, namedXContentRegistry);
            triggerDtos.add(new ThreatIntelTriggerDto(threatIntelTrigger.getDataSources(), threatIntelTrigger.getIocTypes(), remoteMonitorTrigger.getActions(), remoteMonitorTrigger.getName(), remoteMonitorTrigger.getId(), remoteMonitorTrigger.getSeverity()));
        }
        return triggerDtos;
    }

    public static ThreatIntelTrigger getThreatIntelTriggerFromBytesReference(RemoteMonitorTrigger remoteMonitorTrigger, NamedXContentRegistry namedXContentRegistry) throws IOException {
        StreamInput triggerSin = StreamInput.wrap((byte[])remoteMonitorTrigger.getTrigger().toBytesRef().bytes);
        return new ThreatIntelTrigger(triggerSin);
    }

    public static ThreatIntelInput getThreatIntelInputFromBytesReference(BytesReference bytes, NamedXContentRegistry namedXContentRegistry) throws IOException {
        StreamInput sin = StreamInput.wrap((byte[])bytes.toBytesRef().bytes);
        ThreatIntelInput threatIntelInput = new ThreatIntelInput(sin);
        return threatIntelInput;
    }

    public static ThreatIntelMonitorDto buildThreatIntelMonitorDto(String id, Monitor monitor, NamedXContentRegistry namedXContentRegistry) throws IOException {
        RemoteDocLevelMonitorInput remoteDocLevelMonitorInput = (RemoteDocLevelMonitorInput)monitor.getInputs().get(0);
        List indices = remoteDocLevelMonitorInput.getDocLevelMonitorInput().getIndices();
        ThreatIntelInput threatIntelInput = ThreatIntelMonitorUtils.getThreatIntelInputFromBytesReference(remoteDocLevelMonitorInput.getInput(), namedXContentRegistry);
        return new ThreatIntelMonitorDto(id, monitor.getName(), threatIntelInput.getPerIocTypeScanInputList().stream().map(it -> new PerIocTypeScanInputDto(it.getIocType(), it.getIndexToFieldsMap())).collect(Collectors.toList()), monitor.getSchedule(), monitor.getEnabled(), monitor.getUser(), ThreatIntelMonitorUtils.buildThreatIntelTriggerDtos(monitor.getTriggers(), namedXContentRegistry));
    }

    public static SearchSourceBuilder getSearchSourceBuilderForExistingAlertsQuery(ArrayList<IocFinding> findings, Trigger trigger) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"trigger_name", (Object)trigger.getName()));
        BoolQueryBuilder iocQueryBuilder = QueryBuilders.boolQuery();
        for (IocFinding finding : findings) {
            BoolQueryBuilder innerQb = QueryBuilders.boolQuery();
            innerQb.must((QueryBuilder)QueryBuilders.matchQuery((String)"ioc_type", (Object)finding.getIocType()));
            innerQb.must((QueryBuilder)QueryBuilders.matchQuery((String)"ioc_value", (Object)finding.getIocValue()));
            iocQueryBuilder.should((QueryBuilder)innerQb);
        }
        queryBuilder.must((QueryBuilder)iocQueryBuilder);
        BoolQueryBuilder stateQueryBuilder = QueryBuilders.boolQuery();
        stateQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)Alert.State.ACTIVE.toString()));
        stateQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)Alert.State.ACKNOWLEDGED.toString()));
        queryBuilder.must((QueryBuilder)stateQueryBuilder);
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)queryBuilder);
        ssb.size(9999);
        return ssb;
    }

    public static Map<String, ThreatIntelAlert> prepareAlertsToUpdate(ArrayList<IocFinding> triggerMatchedFindings, List<ThreatIntelAlert> existingAlerts) {
        HashMap<String, ThreatIntelAlert> updatedAlerts = new HashMap<String, ThreatIntelAlert>();
        for (ThreatIntelAlert existingAlert : existingAlerts) {
            String iocType = existingAlert.getIocType();
            String iocValue = existingAlert.getIocValue();
            if (iocType == null || iocValue == null) continue;
            for (IocFinding finding : triggerMatchedFindings) {
                if (!iocType.equals(finding.getIocType()) || !iocValue.equals(finding.getIocValue())) continue;
                ArrayList<String> findingIds = new ArrayList<String>(existingAlert.getFindingIds());
                findingIds.add(finding.getId());
                updatedAlerts.put(existingAlert.getIocValue() + existingAlert.getIocType(), new ThreatIntelAlert(existingAlert, findingIds));
            }
        }
        return updatedAlerts;
    }

    public static List<ThreatIntelAlert> prepareNewAlerts(Monitor monitor, Trigger trigger, ArrayList<IocFinding> findings, Map<String, ThreatIntelAlert> updatedAlerts) {
        ArrayList<ThreatIntelAlert> alerts = new ArrayList<ThreatIntelAlert>();
        for (IocFinding finding : findings) {
            if (updatedAlerts.containsKey(finding.getIocValue() + finding.getIocType())) continue;
            Instant now = Instant.now();
            alerts.add(new ThreatIntelAlert(UUID.randomUUID().toString(), 1L, 0L, monitor.getUser(), trigger.getId(), trigger.getName(), monitor.getId(), monitor.getName(), Alert.State.ACTIVE, now, null, now, null, null, trigger.getSeverity(), finding.getIocValue(), finding.getIocType(), Collections.emptyList(), List.of(finding.getId())));
        }
        return alerts;
    }

    public static ArrayList<IocFinding> getTriggerMatchedFindings(List<IocFinding> iocFindings, ThreatIntelTrigger threatIntelTrigger) {
        ArrayList<IocFinding> triggerMatchedFindings = new ArrayList<IocFinding>();
        for (IocFinding iocFinding : iocFindings) {
            boolean iocTypeConditionMatch = false;
            if (threatIntelTrigger.getIocTypes() == null || threatIntelTrigger.getIocTypes().isEmpty()) {
                iocTypeConditionMatch = true;
            } else if (threatIntelTrigger.getIocTypes().contains(iocFinding.getIocType())) {
                iocTypeConditionMatch = true;
            }
            boolean dataSourcesConditionMatch = false;
            if (threatIntelTrigger.getDataSources() == null || threatIntelTrigger.getDataSources().isEmpty()) {
                dataSourcesConditionMatch = true;
            } else {
                List dataSources = iocFinding.getRelatedDocIds().stream().map(it -> {
                    String[] parts = it.split(":");
                    if (parts.length == 2) {
                        return parts[1];
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                if (threatIntelTrigger.getDataSources().stream().anyMatch(dataSources::contains)) {
                    dataSourcesConditionMatch = true;
                }
            }
            if (!dataSourcesConditionMatch || !iocTypeConditionMatch) continue;
            triggerMatchedFindings.add(iocFinding);
        }
        return triggerMatchedFindings;
    }
}

