/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.checksums.Md5Checksum;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpHeaders;
import software.amazon.awssdk.services.s3.internal.checksums.ChecksumsEnabledValidator;
import software.amazon.awssdk.services.s3.internal.checksums.S3ChecksumValidatingPublisher;

@SdkInternalApi
public final class AsyncChecksumValidationInterceptor
implements ExecutionInterceptor {
    public Optional<Publisher<ByteBuffer>> modifyAsyncHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        if (ChecksumsEnabledValidator.getObjectChecksumEnabledPerResponse(context.request(), (SdkHttpHeaders)context.httpResponse(), executionAttributes) && context.responsePublisher().isPresent()) {
            long contentLength = context.httpResponse().firstMatchingHeader("Content-Length").map(Long::parseLong).orElse(0L);
            Md5Checksum checksum = new Md5Checksum();
            executionAttributes.putAttribute(ChecksumsEnabledValidator.CHECKSUM, (Object)checksum);
            if (contentLength > 0L) {
                return Optional.of(new S3ChecksumValidatingPublisher((Publisher<ByteBuffer>)((Publisher)context.responsePublisher().get()), (SdkChecksum)checksum, contentLength));
            }
        }
        return context.responsePublisher();
    }
}

