/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.aws;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class AsyncCapturingSubscriber
implements Subscriber<ByteBuffer> {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final CompletableFuture<byte[]> promise = new CompletableFuture();
    private Subscription subscription;

    AsyncCapturingSubscriber() {
    }

    public CompletableFuture<byte[]> getPromise() {
        return this.promise;
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(ByteBuffer buf) {
        try {
            if (buf != null && buf.remaining() > 0) {
                if (buf.hasArray()) {
                    this.buffer.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                } else {
                    byte[] data = new byte[buf.remaining()];
                    buf.asReadOnlyBuffer().get(data);
                    this.buffer.write(data);
                }
            }
            this.subscription.request(1L);
        }
        catch (Throwable e) {
            this.promise.completeExceptionally(e);
        }
    }

    public void onError(Throwable e) {
        if (e == null) {
            e = new IllegalArgumentException("Subscriber.onError called with null paramter");
        }
        this.promise.completeExceptionally(e);
    }

    public void onComplete() {
        this.promise.complete(this.buffer.toByteArray());
    }
}

