/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression;

import com.oracle.labs.mlrg.olcut.util.MutableDouble;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import java.util.Map;
import org.tribuo.MutableOutputInfo;
import org.tribuo.regression.RegressionFactory;
import org.tribuo.regression.RegressionInfo;
import org.tribuo.regression.Regressor;

public class MutableRegressionInfo
extends RegressionInfo
implements MutableOutputInfo<Regressor> {
    private static final long serialVersionUID = 2L;

    MutableRegressionInfo() {
    }

    public MutableRegressionInfo(RegressionInfo info) {
        super(info);
    }

    public void observe(Regressor output) {
        if (output == RegressionFactory.UNKNOWN_REGRESSOR) {
            ++this.unknownCount;
        } else {
            if (this.overallCount != 0L) {
                String[] names = output.getNames();
                if (names.length != this.countMap.size()) {
                    throw new IllegalArgumentException("Expected this Regressor to contain " + this.countMap.size() + " dimensions, found " + names.length);
                }
                for (String name : names) {
                    if (this.countMap.containsKey(name)) continue;
                    throw new IllegalArgumentException("Regressor contains unexpected dimension named '" + name + "'");
                }
            }
            for (Regressor.DimensionTuple r : output) {
                String name = r.getName();
                double value = r.getValue();
                this.minMap.merge(name, new MutableDouble(value), (a, b) -> a.doubleValue() < b.doubleValue() ? a : b);
                this.maxMap.merge(name, new MutableDouble(value), (a, b) -> a.doubleValue() > b.doubleValue() ? a : b);
                MutableLong countValue = this.countMap.computeIfAbsent(name, k -> new MutableLong());
                countValue.increment();
                MutableDouble meanValue = this.meanMap.computeIfAbsent(name, k -> new MutableDouble());
                double delta = value - meanValue.doubleValue();
                meanValue.increment(delta / (double)countValue.longValue());
                double delta2 = value - meanValue.doubleValue();
                MutableDouble sumSquaresValue = this.sumSquaresMap.computeIfAbsent(name, k -> new MutableDouble());
                sumSquaresValue.increment(delta * delta2);
            }
            ++this.overallCount;
        }
    }

    public void clear() {
        this.maxMap.clear();
        this.minMap.clear();
        this.meanMap.clear();
        this.sumSquaresMap.clear();
        this.countMap.clear();
    }

    @Override
    public MutableRegressionInfo copy() {
        return new MutableRegressionInfo(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegressionInfo(");
        for (Map.Entry e : this.countMap.entrySet()) {
            String name = (String)e.getKey();
            long count = ((MutableLong)e.getValue()).longValue();
            builder.append(String.format("{name=%s,count=%d,max=%f,min=%f,mean=%f,variance=%f},", name, count, ((MutableDouble)this.maxMap.get(name)).doubleValue(), ((MutableDouble)this.minMap.get(name)).doubleValue(), ((MutableDouble)this.meanMap.get(name)).doubleValue(), ((MutableDouble)this.sumSquaresMap.get(name)).doubleValue() / (double)(count - 1L)));
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        return builder.toString();
    }

    public String toReadableString() {
        return this.toString();
    }
}

