/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataRows
implements Iterable<Row> {
    private final long size;
    private final long totalHits;
    private final List<Row> rows;

    public DataRows(long size, long totalHits, List<Row> rows) {
        this.size = size;
        this.totalHits = totalHits;
        this.rows = rows;
    }

    public DataRows(List<Row> rows) {
        this.size = rows.size();
        this.totalHits = rows.size();
        this.rows = rows;
    }

    public long getSize() {
        return this.size;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            private final Iterator<Row> iter;
            {
                this.iter = DataRows.this.rows.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Row next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("No changes allowed to DataRows rows");
            }
        };
    }

    public static class Row {
        private final Map<String, Object> data;

        public Row(Map<String, Object> data) {
            this.data = data;
        }

        public Map<String, Object> getContents() {
            return this.data;
        }

        public boolean hasField(String field) {
            return this.data.containsKey(field);
        }

        public Object getData(String field) {
            return this.data.get(field);
        }

        public Object getDataOrDefault(String field, Object defaultValue) {
            return this.data.getOrDefault(field, defaultValue);
        }
    }
}

