/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.i18n;

import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class RuleTemplateI18nUtil {
    public static final String RULE_TEMPLATE = "rule-template";
    private final TranslationProvider i18nProvider;

    public RuleTemplateI18nUtil(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public @Nullable String getLocalizedRuleTemplateLabel(Bundle bundle, String ruleTemplateUID, @Nullable String defaultLabel, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferRuleTemplateKey(ruleTemplateUID, "label"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public @Nullable String getLocalizedRuleTemplateDescription(Bundle bundle, String ruleTemplateUID, @Nullable String defaultDescription, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> this.inferRuleTemplateKey(ruleTemplateUID, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private String inferRuleTemplateKey(String ruleTemplateUID, String lastSegment) {
        return "rule-template." + ruleTemplateUID + "." + lastSegment;
    }
}

