/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.identifier;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import org.opensearch.sql.legacy.rewriter.RewriteRule;
import org.opensearch.sql.legacy.utils.StringUtils;

public class UnquoteIdentifierRule
extends MySqlASTVisitorAdapter
implements RewriteRule<SQLQueryExpr> {
    public boolean visit(SQLSelectItem selectItem) {
        String identifier;
        if (selectItem.getExpr() instanceof SQLIdentifierExpr && (identifier = ((SQLIdentifierExpr)selectItem.getExpr()).getName()).endsWith(".")) {
            String correctedIdentifier = identifier + StringUtils.unquoteSingleField(selectItem.getAlias(), "`");
            selectItem.setExpr((SQLExpr)new SQLIdentifierExpr(correctedIdentifier));
            selectItem.setAlias(null);
        }
        selectItem.setAlias(StringUtils.unquoteSingleField(selectItem.getAlias(), "`"));
        return true;
    }

    public void endVisit(SQLIdentifierExpr identifierExpr) {
        identifierExpr.setName(StringUtils.unquoteFullColumn(identifierExpr.getName()));
    }

    public void endVisit(SQLExprTableSource tableSource) {
        tableSource.setAlias(StringUtils.unquoteSingleField(tableSource.getAlias()));
    }

    @Override
    public boolean match(SQLQueryExpr root) {
        return true;
    }

    @Override
    public void rewrite(SQLQueryExpr root) {
        root.accept((SQLASTVisitor)new UnquoteIdentifierRule());
    }
}

