/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.property;

import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public final class ListProperty
implements Property {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ListProperty.class.getName());
    private final List<SimpleProperty> simpleList;
    private final List<Class<?>> classList;

    public ListProperty(List<SimpleProperty> simpleList, List<Class<?>> classList) {
        this.simpleList = Collections.unmodifiableList(simpleList);
        this.classList = Collections.unmodifiableList(classList);
    }

    public ListProperty(List<SimpleProperty> simpleList) {
        this.simpleList = Collections.unmodifiableList(simpleList);
        this.classList = Collections.emptyList();
    }

    public List<SimpleProperty> getSimpleList() {
        return this.simpleList;
    }

    public List<Class<?>> getClassList() {
        return this.classList;
    }

    @Override
    public ListProperty copy() {
        ArrayList<SimpleProperty> newSimpleList = new ArrayList<SimpleProperty>();
        for (SimpleProperty p : this.simpleList) {
            newSimpleList.add(p.copy());
        }
        if (this.classList.isEmpty()) {
            return new ListProperty(newSimpleList);
        }
        return new ListProperty(newSimpleList, new ArrayList(this.classList));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListProperty)) {
            return false;
        }
        ListProperty that = (ListProperty)o;
        return this.getSimpleList().equals(that.getSimpleList()) && this.getClassList().equals(that.getClassList());
    }

    public int hashCode() {
        return Objects.hash(this.getSimpleList(), this.getClassList());
    }

    public String toString() {
        return "[" + this.simpleList.toString() + ", " + this.classList.toString() + "]";
    }

    public static ListProperty createFromStringList(List<String> stringList) {
        ArrayList<SimpleProperty> output = new ArrayList<SimpleProperty>();
        for (String s : stringList) {
            output.add(new SimpleProperty(s));
        }
        return new ListProperty(output);
    }
}

