/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.seqno;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.WriteResponse;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.support.replication.ReplicationTask;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.action.support.replication.TransportWriteAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexingPressureService;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.SystemIndices;
import org.opensearch.tasks.Task;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class RetentionLeaseSyncAction
extends TransportWriteAction<Request, Request, Response> {
    public static final String ACTION_NAME = "indices:admin/seq_no/retention_lease_sync";
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseSyncAction.class);

    protected Logger getLogger() {
        return LOGGER;
    }

    @Inject
    public RetentionLeaseSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexingPressureService indexingPressureService, SystemIndices systemIndices, Tracer tracer) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, Request::new, Request::new, ignore -> "management", false, indexingPressureService, systemIndices, tracer);
    }

    @Override
    protected void doExecute(Task parentTask, Request request, ActionListener<Response> listener) {
        assert (false) : "use RetentionLeaseSyncAction#sync";
    }

    final void sync(final ShardId shardId, String primaryAllocationId, long primaryTerm, RetentionLeases retentionLeases, final ActionListener<ReplicationResponse> listener) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            ThreadContextAccess.doPrivilegedVoid(threadContext::markAsSystemContext);
            Request request = new Request(shardId, retentionLeases);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "retention_lease_sync", request);
            this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<Request>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){
                final /* synthetic */ RetentionLeaseSyncAction this$0;
                {
                    this.this$0 = this$0;
                }

                public ReplicationResponse read(StreamInput in) throws IOException {
                    return this.this$0.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    task.setPhase("finished");
                    this.this$0.taskManager.unregister(task);
                    listener.onResponse((Object)response);
                }

                @Override
                public void handleException(TransportException e) {
                    if (ExceptionsHelper.unwrap((Throwable)((Object)e), (Class[])new Class[]{IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class}) == null) {
                        this.this$0.getLogger().warn((Message)new ParameterizedMessage("{} retention lease sync failed", (Object)shardId), (Throwable)((Object)e));
                    }
                    task.setPhase("finished");
                    this.this$0.taskManager.unregister(task);
                    listener.onFailure((Exception)((Object)e));
                }
            });
        }
    }

    @Override
    protected void dispatchedShardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, Response>> listener) {
        ActionListener.completeWith(listener, () -> {
            assert (request.waitForActiveShards().equals(ActiveShardCount.NONE)) : request.waitForActiveShards();
            Objects.requireNonNull(request);
            Objects.requireNonNull(primary);
            primary.persistRetentionLeases();
            return new TransportWriteAction.WritePrimaryResult<Request, Response>(request, new Response(), null, null, primary, this.getLogger());
        });
    }

    @Override
    protected void dispatchedShardOperationOnReplica(Request request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            Objects.requireNonNull(request);
            Objects.requireNonNull(replica);
            replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
            replica.persistRetentionLeases();
            return new TransportWriteAction.WriteReplicaResult<Request>(request, null, null, replica, this.getLogger());
        });
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected Response newResponseInstance(StreamInput in) throws IOException {
        return new Response(in);
    }

    public static final class Request
    extends ReplicatedWriteRequest<Request> {
        private RetentionLeases retentionLeases;

        public RetentionLeases getRetentionLeases() {
            return this.retentionLeases;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.retentionLeases = new RetentionLeases(in);
        }

        public Request(ShardId shardId, RetentionLeases retentionLeases) {
            super(Objects.requireNonNull(shardId));
            this.retentionLeases = Objects.requireNonNull(retentionLeases);
            this.waitForActiveShards(ActiveShardCount.NONE);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(Objects.requireNonNull(out));
            this.retentionLeases.writeTo(out);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new ReplicationTask(id, type, action, "retention_lease_sync shardId=" + String.valueOf(this.shardId), parentTaskId, headers);
        }

        @Override
        public String toString() {
            return "RetentionLeaseSyncAction.Request{retentionLeases=" + String.valueOf(this.retentionLeases) + ", shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", index='" + this.index + "', waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + "}";
        }
    }

    public static final class Response
    extends ReplicationResponse
    implements WriteResponse {
        public Response() {
        }

        Response(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void setForcedRefresh(boolean forcedRefresh) {
        }
    }
}

