/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.HKDF;
import software.amazon.cryptography.materialproviders.model.IDENTITY;
import software.amazon.cryptography.materialproviders.model.None;

public class DerivationAlgorithm {
    private final HKDF HKDF;
    private final IDENTITY IDENTITY;
    private final None None;

    protected DerivationAlgorithm(BuilderImpl builder) {
        this.HKDF = builder.HKDF();
        this.IDENTITY = builder.IDENTITY();
        this.None = builder.None();
    }

    public HKDF HKDF() {
        return this.HKDF;
    }

    public IDENTITY IDENTITY() {
        return this.IDENTITY;
    }

    public None None() {
        return this.None;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected HKDF HKDF;
        protected IDENTITY IDENTITY;
        protected None None;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DerivationAlgorithm model) {
            this.HKDF = model.HKDF();
            this.IDENTITY = model.IDENTITY();
            this.None = model.None();
        }

        @Override
        public Builder HKDF(HKDF HKDF2) {
            this.HKDF = HKDF2;
            return this;
        }

        @Override
        public HKDF HKDF() {
            return this.HKDF;
        }

        @Override
        public Builder IDENTITY(IDENTITY IDENTITY2) {
            this.IDENTITY = IDENTITY2;
            return this;
        }

        @Override
        public IDENTITY IDENTITY() {
            return this.IDENTITY;
        }

        @Override
        public Builder None(None None2) {
            this.None = None2;
            return this;
        }

        @Override
        public None None() {
            return this.None;
        }

        @Override
        public DerivationAlgorithm build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`DerivationAlgorithm` is a Union. A Union MUST have one and only one value set.");
            }
            return new DerivationAlgorithm(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.HKDF, this.IDENTITY, this.None};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder HKDF(HKDF var1);

        public HKDF HKDF();

        public Builder IDENTITY(IDENTITY var1);

        public IDENTITY IDENTITY();

        public Builder None(None var1);

        public None None();

        public DerivationAlgorithm build();
    }
}

