/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.util.ByteArrays;

public final class LlcControlInformation
implements LlcPacket.LlcControl {
    private static final long serialVersionUID = -4014592337107864662L;
    private final byte receiveSequenceNumber;
    private final boolean pfBit;
    private final byte sendSequenceNumber;

    public static LlcControlInformation newInstance(short value2) throws IllegalRawDataException {
        return new LlcControlInformation(value2);
    }

    private LlcControlInformation(short value2) throws IllegalRawDataException {
        if ((value2 & 0x100) != 0) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("value & 0x0100 must be 0. value: ").append(ByteArrays.toHexString(value2, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.receiveSequenceNumber = (byte)(value2 >> 1 & 0x7F);
        this.pfBit = (value2 & 1) != 0;
        this.sendSequenceNumber = (byte)(value2 >> 9 & 0x7F);
    }

    private LlcControlInformation(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder must not be null.");
        }
        if (builder2.receiveSequenceNumber < 0) {
            throw new IllegalArgumentException("receiveSequenceNumber must be positive. receiveSequenceNumber: " + builder2.receiveSequenceNumber);
        }
        if (builder2.sendSequenceNumber < 0) {
            throw new IllegalArgumentException("sendSequenceNumber must be positive. sendSequenceNumber: " + builder2.sendSequenceNumber);
        }
        this.receiveSequenceNumber = builder2.receiveSequenceNumber;
        this.pfBit = builder2.pfBit;
        this.sendSequenceNumber = builder2.sendSequenceNumber;
    }

    public byte getReceiveSequenceNumber() {
        return this.receiveSequenceNumber;
    }

    public int getReceiveSequenceNumberAsInt() {
        return this.receiveSequenceNumber;
    }

    public boolean getPfBit() {
        return this.pfBit;
    }

    public byte getSendSequenceNumber() {
        return this.sendSequenceNumber;
    }

    public int getSendSequenceNumberAsInt() {
        return this.sendSequenceNumber;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[2];
        data[1] = (byte)(this.receiveSequenceNumber << 1);
        if (this.pfBit) {
            data[1] = (byte)(data[1] | 1);
        }
        data[0] = (byte)(this.sendSequenceNumber << 1);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[receive sequence number: ").append(this.receiveSequenceNumber).append("] [P/F bit: ").append(this.pfBit ? 1 : 0).append("] [send sequence number: ").append(this.sendSequenceNumber).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.receiveSequenceNumber;
        result = 31 * result + (this.pfBit ? 1231 : 1237);
        result = 31 * result + this.sendSequenceNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LlcControlInformation other = (LlcControlInformation)obj;
        return this.receiveSequenceNumber == other.receiveSequenceNumber && this.sendSequenceNumber == other.sendSequenceNumber && this.pfBit == other.pfBit;
    }

    public static final class Builder {
        private byte receiveSequenceNumber;
        private boolean pfBit;
        private byte sendSequenceNumber;

        public Builder() {
        }

        private Builder(LlcControlInformation ctrl) {
            this.receiveSequenceNumber = ctrl.receiveSequenceNumber;
            this.pfBit = ctrl.pfBit;
            this.sendSequenceNumber = ctrl.sendSequenceNumber;
        }

        public Builder receiveSequenceNumber(byte receiveSequenceNumber) {
            this.receiveSequenceNumber = receiveSequenceNumber;
            return this;
        }

        public Builder pfBit(boolean pfBit) {
            this.pfBit = pfBit;
            return this;
        }

        public Builder sendSequenceNumber(byte sendSequenceNumber) {
            this.sendSequenceNumber = sendSequenceNumber;
            return this;
        }

        public LlcControlInformation build() {
            return new LlcControlInformation(this);
        }
    }
}

