"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLFacet = void 0;
var _ppl_datasource = require("../../adaptors/ppl_datasource");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class PPLFacet {
  constructor(client) {
    this.client = client;
    _defineProperty(this, "fetch", async (context, request, format, _responseFormat) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const dataSourceMDSId = request.query.dataSourceMDSId;
        const params = {
          body: {
            query: request.body.query
          }
        };
        if (request.body.format !== 'jdbc') {
          params.format = request.body.format;
        }
        let queryRes;
        if (dataSourceMDSId) {
          const mdsClient = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryRes = await mdsClient.callAPI(format, params);
        } else {
          queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        const pplDataSource = new _ppl_datasource.PPLDataSource(queryRes, request.body.format);
        res.success = true;
        res.data = pplDataSource.getDataSource();
      } catch (err) {
        console.error('PPL query fetch err: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "describeQuery", async (context, request) => {
      return this.fetch(context, request, 'ppl.pplQuery', 'json');
    });
    this.client = client;
  }
}
exports.PPLFacet = PPLFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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