/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ClientCertificateTypeExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ClientCertificateTypeExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ClientCertificateTypeExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCertificateTypeExtensionHandler
extends ExtensionHandler<ClientCertificateTypeExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientCertificateTypeExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public ClientCertificateTypeExtensionParser getParser(byte[] message, int pointer) {
        return new ClientCertificateTypeExtensionParser(pointer, message);
    }

    public ClientCertificateTypeExtensionPreparator getPreparator(ClientCertificateTypeExtensionMessage message) {
        return new ClientCertificateTypeExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public ClientCertificateTypeExtensionSerializer getSerializer(ClientCertificateTypeExtensionMessage message) {
        return new ClientCertificateTypeExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(ClientCertificateTypeExtensionMessage message) {
        if (this.context.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            if (((byte[])message.getCertificateTypes().getValue()).length != 1) {
                LOGGER.warn("Invalid ClientCertificateType extension. Not adjusting context");
            } else {
                this.context.setSelectedClientCertificateType(CertificateType.getCertificateType(((byte[])message.getCertificateTypes().getValue())[0]));
            }
        } else {
            this.context.setClientCertificateTypeDesiredTypes(CertificateType.getCertificateTypesAsList((byte[])message.getCertificateTypes().getValue()));
        }
    }
}

