/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate.ocsp;

import com.google.common.io.ByteStreams;
import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1EncapsulatingOctetString;
import de.rub.nds.asn1.model.Asn1Explicit;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1PrimitiveIa5String;
import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.asn1.parser.Asn1Parser;
import de.rub.nds.asn1.parser.ParserException;
import de.rub.nds.asn1.translator.ParseOcspTypesContext;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.certificate.ExtensionObjectIdentifier;
import de.rub.nds.tlsattacker.core.util.Asn1ToolInitializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;

public class CertificateInformationExtractor {
    private final Certificate certificate;
    private List<Asn1Encodable> x509ExtensionSequences;
    private Asn1Sequence authorityInfoAccessEntities;
    private Asn1Sequence tlsFeatureExtension;
    private Boolean mustStaple;
    private Boolean mustStaplev2;
    private String ocspServerUrl;
    private String certificateIssuerUrl;
    private static final int X509_EXTENSION_ASN1_EXPLICIT_OFFSET = 3;
    private static final int STATUS_REQUEST_TLS_EXTENSION_ID = 5;
    private static final int STATUS_REQUEST_V2_TLS_EXTENSION_ID = 17;

    public CertificateInformationExtractor(Certificate certificate) {
        this.certificate = certificate;
        Asn1ToolInitializer.initAsn1Tool();
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    public byte[] getIssuerNameHash() throws IOException, NoSuchAlgorithmException {
        byte[] encodedDistinguishedName = this.certificate.getIssuer().getEncoded();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        return md.digest(encodedDistinguishedName);
    }

    public byte[] getIssuerKeyHash() throws IOException, NoSuchAlgorithmException {
        byte[] publicKey = this.certificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        return md.digest(publicKey);
    }

    public Boolean getMustStaple() throws IOException, ParserException {
        if (this.mustStaple == null) {
            this.mustStaple = this.parseMustStaple();
        }
        return this.mustStaple;
    }

    public Boolean getMustStaplev2() throws IOException, ParserException {
        if (this.mustStaplev2 == null) {
            this.mustStaplev2 = this.parseMustStaplev2();
        }
        return this.mustStaplev2;
    }

    public String getOcspServerUrl() throws IOException, ParserException, NoSuchFieldException {
        if (this.ocspServerUrl == null) {
            this.ocspServerUrl = this.parseOcspServerUrl();
        }
        return this.ocspServerUrl;
    }

    public String getCertificateIssuerUrl() throws IOException, ParserException, NoSuchFieldException {
        if (this.certificateIssuerUrl == null) {
            this.certificateIssuerUrl = this.parseCertificateIssuerUrl();
        }
        return this.certificateIssuerUrl;
    }

    private void extractX509Extensions() throws IOException, ParserException {
        Object ocspUrlResult = null;
        byte[] certAsn1 = this.certificate.getEncoded();
        Asn1Parser asn1Parser = new Asn1Parser(certAsn1, false);
        List asn1Encodables = asn1Parser.parse(ParseOcspTypesContext.NAME);
        Asn1Sequence innerObjects = (Asn1Sequence)((Asn1Sequence)asn1Encodables.get(0)).getChildren().get(0);
        Asn1Explicit x509Extensions = null;
        for (Asn1Encodable singleObject : innerObjects.getChildren()) {
            if (!(singleObject instanceof Asn1Explicit) || ((Asn1Explicit)singleObject).getOffset() != 3) continue;
            x509Extensions = (Asn1Explicit)singleObject;
            break;
        }
        this.x509ExtensionSequences = ((Asn1Sequence)x509Extensions.getChildren().get(0)).getChildren();
    }

    private void extractAuthorityInfoAccessEntities() throws NoSuchFieldException {
        Asn1Sequence authorityInfoAccess = null;
        for (Asn1Encodable singleExtension : this.x509ExtensionSequences) {
            Asn1ObjectIdentifier objectIdentifier;
            if (!(singleExtension instanceof Asn1Sequence) || !(objectIdentifier = (Asn1ObjectIdentifier)((Asn1Sequence)singleExtension).getChildren().get(0)).getValue().equals(ExtensionObjectIdentifier.AUTHORITY_INFO_ACCESS.getOID())) continue;
            authorityInfoAccess = (Asn1Sequence)singleExtension;
            break;
        }
        if (authorityInfoAccess == null) {
            throw new NoSuchFieldException("No 'Authority Info Access' entry found in certificate.");
        }
        Asn1EncapsulatingOctetString authorityInfoAccessContent = (Asn1EncapsulatingOctetString)authorityInfoAccess.getChildren().get(1);
        this.authorityInfoAccessEntities = (Asn1Sequence)authorityInfoAccessContent.getChildren().get(0);
    }

    private void extractTlsFeatureExtension() throws IOException, ParserException {
        if (this.x509ExtensionSequences == null) {
            this.extractX509Extensions();
        }
        for (Asn1Encodable enc : this.x509ExtensionSequences) {
            Asn1ObjectIdentifier objectIdentifier;
            if (!(enc instanceof Asn1Sequence) || !(objectIdentifier = (Asn1ObjectIdentifier)((Asn1Sequence)enc).getChildren().get(0)).getValue().equals(ExtensionObjectIdentifier.TLS_FEATURE.getOID())) continue;
            this.tlsFeatureExtension = (Asn1Sequence)enc;
            break;
        }
    }

    private boolean parseMustStaple() throws IOException, ParserException {
        if (this.tlsFeatureExtension == null) {
            this.extractTlsFeatureExtension();
        }
        boolean foundMustStaple = false;
        if (this.tlsFeatureExtension != null) {
            Asn1EncapsulatingOctetString tlsFeaturesContent = (Asn1EncapsulatingOctetString)this.tlsFeatureExtension.getChildren().get(1);
            Asn1Sequence tlsFeaturesContentSequence = (Asn1Sequence)tlsFeaturesContent.getChildren().get(0);
            for (Asn1Encodable feature : tlsFeaturesContentSequence.getChildren()) {
                if (!(feature instanceof Asn1Integer) || ((Asn1Integer)feature).getValue().intValue() != 5) continue;
                foundMustStaple = true;
            }
        }
        return foundMustStaple;
    }

    private boolean parseMustStaplev2() throws IOException, ParserException {
        if (this.tlsFeatureExtension == null) {
            this.extractTlsFeatureExtension();
        }
        boolean foundMustStaplev2 = false;
        if (this.tlsFeatureExtension != null) {
            Asn1EncapsulatingOctetString tlsFeaturesContent = (Asn1EncapsulatingOctetString)this.tlsFeatureExtension.getChildren().get(1);
            Asn1Sequence tlsFeaturesContentSequence = (Asn1Sequence)tlsFeaturesContent.getChildren().get(0);
            for (Asn1Encodable feature : tlsFeaturesContentSequence.getChildren()) {
                if (!(feature instanceof Asn1Integer) || ((Asn1Integer)feature).getValue().intValue() != 17) continue;
                foundMustStaplev2 = true;
            }
        }
        return foundMustStaplev2;
    }

    private String getStringFromInformationAccessEntry(List<Asn1Encodable> authorityInformationAccessInformation) {
        String urlString = null;
        if (authorityInformationAccessInformation != null) {
            Asn1PrimitiveIa5String urlIa5String = null;
            if (authorityInformationAccessInformation.size() > 1 && authorityInformationAccessInformation.get(1) instanceof Asn1PrimitiveIa5String) {
                urlIa5String = (Asn1PrimitiveIa5String)authorityInformationAccessInformation.get(1);
            }
            urlString = urlIa5String.getValue();
        }
        return urlString;
    }

    private String parseOcspServerUrl() throws IOException, ParserException, NoSuchFieldException {
        if (this.x509ExtensionSequences == null) {
            this.extractX509Extensions();
        }
        if (this.authorityInfoAccessEntities == null) {
            this.extractAuthorityInfoAccessEntities();
        }
        List ocspInformation = null;
        for (Asn1Encodable enc : this.authorityInfoAccessEntities.getChildren()) {
            Asn1ObjectIdentifier objectIdentifier;
            if (!(enc instanceof Asn1Sequence) || !(objectIdentifier = (Asn1ObjectIdentifier)((Asn1Sequence)enc).getChildren().get(0)).getValue().equals(ExtensionObjectIdentifier.OCSP.getOID())) continue;
            ocspInformation = ((Asn1Sequence)enc).getChildren();
            break;
        }
        if (ocspInformation == null) {
            throw new NoSuchFieldException("No OCSP entry found in certificate.");
        }
        return this.getStringFromInformationAccessEntry(ocspInformation);
    }

    private String parseCertificateIssuerUrl() throws IOException, ParserException, NoSuchFieldException {
        if (this.x509ExtensionSequences == null) {
            this.extractX509Extensions();
        }
        if (this.authorityInfoAccessEntities == null) {
            this.extractAuthorityInfoAccessEntities();
        }
        List certificateIssuerInformation = null;
        for (Asn1Encodable enc : this.authorityInfoAccessEntities.getChildren()) {
            Asn1ObjectIdentifier objectIdentifier;
            if (!(enc instanceof Asn1Sequence) || !(objectIdentifier = (Asn1ObjectIdentifier)((Asn1Sequence)enc).getChildren().get(0)).getValue().equals(ExtensionObjectIdentifier.CERTIFICATE_AUTHORITY_ISSUER.getOID())) continue;
            certificateIssuerInformation = ((Asn1Sequence)enc).getChildren();
            break;
        }
        if (certificateIssuerInformation == null) {
            throw new NoSuchFieldException("No Certificate Issuer entry found in certificate.");
        }
        return this.getStringFromInformationAccessEntry(certificateIssuerInformation);
    }

    public Certificate retrieveIssuerCertificate() throws IOException, ParserException, NoSuchFieldException {
        String issuerCertificateUrlString = this.getCertificateIssuerUrl();
        if (issuerCertificateUrlString == null) {
            throw new RuntimeException("Didn't get any issuer certificate URL from certificate.");
        }
        URL issuerCertificateUrl = new URL(issuerCertificateUrlString);
        HttpURLConnection httpCon = (HttpURLConnection)issuerCertificateUrl.openConnection();
        httpCon.setConnectTimeout(5000);
        httpCon.setRequestMethod("GET");
        int status = httpCon.getResponseCode();
        if (status != 200) {
            throw new RuntimeException("Response not successful: Received status code " + status);
        }
        byte[] response = ByteStreams.toByteArray((InputStream)httpCon.getInputStream());
        httpCon.disconnect();
        byte[] certificateWithLength = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)response.length, (int)3), response});
        ByteArrayInputStream stream = new ByteArrayInputStream(ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)certificateWithLength.length, (int)3), certificateWithLength}));
        org.bouncycastle.crypto.tls.Certificate tlsCertificate = org.bouncycastle.crypto.tls.Certificate.parse((InputStream)stream);
        return tlsCertificate.getCertificateAt(0);
    }
}

