/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.arc.All;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.tracing.RemoveableLateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.runtime.propagation.TextMapPropagatorCustomizer;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.opentelemetry.runtime.tracing.DropTargetsSampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRecorder;
import io.quarkus.opentelemetry.runtime.tracing.TracerUtil;
import io.quarkus.runtime.ApplicationConfig;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public interface AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
    public void customize(AutoConfiguredOpenTelemetrySdkBuilder var1);

    private static String getHostname() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
        }
        return hostname;
    }

    @Singleton
    public static final class TextMapPropagatorCustomizers
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final List<TextMapPropagatorCustomizer> customizers;

        public TextMapPropagatorCustomizers(@All List<TextMapPropagatorCustomizer> customizers) {
            this.customizers = customizers;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            for (final TextMapPropagatorCustomizer customizer : this.customizers) {
                builder.addPropagatorCustomizer((BiFunction)new BiFunction<TextMapPropagator, ConfigProperties, TextMapPropagator>(){

                    @Override
                    public TextMapPropagator apply(final TextMapPropagator textMapPropagator, final ConfigProperties configProperties) {
                        return customizer.customize(new TextMapPropagatorCustomizer.Context(){

                            @Override
                            public TextMapPropagator propagator() {
                                return textMapPropagator;
                            }

                            @Override
                            public ConfigProperties otelConfigProperties() {
                                return configProperties;
                            }
                        });
                    }
                });
            }
        }
    }

    @Singleton
    public static final class MetricProviderCustomizer
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final OTelBuildConfig oTelBuildConfig;
        private final Instance<Clock> clock;

        public MetricProviderCustomizer(OTelBuildConfig oTelBuildConfig, Instance<Clock> clock) {
            this.oTelBuildConfig = oTelBuildConfig;
            this.clock = clock;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            if (this.oTelBuildConfig.metrics().enabled().orElse(Boolean.TRUE).booleanValue()) {
                builder.addMeterProviderCustomizer((BiFunction)new BiFunction<SdkMeterProviderBuilder, ConfigProperties, SdkMeterProviderBuilder>(){

                    @Override
                    public SdkMeterProviderBuilder apply(SdkMeterProviderBuilder metricProvider, ConfigProperties configProperties) {
                        if (clock.isUnsatisfied()) {
                            throw new IllegalStateException("No Clock bean found");
                        }
                        metricProvider.setClock((Clock)clock.get());
                        return metricProvider;
                    }
                });
            }
        }
    }

    @Singleton
    public static final class TracerProviderCustomizer
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final OTelBuildConfig oTelBuildConfig;
        private final List<IdGenerator> idGenerator;
        private final List<SpanProcessor> spanProcessors;

        public TracerProviderCustomizer(OTelBuildConfig oTelBuildConfig, @All List<IdGenerator> idGenerator, @All List<SpanProcessor> spanProcessors) {
            this.oTelBuildConfig = oTelBuildConfig;
            this.idGenerator = idGenerator;
            this.spanProcessors = spanProcessors;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            builder.addTracerProviderCustomizer((BiFunction)new BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder>(){

                @Override
                public SdkTracerProviderBuilder apply(SdkTracerProviderBuilder tracerProviderBuilder, ConfigProperties configProperties) {
                    if (oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                        idGenerator.stream().findFirst().ifPresent(arg_0 -> ((SdkTracerProviderBuilder)tracerProviderBuilder).setIdGenerator(arg_0));
                        spanProcessors.stream().filter(new Predicate<SpanProcessor>(){

                            @Override
                            public boolean test(SpanProcessor sp) {
                                return !(sp instanceof RemoveableLateBoundBatchSpanProcessor);
                            }
                        }).forEach(arg_0 -> ((SdkTracerProviderBuilder)tracerProviderBuilder).addSpanProcessor(arg_0));
                    }
                    return tracerProviderBuilder;
                }
            });
        }
    }

    @Singleton
    public static final class SamplerCustomizer
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final OTelBuildConfig oTelBuildConfig;
        private final OTelRuntimeConfig oTelRuntimeConfig;
        private final List<Sampler> sampler;

        public SamplerCustomizer(OTelBuildConfig oTelBuildConfig, OTelRuntimeConfig oTelRuntimeConfig, @All List<Sampler> sampler) {
            this.oTelBuildConfig = oTelBuildConfig;
            this.oTelRuntimeConfig = oTelRuntimeConfig;
            this.sampler = sampler;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            builder.addSamplerCustomizer((BiFunction)new BiFunction<Sampler, ConfigProperties, Sampler>(){

                @Override
                public Sampler apply(Sampler existingSampler, ConfigProperties configProperties) {
                    if (oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue()) {
                        Sampler effectiveSampler = sampler.stream().findFirst().map(Sampler.class::cast).orElse(existingSampler);
                        ArrayList<String> dropTargets = new ArrayList<String>();
                        if (oTelRuntimeConfig.traces().suppressNonApplicationUris().booleanValue()) {
                            dropTargets.addAll(TracerRecorder.dropNonApplicationUriTargets);
                        }
                        if (!oTelRuntimeConfig.traces().includeStaticResources().booleanValue()) {
                            dropTargets.addAll(TracerRecorder.dropStaticResourceTargets);
                        }
                        if (!dropTargets.isEmpty()) {
                            return new DropTargetsSampler(effectiveSampler, dropTargets);
                        }
                        return effectiveSampler;
                    }
                    return Sampler.alwaysOff();
                }
            });
        }
    }

    @Singleton
    public static final class TracingResourceCustomizer
    implements AutoConfiguredOpenTelemetrySdkBuilderCustomizer {
        private final ApplicationConfig appConfig;
        private final OTelBuildConfig oTelBuildConfig;
        private final OTelRuntimeConfig oTelRuntimeConfig;
        private final Instance<DelayedAttributes> delayedAttributes;
        private final List<Resource> resources;

        public TracingResourceCustomizer(ApplicationConfig appConfig, OTelBuildConfig oTelBuildConfig, OTelRuntimeConfig oTelRuntimeConfig, @Any Instance<DelayedAttributes> delayedAttributes, @All List<Resource> resources) {
            this.appConfig = appConfig;
            this.oTelBuildConfig = oTelBuildConfig;
            this.oTelRuntimeConfig = oTelRuntimeConfig;
            this.delayedAttributes = delayedAttributes;
            this.resources = resources;
        }

        @Override
        public void customize(AutoConfiguredOpenTelemetrySdkBuilder builder) {
            builder.addResourceCustomizer((BiFunction)new BiFunction<Resource, ConfigProperties, Resource>(){

                @Override
                public Resource apply(Resource existingResource, ConfigProperties configProperties) {
                    if (oTelBuildConfig.traces().enabled().orElse(Boolean.TRUE).booleanValue() || oTelBuildConfig.metrics().enabled().orElse(Boolean.TRUE).booleanValue()) {
                        Resource consolidatedResource = existingResource.merge(Resource.create((Attributes)((Attributes)delayedAttributes.get())));
                        String serviceName = oTelRuntimeConfig.serviceName().filter(new Predicate<String>(){

                            @Override
                            public boolean test(String sn) {
                                return !sn.equals(appConfig.name.orElse("unset"));
                            }
                        }).orElse(null);
                        String hostname = AutoConfiguredOpenTelemetrySdkBuilderCustomizer.getHostname();
                        Resource resource = resources.stream().reduce(Resource.empty(), Resource::merge).merge(TracerUtil.mapResourceAttributes(oTelRuntimeConfig.resourceAttributes().orElse(Collections.emptyList()), serviceName, hostname));
                        return consolidatedResource.merge(resource);
                    }
                    return Resource.builder().build();
                }
            });
        }
    }
}

