/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternBuilder;
import com.thaiopensource.relaxng.pattern.PatternInterner;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.UnexpandedNotAllowedPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.util.List;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

public class SchemaPatternBuilder
extends PatternBuilder {
    private boolean idTypes;
    private final UnexpandedNotAllowedPattern unexpandedNotAllowed = new UnexpandedNotAllowedPattern();
    private final TextPattern text = new TextPattern();
    private final PatternInterner schemaInterner = new PatternInterner();

    public boolean hasIdTypes() {
        return this.idTypes;
    }

    Pattern makeElement(NameClass nameClass, Pattern pattern, Locator locator) {
        ElementPattern elementPattern = new ElementPattern(nameClass, pattern, locator);
        return this.schemaInterner.intern(elementPattern);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern pattern, Locator locator) {
        return this.makeAttribute(nameClass, pattern, locator, null);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern pattern, Locator locator, String string) {
        if (pattern == this.notAllowed) {
            return pattern;
        }
        AttributePattern attributePattern = new AttributePattern(nameClass, pattern, locator, string);
        return this.schemaInterner.intern(attributePattern);
    }

    Pattern makeData(Datatype datatype, Name name, List<String> list) {
        this.noteDatatype(datatype);
        DataPattern dataPattern = new DataPattern(datatype, name, list);
        return this.schemaInterner.intern(dataPattern);
    }

    Pattern makeDataExcept(Datatype datatype, Name name, List<String> list, Pattern pattern, Locator locator) {
        this.noteDatatype(datatype);
        DataExceptPattern dataExceptPattern = new DataExceptPattern(datatype, name, list, pattern, locator);
        return this.schemaInterner.intern(dataExceptPattern);
    }

    Pattern makeValue(Datatype datatype, Name name, Object object, String string) {
        this.noteDatatype(datatype);
        ValuePattern valuePattern = new ValuePattern(datatype, name, object, string);
        return this.schemaInterner.intern(valuePattern);
    }

    Pattern makeText() {
        return this.text;
    }

    @Override
    Pattern makeOneOrMore(Pattern pattern) {
        if (pattern == this.text) {
            return pattern;
        }
        return super.makeOneOrMore(pattern);
    }

    Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    Pattern makeError() {
        ErrorPattern errorPattern = new ErrorPattern();
        return this.schemaInterner.intern(errorPattern);
    }

    @Override
    Pattern makeChoice(Pattern pattern, Pattern pattern2) {
        if (pattern == this.notAllowed || pattern == pattern2) {
            return pattern2;
        }
        if (pattern2 == this.notAllowed) {
            return pattern;
        }
        return super.makeChoice(pattern, pattern2);
    }

    Pattern makeList(Pattern pattern, Locator locator) {
        if (pattern == this.notAllowed) {
            return pattern;
        }
        ListPattern listPattern = new ListPattern(pattern, locator);
        return this.schemaInterner.intern(listPattern);
    }

    Pattern makeMixed(Pattern pattern) {
        return this.makeInterleave(this.text, pattern);
    }

    private void noteDatatype(Datatype datatype) {
        if (datatype.getIdType() != 0) {
            this.idTypes = true;
        }
    }
}

