/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.iconset.classic.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.ui.icon.AbstractResourceIconProvider;
import org.openhab.core.ui.icon.IconProvider;
import org.openhab.core.ui.icon.IconSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@NonNullByDefault
public class ClassicIconProvider
extends AbstractResourceIconProvider
implements IconProvider {
    static final String ICONSET_ID = "classic";
    private static final String DEFAULT_LABEL = "Classic Icons";
    private static final String DEFAULT_DESCRIPTION = "This is a modernized version of the original icon set of openHAB 1.";
    private final Logger logger = LoggerFactory.getLogger(ClassicIconProvider.class);
    private final BundleContext context;

    @Activate
    public ClassicIconProvider(BundleContext context, @Reference TranslationProvider i18nProvider) {
        super(i18nProvider);
        this.context = context;
    }

    public Set<IconSet> getIconSets(@Nullable Locale locale) {
        Set<IconSet.Format> formats = Set.of(IconSet.Format.SVG);
        String label = this.i18nProvider.getText(this.context.getBundle(), "iconset.label", DEFAULT_LABEL, locale);
        label = label == null ? DEFAULT_LABEL : label;
        String description = this.i18nProvider.getText(this.context.getBundle(), "iconset.description", DEFAULT_DESCRIPTION, locale);
        description = description == null ? DEFAULT_DESCRIPTION : description;
        IconSet iconSet = new IconSet(ICONSET_ID, label, description, formats);
        return Collections.singleton(iconSet);
    }

    protected @Nullable InputStream getResource(String iconSetId, String resourceName) {
        if (ICONSET_ID.equals(iconSetId)) {
            URL iconResource = this.context.getBundle().getEntry("icons/" + resourceName);
            try {
                return iconResource.openStream();
            }
            catch (IOException e) {
                this.logger.error("Failed to read icon '{}': {}", (Object)resourceName, (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }

    protected boolean hasResource(String iconSetId, String resourceName) {
        if (ICONSET_ID.equals(iconSetId)) {
            URL iconResource = this.context.getBundle().getEntry("icons/" + resourceName);
            return iconResource != null;
        }
        return false;
    }

    protected Integer getPriority() {
        return 0;
    }
}

