/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_uniform_info_t")
public class BGFXUniformInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPE;
    public static final int NUM;

    public BGFXUniformInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXUniformInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return BGFXUniformInfo.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return BGFXUniformInfo.nnameString(this.address());
    }

    @NativeType(value="bgfx_uniform_type_t")
    public int type() {
        return BGFXUniformInfo.ntype(this.address());
    }

    @NativeType(value="uint16_t")
    public short num() {
        return BGFXUniformInfo.nnum(this.address());
    }

    public BGFXUniformInfo name(@NativeType(value="char[256]") ByteBuffer value) {
        BGFXUniformInfo.nname(this.address(), value);
        return this;
    }

    public BGFXUniformInfo type(@NativeType(value="bgfx_uniform_type_t") int value) {
        BGFXUniformInfo.ntype(this.address(), value);
        return this;
    }

    public BGFXUniformInfo num(@NativeType(value="uint16_t") short value) {
        BGFXUniformInfo.nnum(this.address(), value);
        return this;
    }

    public BGFXUniformInfo set(ByteBuffer name, int type, short num) {
        this.name(name);
        this.type(type);
        this.num(num);
        return this;
    }

    public BGFXUniformInfo set(BGFXUniformInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXUniformInfo malloc() {
        return (BGFXUniformInfo)BGFXUniformInfo.wrap(BGFXUniformInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXUniformInfo calloc() {
        return (BGFXUniformInfo)BGFXUniformInfo.wrap(BGFXUniformInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXUniformInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXUniformInfo)BGFXUniformInfo.wrap(BGFXUniformInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXUniformInfo create(long address) {
        return (BGFXUniformInfo)BGFXUniformInfo.wrap(BGFXUniformInfo.class, (long)address);
    }

    @Nullable
    public static BGFXUniformInfo createSafe(long address) {
        return address == 0L ? null : (BGFXUniformInfo)BGFXUniformInfo.wrap(BGFXUniformInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)BGFXUniformInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)BGFXUniformInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)BGFXUniformInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXUniformInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)BGFXUniformInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXUniformInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXUniformInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static BGFXUniformInfo mallocStack() {
        return BGFXUniformInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXUniformInfo callocStack() {
        return BGFXUniformInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXUniformInfo mallocStack(MemoryStack stack) {
        return BGFXUniformInfo.malloc(stack);
    }

    @Deprecated
    public static BGFXUniformInfo callocStack(MemoryStack stack) {
        return BGFXUniformInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXUniformInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXUniformInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.calloc(capacity, stack);
    }

    public static BGFXUniformInfo malloc(MemoryStack stack) {
        return (BGFXUniformInfo)BGFXUniformInfo.wrap(BGFXUniformInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXUniformInfo calloc(MemoryStack stack) {
        return (BGFXUniformInfo)BGFXUniformInfo.wrap(BGFXUniformInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)BGFXUniformInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)BGFXUniformInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static short nnum(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUM);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)NAME), (long)value.remaining());
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnum(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)NUM, value);
    }

    static {
        Struct.Layout layout = BGFXUniformInfo.__struct((Struct.Member[])new Struct.Member[]{BGFXUniformInfo.__array((int)1, (int)256), BGFXUniformInfo.__member((int)4), BGFXUniformInfo.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        NUM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<BGFXUniformInfo, Buffer>
    implements NativeResource {
        private static final BGFXUniformInfo ELEMENT_FACTORY = BGFXUniformInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXUniformInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return BGFXUniformInfo.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return BGFXUniformInfo.nnameString(this.address());
        }

        @NativeType(value="bgfx_uniform_type_t")
        public int type() {
            return BGFXUniformInfo.ntype(this.address());
        }

        @NativeType(value="uint16_t")
        public short num() {
            return BGFXUniformInfo.nnum(this.address());
        }

        public Buffer name(@NativeType(value="char[256]") ByteBuffer value) {
            BGFXUniformInfo.nname(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="bgfx_uniform_type_t") int value) {
            BGFXUniformInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer num(@NativeType(value="uint16_t") short value) {
            BGFXUniformInfo.nnum(this.address(), value);
            return this;
        }
    }
}

