/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.darwin;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum AddressInfo implements Constant
{
    AI_PASSIVE(1L),
    AI_CANONNAME(2L),
    AI_NUMERICHOST(4L),
    AI_NUMERICSERV(4096L),
    AI_MASK(5127L),
    AI_ALL(256L),
    AI_V4MAPPED_CFG(512L),
    AI_ADDRCONFIG(1024L),
    AI_V4MAPPED(2048L),
    AI_DEFAULT(1536L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 5127L;

    private AddressInfo(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<AddressInfo, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<AddressInfo, String> generateTable() {
            EnumMap<AddressInfo, String> map2 = new EnumMap<AddressInfo, String>(AddressInfo.class);
            map2.put(AI_PASSIVE, "AI_PASSIVE");
            map2.put(AI_CANONNAME, "AI_CANONNAME");
            map2.put(AI_NUMERICHOST, "AI_NUMERICHOST");
            map2.put(AI_NUMERICSERV, "AI_NUMERICSERV");
            map2.put(AI_MASK, "AI_MASK");
            map2.put(AI_ALL, "AI_ALL");
            map2.put(AI_V4MAPPED_CFG, "AI_V4MAPPED_CFG");
            map2.put(AI_ADDRCONFIG, "AI_ADDRCONFIG");
            map2.put(AI_V4MAPPED, "AI_V4MAPPED");
            map2.put(AI_DEFAULT, "AI_DEFAULT");
            return map2;
        }
    }
}

